/*
   Sophos Anti-Virus for OS/2
   Procedure to make Emergency OSWEEP diskettes

   Version 1.40     September 2003

   Copyright (c) 2000,03 Sophos Plc, www.sophos.com
*/

/* Configuration */

VDL_COUNT = 4

/* Main procedure */

"@ECHO OFF"

SAY "Emergency OSWEEP diskette generator for OS/2"
SAY "Version 1.40"
SAY "Copyright (c) 2000,03 Sophos Plc, www.sophos.com"
SAY ""

/* CID return codes */

CID_QUIT = X2D("0004")
CID_DATA = X2D("0800")
CID_PATH = X2D("0812")
CID_ARGS = X2D("1600")
CID_OTHER = X2D("1604")

exit_code = 0
exit_msg = ""

globals = "CID_QUIT CID_DATA CID_PATH CID_ARGS CID_OTHER exit_code exit_msg"

/* load external utility functions */

CALL RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
CALL SysLoadFuncs

/* process arguments and prompt for missing parameters */

SourceDir = SourceDirectory()

utilDrive = ""		/* drive for OS/2 utility disks */
targetDrive = ""	/* drive for emergency disks being produced */
update_mode = 0		/* whether to update SWEEP files only, not OS/2 */

PARSE ARG args
DO WHILE args \= ""
	PARSE UPPER VALUE args WITH a args
	IF LEFT(a, 1) = "/" | LEFT(a, 1) = "-" THEN DO
		opt = SUBSTR(a, 2)
		prefix = LEFT(opt, 2)
		SELECT
			WHEN LEFT(opt, 1) = "H" | LEFT(opt, 1) = "?" THEN
				SIGNAL help_message
			WHEN opt = "P" THEN
				update_mode = 1
			WHEN prefix = "T:" | prefix = "T=" THEN
				targetDrive = checkDrive(SUBSTR(opt, 3), "target")
			WHEN prefix = "U:" | prefix = "U=" THEN
				utilDrive = checkDrive(SUBSTR(opt, 3), "utility diskettes")
			OTHERWISE
				CALL invalid_arg "qualifier" a
		END
	END
	ELSE
		CALL invalid_arg "argument" a
END

IF utilDrive = "" & \ update_mode THEN
	utilDrive = ask_drive("OS/2 utility diskettes drive: ")

IF targetDrive = "" THEN
	targetDrive = ask_drive("Target drive: ")

IF \ is_diskette_drive(targetDrive) THEN DO
	SAY "Target drive must be a diskette drive on A: or B:"
	EXIT CID_DATA
END

IF \ update_mode THEN
	utilDrive = checkDrive(utilDrive, "utility diskettes")
targetDrive = checkDrive(targetDrive, "target")

/* ensure cleanup on error/abort */
SIGNAL ON ERROR NAME cleanup
SIGNAL ON FAILURE NAME cleanup
SIGNAL ON HALT

/* Create emergency disks */

exit_msg = "An error occurred while fetching files"
exit_code = 0

CALL CheckSavFiles SourceDir, VDL_COUNT
IF \ update_mode THEN DO
	CALL FetchSystemFiles UtilDrive, SourceDir
END

exit_msg = "An error occurred while writing the diskettes"
exit_code = 0

TotalDisks = OutputFiles(SourceDir, VDL_COUNT, TargetDrive, update_mode)

exit_msg = ""
exit_code = 0

SIGNAL OFF ERROR
SIGNAL OFF FAILURE
SIGNAL OFF HALT

CALL ClearTemp
CALL Generated TotalDisks
CALL offer_sweep SourceDir, TargetDrive
CALL Complete

EXIT 0


/* Argument-processing */


/* Print help and exit */
help_message:
	SAY "Command qualifiers:"
	SAY "-P       Update SWEEP files on existing emergency diskettes"
	SAY "-T:x     Use drive x for target (emergency) diskettes"
	SAY "-U:x     Use drive x for OS/2 utility diskettes"
	EXIT CID_ARGS


invalid_arg: PROCEDURE EXPOSE (globals)
	PARSE ARG type val
	SAY "Invalid" type || ":" val
	EXIT CID_ARGS


/* Procedures to generate emergency disks */


/* Check that the source directory contains all required SAV for OS/2 files */
CheckSavFiles: PROCEDURE EXPOSE (globals)
	PARSE ARG SourceDir, VdlCount
	CALL CheckFile SourceDir, "OSWEEP.EXE"
	CALL CheckFile SourceDir, "SAVI.DLL"
	DO d = 1 TO VdlCount
		CALL CheckFile SourceDir, VdlPartFilename(d)
	END
	RETURN


CheckFile: PROCEDURE EXPOSE (globals)
	PARSE ARG dir, file
	Path = MkPath(dir, file)
	IF \ FileExists(Path) THEN DO
		exit_code = CID_DATA
		exit_msg = "File not found:" Path
		SIGNAL cleanup
	END
	RETURN


/* Fetch OS/2 system DLLs required to run OSWEEP
	from utility diskettes drive into source directory. */
FetchSystemFiles: PROCEDURE EXPOSE (globals)
	PARSE ARG UtilDrive, SourceDir

	UTILITY_DISK = "OS/2 utility diskette"
	CALL FetchFloppy "QUECALLS.DLL", UtilDrive, UTILITY_DISK "2", SourceDir, 1
	CALL FetchFloppy "VIOCALLS.DLL", UtilDrive, UTILITY_DISK "2", SourceDir, 0
	CALL FetchFloppy "NLS.DLL", UtilDrive, UTILITY_DISK "3", SourceDir, 0

	RETURN


/* Copy file from source floppy root to destination directory,
	prompting for disk if necessary. On error, set exit_code, exit_msg. */
FetchFloppy: PROCEDURE EXPOSE (globals)
	PARSE ARG Filename, SourceDrive, DiskTitle, DestDir, FirstUse
	SourcePath = FloppyFile(Filename, SourceDrive, DiskTitle, FirstUse)
	IF SourcePath = "" THEN DO
		exit_msg = "User cancelled"
		exit_code = CID_QUIT
		SIGNAL cleanup
	END
	SAY "Copying" Filename
	"COPY" SourcePath DestDir
	IF RC > 0 THEN DO
		exit_msg = "File copy failed:" SourcePath
		exit_code = CID_OTHER
		SIGNAL cleanup
	END
	RETURN


/* Return path of given file on given floppy disk,
	prompting for the disk until the file is present. */
FloppyFile: PROCEDURE EXPOSE (globals)
	PARSE ARG Filename, Drive, DiskTitle, FirstUse
	Path = RootDir(Drive) || Filename
	IF FirstUse THEN
		IF \ prompt(DiskTitle, Drive, Filename) THEN
			RETURN ""
	DO WHILE \ FileExists(Path)
		IF \ prompt(DiskTitle, Drive, Filename) THEN
			RETURN ""
	END
	RETURN Path


/* Output required files, including given number of VDL files, to target disk.
	Return number of diskettes generated. */
OutputFiles: PROCEDURE EXPOSE (globals)
	PARSE ARG SourceDir, VdlCount, TargetDrive, Update

	TotalDisks = 0

	BlankOpt = "B"
	IF Update THEN
		BlankOpt = ""
	CALL ObtainRequiredDisk TargetDrive, "P", BlankOpt
	CALL Output "OSWEEP.EXE", TargetDrive, SourceDir, Update
	CALL Output "SAVI.DLL", TargetDrive, SourceDir, Update
	IF \ Update THEN DO
		CALL Output "QUECALLS.DLL", TargetDrive, SourceDir, Update
		CALL Output "VIOCALLS.DLL", TargetDrive, SourceDir, Update
		CALL Output "NLS.DLL", TargetDrive, SourceDir, Update
		CALL label_msg StandaloneDiskTitle("P", VdlCount)
	END
	ELSE
		CALL remove_msg
	TotalDisks = TotalDisks + 1

	BlankOpt = "B"
	IF Update THEN
		BlankOpt = "O"
	DO d = 1 TO VdlCount
		Type = VdlFileType(d)
		CALL ObtainRequiredDisk TargetDrive, Type, BlankOpt
		VdlFile = VdlPartFilename(d)
		CALL Output VdlFile, TargetDrive, SourceDir, Update
		CALL label_msg StandaloneDiskTitle(Type, VdlCount)
		TotalDisks = TotalDisks + 1
	END

	RETURN TotalDisks


/* Output file to target drive from source directory.
	Exit on error or if user quits. */
Output: PROCEDURE EXPOSE (globals)
	PARSE ARG Filename, TargetDrive, SourceDir, UpdateMode

	TargetDrive = proper_drive(TargetDrive)
	IF UpdateMode THEN
		IF \ overwrite_ok(Filename, TargetDrive, SourceDir) THEN
			RETURN

	SourcePath = MkPath(SourceDir, Filename)
	SAY "Copying files, please wait..."
	exit_msg = "Error copying" SourcePath "to" TargetDrive
	exit_code = CID_OTHER
	"COPY" SourcePath TargetDrive
	exit_msg = ""
	exit_code = 0
	RETURN


/* Obtain required disk in given drive. Exit if not obtained. */
ObtainRequiredDisk: PROCEDURE EXPOSE (globals)
	ARG drive, type, BlankOpt
	IF \ GetRequiredDisk(drive, type, BlankOpt) THEN DO
		exit_msg = "Process stopped by user"
		exit_code = CID_OTHER
		SIGNAL cleanup
	END
	RETURN


/* Get required disk into given drive for use as given standalone disk type.
	BlankOpt is "B" if it must be blank, "O" if blank OK,
	"" if existing standalone disk, not a blank one, is required.
	Return 1 if we have the required disk, 0 if user quit. */
GetRequiredDisk: PROCEDURE EXPOSE (globals)
	ARG Drive, Type, BlankOpt

	DiskTitle = "a write-enabled diskette"
	DiskTitle2 = ""
	WrongDiskDescrip = "not blank"
	DiskAction = "insert"
	DriveAction = ""
	IF BlankOpt \= "B" THEN DO
		DiskTitle = StandaloneDiskTitle(Type, 0)
		WrongDiskDescrip = "not" DiskTitle
		IF BlankOpt = "O" THEN DO
			DiskTitle2 = "or another write-enabled diskette"
			WrongDiskDescrip = WrongDiskDescrip "or blank"
		END
		ELSE DO
			DiskAction = "write-enable"
			DriveAction = "and insert"
		END
	END

	DiskLabel = StandaloneDiskLabel(Type)
	Drive = proper_drive(Drive)
	DiskOK = 0
	Quit = 0
	PromptReqd = 1
	Rejection = ""
	DO UNTIL (DiskOK | Quit)
		IF PromptReqd THEN DO
			CALL Box Rejection, ,
				"Please" DiskAction DiskTitle, DiskTitle2, ,
				DriveAction "in drive" drive, ,
				"Press ENTER to continue; enter Q to quit."
			CALL Bell
			PULL Reply
			IF LEFT(STRIP(Reply), 1) = "Q" THEN
				Quit = 1
		END
		PromptReqd = 1
		Rejection = ""
		IF Quit THEN
			NOP
		ELSE IF BlankOpt \= "" & BlankDisk(Drive) THEN
			DiskOK = 1
		ELSE IF BlankOpt \= "B" & standalone_disk(Type, Drive) THEN
			DiskOK = 1
		ELSE IF SysDriveInfo(drive) \= "" THEN DO
			IF BlankOpt = "" THEN
				Rejection = "The inserted disk is" WrongDiskDescrip || "."
			ELSE DO
				choice = AskFormat(drive, WrongDiskDescrip)
				IF choice = "Y" THEN
					CALL format_drive Drive, DiskLabel
				ELSE IF choice = "Q" THEN
					Quit = 1
				PromptReqd = 0
			END
		END
	END
	IF DiskOK THEN
		"LABEL" Drive || DiskLabel
	RETURN DiskOK


Generated: PROCEDURE EXPOSE (globals)
	ARG count
	CALL box "Emergency OSWEEP diskettes generated.", ,
		"Number of diskettes generated:" count
	SAY ""
	RETURN


Complete: PROCEDURE EXPOSE (globals)
	SAY ""
	CALL box "Emergency OSWEEP diskette generation successfully completed.", ,
			"Please store the diskettes with the OS/2 utility diskettes", ,
			"in a secure place."
	SAY ""
	RETURN


/* Offer sweep of generated disks and perform it if accepted. */
offer_sweep: PROCEDURE EXPOSE (globals)
	PARSE ARG SourceDir, TargetDrive
	TargetDrive = proper_drive(TargetDrive)
	msg3 = "It is recommended that you SWEEP the diskettes produced"
	msg4 = "before storing them."
	msg5 = "Do you want to run SWEEP on the generated diskettes"
	CALL box msg3, msg4
	IF \ ask(msg5) THEN
		RETURN
	CALL box "Please insert the generated diskettes in drive" TargetDrive "when prompted"
	SAY ""
	SETLOCAL
	ENV = "OS2ENVIRONMENT"
	oldlib = VALUE("BEGINLIBPATH", , ENV)
	"SET BEGINLIBPATH=" || SourceDir || ";" || oldlib
	"SET SAV_VDL=" || SourceDir
	SIGNAL ON ERROR NAME sweep_cleanup
	SIGNAL ON FAILURE NAME sweep_cleanup
	SIGNAL ON HALT NAME sweep_cleanup
	SAY "Please wait while SWEEP is loaded..."
	SweepPath = MkPath(SourceDir, "OSWEEP.EXE")
	SweepPath TargetDrive "/CI /NAF /MU /ALL"

	ec = RC
	"SET BEGINLIBPATH=" || oldlib
	ENDLOCAL
	IF ec = 1 THEN DO
		SAY "OSWEEP was interrupted"
		EXIT 0
	END
	IF ec = 2 | ec > 3 THEN DO
		SAY "OSWEEP encountered an error"
		EXIT CID_OTHER
	END
	IF ec = 3 THEN DO
		SAY "OSWEEP encountered a virus"
		EXIT CID_OTHER
	END
	RETURN


/* Cleaning up during final sweep */


sweep_cleanup:
	ec = RC
	"SET BEGINLIBPATH=" || oldlib
	IF CONDITION("C") = "HALT" THEN DO
		SAY "OSWEEP was interrupted"
		EXIT 0
	END
	IF CONDITION("C") = "ERROR" THEN
		SIGNAL sweep_error
	EXIT CID_OTHER


sweep_error:
	IF ec = 1 THEN DO
		SAY "OSWEEP was interrupted"
		EXIT 0
	END
	IF ec = 3 THEN
		SAY "OSWEEP encountered a virus"
	ELSE
		SAY "OSWEEP encountered an error"
	EXIT CID_OTHER


/* Cleaning up during main process */


halt:
	exit_msg = "Interrupted"
	exit_code = CID_OTHER
	SIGNAL cleanup


/* Cleanup and exit. */
cleanup:
	IF exit_msg = "" THEN
		SAY "Cleaning up after error"
	ELSE
		SAY exit_msg
	IF exit_code = 0 THEN
		exit_code = CID_OTHER
	SIGNAL OFF ERROR
	SIGNAL OFF FAILURE
	SIGNAL OFF HALT

	CALL ClearTemp

	EXIT exit_code


ClearTemp: PROCEDURE EXPOSE (globals)
	TempDir = SourceDirectory()
	CALL DeleteFile MkPath(TempDir, "QUECALLS.DLL")
	CALL DeleteFile MkPath(TempDir, "VIOCALLS.DLL")
	CALL DeleteFile MkPath(TempDir, "NLS.DLL")
	RETURN


/* Standlone-disk functions */


/* Return 1 if drive holds given type (P, DAT or Dnn) of emergency disk;
	0 otherwise. */
standalone_disk: PROCEDURE EXPOSE (globals)
	ARG type, drive
	drive = proper_drive(drive)
	IF SysDriveInfo(drive) = "" THEN
		RETURN 0
	IF type = "P" THEN DO
		files.0 = 5
		files.1 = "OSWEEP.EXE"
		files.2 = "SAVI.DLL"
		files.3 = "QUECALLS.DLL"
		files.4 = "NLS.DLL"
		files.5 = "VIOCALLS.DLL"
	END
	ELSE DO
		files.0 = 1
		files.1 = VdlTypeFilename(type)
	END
	DO i = 1 TO files.0
		IF \ find_files(drive, drive || "\" || files.i) THEN
			RETURN 0
	END
	RETURN 1


/* Return title of given standalone disk type (P, DAT or Dnn). */
StandaloneDiskTitle: PROCEDURE EXPOSE (globals)
	ARG Type, VdlCount
	Title = ""
	IF Type = "P" THEN
		Title = "Emergency OSWEEP diskette"
	ELSE IF Type = "DAT" THEN
		Title = "Emergency virus data diskette 1"
	ELSE IF LEFT(Type, 1) = "D" THEN DO
		NumStr = SUBSTR(Type, 2)
		IF DATATYPE(NumStr) = "NUM" THEN DO
			Num = FORMAT(NumStr)
			Title = "Emergency virus data diskette" Num
		END
	END
	IF LEFT(Type, 1) = "D" & Title \= "" & VdlCount > 0 THEN
		Title = Title "of" VdlCount
	RETURN Title


/* Return label to be used for given standalone disk type (P, DAT or Dnn). */
StandaloneDiskLabel: PROCEDURE EXPOSE (globals)
	ARG Type
	Label = ""
	IF Type = "P" THEN
		Label = "EMERGENCY_0"
	ELSE IF Type = "DAT" THEN
		Label = "EMERGENCY_1"
	ELSE
		Label = "EMERGENCY" || SUBSTR(Type, 2)
	RETURN Label


VdlFileType: PROCEDURE EXPOSE (globals)
	ARG n
	IF DATATYPE(n) \= "NUM" THEN DO
		exit_code = CID_OTHER
		exit_msg = "Internal error determining VDL file name"
		SIGNAL cleanup
	END
	Type = "DAT"
	IF n > 1 THEN
		Type = "D" || RIGHT("0" || n, 2)
	RETURN Type


VdlPartFilename: PROCEDURE EXPOSE (globals)
	ARG n
	RETURN "VDL." || VdlFileType(n)


VdlTypeFilename: PROCEDURE EXPOSE (globals)
	ARG Type
	RETURN "VDL." || Type


/* File, disk and user interface functions */


/* Print description of situation and ask whether to quit (return "Q"),
	format (return "Y") or try again. */
AskFormat: PROCEDURE EXPOSE (globals)
	PARSE ARG drive, descrip
	CALL Box "The disk in drive" drive "is" descrip || ".", ,
		"Enter Y to use this disk, erasing its current contents;", ,
		"enter Q to quit;", ,
		"or insert another disk and press ENTER."
	CALL Bell
	PULL reply
	reply = LEFT(STRIP(reply), 1)
	IF reply \= "Q" & reply \= "Y" THEN
		reply = ""
	RETURN reply


/* Return 1 if the file on the target drive can be overwritten by the source
	file; 0 otherwise. Target file can be overwritten if it does not exist,
	or it is older than the source file, or the user chooses to overwrite. */
overwrite_ok: PROCEDURE EXPOSE (globals)
	PARSE ARG filename, target_drive, source_dir
	IF RIGHT(source_dir, 1) \= "\" THEN
		source_dir = source_dir || "\"
	source_path = source_dir || filename
	target_path = proper_drive(target_drive) || "\" || filename
	IF \ FileExists(target_path) THEN
		RETURN 1
	source_time = timestamp(source_path)
	target_time = timestamp(target_path)
	IF source_time > target_time THEN
		RETURN 1
	IF source_time = target_time THEN
		comp = "the same age as"
	ELSE
		comp = "older than"
	CALL Box "WARNING! Source file" filename, ,
		"is" comp "that on the emergency diskette"
	CALL bell
	RETURN ask("Update the file anyway")


/* Prompt for disk; return 0 to quit, 1 otherwise. */
prompt: PROCEDURE EXPOSE (globals)
	PARSE ARG title, drive, filename
	IF filename = "" THEN
		filePrompt = ""
	ELSE
		filePrompt = "containing file " || filename
	CALL box "Please insert " || title, filePrompt ,
		, "in drive " || drive , "Press ENTER to continue; enter Q to quit."
	CALL Bell
	PULL reply
	RETURN (LEFT(reply, 1) \= "Q")


/* Prompt for a drive letter until valid or blank line (when exit). */
ask_drive: PROCEDURE EXPOSE (globals)
	PARSE ARG msg
	drive = ""
	DO WHILE drive = ""
		x = CHAROUT(, msg)
		PULL drive
		IF drive = "" THEN DO
			SAY "No drive entered"
			EXIT CID_ARGS
		END
		ELSE DO
			drive = validateDrive(drive, "")
			IF drive = "" THEN
				SAY "Please enter a drive letter, or just press ENTER to quit."
		END
	END
	RETURN drive


label_msg: PROCEDURE EXPOSE (globals)
	PARSE ARG label
	CALL box "Please remove the diskette from the drive, label it:", ,
			label, ,
			"and write-protect it.", ,
			"Press ENTER to continue."
	PULL a
	RETURN


remove_msg: PROCEDURE EXPOSE (globals)
	CALL box "Please remove the diskette from the drive", ,
			"and write-protect it.", ,
			"Press ENTER to continue."
	PULL a
	RETURN


/* Display multi-line message in a box */
box: PROCEDURE EXPOSE (globals)
	CALL purge_input
	line = 0
	DO i = 1 TO ARG()
		len = LENGTH(ARG(i))
		IF len > line THEN
			line = len
	END
	IF line > 75 THEN DO
		SAY COPIES("*", 78)
		DO i = 1 TO ARG()
			IF ARG(i) \= "" THEN
				SAY ARG(i)
		END
		SAY COPIES("*", 78)
	END
	ELSE DO
		SAY COPIES("*", line + 4)
		DO i = 1 TO ARG()
			IF ARG(i) \= "" THEN
				SAY "*" CENTRE(ARG(i), line) "*"
		END
		SAY COPIES("*", line + 4)
	END
	CALL purge_input
	RETURN


/* Ask yes/no question; return 1 yes, 0 no */
ask: PROCEDURE EXPOSE (globals)
	PARSE ARG question
	CALL purge_input
	ans = -1
	DO WHILE ans = -1
		x = CHAROUT(, question || "? (y/n) ")
		PULL reply
		reply = LEFT(reply, 1)
		SELECT
			WHEN reply = "Y" THEN ans = 1
			WHEN reply = "N" THEN ans = 0
			OTHERWISE ans = -1
		END
	END
	RETURN ans


purge_input: PROCEDURE EXPOSE (globals)
	DO WHILE LINES()
		PULL a
	END
	RETURN


bell: PROCEDURE EXPOSE (globals)
	CALL BEEP 880, 300
	RETURN


format_drive: PROCEDURE EXPOSE (globals)
	PARSE ARG drive, label
	drive = proper_drive(drive)
	exit_msg = "Error formatting drive" drive
	exit_code = CID_OTHER
	"FORMAT" drive "/ONCE /V:" || label
	IF rc \= 0 THEN
		SIGNAL cleanup
	exit_msg = ""
	exit_code = 0
	RETURN


/* Return date-time of given file in format yyyymmddhhnn. */
timestamp: PROCEDURE EXPOSE (globals)
	PARSE ARG path
	IF SysFileTree(path, found, "T") > 0 THEN DO
		exit_msg = "Out of memory while looking for" path
		exit_code = CID_PATH
		SIGNAL cleanup
	END
	IF found.0 \= 1 THEN DO
		exit_msg = "Expected file not found:" path
		exit_code = CID_PATH
		SIGNAL cleanup
	END
	PARSE VALUE found.1 WITH datetime .
	PARSE VALUE datetime WITH yr "/" mon "/" day "/" hr "/" min
	IF yr < 100 THEN
		IF yr < 50 THEN
			yr = 2000 + yr
		ELSE
			yr = 1900 + yr
	stamp = FORMAT(yr, 4) || FORMAT(mon, 2) || FORMAT(day, 2) || FORMAT(hr, 2) || FORMAT(min, 2)
	RETURN stamp


/* Find files (not directories or hidden) matching given pattern.
	Return number found. */
find_files: PROCEDURE EXPOSE (globals)
	PARSE ARG drive, pattern
	drive = proper_drive(drive)
	IF SysDriveInfo(drive) = "" THEN
		RETURN 0
	IF SysFileTree(pattern, found, "FO", "*--**") > 0 THEN DO
		SAY "Out of memory"
		EXIT CID_OTHER
	END
	RETURN found.0


/* BlankDisk(drive): Test whether disk in drive is blank; return 1 if so, 0 if not. */
BlankDisk: PROCEDURE EXPOSE (globals)
	PARSE ARG drive
	drive = proper_drive(drive)
	IF SysDriveInfo(drive) = "" THEN
		RETURN 0
	IF SysFileTree(drive || "\*", files, "O") > 0 THEN DO
		SAY "Out of memory"
		EXIT CID_OTHER
	END
	RETURN (files.0 = 0)


/* Return path constructed from directory, filename. */
MkPath: PROCEDURE EXPOSE (globals)
	PARSE ARG dir, filename
	path = dir
	IF path \= "" & RIGHT(path, 1) \= "\" THEN
		path = path || "\"
	path = path || filename
	RETURN path


RootDir: PROCEDURE
	ARG Drive
	RETURN LEFT(Drive, 1) || ":\"


/* Return 1 if given file exists, 0 otherwise. */
FileExists: PROCEDURE
	PARSE ARG Filename
	Drive = FILESPEC("D", Filename)
	IF ValidDrive(Drive) \= "" THEN
		IF SysDriveInfo(Drive) = "" THEN
			RETURN 0
	Found = 0
	IF SysFileTree(Filename, Files, "FO") = 0 THEN
		IF Files.0 = 1 THEN
			Found = 1
	RETURN Found


/* If given drive letter is valid, return it in normalised form.
	Otherwise issue error message and exit. */
checkDrive: PROCEDURE EXPOSE (globals)
	PARSE ARG d, type
	d = validateDrive(d, type)
	IF d = "" THEN
		EXIT CID_ARGS
	RETURN d


/* If given drive letter is valid, return it in normalised form.
	Otherwise issue error message and return "". */
validateDrive: PROCEDURE EXPOSE (globals)
	PARSE ARG d, type

	drive = ValidDrive(d)
	IF drive = "" THEN
	DO
		IF type = "" THEN
			msg = "Invalid drive:" d
		ELSE
			msg = "Invalid" type "drive:" d
		SAY msg
	END
	RETURN drive


/* Return given drive letter in normalised form if valid, "" otherwise. */
ValidDrive: PROCEDURE EXPOSE (globals)
	ARG d
	d = proper_drive(d)
	assigned = SysDriveMap("A", "USED")
	IF d = "" | LENGTH(d) > 2 | \ DATATYPE(LEFT(d,1), "M") | (LENGTH(d) = 2 & RIGHT(d,1) \= ":") | POS(LEFT(d,1), assigned) = 0 THEN
		RETURN ""
	RETURN d


/* Return given drive letter in normalised form */
proper_drive: PROCEDURE EXPOSE (globals)
	PARSE UPPER ARG drive
	IF RIGHT(drive, 1) \= ":" THEN
		drive = drive || ":"
	RETURN drive


/* Return 1 if given drive letter is A: or B:, 0 otherwise. */
is_diskette_drive: PROCEDURE EXPOSE (globals)
	PARSE UPPER ARG d
	IF RIGHT(d, 1) = ":" THEN
		d = LEFT(d, LENGTH(d)-1)
	RETURN (d = "A" | d = "B")

/* Return source/temp directory - directory from which MKSTAND is running */
SourceDirectory: PROCEDURE EXPOSE (globals)
	PARSE SOURCE . . CommandPath
	RETURN FILESPEC("D", CommandPath) || FILESPEC("P", CommandPath)


DeleteFile: PROCEDURE EXPOSE (globals)
	PARSE ARG Path
	IF FileExists(Path) THEN
		"DEL" Path
	RETURN
