#ifndef __NCURSESUI_H__
#define __NCURSESUI_H__

#include "groanui.h"
#include "groandict.h"

#include "textwindow.h"
#include "textbrowser.h"
#include "textinputline.h"
#include "fileselector.h"
#include "dialogbox.h"
#include "cmenus.h"

#define cp_main_frame   1
#define cp_main_text    2
#define cp_main_hl      3
#define cp_main_sel     4
#define cp_main_stat    9
#define cp_main_input   10

#define cp_dlg_frame    5
#define cp_dlg_text     6
#define cp_dlg_hl       7
#define cp_dlg_sel      8

#define DIALOG_WIDTH    ((int) (COLS*0.8))
#define DIALOG_HEIGHT   ((int) (LINES*0.7))

class ncursesui: public groanui {
    private:
	textwindow dscr, fselwindow;
	textbrowser db;
	verticalmenu dm;
	textinputline inp;
	fileselector fsel;

	string lookuptext, statmsg;

	vector<int> boldcolors;

	bool finished;
	int halfpos, dstartpos, dcurrent;

	static int menukeys(verticalmenu &m, int k);
	static int browserkeys(textbrowser &b, int k);

	int getcolor(int ncp) const;
	void readconf();

	void changedict();
	void lookup();
	void quickmove();
	void gotoword();

	void mainloop();
	void done();

	void help() const;

	void log(const string amsg);
	bool input(groanui::inputkind kind, string &result, const string prompt);

	const string getlookuptext() const;
	void setlookuptext(const string atext);

	void status() const;
	void usage() const;

    public:
	ncursesui();
	~ncursesui();

	void init();
	void exec();
	void commandline(int argc, char **argv);
};

extern ncursesui thisui;

#endif
