#include "ncursesui.h"
#include "groandict.h"
#include "groan.h"

ncursesui thisui;

ncursesui::ncursesui() {
    kinterface();
}

ncursesui::~ncursesui() {
}

int ncursesui::getcolor(int ncp) const {
    return
	find(boldcolors.begin(), boldcolors.end(), ncp)
	    != boldcolors.end() ? boldcolor(ncp) : color(ncp);
}

void ncursesui::readconf() {
    string buf, pname;
    ifstream f;
    int npair, i, nbg, nfg;

    /* Setting default color settings */

    init_pair(cp_main_frame, COLOR_BLUE, COLOR_BLACK);
    init_pair(cp_main_text, COLOR_CYAN, COLOR_BLACK);
    init_pair(cp_main_hl, COLOR_YELLOW, COLOR_BLACK);
    init_pair(cp_main_sel, COLOR_BLACK, COLOR_WHITE);
    init_pair(cp_main_stat, COLOR_BLACK, COLOR_WHITE);
    init_pair(cp_main_input, COLOR_BLACK, COLOR_WHITE);
    init_pair(cp_dlg_frame, COLOR_BLUE, COLOR_WHITE);
    init_pair(cp_dlg_text, COLOR_BLACK, COLOR_WHITE);
    init_pair(cp_dlg_hl, COLOR_RED, COLOR_WHITE);
    init_pair(cp_dlg_sel, COLOR_WHITE, COLOR_BLACK);

    boldcolors.push_back(cp_main_hl);
    boldcolors.push_back(cp_main_frame);
    boldcolors.push_back(cp_dlg_sel);

    /* Loading user defined ones */

    f.open(g.getconfname("colorscheme").c_str());
    if(f.is_open()) {
	boldcolors.clear();

	while(!f.eof()) {
	    getline(f, buf);
	    pname = getword(buf);

	    if(pname == "main_frame") npair = cp_main_frame; else
	    if(pname == "main_text") npair = cp_main_text; else
	    if(pname == "main_hl") npair = cp_main_hl; else
	    if(pname == "main_sel") npair = cp_main_sel; else
	    if(pname == "main_stat") npair = cp_main_stat; else
	    if(pname == "main_input") npair = cp_main_input; else
	    if(pname == "dlg_frame") npair = cp_dlg_frame; else
	    if(pname == "dlg_text") npair = cp_dlg_text; else
	    if(pname == "dlg_hl") npair = cp_dlg_hl; else
	    if(pname == "dlg_sel") npair = cp_dlg_sel; else
		continue;

	    pname = getword(buf);

	    if(i = pname.find("/")) {
		nfg = findcolor(pname.substr(0, i));
		nbg = findcolor(pname.substr(i+1));
		init_pair(npair, nfg, nbg);
		if(buf == "bold") boldcolors.push_back(npair);
	    }
	}

	f.close();
	f.clear();
    }
}

void ncursesui::changedict() {
    bool fin, firstiter;
    dialogbox db;
    int n, b, nl, ns, citem;
    groan::dictlist::iterator id;
    string oldname, fname;

    db.setwindow(new textwindow(0, 0, DIALOG_WIDTH, DIALOG_HEIGHT,
	getcolor(cp_dlg_frame), TW_CENTERED,
	getcolor(cp_dlg_hl), _(" Dictionary manager ")));

    db.setbar(new horizontalbar(getcolor(cp_dlg_text),
	getcolor(cp_dlg_sel), _("Remove"), _("Add"), _("Open"), 0));

    db.settree(new treeview(getcolor(cp_dlg_text),
	getcolor(cp_dlg_sel),
	getcolor(cp_dlg_hl),
	getcolor(cp_dlg_text)));

    db.getbar()->item = 2;

    db.addkey(KEY_IC, 1);
    db.addkey(KEY_DC, 0);

    treeview &t = *db.gettree();

    for(fin = false, firstiter = true; !fin; ) {
	t.clear();
	nl = t.addnode(0, 0, 0, _(" Local dictionaries "));

	for(id = g.dbegin(); id != g.dend(); id++) {
	    n = t.addleaf(nl, 0, id-g.dbegin()+1, " " + id->name + " ");

	    if(firstiter)
	    if(localdict.getname() == id->name)
		t.setcur(n);
	}

	firstiter = false;
	fin = !db.open(n, b, (void **) &citem);

	if(!fin) {
	    if(!citem) {
		if(b != 1) continue;
	    }

	    citem--;
	    id = g.dbegin()+citem;

	    switch(b) {
		case 0:
		    if(id->name == localdict.getname()) {
			localdict.close();
		    }

		    g.dictremove(id);
		    break;
		case 1:
		    if(input(groanui::file, fname, _("File name: ")))
		    if(!fname.empty()) {
			if(!g.dictadd("file://" + fname)) {
			    log(_("Cannot add the dictionary specified"));
			}
		    }
		    break;
		case 2:
		    oldname = localdict.getname();

		    if(oldname != id->name) {
			localdict.close();

			localdict.open(id->name);
			if(localdict.is_open()) {
			    dstartpos = dcurrent = 0;
			    fin = true;
			} else {
			    localdict.open(oldname);
			}
		    }
		    break;
	    }
	}
    }

    db.close();
}

void ncursesui::init() {
    halfpos = (int) (COLS*0.7);

    dscr = textwindow(0, 1, COLS-1, LINES-2, getcolor(cp_main_frame), 0);
    dscr.open();
    dscr.separatex(halfpos);

    dm = verticalmenu(halfpos+1, 2, COLS-1, LINES-3,
	getcolor(cp_main_text), getcolor(cp_main_sel));

    fselwindow = textwindow(0, 0, DIALOG_WIDTH, DIALOG_HEIGHT,
	getcolor(cp_dlg_frame), TW_CENTERED);

    db = textbrowser(1, 2, halfpos-1, LINES-2, getcolor(cp_main_text));

    dm.otherkeys = &menukeys;
    db.otherkeys = &browserkeys;

    dm.exitonedges = true;

    inp.setcolor(getcolor(cp_main_input), getcolor(cp_dlg_frame),
	getcolor(cp_dlg_sel));

    fsel.setcolor(getcolor(cp_dlg_frame), getcolor(cp_dlg_hl),
	getcolor(cp_dlg_sel), getcolor(cp_dlg_text));

    fsel.setwindow(fselwindow);

    statmsg = _("F1 Help");

    kwriteat(0, LINES-1,
	(statmsg + "  " + string(COLS-statmsg.size()-2, ' ')).c_str(),
	getcolor(cp_main_stat));

    attrset(getcolor(cp_main_stat));
    mvhline(LINES-1, statmsg.size()+1, VLINE, 1);
}

void ncursesui::done() {
    attrset(0);
    kendinterface();
    for(int i = 0; i < LINES; i++) cout << endl;
    cout << flush;
}

void ncursesui::quickmove() {
    unsigned long n;

    if(!lookuptext.empty()) {
	if(localdict.find(lookuptext, n)) {
	    dcurrent = n;
	} else {
	    lookuptext.erase(lookuptext.size()-1);
	}
    }

    kwriteat(halfpos+2, LINES-3, (lookuptext +
	string(COLS-halfpos-lookuptext.size()-3, ' ')).c_str(),
	getcolor(cp_main_hl));
}

void ncursesui::lookup() {
    groandict::dictword dw;

    dw = localdict.get(dcurrent);
    if(!dw.getword().empty() && !dw.gettranslation().empty()) {
	db.setbuf(dw.gettranslation());
	db.open();
	db.close();
    }
}

void ncursesui::mainloop() {
    int i, n, perpage;
    groandict::dictword dw;

    finished = false;
    dstartpos = dcurrent = 0;
    perpage = LINES-2;

    while(!finished) {
	status();

	if(!localdict.is_open()) {
	    changedict();
	    if(!localdict.is_open())
		break;
	}

	dm.clear();

	if((dcurrent-dstartpos >= perpage) || (dcurrent-dstartpos < 0)) {
	    dstartpos = dcurrent-perpage+1;
	}

	if(dstartpos+perpage > localdict.size()) {
	    dstartpos = localdict.size()-perpage-1;
	}

	if(dstartpos < 0) dstartpos = 0;
	if(dcurrent < 0) dcurrent = 0;

	for(i = dstartpos; i < min(dstartpos+perpage, localdict.size()-1); i++) {
	    dw = localdict.get(i);
	    dm.additem(0, i, " " + dw.getword());
	}

	dm.setpos(dcurrent-dstartpos);

	if(n = dm.open()) {
	    dcurrent = dstartpos+n-1;

	    if(!lookuptext.empty()) {
		lookuptext = "";
		kwriteat(halfpos+2, LINES-3, string(COLS-halfpos-3, ' ').c_str(), getcolor(cp_main_hl));
	    }

	    switch(dm.getlastkey()) {
		case KEY_UP:
		    dstartpos -= perpage/2;
		    dcurrent--;
		    break;
		case KEY_DOWN:
		    dstartpos += perpage/2;
		    dcurrent++;
		    break;
		case KEY_HOME:
		    dstartpos = dcurrent = 0;
		    break;
		case KEY_END:
		    dstartpos = dcurrent = localdict.size();
		    break;
		case KEY_NPAGE:
		    break;
		case KEY_PPAGE:
		    break;
		case '\r':
		    lookup();
		    break;
	    }
	}
    }
}

void ncursesui::exec() {
    readconf();

#ifdef DEBUGTEST
    if(!localdict.is_open())
    if(g.dbegin() != g.dend()) {
	localdict.open((g.dend()-1)->name);
    }

    if(localdict.is_open()) {
	string buf;
	unsigned long n;
	groandict::dictword dw;

	kendinterface();
	cout << "ready" << endl;

	while(1) {
	    cin >> buf;
	    if(buf == "/q") break;

	    if(localdict.find(buf, n)) {
		dw = localdict.get(n);
		cout << endl << dw.getword() << endl;
		cout << dw.gettranslation() << endl << endl;
	    } else {
		cout << "not found" << endl;
	    }
	}
    }

#else

    init();

    if(!localdict.is_open())
    if(g.dbegin() != g.dend()) {
	localdict.open((g.dend()-1)->name);
    }

    mainloop();
    done();

#endif
}

int ncursesui::menukeys(verticalmenu &m, int k) {
    string cltext = thisui.getlookuptext();

    switch(k) {
	case KEY_F(1):
	    thisui.help();
	    return 0;

	case KEY_F(2):
	    thisui.gotoword();
	    return 0;

	case KEY_F(5):
	    thisui.changedict();
	    thisui.finished = !localdict.is_open();
	    return 0;

	case KEY_F(10):
	    thisui.finished = true;
	    return 0;

	default:
	    if(k > 31 && k < 256) {
		thisui.setlookuptext(cltext + (char) k);
		thisui.quickmove();
		return 0;
	    } else {
		switch(k) {
		    case KEY_BACKSPACE:
			if(!cltext.empty()) cltext.erase(cltext.size()-1);
			thisui.setlookuptext(cltext);
			thisui.quickmove();
			return 0;
		    case KEY_DC:
			thisui.setlookuptext("");
			thisui.quickmove();
			return 0;
		}
	    }
	    break;
    }

    return -1;
}

int ncursesui::browserkeys(textbrowser &b, int k) {
    switch(k) {
	case '\r':
	case KEY_F(10):
	    return 0;
    }

    return -1;
}

const string ncursesui::getlookuptext() const {
    return lookuptext;
}

void ncursesui::setlookuptext(const string atext) {
    lookuptext = atext;
}

void ncursesui::log(const string amsg) {
    int offs = statmsg.empty() ? 0 : statmsg.size()+3;

    kwriteat(offs, LINES-1, (amsg + string(COLS-amsg.size()-offs, ' ')).c_str(),
	getcolor(cp_main_stat));
}

bool ncursesui::input(groanui::inputkind kind, string &result, const string prompt) {
    int sh;
    screenarea sa(0, LINES-2, COLS, LINES-2);

    switch(kind) {
	case file:
	    sh = 8;
	    kwriteat(COLS-8, LINES-2, "[Ctrl-T]", getcolor(cp_main_input));
	    inp.connectselector(fsel);
	    break;
	case text:
	    sh = 0;
	    inp.removeselector();
	    break;
    }

    kwriteat(0, LINES-2, prompt.c_str(), getcolor(cp_main_stat));

    inp.setvalue(result);
    inp.setcoords(prompt.size(), LINES-2, COLS-prompt.size()-sh);
    inp.exec();
    sa.restore();

    if(inp.getlastkey() == '\r') {
	result = inp.getvalue();
	return true;
    }

    return false;
}

void ncursesui::help() const {
    dialogbox db;
    string htext;

    db.setwindow(new textwindow(0, 0, DIALOG_WIDTH, DIALOG_HEIGHT,
	getcolor(cp_dlg_frame), TW_CENTERED,
	getcolor(cp_dlg_hl), _(" Help ")));

    db.setbar(new horizontalbar(getcolor(cp_dlg_text),
	getcolor(cp_dlg_sel), _("Ok"), 0));

    htext  = _(" F1  This help screen\n");
    htext += _(" F2  Go to word number..\n");
    htext += _(" F5  Invoke the dictionary manager\n");
    htext += _("F10  Quit the program\n");
    htext += (string) "\n" + _("To lookup a word just type it and press Enter. Del clears the lookup line.\n");

    db.setbrowser(new textbrowser(getcolor(cp_dlg_text)));
    db.getbrowser()->setbuf(htext);

    db.open();
    db.close();
}

void ncursesui::status() const {
    string st;
    string::iterator i;

    st = (string) PACKAGE + " " + VERSION;
    for(i = st.begin(); i != st.end(); *i = toupper(*i), i++);

    attrset(getcolor(cp_main_stat));
    mvhline(0, 0, ' ', COLS);

    kwriteat(2, 0, st.c_str(), getcolor(cp_main_stat));

    if(!(st = localdict.getname()).empty()) {
	st.insert(0, "file://");
	kwriteat(COLS-st.size()-1, 0, st.c_str(), getcolor(cp_main_stat));
    }
}

void ncursesui::gotoword() {
    static string buf;
    unsigned long i;

    if(input(text, buf, _("Word number: "))) {
	if(i = strtoul(buf.c_str(), 0, 0)) {
	    dcurrent = i;
	}
    }
}

void ncursesui::usage() const {
    kendinterface();

    cout << "groan command line usage:" << endl <<
    "\t--ascii, -a\t\tuse ascii characters to draw boxes" << endl <<
    "\t--help, -h\t\tdisplay this help" << endl;

    exit(0);
}

void ncursesui::commandline(int argc, char **argv) {
    int r;
    string slong;

    while((r = getopt(argc, argv, "ah-:")) != -1)
    switch(r) {
	case 'a':
	    kintf_graph = 0;
	    break;
	case '?':
	case 'h':
	    usage();
	    break;
    }

    for(r = 1; argv[r]; r++) {
	slong = argv[r];

	if(slong == "--ascii") {
	    kintf_graph = 0;
	} else if(slong == "--help") {
	    usage();
	}
    }
}
