#ifndef __GROANDICT_H__
#define __GROANDICT_H__

#include "common.h"

#define PARAGRAPH_LINES   16

class groandict {
    public:
	class dictword {
	    private:
		string word, trans;

	    public:
		dictword(const string desc = "");
		~dictword();

		const string getword() const;
		const string gettranslation() const;
	};

    private:
	typedef pair<unsigned long, string> paragraph;

	ifstream f;
	string name;

	unsigned long cpgnumber;
	vector<dictword> cpgwords;

	vector<paragraph> paragraphs;
	vector<unsigned long> words;

	short comparewords(string fs, string ss);
	void readparagraph(unsigned long windex);

    public:
	groandict();
	groandict(const string afname);
	~groandict();

	void open(const string afname);
	bool is_open() const;
	void close();
	int size() const;

	const string getname() const;

	bool find(const string aword, unsigned long &aindex);
	dictword get(unsigned long aindex);
};

extern groandict localdict;

#endif
