#include "groandict.h"
#include "groanui.h"
#include "groan.h"

groandict localdict;

groandict::groandict() {
}

groandict::groandict(const string afname) {
    open(afname);
}

groandict::~groandict() {
}

void groandict::open(const string fname) {
    int count;
    unsigned long pos;
    time_t st;
    string buf;

    if(f.is_open()) return;

    f.open(fname.c_str());

    if(f.is_open()) {
	name = fname;
	time(&st);

	ui.logf(_("Reading index from %s.."), name.c_str());

	paragraphs.clear();
	words.clear();

	for(count = PARAGRAPH_LINES; !f.eof(); count++) {
	    pos = f.tellg();
	    words.push_back(pos);
	    getstring(f, buf);

	    if(count >= PARAGRAPH_LINES) {
		count = 0;
		paragraphs.push_back(paragraph(pos, getword(buf, "=")));
	    }
	}

	ui.logf(_("It took %d seconds to load the dictionary. %lu words total."),
	    time(0)-st, words.size());
    } else {
	ui.logf(_("Unable to open %s"), name.c_str());
    }
}

short groandict::comparewords(string fs, string ss) {
    string::iterator fi, si;
    static const string delims = "|";
    unsigned char fc, sc;

    for(fi = fs.begin(), si = ss.begin();
    fi != fs.end() && si != ss.end(); fi++, si++) {
	if(delims.find(*fi) != -1) {
	    si--;
	} else {
	    fc = g.tolower(*fi);
	    sc = g.tolower(*si);

	    if(fc > sc) return 1; else
	    if(fc < sc) return -1;
	}
    }

    return ss.size() > fs.size() ? -1 : 0;
}

void groandict::readparagraph(unsigned long windex) {
    int i;
    string buf;

    cpgnumber = (windex/PARAGRAPH_LINES);
    cpgwords.clear();

    f.clear();
    f.seekg(paragraphs[cpgnumber].first);

    for(i = 0; (i < PARAGRAPH_LINES) && !f.eof(); i++) {
	getline(f, buf);
	cpgwords.push_back(dictword(buf));
    }
}

bool groandict::find(const string aword, unsigned long &aindex) {
    bool r;
    int bval;
    unsigned long pgbeg, pgend, i;
    vector<dictword>::iterator idw;
    vector<int> compresults;
    vector<int>::iterator icr;

    pgbeg = 0;
    pgend = paragraphs.size();

    while(pgend-pgbeg > 1) {
	i = (pgbeg+pgend)/2;

	if((bval = comparewords(aword, paragraphs[i].second)) > 0) {
	    pgbeg = i;
	} else {
	    pgend = i;
	}

#ifdef DEBUGTEST
	cout << "find: " << paragraphs[i].second << " and " << aword
	    << " = " << bval << endl;
#endif
    }

    for(i = pgbeg, r = false; (i <= pgend) && !r; i++) {
	readparagraph(i*PARAGRAPH_LINES);
	compresults.clear();

	for(idw = cpgwords.begin(); idw != cpgwords.end(); idw++) {
	    compresults.push_back(bval = comparewords(idw->getword(), aword));
#ifdef DEBUGTEST
	    cout << bval << ": " << idw->getword() << " and " << aword << endl;
#endif
	}

	r = (icr = ::find(compresults.begin(), compresults.end(), 0)) != compresults.end();

	if(r) {
	    aindex = icr-compresults.begin();
	} else {
	    bval = *compresults.begin();
	    for(icr = compresults.begin()+1; icr != compresults.end(); icr++) {
		if(bval != *icr) {
		    aindex = icr-compresults.begin();
		    break;
		}
		bval = *icr;
	    }
	}

	aindex += cpgnumber*PARAGRAPH_LINES;
    }

    return r;
}

groandict::dictword groandict::get(unsigned long aindex) {
    string buf;

    f.clear();
    f.seekg(words[aindex]);
    getline(f, buf);

    return dictword(buf);
}

bool groandict::is_open() const {
    return f.is_open();
}

int groandict::size() const {
    return words.size();
}

const string groandict::getname() const {
    return name;
}

void groandict::close() {
    if(f.is_open()) {
	f.close();
	f.clear();
    }
}

// ----------------------------------------------------------------------------

groandict::dictword::dictword(const string desc) {
    string buf = desc;
    string::iterator i;

    word = ::getword(buf, "=");
    trans = buf;

    word = leadcut(trailcut(word));

    i = trans.begin();
    while((i = ::find(i, trans.end(), ';')) != trans.end()) {
	*i = '\n';
	i++;
    }
}

groandict::dictword::~dictword() {
}

const string groandict::dictword::getword() const {
    return word;
}

const string groandict::dictword::gettranslation() const {
    return trans;
}
