#ifndef __GROAN_H__
#define __GROAN_H__

#include "common.h"

class groan {
    public:
	enum dicttype {
	    dtlocal,
	    dtserver
	};

	struct dictdef {
	    string name;
	    dicttype type;

	    dictdef(const string aname, dicttype atype);
	    const string totext() const;

	    bool operator == (dicttype atype) const;
	    bool operator != (dicttype atype) const;

	    bool operator == (const string defstr) const;
	    bool operator != (const string defstr) const;
	};

	typedef vector<dictdef> dictlist;

    private:
	dictlist dlist;

	unsigned char *SC,
	    SC1[256], // russian sort order
	    SC2[256]; // european sort order

	void initcharset();

    public:
	groan();
	~groan();

	void exec();
	void commandline(int argc, char **argv);
	void draw();

	const string getconfname(const string confname) const;

	void readconf();
	void saveconf();

	dictlist::iterator dbegin();
	dictlist::iterator dend();

	bool dictadd(const string def);
	void dictremove(dictlist::iterator id);

	char tolower(char c) const;
};

extern groan g;

#endif
