#include "groan.h"
#include "groanui.h"
#include "groandict.h"

groan::groan() {
    initcharset();
}

groan::~groan() {
}

char groan::tolower(char c) const {
    return (char) SC[(unsigned char) c];
}

void groan::commandline(int argc, char **argv) {
    ui.commandline(argc, argv);
}

void groan::exec() {
    ui.exec();
}

const string groan::getconfname(const string confname) const {
    string r;

    r = (string) getenv("HOME") + "/.groan/" + confname;
    if(access(r.c_str(), R_OK)) r = (string) SHARE_DIR + "/" + confname;

    return r;
}

void groan::readconf() {
    ifstream f;
    string buf, sect;

    f.open(getconfname("conf").c_str());
    if(f.is_open()) {

	while(getconf(sect, buf, f)) {
	    if(sect == "registered") {
		dictadd(buf);
	    }
	}

	f.close();
	f.clear();
    }
}

void groan::saveconf() {
    string dname;
    ofstream f;
    dictlist::iterator id, cid;

    dname = (string) getenv("HOME") + "/.groan";
    if(access(dname.c_str(), X_OK)) {
	mkdir(dname.c_str(), S_IRWXU);
    }

    f.open((dname + "/conf").c_str());
    if(f.is_open()) {
	f << "%registered" << endl;

	cid = dend();

	for(id = dbegin(); id != dend(); id++) {
	    if(localdict.getname() != id->name) {
		f << id->totext() << endl;
	    } else {
		cid = id;
	    }
	}

	if(cid != dend()) {
	    f << cid->totext() << endl;
	}

	f.close();
	f.clear();
    }
}

groan::dictlist::iterator groan::dbegin() {
    return dlist.begin();
}

groan::dictlist::iterator groan::dend() {
    return dlist.end();
}

bool groan::dictadd(const string def) {
    bool r;
    int pos;
    string kind, fname;

    if(r = (pos = def.find("://")))
    if(find(dlist.begin(), dlist.end(), def) == dlist.end()) {
	kind = def.substr(0, pos);
	fname = def.substr(pos+3);

	if(kind == "file") {
	    if(r = !access(fname.c_str(), R_OK)) {
		dlist.push_back(dictdef(fname, dtlocal));
	    }
	}
    }

    return r;
}

void groan::dictremove(dictlist::iterator id) {
    dlist.erase(id);
}

/*
*
* Code taken from slowo by D. Anisimow
*
*/

void groan::initcharset() {
    short i;

    SC = SC1;

    for(i = 0; i < 256; i++) {
	SC[i] = i;
    }

    for(i = 65; i < 91; i++) {
	SC[i] = i+32;
    }

    SC[193] = SC[225] = 128;
    SC[194] = SC[226] = 129;
    SC[215] = SC[247] = 130;
    SC[199] = SC[231] = 131;
    SC[196] = SC[228] = 132;
    SC[197] = SC[229] = 133;
    SC[214] = SC[246] = 134;
    SC[218] = SC[250] = 135;
    SC[201] = SC[233] = 136;
    SC[202] = SC[234] = 137;
    SC[203] = SC[235] = 138;
    SC[204] = SC[236] = 139;
    SC[205] = SC[237] = 140;
    SC[206] = SC[238] = 141;
    SC[207] = SC[239] = 142;
    SC[208] = SC[240] = 143;
    SC[210] = SC[242] = 144;
    SC[211] = SC[243] = 145;
    SC[212] = SC[244] = 146;
    SC[213] = SC[245] = 147;
    SC[198] = SC[230] = 148;
    SC[200] = SC[232] = 149;
    SC[195] = SC[227] = 150;
    SC[222] = SC[254] = 151;
    SC[219] = SC[251] = 152;
    SC[221] = SC[253] = 153;
    SC[216] = SC[248] = 154;
    SC[217] = SC[249] = 155;
    SC[223] = SC[255] = 156;
    SC[220] = SC[252] = 157;
    SC[192] = SC[224] = 158;
    SC[209] = SC[241] = 160;

    SC = SC2;

    for(i = 0; i < 256; i++) {
	SC[i] = i;
    }

    for(i = 65; i < 91; i++) {
	SC[i] = i+32;
    }

    SC[192] = SC[193]=SC[194]=SC[195]=SC[196]=SC[197]=97; //A
    SC[224] = SC[225]=SC[226]=SC[227]=SC[228]=SC[229]=97; //a
    SC[200] = SC[201]=SC[202]=SC[203]=101; //E
    SC[232] = SC[233]=SC[234]=SC[235]=101; //e
    SC[204] = SC[205]=SC[206]=SC[207]=SC[208]=111; //O
    SC[242] = SC[243]=SC[244]=SC[245]=SC[246]=111; //o
    SC[223] = 115; //s
    SC[217] = SC[218]=SC[219]=SC[220]=117; //U
    SC[249] = SC[250]=SC[251]=SC[252]=117; //u
    SC[221] = SC[253]=SC[255]=121; // y

    SC = SC1;
}

// ----------------------------------------------------------------------------

groan::dictdef::dictdef(const string aname, dicttype atype) {
    name = aname, type = atype;
}

bool groan::dictdef::operator == (dicttype atype) const {
    return type == atype;
}

bool groan::dictdef::operator != (dicttype atype) const {
    return !(*this == atype);
}

bool groan::dictdef::operator == (const string defstr) const {
    return totext() == defstr;
}

bool groan::dictdef::operator != (const string defstr) const {
    return !(*this == defstr);
}

const string groan::dictdef::totext() const {
    return (string) (type == dtlocal ? "file://" : "dict://") + name;
}
