/*
			       Zip Tool IO

	Zip Tool window with the low-level Zip Tool program IO.
 */

#ifndef ZIP_TOOL_IO_H
#define ZIP_TOOL_IO_H

#include <glib.h>
#include "../libendeavour2-base/endeavour2.h"


/*
 *      Zip Tool Lock States:
 */
typedef enum {
	ZIP_TOOL_LOCK_STATE_UNLOCKED,
	ZIP_TOOL_LOCK_STATE_LOCKED,
	ZIP_TOOL_LOCK_STATE_LOCKED_PASSWORD
} ZipToolLockState;


extern gchar *zt_last_error(void);

extern gint zt_mount(EDVDevice *dev_ptr);
extern gint zt_unmount(EDVDevice *dev_ptr);
extern ZipToolLockState zt_device_is_protected(
	EDVDevice *dev_ptr
);
extern gint zt_lock(
	EDVDevice *dev_ptr, const gchar *password
);
extern gint zt_unlock(
	EDVDevice *dev_ptr, const gchar *password
);
extern gint zt_spin_down(EDVDevice *dev_ptr);
extern gint zt_eject(EDVDevice *dev_ptr);


#endif	/* ZIP_TOOL_IO_H */
