/*
				Zip Tool Window
 */

#ifndef ZIPTOOL_H
#define ZIPTOOL_H

#include <gtk/gtk.h>
#include "../edv_types.h"
#include "../tool_bar.h"
#include "../libendeavour2-base/endeavour2.h"
#include "zip_tool_io.h"



typedef struct _ZipToolOPID			ZipToolOPID;
#define ZIP_TOOL_OPID(p)			((ZipToolOPID *)(p))

typedef struct _ZipTool				ZipTool;
#define ZIP_TOOL(p)				((ZipTool *)(p))


/*
 *	Operations
 */
#define ZIP_TOOL_OPID_CLOSE			10
#define ZIP_TOOL_OPID_EXIT			11

#define ZIP_TOOL_OPID_MOUNT			30
#define ZIP_TOOL_OPID_UNMOUNT			31

#define ZIP_TOOL_OPID_SPIN_DOWN			35
#define ZIP_TOOL_OPID_EJECT			36

#define ZIP_TOOL_OPID_PASSWORD			40

#define ZIP_TOOL_OPID_BROWSE			50
#define ZIP_TOOL_OPID_REFRESH			51
#define ZIP_TOOL_OPID_FSCK			52


/*
 *	Zip Tool Window Operation ID:
 */
struct _ZipToolOPID {

	gint		id;
	gpointer	zt;			/* Pointer back to Zip Tool Window */

	gchar		*name;			/* Full name */
	gchar		*button_name;		/* Short name (used in buttons) */
 	guint8		**icon_data;		/* Shared */
	gchar		*tooltip;		/* Tooltip message */

	void (*func_cb)(GtkWidget *, gpointer);
	gint (*func_enter_cb)(GtkWidget *, GdkEventCrossing *, gpointer);
	gint (*func_leave_cb)(GtkWidget *, GdkEventCrossing *, gpointer);

};


/*
 *	Zip Tool Window:
 */
struct _ZipTool {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gint		freeze_count,
			busy_count;
	EDVContext	*ctx;

	GdkCursor	*busy_cur,
			*text_cur;

	GList		*opid;

	GtkWidget	*tool_bar;

	GtkWidget	*main_vbox,
			*tool_bar_handle,
			*display_event_box,
			*display_parent,	/* GtkVBox */
			*display_child,		/* GtkHBox */
			*capacity_pie_chart,
			*display_mount_path_btn,
			*display_mount_btn,
			*display_lock_btn;

	/* Status bar widgets */
	GtkWidget	*status_label;

	GtkWidget	*menu,			/* Right click menu */
			*mount_mi,
			*unmount_mi,
			*spin_down_mi,
			*eject_mi,
			*password_mi,
			*fsck_mi,
			*refresh_mi;

	/* IOMega Jaz or Zip drive device reference */
	EDVDevice	*device;

	ZipToolLockState	lock_state;

};


/* OPID */
extern ZipToolOPID *zt_opid_new(void);
extern void zt_opid_delete(ZipToolOPID *opid);

/* OPIDs List */
extern ZipToolOPID *zt_opids_list_find(
	GList *opids_list,
	const gint id
);
extern GList *zt_opids_list_new(ZipTool *zt);
extern void zt_opids_list_delete(GList *opid);

/* Set Device */
extern void zt_set_device(
	ZipTool *zt,
	EDVDevice *dev
);

/* Refresh Device */
extern void zt_refresh_device(
	ZipTool *zt,
	EDVDevice *dev
);

/* ZipTool */
extern ZipTool *zt_new(EDVContext *ctx);
extern void zt_update_display(ZipTool *zt);
extern void zt_set_busy(
	ZipTool *zt,
	const gboolean busy
);
extern void zt_status_message(
	ZipTool *zt, const gchar *mesg,
	gboolean allow_gtk_iteration

);
extern gboolean zt_is_mapped(ZipTool *zt);
extern void zt_map(ZipTool *zt);
extern void zt_unmap(ZipTool *zt);
extern void zt_delete(ZipTool *zt);


#endif	/* ZIPTOOL_H */
