/*
            Endeavour Mark II - VFS Browser - Directory GtkCTree
 */

#ifndef VFS_BROWSER_TREE_H
#define VFS_BROWSER_TREE_H

#include <gtk/gtk.h>

#include "edv_types.h"
#include "libendeavour2-base/edv_vfs_obj.h"
#include "edv_device.h"
#include "vfs_browser.h"


/* Node Utilities */
extern GtkCTreeNode *edv_vfs_browser_tree_get_toplevel_node(EDVVFSBrowser *browser);

/* Origin Path */
extern void edv_vfs_browser_tree_set_origin_path(
	EDVVFSBrowser *browser,
	const gchar *path
);

/* Get Listing */
extern void edv_vfs_browser_tree_create_toplevel_nodes(EDVVFSBrowser *browser);
extern void edv_vfs_browser_tree_get_node_listing(
	EDVVFSBrowser *browser,
	GtkCTreeNode *node,
	const gboolean show_progress
);
extern void edv_vfs_browser_tree_clear(EDVVFSBrowser *browser);

/* Expanding */
extern void edv_vfs_browser_tree_expand_node(
	EDVVFSBrowser *browser,
	GtkCTreeNode *node,
	const gboolean show_progress
);

/* Realize Listing */
extern void edv_vfs_browser_tree_realize_node_listing(
	EDVVFSBrowser *browser,
	GtkCTreeNode *node
);

/* Selecting */
extern void edv_vfs_browser_tree_select_path(
	EDVVFSBrowser *browser,
	const gchar *path
);

/* Finding */
extern GtkCTreeNode *edv_vfs_browser_tree_find_by_index(
	EDVVFSBrowser *browser,
	const gulong device_index, const gulong index
);
extern GtkCTreeNode *edv_vfs_browser_tree_find_by_path(
	EDVVFSBrowser *browser,
	const gchar *path
);

/* Removing */
extern void edv_vfs_browser_tree_remove_grand_children_nodes(
	EDVVFSBrowser *browser,
	GtkCTreeNode *node
);

/* Opening */
extern void edv_vfs_browser_tree_open_with(
	EDVVFSBrowser *browser,
	GtkCTreeNode *node
);

/* Renaming */
extern void edv_vfs_browser_tree_rename_query(
	EDVVFSBrowser *browser,
	GtkCTreeNode *node
);

/* EDVVFSObject Callbacks */
extern void edv_vfs_browser_tree_vfs_object_added_cb(
	EDVVFSBrowser *browser,
	const gchar *path,
	EDVVFSObject *obj
);
extern void edv_vfs_browser_tree_vfs_object_modified_cb(
	EDVVFSBrowser *browser,
	const gchar *path,
	const gchar *new_path,
	EDVVFSObject *obj
);
extern void edv_vfs_browser_tree_vfs_object_removed_cb(
	EDVVFSBrowser *browser,
	const gchar *path
);

/* EDVDevice Mount Callbacks */
extern void edv_vfs_browser_tree_vfs_object_device_mount_cb(
	EDVVFSBrowser *browser,
	EDVDevice *d,
	const gboolean mounted
);


#endif	/* VFS_BROWSER_TREE_H */
