/*
             Endeavour Mark II - VFS Browser - Operations
 */

#ifndef VFS_BROWSER_OP_H
#define VFS_BROWSER_OP_H

#include <gtk/gtk.h>
#include "tool_bar.h"
#include "edv_types.h"
#include "libendeavour2-base/edv_vfs_obj.h"
#include "edv_device.h"
#include "edv_mount_bar.h"
#include "edv_find_bar.h"
#include "edv_status_bar.h"
#include "vfs_browser.h"


extern void edv_vfs_browser_op_cb(
	ToolBarItem *item,
	const gint id,
	gpointer data
);
extern void edv_vfs_browser_op_enter_cb(
	ToolBarItem *item,
	const gint id,
	gpointer data
);
extern void edv_vfs_browser_op_leave_cb(
	ToolBarItem *item,
	const gint id,
	gpointer data
);

extern void edv_vfs_browser_op_close(EDVVFSBrowser *browser);

extern void edv_vfs_browser_op_paste(EDVVFSBrowser *browser);
extern void edv_vfs_browser_op_paste2(
        EDVVFSBrowser *browser,
        EDVVFSObject *obj
);

extern void edv_vfs_browser_op_refresh(EDVVFSBrowser *browser);
extern void edv_vfs_browser_op_refresh_all(EDVVFSBrowser *browser);


#endif	/* VFS_BROWSER_OP_H */
