/*
            Endeavour Mark II - VFS Browser - Contents GtkCList
 */

#ifndef VFS_BROWSER_LIST_H
#define VFS_BROWSER_LIST_H

#include <gtk/gtk.h>
#include "vfs_browser.h"


/* Columns */
extern gint edv_vfs_browser_list_get_column_index_by_type(
        EDVVFSBrowser *browser,
        const EDVVFSBrowserColumnType column_type
);
extern gint edv_vfs_browser_list_get_column_width_by_type(
        EDVVFSBrowser *browser,
        const EDVVFSBrowserColumnType column_type
);
extern EDVVFSBrowserColumnType edv_vfs_browser_list_get_column_type_by_index(
        EDVVFSBrowser *browser,
        const gint column_num
);
extern void edv_vfs_browser_list_set_column_width_by_type(
        EDVVFSBrowser *browser,
        const EDVVFSBrowserColumnType column_type,
        const gint width
);
extern void edv_vfs_browser_list_resize_column_optimul(
	EDVVFSBrowser *browser,
	const gint column_num
);
extern void edv_vfs_browser_list_resize_columns_optimul(EDVVFSBrowser *browser);

/* Finding */
extern gint edv_vfs_browser_list_find_by_index(
	EDVVFSBrowser *browser,
	const gulong device_index, const gulong index
);
extern gint edv_vfs_browser_list_find_by_path(
	EDVVFSBrowser *browser,
	const gchar *path
);

/* Realize Listing */
extern void edv_vfs_browser_list_realize_listing(EDVVFSBrowser *browser);

/* Get Listing */
extern void edv_vfs_browser_list_get_listing(
	EDVVFSBrowser *browser,
	const gchar *path,
	const gboolean show_progress
);
extern void edv_vfs_browser_list_clear(EDVVFSBrowser *browser);

/* Opening */
extern void edv_vfs_browser_list_open(
	EDVVFSBrowser *browser,
	const gint row, const gint column,
	const guint state
);
extern void edv_vfs_browser_list_open_with(
	EDVVFSBrowser *browser,
	const gint row, const gint column
);

/* Renaming */
extern void edv_vfs_browser_list_rename_query(
	EDVVFSBrowser *browser,
	const gint row, const gint column
);

/* EDVVFSObject Callbacks */
extern void edv_vfs_browser_list_vfs_object_added_cb(
	EDVVFSBrowser *browser,
	const gchar *path,
	EDVVFSObject *obj
);
extern void edv_vfs_browser_list_vfs_object_modified_cb(
	EDVVFSBrowser *browser,
	const gchar *path,
	const gchar *new_path,
	EDVVFSObject *obj
);
extern void edv_vfs_browser_list_vfs_object_removed_cb(
	EDVVFSBrowser *browser,
	const gchar *path
);

/* EDVDevice Mount Callbacks */
extern void edv_vfs_browser_list_device_mount_cb(
	EDVVFSBrowser *browser,
	EDVDevice *d,
	const gboolean mounted
);


#endif	/* VFS_BROWSER_LIST_H */
