/*
                Endeavour Mark II - VFS Browser - Callbacks
 */

#ifndef VFS_BROWSER_CB_H
#define VFS_BROWSER_CB_H

#include <gtk/gtk.h>
#include "edv_device.h"
#include "edv_mime_type.h"
#include "vfs_browser.h"


/* GTK+ Signal Callbacks */
extern void edv_vfs_browser_realize_cb(GtkWidget *widget, gpointer data);
extern gint edv_vfs_browser_delete_event_cb(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
extern gint edv_vfs_browser_key_event_cb(
	 GtkWidget *widget, GdkEventKey *key, gpointer data
);
extern gint edv_vfs_browser_button_event_cb(
	GtkWidget *widget, GdkEventButton *button, gpointer data
);

extern void edv_vfs_browser_handle_child_attach_cb(
        GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);
extern void edv_vfs_browser_handle_child_detach_cb(
        GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);

extern void edv_vfs_browser_location_bar_icon_realize_cb(GtkWidget *widget, gpointer data);

extern void edv_vfs_browser_tree_select_row_cb(
	GtkCTree *ctree, GtkCTreeNode *node, gint column,
	gpointer data
);
extern void edv_vfs_browser_tree_unselect_row_cb(
	GtkCTree *ctree, GtkCTreeNode *node, gint column,
	gpointer data
);
extern void edv_vfs_browser_tree_expand_cb(
	GtkCTree *ctree, GtkCTreeNode *node, gpointer data
);
extern void edv_vfs_browser_tree_collapse_cb(
	GtkCTree *ctree, GtkCTreeNode *node, gpointer data
);

extern void edv_vfs_browser_list_realize_cb(GtkWidget *widget, gpointer data);
extern void edv_vfs_browser_resize_column_cb(
	GtkCList *clist, gint column, gint width, gpointer data
);
extern void edv_vfs_browser_click_column_cb(
	GtkCList *clist, gint column, gpointer data
);
extern void edv_vfs_browser_list_select_row_cb(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);
extern void edv_vfs_browser_list_unselect_row_cb(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);

extern void edv_vfs_browser_location_combo_activate_cb(GtkWidget *widget, gpointer data);

/* Menu Item Callbacks */
extern void edv_vfs_browser_menu_item_cb(GtkWidget *widget, gpointer data);
extern gint edv_vfs_browser_menu_item_enter_cb(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint edv_vfs_browser_menu_item_leave_cb(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern void edv_vfs_browser_menu_item_cmd_object_op_cb(GtkWidget *widget, gpointer data);
extern void edv_vfs_browser_menu_item_cmd_new_object_cb(GtkWidget *widget, gpointer data);
extern gint edv_vfs_browser_menu_item_cmd_enter_cb(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint edv_vfs_browser_menu_item_cmd_leave_cb(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);

/* Paths List Get Callback */
extern GList *edv_vfs_browser_get_selected_paths_cb(gpointer data);

/* Go To Directory Callback */
extern void edv_vfs_browser_goto_directory_cb(gpointer data, const gchar *path);

/* Mount Bar Callbacks */
extern void edv_vfs_browser_mount_bar_mount_cb(
	GtkWidget *widget, const gint dev_num, EDVDevice *dev,
	gpointer data
);
extern void edv_vfs_browser_mount_bar_eject_cb(
	GtkWidget *widget, const gint dev_num, EDVDevice *dev,
	gpointer data
);
extern void edv_vfs_browser_mount_bar_goto_cb(
	GtkWidget *widget, const gint dev_num, EDVDevice *dev,
	gpointer data
);

/* Find Bar Callbacks */
extern const gchar *edv_vfs_browser_find_bar_location_cb(
	GtkWidget *bar,
	gpointer data
);
extern void edv_vfs_browser_find_bar_start_cb(
	GtkWidget *bar,
	gpointer data
);
extern void edv_vfs_browser_find_bar_end_cb(
	GtkWidget *bar,
	const gint nmatches,
	gpointer data
);
extern void edv_vfs_browser_find_bar_match_cb(
	GtkWidget *bar,
	const gchar *path,
	GList *properties_list,
	const gint line_index,
	const gchar *excerpt,
	gpointer data
);

/* Status Bar Callbacks */
extern void edv_vfs_browser_status_message_cb(
	GtkWidget *widget,
	const gchar *message,
	gpointer data
);
extern void edv_vfs_browser_status_progress_cb(
	GtkWidget *widget,
	const gfloat progress,
	gpointer data
);

/* Window Created/Deleted Callbacks */
extern void edv_vfs_browser_window_created_cb(
	EDVVFSBrowser *browser,
	const EDVWindowType win_type,
	gpointer win
);
extern void edv_vfs_browser_window_deleted_cb(
	EDVVFSBrowser *browser,
	const EDVWindowType win_type,
	gpointer win
);

/* Master Write Protect Changed Callback */
extern void edv_vfs_browser_master_write_protect_changed_cb(
	EDVVFSBrowser *browser,
	const gboolean state
);

/* Delete Method Changed Callback */
extern void edv_vfs_browser_delete_method_changed_cb(
	EDVVFSBrowser *browser,
	const EDVDeleteMethod delete_method
);

/* EDVVFSObject Callbacks */
extern void edv_vfs_browser_vfs_object_added_cb(
	EDVVFSBrowser *browser,
	const gchar *path,
	EDVVFSObject *obj
);
extern void edv_vfs_browser_vfs_object_modified_cb(
	EDVVFSBrowser *browser,
	const gchar *path,
	const gchar *new_path,
	EDVVFSObject *obj
);
extern void edv_vfs_browser_vfs_object_removed_cb(
	EDVVFSBrowser *browser,
	const gchar *path
);

/* Mount/Unmount Callback */
extern void edv_vfs_browser_device_mount_cb(
	EDVVFSBrowser *browser,
	const gint dev_num, EDVDevice *d,
	const gboolean mounted
);

/* EDVRecycledObject Callbacks */
extern void edv_vfs_browser_recycled_object_added_cb(
	EDVVFSBrowser *browser,
	const guint index
);
extern void edv_vfs_browser_recycled_object_modified_cb(
	EDVVFSBrowser *browser,
	const guint index
);
extern void edv_vfs_browser_recycled_object_removed_cb(
	EDVVFSBrowser *browser,
	const guint index
);

/* Reconfigured Callback */
extern void edv_vfs_browser_reconfigured_cb(EDVVFSBrowser *browser);

/* EDVMIMEType Callbacks */
extern void edv_vfs_browser_mime_type_added_cb(
	EDVVFSBrowser *browser,
	const gint mt_num, EDVMIMEType *m
);
extern void edv_vfs_browser_mime_type_modified_cb(
	EDVVFSBrowser *browser,
	const gint mt_num, EDVMIMEType *m
);
extern void edv_vfs_browser_mime_type_removed_cb(
	EDVVFSBrowser *browser,
	const gint mt_num
);

/* EDVDevice Callbacks */
extern void edv_vfs_browser_device_added_cb(
	EDVVFSBrowser *browser,
	const gint dev_num, EDVDevice *d
);
extern void edv_vfs_browser_device_modified_cb(
	EDVVFSBrowser *browser,
	const gint dev_num, EDVDevice *d
);
extern void edv_vfs_browser_device_removed_cb(
	EDVVFSBrowser *browser,
	const gint dev_num
);


#endif	/* VFS_BROWSER_CB_H */
