/*
                       Endeavour Mark II - VFS Browser
 */

#ifndef VFS_BROWSER_H
#define VFS_BROWSER_H

#include <gtk/gtk.h>
#include "cfg.h"
#include "guiutils.h"
#include "tool_bar.h"
#include "edv_types.h"
#include "edv_mime_type.h"


typedef struct _EDVVFSBrowser		EDVVFSBrowser;
#define EDV_VFS_BROWSER(p)		((EDVVFSBrowser *)(p))

typedef struct _EDVVFSBrowserOp		EDVVFSBrowserOp;
#define EDV_VFS_BROWSER_OP(p)		((EDVVFSBrowserOp *)(p))

typedef struct _EDVVFSBrowserCommand	EDVVFSBrowserCommand;
#define EDV_VFS_BROWSER_COMMAND(p)	((EDVVFSBrowserCommand *)(p))
#define EDV_VFS_BROWSER_COMMAND_DATA_KEY	\
					"EDV/VFSBrowser/Command"


/*
 *	Flags:
 */
typedef enum {
	EDV_VFS_BROWSER_MAPPED		= (1 << 0),
	EDV_VFS_BROWSER_REALIZED	= (1 << 1),
	EDV_VFS_BROWSER_PROCESSING	= (1 << 2),
	EDV_VFS_BROWSER_TOOL_BAR_MAPPED	= (1 << 4),
	EDV_VFS_BROWSER_LOCATION_BAR_MAPPED	\
					= (1 << 5),
	EDV_VFS_BROWSER_MOUNT_BAR_MAPPED	\
					= (1 << 6),
	EDV_VFS_BROWSER_FIND_BAR_MAPPED	= (1 << 7),
	EDV_VFS_BROWSER_STATUS_BAR_MAPPED	\
					= (1 << 8)
} EDVVFSBrowserFlags;


/*
 *	Column Types:
 */
typedef enum {
	EDV_VFS_BROWSER_COLUMN_TYPE_NAME,
	EDV_VFS_BROWSER_COLUMN_TYPE_SIZE,
	EDV_VFS_BROWSER_COLUMN_TYPE_TYPE,
	EDV_VFS_BROWSER_COLUMN_TYPE_PERMISSIONS,
	EDV_VFS_BROWSER_COLUMN_TYPE_OWNER,
	EDV_VFS_BROWSER_COLUMN_TYPE_GROUP,
	EDV_VFS_BROWSER_COLUMN_TYPE_DATE_ACCESS,
	EDV_VFS_BROWSER_COLUMN_TYPE_DATE_MODIFIED,
	EDV_VFS_BROWSER_COLUMN_TYPE_DATE_CHANGED,
	EDV_VFS_BROWSER_COLUMN_TYPE_HARD_LINKS,
	EDV_VFS_BROWSER_COLUMN_TYPE_LINKED_TO,
	EDV_VFS_BROWSER_COLUMN_TYPE_DEVICE_INDEX,
	EDV_VFS_BROWSER_COLUMN_TYPE_INDEX,
	EDV_VFS_BROWSER_COLUMN_TYPE_DEVICE_TYPE,
	EDV_VFS_BROWSER_COLUMN_TYPE_BLOCK_SIZE,
	EDV_VFS_BROWSER_COLUMN_TYPE_BLOCKS
} EDVVFSBrowserColumnType;
#define EDV_VFS_BROWSER_NCOLUMN_TYPES	16


/*
 *	List Cell Styles:
 *
 *	Cell Style value corresponds to the index of the cell_style
 *	on the EDVVFSBrowser.
 */
typedef enum {
	EDV_VFS_BROWSER_CELL_STYLE_UNKNOWN,
	EDV_VFS_BROWSER_CELL_STYLE_ERROR,
	EDV_VFS_BROWSER_CELL_STYLE_NO_ACCESS,
	EDV_VFS_BROWSER_CELL_STYLE_DANGLING_LINK,
	EDV_VFS_BROWSER_CELL_STYLE_RECURSIVE_LINK,
	EDV_VFS_BROWSER_CELL_STYLE_HIDDEN,
	EDV_VFS_BROWSER_CELL_STYLE_EXECUTABLE
} EDVVFSBrowserCellStyleType;
#define EDV_VFS_BROWSER_NCELL_STYLE_TYPES	\
					7


/*
 *	Command:
 *
 *	Used as data for the object operations GtkMenuItems to store
 *	commands that to be executed when the GtkMenuItem is actvated.
 */
struct _EDVVFSBrowserCommand {

	EDVVFSBrowser	*vfs_browser;

	gchar		*label,
			*command,
			*description,
			*ext_data;

	CfgMenuItemFlags	flags;

};


/*
 *	Operation IDs:
 */
typedef enum {

	EDV_VFS_BROWSER_OP_NONE		= 0,
	EDV_VFS_BROWSER_OP_SEPARATOR	= 100,

	EDV_VFS_BROWSER_OP_CLOSE	= 200,
	EDV_VFS_BROWSER_OP_EXIT		= 201,

	EDV_VFS_BROWSER_OP_SYNC_DISKS	= 301,
	EDV_VFS_BROWSER_OP_HISTORY	= 302,
	EDV_VFS_BROWSER_OP_RUN		= 303,
	EDV_VFS_BROWSER_OP_RUN_TERMINAL	= 304,
	EDV_VFS_BROWSER_OP_WRITE_PROTECT	\
				    	= 305,
	EDV_VFS_BROWSER_OP_DELETE_METHOD_RECYCLE	\
					= 308,
	EDV_VFS_BROWSER_OP_DELETE_METHOD_PURGE	\
					= 309,

	EDV_VFS_BROWSER_OP_NEW		= 400,
	EDV_VFS_BROWSER_OP_NEW_FILE	= 410,
	EDV_VFS_BROWSER_OP_NEW_DIRECTORY	\
					= 412,
	EDV_VFS_BROWSER_OP_NEW_LINK	= 413,
	EDV_VFS_BROWSER_OP_NEW_FIFO	= 414,
	EDV_VFS_BROWSER_OP_NEW_DEVICE_BLOCK	\
					= 415,
	EDV_VFS_BROWSER_OP_NEW_DEVICE_CHARACTER	\
					= 416,
	EDV_VFS_BROWSER_OP_NEW_SOCKET	= 417,

	EDV_VFS_BROWSER_OP_OPEN		= 500,
	EDV_VFS_BROWSER_OP_OPEN_TO	= 501,
	EDV_VFS_BROWSER_OP_OPEN_WITH	= 502,

	EDV_VFS_BROWSER_OP_COPY_PATH	= 601,
	EDV_VFS_BROWSER_OP_COPY_URL	= 602,
	EDV_VFS_BROWSER_OP_PASTE	= 610,

	EDV_VFS_BROWSER_OP_MOVE		= 700,
	EDV_VFS_BROWSER_OP_COPY		= 701,
	EDV_VFS_BROWSER_OP_LINK		= 702,
	EDV_VFS_BROWSER_OP_RENAME	= 703,
	EDV_VFS_BROWSER_OP_CHMOD	= 704,
	EDV_VFS_BROWSER_OP_CHOWN	= 705,
	EDV_VFS_BROWSER_OP_CHTIME	= 706,
	EDV_VFS_BROWSER_OP_DELETE	= 770,
	EDV_VFS_BROWSER_OP_PROPERTIES	= 780,

	EDV_VFS_BROWSER_OP_SELECT_ALL	= 800,
	EDV_VFS_BROWSER_OP_UNSELECT_ALL	= 801,
	EDV_VFS_BROWSER_OP_INVERT_SELECTION	\
					= 802,
	EDV_VFS_BROWSER_OP_FIND		= 850,

	EDV_VFS_BROWSER_OP_DOWNLOAD	= 900,

	EDV_VFS_BROWSER_OP_REFRESH	= 1000,
	EDV_VFS_BROWSER_OP_REFRESH_ALL	= 1001,
	EDV_VFS_BROWSER_OP_GOTO_PARENT	= 1100,
	EDV_VFS_BROWSER_OP_GOTO_HOME	= 1101,
	EDV_VFS_BROWSER_OP_EXPAND	= 1200,

	EDV_VFS_BROWSER_OP_SHOW_TOOL_BAR	\
					= 1300,
	EDV_VFS_BROWSER_OP_SHOW_LOCATION_BAR	\
					= 1301,
	EDV_VFS_BROWSER_OP_SHOW_MOUNT_BAR	\
					= 1302,
	EDV_VFS_BROWSER_OP_SHOW_FIND_BAR	\
					= 1303,
	EDV_VFS_BROWSER_OP_SHOW_STATUS_BAR	\
					= 1304,

	EDV_VFS_BROWSER_OP_LIST_FILTER	\
					= 1400,
	EDV_VFS_BROWSER_OP_CONTENTS_LIST_AUTO_RESIZE_COLUMNS	\
					= 1410,
	EDV_VFS_BROWSER_OP_SHOW_HIDDEN_OBJECTS	\
					= 1420,
	EDV_VFS_BROWSER_OP_SHOW_NOACCESS_OBJECTS	\
					= 1421,

	EDV_VFS_BROWSER_OP_DIRECTORY_TREE_ORIGIN	\
					= 1500,

	EDV_VFS_BROWSER_OP_MOUNT	= 1600,	/* Mount/unmount */
	EDV_VFS_BROWSER_OP_EJECT	= 1620,
	EDV_VFS_BROWSER_OP_DEVICE_CHECK	= 1650,
	EDV_VFS_BROWSER_OP_DEVICE_TOOLS	= 1651,
	EDV_VFS_BROWSER_OP_DEVICE_FORMAT	\
					= 1652,

	EDV_VFS_BROWSER_OP_MIME_TYPES	= 1700,
	EDV_VFS_BROWSER_OP_DEVICES	= 1701,

	EDV_VFS_BROWSER_OP_NEW_BROWSER	= 1800,
	EDV_VFS_BROWSER_OP_NEW_IMBR	= 1801,
	EDV_VFS_BROWSER_OP_NEW_ARCHIVER	= 1802,
	EDV_VFS_BROWSER_OP_RECYCLE_BIN	= 1900,

	EDV_VFS_BROWSER_OP_OPTIONS	= 2000,
	EDV_VFS_BROWSER_OP_CUSTOMIZE	= 2001,

	EDV_VFS_BROWSER_OP_HELP_CONTENTS	\
					= 3000,
	EDV_VFS_BROWSER_OP_HELP_FILE_BROWSER	\
					= 3010,
	EDV_VFS_BROWSER_OP_HELP_IMAGE_BROWSER	\
					= 3011,
	EDV_VFS_BROWSER_OP_HELP_ARCHIVER	\
					= 3012,
	EDV_VFS_BROWSER_OP_HELP_RECYCLE_BIN	\
					= 3030,
	EDV_VFS_BROWSER_OP_HELP_KEYS_LIST	\
					= 3050,
	EDV_VFS_BROWSER_OP_HELP_MIME_TYPES	\
					= 3051,
	EDV_VFS_BROWSER_OP_HELP_DEVICES		\
					= 3052,
	EDV_VFS_BROWSER_OP_HELP_COMMON_OPERATIONS	\
					= 3053,
	EDV_VFS_BROWSER_OP_HELP_ABOUT	= 3100

} EDVVFSBrowserOpID;


/*
 *	Operation:
 */
struct _EDVVFSBrowserOp {

	EDVVFSBrowserOpID	id;
	EDVOpIDFlags	flags;
	ToolBarItemType	tb_item_type;
	EDVVFSBrowser	*vfs_browser;

	/* Operation callback */
	void		(*func_cb)(
		ToolBarItem *,			/* Tool Bar Item */
		gint,				/* EDVBrowserOpID */
		gpointer			/* EDVBrowserOp */
	);

	/* Enter and leave notify callbacks */
	void		(*enter_func_cb)(
		ToolBarItem *,			/* Tool Bar Item */
		gint,				/* EDVBrowserOpID */
		gpointer			/* EDVBrowserOp */
	);
	void		(*leave_func_cb)(
		ToolBarItem *,			/* Tool Bar Item */
		gint,				/* EDVBrowserOpID */
		gpointer			/* EDVBrowserOp */
	);

	gchar		*button_name,		/* Name on a button */
			*menu_name,		/* Name on a menu item */
			*tooltip;		/* Tool tip or description (one line) */

	guint		accel_key,		/* Accelerator key */
			accel_mods;		/* Accelerator key modifiers */

	guint8		**button_icon_data,	/* Shared */
			**menu_icon_data;	/* Shared */

};


/*
 *	VFS Browser:
 */
struct _EDVVFSBrowser {

	GtkWidget	*toplevel;
	EDVCore		*core;
	EDVVFSBrowserFlags	flags;
	gint		freeze_count,
			busy_count,
			stop_count;

	GList		*op_ids_list;

	GtkWidget	*main_vbox,
			*menu_bar,

			*menu_bar_handle,
			*tool_bar_handle,
			*location_bar_handle,
			*mount_bar_handle,
			*find_bar_handle,

			*location_bar_hbox,	/* GtkHBox parent for location bar */
			*location_icon_fixed,
			*location_icon_pm,
			*location_combo,

			*main_paned,		/* GtkHPaned */
			*directory_ctree,	/* Directory GtkCTree */
			*contents_clist;	/* Contents GtkCList */

	guint		directory_ctree_expand_optimize_idleid;

	/* GtkMenus and GtkMenuItems */
	GtkWidget	*file_menu,
			*open_mi,
			*open_to_mi,
			*open_to_menu,
			*open_with_mi,
			*new_object_mi,
			*new_object_menu,
			*new_file_mi,
			*new_directory_mi,
			*new_link_mi,
			*new_fifo_mi,
			*new_device_block_mi,
			*new_device_character_mi,
			*new_socket_mi,
			*sync_disks_mi,
			*history_mi,
			*run_mi,
			*close_mi,

			*edit_menu,
			*move_mi,
			*copy_mi,
			*link_mi,
			*rename_mi,
			*chmod_mi,
			*chown_mi,
			*chtime_mi,
			*delete_mi,
			*copy_path_mi,
			*copy_url_mi,
			*paste_mi,
			*select_all_mi,
			*unselect_all_mi,
			*invert_selection_mi,
			*find_mi,
			*properties_mi,

			*view_menu,
			*refresh_mi,
			*refresh_all_mi,
			*show_tool_bar_micheck,
			*show_location_bar_micheck,
			*show_mount_bar_micheck,
			*show_find_bar_micheck,
			*show_status_bar_micheck,
			*directory_tree_origin_mi,
			*show_hidden_objects_micheck,
			*show_noaccess_objects_micheck,
			*contents_list_filter_mi,
			*contents_list_auto_resize_columns_micheck,
			*mime_types_mi,

			*device_menu,
			*mount_mi,
			*eject_mi,
			*device_check_mi,
			*device_tools_mi,
			*device_format_mi,
			*devices_mi,

			*settings_menu,
			*write_protect_mi,
			*delete_method_recycle_micheck,
			*delete_method_purge_micheck,
			*options_mi,
			*customize_mi,

			*windows_menu,
			*window_new_browser_mi,
			*window_new_imbr_mi,
			*window_new_archiver_mi,
			*window_recycle_bin_mi,

			*help_menu,
			*help_contents_mi,
			*help_file_browser_mi,
			*help_keys_list_mi,
			*help_mime_types_mi,
			*help_devices_mi,
			*help_common_operations_mi,
			*help_about_mi;

	/* Tool Bar */
	GtkWidget	*tool_bar;

	/* Mount Bar */
	GtkWidget	*mount_bar;

	/* Find Bar */
	GtkWidget	*find_bar;

	/* Status Bar */
	GtkWidget	*status_bar;

	/* Directory GtkCTree Right-Click GtkMenu */
	GtkWidget	*directory_ctree_menu,
			*directory_ctree_expand_mi,	/* Expand or colapse */
			*directory_ctree_mount_mi,
			*directory_ctree_eject_mi,
			*directory_ctree_mount_misep,
			*directory_ctree_move_mi,
			*directory_ctree_copy_mi,
			*directory_ctree_link_mi,
			*directory_ctree_rename_mi,
			*directory_ctree_chmod_mi,
			*directory_ctree_chown_mi,
			*directory_ctree_chtime_mi,
			*directory_ctree_delete_mi,
			*directory_ctree_copy_path_mi,
			*directory_ctree_copy_url_mi,
			*directory_ctree_paste_mi,
			*directory_ctree_properties_mi;

	/* Contents GtkCList Right-Click GtkMenu */
	GtkWidget       *contents_clist_menu,
			*contents_clist_open_mi,
			*contents_clist_open_to_mi,
			*contents_clist_open_to_menu,
			*contents_clist_open_with_mi,
			*contents_clist_move_mi,
			*contents_clist_copy_mi,
			*contents_clist_link_mi,
			*contents_clist_rename_mi,
			*contents_clist_chmod_mi,
			*contents_clist_chown_mi,
			*contents_clist_chtime_mi,
			*contents_clist_delete_mi,
			*contents_clist_copy_path_mi,
			*contents_clist_copy_url_mi,
			*contents_clist_paste_mi,
			*contents_clist_properties_mi;


	/* Contents list filter */
	gchar		*contents_list_filter;


	/* Styles for the Directory Tree & Contents List cells */
	GtkStyle	*cell_style[EDV_VFS_BROWSER_NCELL_STYLE_TYPES];

	/* Special icons */
	EDVPixmap	*directory_parent_icon;

	/* Directory toplevel origin directory */
	gchar		*directory_ctree_origin_path;

	/* Last selected node on the ctree (can be NULL)
	 * Note that even if this value is not NULL it should still
	 * be verified that it is a valid node that actuall exists on
	 * the ctree
	 */
	GtkCTreeNode	*directory_ctree_selected_node;

	/* Selected device, reflects the device of the disk object of
	 * the node specified by directory_ctree_selected_node
	 *
	 * This device number corresponds with a device on the core's
	 * list of devices
	 */
	gint		selected_dev_num;

	/* Last selected row on the clist (can be -1 for none)
	 *
	 * Note that this does not reflect other selected rows since
	 * multiple selections are allowed
	 */
	gint		contents_clist_selected_row;


	/* Last known items in recycle bin, this is used as a quick access
	 * value to check if the recycle bin has contents or not
	 *
	 * Can be -1 to indicate undefined
	 */
	gint		last_nrecycle_bin_items;

	/* Last known write protect state (can be -1 to indicate
	 * undefined)
	 */
	gint		last_write_protect_state;

};

#define EDV_VFS_BROWSER_IS_PROCESSING(p)	(((p) != NULL) ?	\
 ((p)->flags & EDV_VFS_BROWSER_PROCESSING) : FALSE)
#define EDV_VFS_BROWSER_IS_FROZEN(p)	(((p) != NULL) ?	\
 ((p)->freeze_count > 0) : FALSE)
#define EDV_VFS_BROWSER_IS_BUSY(p)	(((p) != NULL) ?	\
 ((p)->freeze_count > 0) : FALSE)


/* Utilities */
extern EDVVFSBrowserOp *edv_vfs_browser_op_match_by_id(
	EDVVFSBrowser *browser,
	const EDVVFSBrowserOpID id
);
extern gboolean edv_vfs_browser_is_path_from_tree_origin(
	EDVVFSBrowser *browser,
	const gchar *path
);

/* Title */
extern void edv_vfs_browser_set_title(
	EDVVFSBrowser *browser,
	const gchar *path
);

/* Location */
extern const gchar *edv_vfs_browser_get_location(EDVVFSBrowser *browser);
extern void edv_vfs_browser_set_location(
	EDVVFSBrowser *browser,
	const gchar *path,
	const gboolean record_history
);
extern void edv_vfs_browser_update_location_icon(
	EDVVFSBrowser *browser,
	const gchar *path
);

/* Selected Objects & Paths */
extern GList *edv_vfs_browser_get_selected_objects(
	EDVVFSBrowser *browser,
	const gboolean copy
);
extern GList *edv_vfs_browser_get_selected_paths(EDVVFSBrowser *browser);

/* Regenerating Menus, Bars, etc */
extern void edv_vfs_browser_accelkeys_regenerate(EDVVFSBrowser *browser);
extern void edv_vfs_browser_cell_styles_regenerate(EDVVFSBrowser *browser);
extern void edv_vfs_browser_tool_bar_regenerate(EDVVFSBrowser *browser);
extern void edv_vfs_browser_file_menu_items_regenerate(EDVVFSBrowser *browser);
extern void edv_vfs_browser_new_object_menu_items_regenerate(EDVVFSBrowser *browser);
extern void edv_vfs_browser_open_to_menu_regenerate(
	EDVVFSBrowser *browser,
	EDVMIMEType *m
);
extern void edv_vfs_browser_tree_menu_regenerate(EDVVFSBrowser *browser);
extern void edv_vfs_browser_list_menu_regenerate(EDVVFSBrowser *browser);

/* Sync Configuration */
extern void edv_vfs_browser_sync_configuration(EDVVFSBrowser *browser);

/* EDVVFSBrowserOp */
extern GList *edv_vfs_browser_ops_list_new(EDVVFSBrowser *browser);
extern void edv_vfs_browser_ops_list_delete(GList *opids_list);

/* Accelkeys */
extern CfgAccelkeyList *edv_vfs_browser_accelkeys_new(void);

/* EDVVFSBrowser */
extern EDVVFSBrowser *edv_vfs_browser_new(
	EDVCore *core,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry
);
extern void edv_vfs_browser_sync_data(EDVVFSBrowser *browser);
extern void edv_vfs_browser_update_display(EDVVFSBrowser *browser);
extern void edv_vfs_browser_set_busy(EDVVFSBrowser *browser, const gboolean busy);
extern gboolean edv_vfs_browser_is_mapped(EDVVFSBrowser *browser);
extern void edv_vfs_browser_map(EDVVFSBrowser *browser);
extern void edv_vfs_browser_unmap(EDVVFSBrowser *browser);
extern void edv_vfs_browser_delete(EDVVFSBrowser *browser);


#endif	/* VFS_BROWSER_H */
