/*
		      Universal Resource Location
 */

#ifndef URL_H
#define URL_H

#include <glib.h>


/* The URL structure name space must be named URLStruct because naming
 * it just URL will conflict with its cast macro URL()
 */
typedef struct _URLStruct		URLStruct;
#define URL(p)				((URLStruct *)(p))


/*
 *	URL Flags:
 */
typedef enum {
	URL_PATH_RELATIVE		= (1 << 0)
} URLFlags;


/*
 *	URL:
 */
struct _URLStruct {

	URLFlags	flags;

	/* Protocol ("file", "ftp", "http", "https", etc) */
	gchar		*protocol;

	/* User & Password (may be NULL for none) */
	gchar		*user,
			*password;

	/* Host & Port Number (host may be NULL for none and port
	 * may be 0 for default)
	 */
	gchar		*host;
	gint		port;

	/* Path or Marker (may be NULL for none)
	 *
	 * For recycled objects, this contains the recycled object's
	 * index value as a string
	 */
	gchar		*path;

	/* Path argument, after the '?' character (may be NULL for
	 * none)
	 */
	gchar		*path_arg;

};


extern URLStruct *url_new(void);
extern URLStruct *url_new_with_values(
	const URLFlags flags,
	const gchar *protocol,
	const gchar *user,
	const gchar *password,
	const gchar *host,
	const gint port,
	const gchar *path,
	const gchar *path_arg
);
extern URLStruct *url_new_from_url_string(const gchar *url_str);
extern URLStruct *url_copy(const URLStruct *url);
extern void url_delete(URLStruct *url);

extern guint8 *url_encode(
	GList *url_list,
	gint *buf_len_rtn
);
extern GList *url_decode(
	const guint8 *buf,
	const gint buf_len
);
extern GList *url_decode_string(const gchar *s);

extern gchar *url_tokenize_url_string(const gchar *url_str);
extern gchar *url_detokenize_url_string(const gchar *url_str);


#endif	/* URL_H */
