/*
			       Tool Bar
 */

#ifndef TOOL_BAR_H
#define TOOL_BAR_H

#include <gtk/gtk.h>


typedef struct _ToolBarItem			ToolBarItem;
#define TOOL_BAR_ITEM(p)			((ToolBarItem *)(p))


/*
 *	Tool Bar Item Types:
 */
typedef enum {
	TOOL_BAR_ITEM_SEPARATOR,
	TOOL_BAR_ITEM_BUTTON,
	TOOL_BAR_ITEM_TOGGLE_BUTTON,
	TOOL_BAR_ITEM_MENU_BUTTON
} ToolBarItemType;


/*
 *	Tool Bar Button Decals:
 */
typedef enum {
	TOOL_BAR_BUTTON_DECALS_TEXT,
	TOOL_BAR_BUTTON_DECALS_PICTURES,
	TOOL_BAR_BUTTON_DECALS_PICTURES_AND_TEXT
} ToolBarButtonDecals;


/* ToolBarItem */
extern ToolBarItem *ToolBarItemNew(
	const ToolBarItemType type,
	const gchar *text,
	guint8 **icon_data,
	const gchar *tooltip,
	const gint id,
	void (*activate_cb)(
		ToolBarItem *,
		const gint,
		gpointer
	),
	gpointer activate_data,
	void (*enter_cb)(
		ToolBarItem *,
		const gint,
		gpointer
	),
	gpointer enter_data,
	void (*leave_cb)(
		ToolBarItem *,
		const gint,
		gpointer
	),
	gpointer leave_data
);
extern ToolBarItem *ToolBarItemNewSeparator(void);

extern void ToolBarItemDelete(ToolBarItem *item);

extern ToolBarItemType ToolBarItemGetType(ToolBarItem *item);
extern GtkWidget *ToolBarItemGetWidget(ToolBarItem *item);
extern GtkWidget *ToolBarItemGetToolBar(ToolBarItem *item);
extern gint ToolBarItemGetID(ToolBarItem *item);
extern void ToolBarItemSetData(
	ToolBarItem *item,
	gpointer data
);
extern void ToolBarItemSetDataFull(
	ToolBarItem *item,
	gpointer data,
	GtkDestroyNotify destroy_cb
);
extern gpointer ToolBarItemGetData(ToolBarItem *item);
extern GdkVisibilityState ToolBarItemGetVisibility(ToolBarItem *item);
extern void ToolBarItemSetToggle(
	ToolBarItem *item,
	const gboolean toggled
);
extern gboolean ToolBarItemGetToggle(ToolBarItem *item);
extern void ToolBarItemSetMenu(
	ToolBarItem *item,
	GtkWidget *menu
);
extern GtkWidget *ToolBarItemGetMenu(ToolBarItem *item);

/* ToolBarItems List */
extern ToolBarItem *ToolBarItemListMatchByID(
	GList *items_list,
	const gint id
);


/* ToolBar */
extern GtkWidget *ToolBarNew(
	const GtkOrientation orientation,
	const ToolBarButtonDecals button_decals,
	const GtkReliefStyle relief,
	const GtkPolicyType scroll_policy,
	GList *items_list
);
extern void ToolBarSetButtonDecals(
	GtkWidget *w,
	const ToolBarButtonDecals display
);
extern void ToolBarSetRelief(
	GtkWidget *w,
	const GtkReliefStyle relief
);
extern void ToolBarSetButtonSize(
        GtkWidget *w,
        const gint width, const gint height
);
extern void ToolBarGetButtonSize(
        GtkWidget *w,
        gint *width_rtn, gint *height_rtn
);
extern void ToolBarSetScrollPolicy(
        GtkWidget *w,
        const GtkPolicyType scroll_policy
);
extern void ToolBarScrollToItem(
        GtkWidget *w,
        const gint id,
        const gfloat coeff
);
extern void ToolBarUpdateItem(
	GtkWidget *w,
	const gint id,
	const gchar *text,
	guint8 **icon_data,
	const gchar *tooltip
);
extern ToolBarItem *ToolBarGetItem(
	GtkWidget *w,
	const gint id
);
extern GtkWidget *ToolBarGetItemWidget(
	GtkWidget *w,
	const gint id
);
extern void ToolBarSetItemSensitive(
	GtkWidget *w,
	const gint id,
	const gboolean sensitive
);
extern void ToolBarSetItemToggle(
	GtkWidget *w,
	const gint id,
	const gboolean toggled
);
extern gboolean ToolBarGetItemToggle(
	GtkWidget *w,
	const gint id
);
extern void ToolBarSetItemMenu(
	GtkWidget *w,
	const gint id,
	GtkWidget *menu
);
extern GtkWidget *ToolBarGetItemMenu(
	GtkWidget *w,
	const gint id
);
extern gboolean ToolBarIsItemMapped(
	GtkWidget *w,
	const gint id
);
extern void ToolBarMapItem(
	GtkWidget *w,
	const gint id
);
extern void ToolBarUnmapItem(
	GtkWidget *w,
	const gint id
);
extern void ToolBarQueueResize(GtkWidget *w);


#endif	/* TOOLBAR_H */
