#include <gtk/gtk.h>
#include "../tool_bar.h"

#include "../images/icon_x_20x20.xpm"


static void print_help(const gchar *prog_name)
{
        g_print(
"Usage: %s [options]\n\
\n\
    Where [options] can be any of the following:\n\
\n\
        --horizontal            Create a horizontal ToolBar.\n\
        --vertical              Create a vertical ToolBar.\n\
\n\
        --pictures-and-text     Button decals with pictures and text.\n\
        -pt                     Same as --pictures-and-text.\n\
        --pictures              Button decals with pictures only.\n\
        -p                      Same as --pictures.\n\
        --text                  Button decals with text only.\n\
        -t                      Same as --text.\n\
\n\
        --normal-relief         Set the relief style to \"normal\".\n\
        -r                      Same as --normal-relief.\n\
        --half-relief           Set the relief style to \"half\".\n\
        -hr                     Same as --half-relief.\n\
        --no-relief             Set the relief style to \"none\".\n\
        -nr                     Same as --no-relief.\n\
\n\
        --scroll-automatic      Automatically show the scroll buttons.\n\
        -s                      Same as --scroll-automatic.\n\
        --scroll-always         Always show the scroll buttons.\n\
        -sa                     Same as --scroll-always.\n\
        --scroll-never          Never show the scroll buttons.\n\
        -sn                     Same as --scroll-never.\n\
\n\
        --help                  Prints this help screen and exits.\n\
\n",
            prog_name
        );
}


/*
 *	Button decals callbacks.
 */
static void button_decals_text_cb(GtkWidget *widget, gpointer data)
{
	GtkWidget *tb = (GtkWidget *)data;
	ToolBarSetButtonDecals(tb, TOOL_BAR_BUTTON_DECALS_TEXT);
}

static void button_decals_pictures_cb(GtkWidget *widget, gpointer data)
{
	GtkWidget *tb = (GtkWidget *)data;
	ToolBarSetButtonDecals(tb, TOOL_BAR_BUTTON_DECALS_PICTURES);
}

static void button_decals_pictures_and_text_cb(GtkWidget *widget, gpointer data)
{
	GtkWidget *tb = (GtkWidget *)data;
	ToolBarSetButtonDecals(tb, TOOL_BAR_BUTTON_DECALS_PICTURES_AND_TEXT);
}


/*
 *	Relief callbacks.
 */
static void relief_normal_cb(GtkWidget *widget, gpointer data)
{
	GtkWidget *tb = (GtkWidget *)data;
	ToolBarSetRelief(tb, GTK_RELIEF_NORMAL);
}

static void relief_half_cb(GtkWidget *widget, gpointer data)
{
	GtkWidget *tb = (GtkWidget *)data;
	ToolBarSetRelief(tb, GTK_RELIEF_HALF);
}

static void relief_none_cb(GtkWidget *widget, gpointer data)
{
	GtkWidget *tb = (GtkWidget *)data;
	ToolBarSetRelief(tb, GTK_RELIEF_NONE);
}


/*
 *	Scroll policy callbacks.
 */
static void scroll_policy_automatic_cb(GtkWidget *widget, gpointer data)
{
	GtkWidget *tb = (GtkWidget *)data;
	ToolBarSetScrollPolicy(tb, GTK_POLICY_AUTOMATIC);
}

static void scroll_policy_always_cb(GtkWidget *widget, gpointer data)
{
	GtkWidget *tb = (GtkWidget *)data;
	ToolBarSetScrollPolicy(tb, GTK_POLICY_ALWAYS);
}

static void scroll_policy_never_cb(GtkWidget *widget, gpointer data)
{
	GtkWidget *tb = (GtkWidget *)data;
	ToolBarSetScrollPolicy(tb, GTK_POLICY_NEVER);
}


/*
 *	ToolBar activate callback.
 */
static void tool_bar_button_cb(
	ToolBarItem *item, gint id, gpointer data
)
{
	switch(ToolBarItemGetType(item))
	{
	  case TOOL_BAR_ITEM_BUTTON:
	    g_print(
"Clicked ToolBarItem %p id=%i\n",
		item,
		id
	    );
	    break;
	  case TOOL_BAR_ITEM_TOGGLE_BUTTON:
	    g_print(
"%s ToolBarItem %p id=%i\n",
		ToolBarItemGetToggle(item) ? "Toggled" : "Untoggled",
		item,
		id
	    );
	    break;
	  case TOOL_BAR_ITEM_MENU_BUTTON:
	    break;
	  case TOOL_BAR_ITEM_SEPARATOR:
	    break;
	}
}

static void menu_item_activate_cb(gpointer data)
{
	ToolBarItem *item = TOOL_BAR_ITEM(data);
	if(item == NULL)
	    return;

	g_print(
"Clicked on MenuItem for ToolBarItem %p id=%i\n",
	    item,
	    ToolBarItemGetID(item)
	);
}


int main(int argc, char *argv[])
{
	const gint	border_minor = 2,
			border_major = 5;
	gint i;
	const gchar *arg;
	GSList *group;
	GList *items_list;
	GtkOrientation orientation = GTK_ORIENTATION_HORIZONTAL;
	GtkReliefStyle relief = GTK_RELIEF_NONE;
	GtkPolicyType scroll_policy = GTK_POLICY_AUTOMATIC;
	GtkWidget	*w,
			*parent, *parent2, *parent3,
			*toplevel,
			*main_box,
			*menu,
			*tb;
	ToolBarButtonDecals button_decals = TOOL_BAR_BUTTON_DECALS_PICTURES_AND_TEXT;


        /* Handle the command line arguments */
        for(i = 1; i < argc; i++)
        {
            arg = argv[i];
            if(arg == NULL)
                continue;

            if(!g_strcasecmp(arg, "--help") ||
               !g_strcasecmp(arg, "-help") ||
               !g_strcasecmp(arg, "--h") ||
               !g_strcasecmp(arg, "-h")
            )
            {
                print_help(argv[0]);
                return(0);
            }
            else if(!g_strcasecmp(arg, "--vertical") ||
                    !g_strcasecmp(arg, "-vertical")
	    )
            {
                orientation = GTK_ORIENTATION_VERTICAL;
            }
            else if(!g_strcasecmp(arg, "--pictures-and-text") ||
		    !g_strcasecmp(arg, "-pictures-and-text") ||
		    !g_strcasecmp(arg, "-pt")
	    )
            {
                button_decals = TOOL_BAR_BUTTON_DECALS_PICTURES_AND_TEXT;
            }
            else if(!g_strcasecmp(arg, "--pictures") ||
		    !g_strcasecmp(arg, "-pictures") ||
		    !g_strcasecmp(arg, "-p")
	    )
            {
                button_decals = TOOL_BAR_BUTTON_DECALS_PICTURES;
            }
            else if(!g_strcasecmp(arg, "--text") ||
		    !g_strcasecmp(arg, "-text") ||
		    !g_strcasecmp(arg, "-t")
	    )
            {
                button_decals = TOOL_BAR_BUTTON_DECALS_TEXT;
            }
            else if(!g_strcasecmp(arg, "--normal-relief") ||
		    !g_strcasecmp(arg, "-normal-relief") ||
		    !g_strcasecmp(arg, "-r")
	    )
            {
                relief = GTK_RELIEF_NORMAL;
            }
            else if(!g_strcasecmp(arg, "--half-relief") ||
		    !g_strcasecmp(arg, "-half-relief") ||
		    !g_strcasecmp(arg, "-hr")
	    )
            {
                relief = GTK_RELIEF_HALF;
            }
            else if(!g_strcasecmp(arg, "--no-relief") ||
		    !g_strcasecmp(arg, "-no-relief") ||
		    !g_strcasecmp(arg, "-nr")
	    )
            {
                relief = GTK_RELIEF_NONE;
            }
            else if(!g_strcasecmp(arg, "--scroll-automatic") ||
		    !g_strcasecmp(arg, "-scroll-automatic") ||
		    !g_strcasecmp(arg, "--scroll-auto") ||
		    !g_strcasecmp(arg, "-scroll-auto") ||
		    !g_strcasecmp(arg, "-s")
	    )
            {
                scroll_policy = GTK_POLICY_AUTOMATIC;
            }
            else if(!g_strcasecmp(arg, "--scroll-always") ||
		    !g_strcasecmp(arg, "-scroll-always") ||
		    !g_strcasecmp(arg, "-sa")
	    )
            {
                scroll_policy = GTK_POLICY_ALWAYS;
            }
            else if(!g_strcasecmp(arg, "--scroll-never") ||
		    !g_strcasecmp(arg, "-scroll-never") ||
		    !g_strcasecmp(arg, "-sn")
	    )
            {
                scroll_policy = GTK_POLICY_NEVER;
            }
        }


        gtk_init(&argc, &argv);

	toplevel = w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_policy(GTK_WINDOW(w), TRUE, TRUE, FALSE);
	gtk_widget_set_usize(w, 400, 200);
	gtk_signal_connect_object(
	    GTK_OBJECT(w), "delete_event",
	    GTK_SIGNAL_FUNC(gtk_main_quit), NULL
	);
	parent = w;

	if(orientation == GTK_ORIENTATION_VERTICAL)
	    w = gtk_hbox_new(FALSE, 0);
	else
	    w = gtk_vbox_new(FALSE, 0);
	main_box = w;
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent = w;

	w = gtk_frame_new(NULL);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_OUT);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent2 = w;

	items_list = NULL;
	items_list = g_list_append(
	    items_list,
	    ToolBarItemNew(
		TOOL_BAR_ITEM_BUTTON,
		"Button",
		(guint8 **)icon_x_20x20_xpm,
		NULL,
		1,
		tool_bar_button_cb, NULL,
		NULL, NULL,
		NULL, NULL
	    )
	);
	items_list = g_list_append(
	    items_list,
	    ToolBarItemNew(
		TOOL_BAR_ITEM_TOGGLE_BUTTON,
		"Toggle",
		(guint8 **)icon_x_20x20_xpm,
		NULL,
		2,
		tool_bar_button_cb, NULL,
		NULL, NULL,
		NULL, NULL
	    )
	);
	items_list = g_list_append(
	    items_list,
	    ToolBarItemNew(
		TOOL_BAR_ITEM_MENU_BUTTON,
		"Menu",
		(guint8 **)icon_x_20x20_xpm,
		NULL,
		3,
		tool_bar_button_cb, NULL,
		NULL, NULL,
		NULL, NULL
	    )
	);
	items_list = g_list_append(
	    items_list,
	    ToolBarItemNewSeparator()
	);
	items_list = g_list_append(
	    items_list,
	    ToolBarItemNew(
		TOOL_BAR_ITEM_BUTTON,
		"Button",
		(guint8 **)icon_x_20x20_xpm,
		NULL,
		4,
		tool_bar_button_cb, NULL,
		NULL, NULL,
		NULL, NULL
	    )
	);
	/* Create the ToolBar */
	tb = ToolBarNew(
	    orientation,
	    button_decals,
	    relief,
	    scroll_policy,
	    items_list
	);
	gtk_container_add(GTK_CONTAINER(parent2), tb);
        gtk_container_border_width(GTK_CONTAINER(tb), border_minor);
	g_list_foreach(
	    items_list,
	    (GFunc)ToolBarItemDelete,
	    NULL
	);
	g_list_free(items_list);
	gtk_widget_show(tb);

	/* Set up the menu for ToolBarItem ID 3 */
	menu = ToolBarGetItemMenu(
	    tb,
	    3
	);
	if(menu != NULL)
	{
	    ToolBarItem *item = ToolBarGetItem(tb, 3);

	    w = gtk_menu_item_new_with_label("Item");
	    gtk_menu_append(GTK_MENU(menu), w);
	    gtk_signal_connect_object(
		GTK_OBJECT(w), "activate",
		GTK_SIGNAL_FUNC(menu_item_activate_cb), (GtkObject *)item
	    );
	    gtk_widget_show(w);
	}


	/* ToolBar options GtkVBox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;


	/* Button Decals GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_label_new("Button Decals:");
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Button Decals GtkRadioButton */
	group = NULL;
	w = gtk_radio_button_new_with_label(group, "Text");
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(w));
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "toggled",
	    GTK_SIGNAL_FUNC(button_decals_text_cb), tb
	);
	if(button_decals == TOOL_BAR_BUTTON_DECALS_TEXT)
	    GTK_TOGGLE_BUTTON(w)->active = TRUE;
	else
	    GTK_TOGGLE_BUTTON(w)->active = FALSE;
	gtk_widget_show(w);

	w = gtk_radio_button_new_with_label(group, "Pictures");
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(w));
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "toggled",
	    GTK_SIGNAL_FUNC(button_decals_pictures_cb), tb
	);
	if(button_decals == TOOL_BAR_BUTTON_DECALS_PICTURES)
	    GTK_TOGGLE_BUTTON(w)->active = TRUE;
	else
	    GTK_TOGGLE_BUTTON(w)->active = FALSE;
	gtk_widget_show(w);

	w = gtk_radio_button_new_with_label(group, "Pictures & Text");
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(w));
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "toggled",
	    GTK_SIGNAL_FUNC(button_decals_pictures_and_text_cb), tb
	);
	if(button_decals == TOOL_BAR_BUTTON_DECALS_PICTURES_AND_TEXT)
	    GTK_TOGGLE_BUTTON(w)->active = TRUE;
	else
	    GTK_TOGGLE_BUTTON(w)->active = FALSE;
	gtk_widget_show(w);


	/* Relief GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_label_new("Relief:");
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Relief GtkRadioButtons */
	group = NULL;
	w = gtk_radio_button_new_with_label(group, "Normal");
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(w));
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "toggled",
	    GTK_SIGNAL_FUNC(relief_normal_cb), tb
	);
	if(relief == GTK_RELIEF_NORMAL)
	    GTK_TOGGLE_BUTTON(w)->active = TRUE;
	else
	    GTK_TOGGLE_BUTTON(w)->active = FALSE;
	gtk_widget_show(w);

	w = gtk_radio_button_new_with_label(group, "Half");
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(w));
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "toggled",
	    GTK_SIGNAL_FUNC(relief_half_cb), tb
	);
	if(relief == GTK_RELIEF_HALF)
	    GTK_TOGGLE_BUTTON(w)->active = TRUE;
	else
	    GTK_TOGGLE_BUTTON(w)->active = FALSE;
	gtk_widget_show(w);

	w = gtk_radio_button_new_with_label(group, "None");
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(w));
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "toggled",
	    GTK_SIGNAL_FUNC(relief_none_cb), tb
	);
	if(relief == GTK_RELIEF_NONE)
	    GTK_TOGGLE_BUTTON(w)->active = TRUE;
	else
	    GTK_TOGGLE_BUTTON(w)->active = FALSE;
	gtk_widget_show(w);


	/* Scroll Policy GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_label_new("Scroll Policy:");
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Scroll Policy GtkRadioButton */
	group = NULL;
	w = gtk_radio_button_new_with_label(group, "Automatic");
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(w));
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "toggled",
	    GTK_SIGNAL_FUNC(scroll_policy_automatic_cb), tb
	);
	if(scroll_policy == GTK_POLICY_AUTOMATIC)
	    GTK_TOGGLE_BUTTON(w)->active = TRUE;
	else
	    GTK_TOGGLE_BUTTON(w)->active = FALSE;
	gtk_widget_show(w);

	w = gtk_radio_button_new_with_label(group, "Always");
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(w));
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "toggled",
	    GTK_SIGNAL_FUNC(scroll_policy_always_cb), tb
	);
	if(scroll_policy == GTK_POLICY_ALWAYS)
	    GTK_TOGGLE_BUTTON(w)->active = TRUE;
	else
	    GTK_TOGGLE_BUTTON(w)->active = FALSE;
	gtk_widget_show(w);

	w = gtk_radio_button_new_with_label(group, "Never");
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(w));
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "toggled",
	    GTK_SIGNAL_FUNC(scroll_policy_never_cb), tb
	);
	if(scroll_policy == GTK_POLICY_NEVER)
	    GTK_TOGGLE_BUTTON(w)->active = TRUE;
	else
	    GTK_TOGGLE_BUTTON(w)->active = FALSE;
	gtk_widget_show(w);




	gtk_widget_show(toplevel);


	gtk_main();


	gtk_widget_destroy(tb);
	gtk_widget_destroy(toplevel);


	return(0);
}
