#include <unistd.h>
#include <gtk/gtk.h>
#include "../progressdialog.h"
#include "../config.h"

#include "../images/icon_info_32x32.xpm"


/*
 *	Progress Dialog Styles:
 */
#define DIALOG_STYLE_STANDARD		0
#define DIALOG_STYLE_ANIMATED		1

/*
 *	Animation Type:
 */
#define ANIMATION_MOVE			0
#define ANIMATION_COPY			1
#define ANIMATION_RECYCLE		2
#define ANIMATION_PURGE			3
#define ANIMATION_ARCHIVE		4
#define ANIMATION_MAIL			5


int main(int argc, char *argv[])
{
	gint	dialog_style = DIALOG_STYLE_ANIMATED,
		animation = ANIMATION_MOVE;
	const gchar	*dialog_style_str,
			*animation_str = "";
	gchar *s;
	gfloat progress = 0.0f;
	GList	*start_icon_paths_list = NULL,
		*icon_paths_list = NULL,
		*end_icon_paths_list = NULL;

	if(argc < 2)
	{
	    /* Print usage if no arguments are given but do not
	     * exit
	     */
	    g_print(
"Usage: %s [dialog_style] [animation_style]\n\
\n\
    Where [dialog_style] can be any of the following:\n\
\n\
	standard                - Standard style.\n\
	animated                - Animated style.\n\
\n\
    Where [animation_style] can be any of the following:\n\
\n\
	move                    - Move object.\n\
	copy                    - Copy object.\n\
	recycle                 - Recycle object.\n\
	purge                   - Purge recycle bin.\n\
	archive                 - Extract archive.\n\
	mail                    - Download mail.\n\
\n",
		argv[0]
	    );
	}

	/* Begin parsing arguments */
	/* Dialog Style */
	if(argc > 1)
	{
	    const gchar *s = argv[1];
	    if(!g_strcasecmp(s, "standard"))
		dialog_style = DIALOG_STYLE_STANDARD;
	    else if(!g_strcasecmp(s, "animated"))
		dialog_style = DIALOG_STYLE_ANIMATED;
	}
	/* Animation */
	if(argc > 2)
	{
	    const gchar *s = argv[2];
	    if(!g_strcasecmp(s, "move"))
		animation = ANIMATION_MOVE;
	    else if(!g_strcasecmp(s, "copy"))
		animation = ANIMATION_COPY;
	    else if(!g_strcasecmp(s, "recycle"))
		animation = ANIMATION_RECYCLE;
	    else if(!g_strcasecmp(s, "purge"))
		animation = ANIMATION_PURGE;
	    else if(!g_strcasecmp(s, "archive"))
		animation = ANIMATION_ARCHIVE;
	    else if(!g_strcasecmp(s, "mail"))
		animation = ANIMATION_MAIL;
	}



	gtk_init(&argc, &argv);

	ProgressDialogInit();

#define APPEND_PATH(_glist_,_xpm_file_name_)	{		\
 (_glist_) = g_list_append(					\
  (_glist_),							\
  ((_xpm_file_name_) != NULL) ? g_strconcat(			\
   "/usr/share/endeavour2/animations",				\
   G_DIR_SEPARATOR_S,						\
   (_xpm_file_name_),						\
   NULL								\
  ) : NULL							\
 );								\
}

	/* Set start icon */
	switch(animation)
	{
	  case ANIMATION_MOVE:
	    animation_str = "move";
	    APPEND_PATH(start_icon_paths_list, "folder_file_32x32.xpm");
	    APPEND_PATH(start_icon_paths_list, "folder_32x32.xpm");
	    APPEND_PATH(start_icon_paths_list, "folder_32x32.xpm");
	    break;
	  case ANIMATION_COPY:
	    animation_str = "copy";
	    APPEND_PATH(start_icon_paths_list, "folder_file_32x32.xpm");
	    APPEND_PATH(start_icon_paths_list, "folder_file_32x32.xpm");
	    APPEND_PATH(start_icon_paths_list, "folder_file_32x32.xpm");
	    break;
	  case ANIMATION_RECYCLE:
	    animation_str = "recycle";
	    APPEND_PATH(start_icon_paths_list, "folder_file_32x32.xpm");
	    APPEND_PATH(start_icon_paths_list, "folder_32x32.xpm");
	    APPEND_PATH(start_icon_paths_list, "folder_32x32.xpm");
	    break;
	  case ANIMATION_PURGE:
	    animation_str = "purge";
	    APPEND_PATH(start_icon_paths_list, "recycle_bin_full_32x32.xpm");
	    APPEND_PATH(start_icon_paths_list, "recycle_bin_32x32.xpm");
	    APPEND_PATH(start_icon_paths_list, "recycle_bin_32x32.xpm");
	    break;
	  case ANIMATION_ARCHIVE:
	    animation_str = "archive";
	    APPEND_PATH(start_icon_paths_list, "package_file_32x32.xpm");
	    APPEND_PATH(start_icon_paths_list, "package_32x32.xpm");
	    APPEND_PATH(start_icon_paths_list, "package_32x32.xpm");
	    break;
	  case ANIMATION_MAIL:
	    animation_str = "mail";
	    APPEND_PATH(start_icon_paths_list, "mailbag_full_32x32.xpm");
	    APPEND_PATH(start_icon_paths_list, "mailbag_full_32x32.xpm");
	    APPEND_PATH(start_icon_paths_list, "mailbag_full_32x32.xpm");
	    break;
	}

	/* Set intermediate icons */
	switch(animation)
	{
	  case ANIMATION_MOVE:
	  case ANIMATION_COPY:
	  case ANIMATION_RECYCLE:
	  case ANIMATION_ARCHIVE:
	    APPEND_PATH(icon_paths_list, "file01_20x20.xpm");
	    APPEND_PATH(icon_paths_list, "file02_20x20.xpm");
	    APPEND_PATH(icon_paths_list, "file03_20x20.xpm");
	    APPEND_PATH(icon_paths_list, "file04_20x20.xpm");
	    APPEND_PATH(icon_paths_list, "file05_20x20.xpm");
	    APPEND_PATH(icon_paths_list, "file06_20x20.xpm");
	    break;
	  case ANIMATION_PURGE:
	    APPEND_PATH(icon_paths_list, "trash01_20x20.xpm");
	    APPEND_PATH(icon_paths_list, "trash02_20x20.xpm");
	    APPEND_PATH(icon_paths_list, "trash03_20x20.xpm");
	    APPEND_PATH(icon_paths_list, "trash04_20x20.xpm");
	    APPEND_PATH(icon_paths_list, "trash05_20x20.xpm");
	    APPEND_PATH(icon_paths_list, "trash06_20x20.xpm");
	    break;
	  case ANIMATION_MAIL:
	    APPEND_PATH(icon_paths_list, "mail01_20x20.xpm");
	    APPEND_PATH(icon_paths_list, "mail02_20x20.xpm");
	    APPEND_PATH(icon_paths_list, "mail03_20x20.xpm");
	    APPEND_PATH(icon_paths_list, "mail04_20x20.xpm");
	    APPEND_PATH(icon_paths_list, "mail05_20x20.xpm");
	    APPEND_PATH(icon_paths_list, "mail06_20x20.xpm");
	    break;
	}

	/* Set end icon */
	switch(animation)
	{
	  case ANIMATION_MOVE:
	    APPEND_PATH(end_icon_paths_list, "folder_32x32.xpm");
	    APPEND_PATH(end_icon_paths_list, "folder_32x32.xpm");
	    APPEND_PATH(end_icon_paths_list, "folder_file_32x32.xpm");
	    break;
	  case ANIMATION_COPY:
	    APPEND_PATH(end_icon_paths_list, "folder_32x32.xpm");
	    APPEND_PATH(end_icon_paths_list, "folder_32x32.xpm");
	    APPEND_PATH(end_icon_paths_list, "folder_file_32x32.xpm");
	    break;
	  case ANIMATION_RECYCLE:
	    APPEND_PATH(end_icon_paths_list, "recycle_bin_32x32.xpm");
	    APPEND_PATH(end_icon_paths_list, "recycle_bin_32x32.xpm");
	    APPEND_PATH(end_icon_paths_list, "recycle_bin_full_32x32.xpm");
	    break;
	  case ANIMATION_PURGE:
	    APPEND_PATH(end_icon_paths_list, NULL);
	    APPEND_PATH(end_icon_paths_list, NULL);
	    APPEND_PATH(end_icon_paths_list, NULL);
	    break;
	  case ANIMATION_ARCHIVE:
	    APPEND_PATH(end_icon_paths_list, "folder_32x32.xpm");
	    APPEND_PATH(end_icon_paths_list, "folder_32x32.xpm");
	    APPEND_PATH(end_icon_paths_list, "folder_file_32x32.xpm");
	    break;
	  case ANIMATION_MAIL:
	    APPEND_PATH(end_icon_paths_list, "mailbox_32x32.xpm");
	    APPEND_PATH(end_icon_paths_list, "mailbox_32x32.xpm");
	    APPEND_PATH(end_icon_paths_list, "mailbox_full_32x32.xpm");
	    break;
	}

	/* Map Progress Dialog based on the dialog style */
	switch(dialog_style)
	{
	  case DIALOG_STYLE_ANIMATED:
	    dialog_style_str = "animated";
	    s = g_strdup_printf(
"This is a sample Progress Dialog\n\
\n\
Dialog Style: \"%s\"\n\
\n\
Animation: \"%s\"\n",
		dialog_style_str,
		animation_str
	    );
	    ProgressDialogMapAnimationFile(
		"Progress Dialog",
		s,
		"Stop",
		start_icon_paths_list,
		icon_paths_list,
		end_icon_paths_list,
		EDV_PROGRESS_DLG_ANIM_INT,
		EDV_PROGRESS_DLG_ANIM_INC
	    );
	    g_free(s);
	    break;
	  default:
	    dialog_style_str = "standard";
	    s = g_strdup_printf(
"This is a sample Progress Dialog\n\
\n\
Dialog Style: \"%s\"\n",
		dialog_style_str
	    );
	    ProgressDialogMap(
		"Progress Dialog",
		"This is a sample Progress Dialog",
		(const guint8 **)icon_info_32x32_xpm,
		"Stop"
	    );
	    g_free(s);
	    break;
	}

	gdk_flush();

	/* Begin updating progress */
	while(TRUE)
	{
	    /* User clicked on stop? */
	    if(ProgressDialogStopCount() > 0)
	    {
		ProgressDialogBreakQuery(TRUE);
		break;
	    }

	    /* Manage GTK events */
	    if(gtk_events_pending() > 0)
		gtk_main_iteration();

	    /* Increment progress */
	    progress += 0.005f;

	    /* Progress warped? */
	    if(progress > 1.0f)
		progress = 0.0f;

	    /* Update Progress Dialog */
	    ProgressDialogUpdate(
		NULL, NULL, NULL, NULL, progress,
		20, TRUE
	    );
#if 0
	    ProgressDialogUpdateUnknown(
		NULL, NULL, NULL, NULL,
		TRUE
	    );
#endif
	    usleep(20000);
	}

	ProgressDialogShutdown();

	return(0);
}
