#include <gtk/gtk.h>
#include "../pulist.h"



static gint delete_event_cb(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	gtk_main_quit();
	return(TRUE);
}

static void pulistbox_changed_cb(
	GtkWidget *box, const gint i, gpointer data
)
{
	GtkWidget *pulist = PUListBoxGetPUList(box);
	if(i > -1)
	{
	    const gchar *text;
	    PUListGetItemText(
		pulist,
		i,
		&text
	    );
	    g_print("Selected: \"%s\"\n", text);
	}
}


int main(int argc, char *argv[])
{
	GtkWidget *toplevel, *parent, *w, *pulist;

	gtk_init(&argc, &argv);

	toplevel = w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(w, 320, 240);
	/* Watch for the button events so that clicking outside of
	 * the Popup List will cause it to unmap
	 */
	gtk_widget_add_events(
	    w,
	    GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "delete_event",
	    GTK_SIGNAL_FUNC(delete_event_cb), NULL
	);
	parent = w;

	w = gtk_vbox_new(FALSE, 0);
	gtk_container_border_width(GTK_CONTAINER(w), 5);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent = w;

	w = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent = w;

	w = gtk_label_new("Popup List Box:");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	w = PUListBoxNew(
	    200, -1
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	PUListBoxSetChangedCB(
	    w,
	    pulistbox_changed_cb, NULL
	);
	gtk_widget_show(w);
	pulist = PUListBoxGetPUList(w);
	if(pulist != NULL)
	{
	    gint i = PUListAddItem(pulist, "Vixen");
	    i = PUListAddItem(pulist, "Wolf");
	    i = PUListAddItem(pulist, "Cat");
	    i = PUListAddItem(pulist, "Turtle");
	    i = PUListAddItem(pulist, "Duck");
	    i = PUListAddItem(pulist, "Human");
	    i = PUListAddItem(pulist, "Not Selectable");
	    PUListSetItemSelectable(
		pulist,
		i,
		FALSE
	    );
	    i = PUListAddItem(pulist, "Insensitive");
	    PUListSetItemSensitive(
		pulist,
		i,
		FALSE
	    );

	    /* Show 3 lines */
	    PUListBoxSetLinesVisible(
		w,
		3
	    );
	}

	gtk_widget_show(toplevel);


	gtk_main();


	gtk_widget_destroy(toplevel);


	return(0);
}
