#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "../guiutils.h"
#include "../pulist.h"
#include "../fprompt.h"
#include "../cdialog.h"
#include "../fb.h"
#include "../icon_sel_dlg.h"
#include "../icon_picker.h"


static gint delete_cb(GtkWidget *widget, GdkEvent *event, gpointer data);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	GtkWindow "delete_event" signal callback.
 */
static gint delete_cb(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	gtk_main_quit();
	return(TRUE);
}


int main(int argc, char *argv[])
{
	gboolean initialized_gtk = FALSE;
	gint i;
	const gchar *arg;
	GtkWidget	*toplevel,
			*isd,
			*w,
			*parent;

	/* Parse arguments */
	for(i = 1; i < argc; i++)
	{
	    arg = argv[i];
	    if(arg == NULL)
		continue;

	    if(!g_strcasecmp(arg, "--help") ||
	       !g_strcasecmp(arg, "-help") ||
	       !g_strcasecmp(arg, "--h") ||
	       !g_strcasecmp(arg, "-h") ||
	       !g_strcasecmp(arg, "-?")
	    )
	    {
		g_print(
"Usage: %s [directory]\n",
		    argv[0]
		);
		return(0);
	    }
	}

	/* Initialize GTK+ as needed */
	if(!initialized_gtk)
	{
	    if(!gtk_init_check(&argc, &argv))
	    {
		g_printerr("Unable to initialize GTK.\n");
		return(1);
	    }
	    initialized_gtk = TRUE;

	    gdk_rgb_init();
	}

	/* Initialize the dialogs */
	FPromptInit();
	CDialogInit();
	FileBrowserInit();

	/* Icon Selection Dialog (needed by the Icon Picker */
	isd = IconSelDlgNew(
	    ICON_SEL_DLG_DOUBLE_BUFFER |
		ICON_SEL_DLG_SHOW_TEXTTIPS |
		ICON_SEL_DLG_ENABLE_DRAG_SCROLL,
	    GTK_ORIENTATION_HORIZONTAL,
	    -1,
	    50, 50,				/* Thumb size */
	    0,					/* Thumb border */
	    "/usr/share/endeavour2/icons",	/* Default path */
	    100l				/* Load interval ms */
	);

	/* Toplevel GtkWindow */
	toplevel = w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_policy(GTK_WINDOW(w), TRUE, TRUE, FALSE);
	gtk_widget_realize(w);
	gtk_signal_connect(
	    GTK_OBJECT(w), "delete_event",
	    GTK_SIGNAL_FUNC(delete_cb), NULL
	);
	parent = w;

	w = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent = w;

	/* Icon Picker */
	w = icon_picker_new(
	    "Title",
	    ICON_PICKER_CAN_CLEAR_ICON | ICON_PICKER_DOUBLE_BUFFER |
		ICON_PICKER_ACCEPT_SMALLER_SIZE | ICON_PICKER_ACCEPT_LARGER_SIZE |
		ICON_PICKER_ACCEPT_DND_DROP | ICON_PICKER_PROVIDE_DND_DRAG |
		ICON_PICKER_SHOW_ICON_NAME | ICON_PICKER_SHOW_ICON_PATH |
		ICON_PICKER_SHOW_ICON_SHADOW | ICON_PICKER_SHOW_TEXTTIPS,
	    ICON_PICKER_ICON_POSITION_CENTER,
	    48, 48,				/* Requested icon size */
	    100, 100,				/* Display size */
	    -1,					/* Label width */
	    isd
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Icon Picker Icons List */
	if(w != NULL)
	{
	    GList *icons_list = NULL;

#define APPEND_ICON(_label_)	{			\
 IconPickerIcon *icon = icon_picker_icon_new();	\
 if(icon != NULL) {					\
  icon->label = STRDUP(_label_);			\
  icons_list = g_list_append(				\
   icons_list,						\
   icon							\
  );							\
 }							\
}
	    APPEND_ICON("Icon #1");
	    APPEND_ICON("Icon #2");
	    APPEND_ICON("Icon #3");
	    APPEND_ICON("Icon #4");
	    APPEND_ICON("Icon #5");

	    /* Set/transfer the icons list to the Icon Picker */
	    icon_picker_set_icons_list(w, icons_list);
	}

	gtk_widget_show(toplevel);


	/* Enter the GTK main loop */
	gtk_main();


	/* Destroy the Toplevel GtkWindow and the Icon Picker */
	gtk_widget_destroy(toplevel);

	/* Unref the Icon Selection Dialog */
	isd = IconSelDlgUnref(isd);


	/* Shutdown the dialogs */
	FileBrowserShutdown();
	CDialogShutdown();
	FPromptShutdown();


	return(0);
}
