#include <gtk/gtk.h>
#include "../fprompt.h"



static gint delete_event_cb(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	gtk_main_quit();
	return(TRUE);
}

static void fprompt_apply_cb(gpointer data, const gchar *value)
{
	g_print("OK Value: \"%s\"\n", value);
}

static void fprompt_cancel_cb(gpointer data)
{
	g_print("Canceled\n");
}

static void map_fprompt_cb(GtkWidget *widget, gpointer data)
{
	FPromptMapQuery(
	    "Prompt:",
	    "Value",
	    NULL,				/* No tooltip */
	    FPROMPT_MAP_TO_POINTER,
	    320, -1,
            FPROMPT_SHOW_LABEL | FPROMPT_SELECT_VALUE |
		FPROMPT_SHOW_OK_BUTTON | FPROMPT_SHOW_CANCEL_BUTTON,
	    widget,				/* Data */
	    NULL,				/* No browse callback */
	    fprompt_apply_cb,
	    fprompt_cancel_cb
	);
}

int main(int argc, char *argv[])
{
	GtkWidget *toplevel, *parent, *w;

	gtk_init(&argc, &argv);

	FPromptInit();

	toplevel = w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(w, 320, 240);
	/* Watch for the button events so that clicking outside of
	 * the floating prompt will cause it to unmap
	 */
	gtk_widget_add_events(
	    w,
	    GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK
	);
	gtk_signal_connect(
	    GTK_OBJECT(w), "delete_event",
	    GTK_SIGNAL_FUNC(delete_event_cb), NULL
	);
	parent = w;

	w = gtk_button_new_with_label("Click Here To Map The Prompt");
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(map_fprompt_cb), NULL
	);
	gtk_widget_show(w);

	gtk_widget_show(toplevel);


	gtk_main();


	gtk_widget_destroy(toplevel);

	FPromptShutdown();


	return(0);
}
