#include <gtk/gtk.h>

#include "../cfg.h"

#include "../guiutils.h"
#include "../fprompt.h"
#include "../cdialog.h"
#include "../progressdialog.h"

#include "../cfg_win.h"

#include "../images/icon_folder_closed_20x20.xpm"
#include "../images/icon_folder_opened_20x20.xpm"
#include "../images/icon_options_20x20.xpm"

#include "../images/icon_options_48x48.xpm"


#define MY_CFG_LIST	{						\
{ CFG_ITEM_TYPE_INT32,	"X",				NULL	},	\
{ CFG_ITEM_TYPE_INT32,	"Y",				NULL	},	\
{ CFG_ITEM_TYPE_INT32,	"Z",				NULL	},	\
{ CFG_ITEM_TYPE_STRING,	"Name",				NULL	},	\
{ 0, NULL, NULL							}	\
}


static void print_help(const gchar *prog_name)
{
	g_print(
"Usage: %s [options]\n\
\n\
    Where [options] can be any of the following:\n\
\n\
        --style [style]         Specifies the CfgWin style, where [style]\n\
                                can be one of:\n\
                                        notebook\n\
                                        tree\n\
        --help                  Prints this help screen and exits.\n\
\n",
	    prog_name
	);
}

static gint delete_event_cb(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	gtk_main_quit();
	return(TRUE);
}

static void ok_button_cb(GtkWidget *widget, gpointer data)
{
	gtk_main_quit();
}

static void apply_button_cb(GtkWidget *widget, gpointer data)
{

}

static void cancel_button_cb(GtkWidget *widget, gpointer data)
{
	gtk_main_quit();
}


static void cfg_win_page_changed_cb(
	 GtkWidget *cfg_win, GtkWidget *page, gpointer data
)
{
	if((cfg_win == NULL) || (page == NULL))
	    return;

	g_print(
"Changed to page \"%s\"\n",
	    CfgWinPageGetLabel(page)
	);
}

static void cfg_win_apply_cb(
	GtkWidget *cfg_win, CfgList *cfg_list, gpointer data
)
{
	CfgItem *cfg_item;
	if(cfg_list == NULL)
	    return;

	for(cfg_item = cfg_list;
	    cfg_item->parameter != NULL;
	    cfg_item++
	)
	{
	    if(cfg_item->value == NULL)
		continue;

	    switch((gint)cfg_item->type)
	    {
	      case CFG_ITEM_TYPE_INT32:
		g_print(
		    "%s=%i\n",
		    cfg_item->parameter,
		    *(gint32 *)cfg_item->value
		);
		break;
	      case CFG_ITEM_TYPE_UINT32:
		g_print(
		    "%s=%u\n",
		    cfg_item->parameter,
		    *(guint32 *)cfg_item->value
		);
		break;
	      case CFG_ITEM_TYPE_STRING:
		g_print(
		    "%s=\"%s\"\n",
		    cfg_item->parameter,
		    (const gchar *)cfg_item->value
		);
		break;
	    }
	}
}


static void create_cfg_win_notebook_pages(
	GtkWidget *cfg_win,
	CfgList *cfg_list
)
{
	GtkWidget	*page,
			*parent_page;
	CfgWinLink *cfg_link;

#define ADD_PROMPT(_page_,_parent_,_cfg_parm_)	{	\
 GtkWidget *w, *parent2;				\
							\
 w = gtk_hbox_new(FALSE, 2);				\
 gtk_box_pack_start(GTK_BOX(_parent_), w, FALSE, FALSE, 0);\
 gtk_widget_show(w);					\
 parent2 = w;						\
							\
 w = gtk_label_new(_cfg_parm_);				\
 gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);\
 gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);\
 gtk_widget_show(w);					\
							\
 w = gtk_entry_new();					\
 gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);\
 cfg_link = CfgWinAddLink(				\
  cfg_win,						\
  (_page_),						\
  CFG_WIN_LINK_WIDGET_EDITABLE,				\
  w,							\
  (_cfg_parm_)						\
 );							\
 gtk_widget_show(w);					\
}

	/* General Page */
	page = CfgWinAddPageNotebook(
	    cfg_win,
	    NULL,				/* Toplevel */
	    -1,					/* Append */
	    "General",
	    NULL,
	    FALSE				/* Not a parent */
	);
	gtk_container_border_width(GTK_CONTAINER(page), 5);
	gtk_box_set_spacing(GTK_BOX(page), 2);

	ADD_PROMPT(page, page, "Name");


	/* Stuff Page */
	page = CfgWinAddPageNotebook(
	    cfg_win,
	    NULL,				/* Toplevel */
	    -1,					/* Append */
	    "Stuff",
	    NULL,
	    TRUE				/* Is a parent */
	);
	gtk_container_border_width(GTK_CONTAINER(page), 5);
	gtk_box_set_spacing(GTK_BOX(page), 2);
	parent_page = page;

	/* Alpha Page */
	page = CfgWinAddPageNotebook(
	    cfg_win,
	    parent_page,
	    -1,					/* Append */
	    "Alpha",
	    NULL,
	    FALSE				/* Not a parent */
	);
	gtk_container_border_width(GTK_CONTAINER(page), 5);
	gtk_box_set_spacing(GTK_BOX(page), 2);

	ADD_PROMPT(page, page, "X");
	ADD_PROMPT(page, page, "Y");

	/* Beta Page */
	page = CfgWinAddPageNotebook(
	    cfg_win,
	    parent_page,
	    -1,					/* Append */
	    "Beta",
	    NULL,
	    FALSE				/* Not a parent */
	);
	gtk_container_border_width(GTK_CONTAINER(page), 5);
	gtk_box_set_spacing(GTK_BOX(page), 2);

	ADD_PROMPT(page, page, "Z");

#undef ADD_PROMPT
}

static void create_cfg_win_tree_pages(
	GtkWidget *cfg_win,
	CfgList *cfg_list
)
{
	GdkBitmap	*mask,
			*closed_mask,
			*opened_mask;
	GdkPixmap	*pixmap,
			*closed_pixmap,
			*opened_pixmap;			
	GtkWidget	*page,
			*parent_page;
	CfgWinLink *cfg_link;

	pixmap = GDK_PIXMAP_NEW_FROM_XPM_DATA(
	    &mask,
	    (guint8 **)icon_options_20x20_xpm
	);
	closed_pixmap = GDK_PIXMAP_NEW_FROM_XPM_DATA(
	    &closed_mask,
	    (guint8 **)icon_folder_closed_20x20_xpm
	);
	opened_pixmap = GDK_PIXMAP_NEW_FROM_XPM_DATA(
	    &opened_mask,
	    (guint8 **)icon_folder_opened_20x20_xpm
	);

#define ADD_PROMPT(_page_,_parent_,_cfg_parm_)	{	\
 GtkWidget *w, *parent2;				\
							\
 w = gtk_hbox_new(FALSE, 2);				\
 gtk_box_pack_start(GTK_BOX(_parent_), w, FALSE, FALSE, 0);\
 gtk_widget_show(w);					\
 parent2 = w;						\
							\
 w = gtk_label_new(_cfg_parm_);				\
 gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);\
 gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);\
 gtk_widget_show(w);					\
							\
 w = gtk_entry_new();					\
 gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);\
 cfg_link = CfgWinAddLink(				\
  cfg_win,						\
  (_page_),						\
  CFG_WIN_LINK_WIDGET_EDITABLE,				\
  w,							\
  (_cfg_parm_)						\
 );							\
 gtk_widget_show(w);					\
}

	/* General Page */
	page = CfgWinAddPageTree(
	    cfg_win,
	    NULL,				/* Toplevel */
	    NULL,				/* Append */
	    "General",
	    pixmap, mask,
	    pixmap, mask,
	    TRUE,				/* Include Heading */
	    FALSE				/* Not a parent */
	);
	gtk_container_border_width(GTK_CONTAINER(page), 5);
	gtk_box_set_spacing(GTK_BOX(page), 2);

	ADD_PROMPT(page, page, "X");
	ADD_PROMPT(page, page, "Y");


	/* Stuff Page */
	page = CfgWinAddPageTree(
	    cfg_win,
	    NULL,				/* Toplevel */
	    NULL,				/* Append */
	    "Stuff",
	    closed_pixmap, closed_mask,
	    opened_pixmap, opened_mask,
	    TRUE,				/* Include Heading */
	    TRUE				/* Is a parent */
	);
	gtk_container_border_width(GTK_CONTAINER(page), 5);
	gtk_box_set_spacing(GTK_BOX(page), 2);
	parent_page = page;

	ADD_PROMPT(page, page, "Name");

	/* Alpha Page */
	page = CfgWinAddPageTree(
	    cfg_win,
	    parent_page,			/* Toplevel */
	    NULL,				/* Append */
	    "Alpha",
	    pixmap, mask,
	    pixmap, mask,
	    TRUE,				/* Include Heading */
	    FALSE				/* Not a parent */
	);
	gtk_container_border_width(GTK_CONTAINER(page), 5);
	gtk_box_set_spacing(GTK_BOX(page), 2);

	ADD_PROMPT(page, page, "Z");

#undef ADD_PROMPT

	GDK_PIXMAP_UNREF(pixmap);
	GDK_BITMAP_UNREF(mask);
	GDK_PIXMAP_UNREF(closed_pixmap);
	GDK_BITMAP_UNREF(closed_mask);
	GDK_PIXMAP_UNREF(opened_pixmap);
	GDK_BITMAP_UNREF(opened_mask);
}


int main(int argc, char *argv[])
{
	gint i;
	const gchar *arg;
	GtkWidget	*w,
			*cfg_win;
	CfgList		*cfg_list,
			cfg_list_src[] = MY_CFG_LIST;
	CfgWinStyle	cfg_win_style = CFG_WIN_STYLE_NOTEBOOK;


	/* Handle the command line arguments */
	for(i = 1; i < argc; i++)
	{
	    arg = argv[i];
	    if(arg == NULL)
		continue;

	    if(!g_strcasecmp(arg, "--help") || 
               !g_strcasecmp(arg, "-help") ||
               !g_strcasecmp(arg, "--h") ||
               !g_strcasecmp(arg, "-h")
	    )
	    {
		print_help(argv[0]);
		return(0);
	    }
	    else if(!g_strcasecmp(arg, "--notebook"))
	    {
		cfg_win_style = CFG_WIN_STYLE_NOTEBOOK;
	    }
	    else if(!g_strcasecmp(arg, "--tree"))
	    {
		cfg_win_style = CFG_WIN_STYLE_TREE;
	    }
	    else if(!g_strcasecmp(arg, "--style") ||
                    !g_strcasecmp(arg, "-style") || 
		    !g_strcasecmp(arg, "-s")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    if(!g_strcasecmp(arg, "notebook"))
		    {
			cfg_win_style = CFG_WIN_STYLE_NOTEBOOK;
		    }
		    else if(!g_strcasecmp(arg, "tree"))
		    {
			cfg_win_style = CFG_WIN_STYLE_TREE;
		    }
		}
	    }
	}

	/* Create the CfgList */
	cfg_list = CFGItemListCopyList(cfg_list_src);
	CFGItemListSetValueI(
	    cfg_list,
	    "X",
	    1234,
	    FALSE
	);
	CFGItemListSetValueI(
	    cfg_list,
	    "Y",
	    5678,
	    FALSE
	);
	CFGItemListSetValueI(
	    cfg_list,
	    "Z",
	    9,
	    FALSE
	);
	CFGItemListSetValueS(
	    cfg_list,
	    "Name",
	    "Wolfpack",
	    FALSE
	);

	/* Initialize GTK+ */
	gtk_init(&argc, &argv);

	/* The CfgWin needs the configuration dialog and the progress
	 * dialog
	 */
	CDialogInit();
	ProgressDialogInit();

	/* Create the CfgWin */
	cfg_win = CfgWinNew(
	    cfg_win_style,
	    "Configuration Window",
	    (guint8 **)icon_options_48x48_xpm,
	    CFG_WIN_BUTTON_OK | CFG_WIN_BUTTON_APPLY |
		CFG_WIN_BUTTON_CANCEL | CFG_WIN_BUTTON_CLOSE,
	    640, 480,
	    cfg_list,
	    NULL,				/* No cfg file */
	    0,
	    NULL
	);
	gtk_signal_connect(
	    GTK_OBJECT(cfg_win), "delete_event",
	    GTK_SIGNAL_FUNC(delete_event_cb), cfg_win
	);

	/* Set up the CfgWin's GtkButtons */
	w = CfgWinGetOKButton(cfg_win);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(ok_button_cb), cfg_win
	);

	w = CfgWinGetApplyButton(cfg_win);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(apply_button_cb), cfg_win
	);

	w = CfgWinGetCancelButton(cfg_win);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(cancel_button_cb), cfg_win
	);

	w = CfgWinGetCloseButton(cfg_win);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(cancel_button_cb), cfg_win
	);

	/* Set the page changed callback */
	CfgWinSetPageChangedCB(
	    cfg_win,
	    cfg_win_page_changed_cb, cfg_win
	);

	/* Set the apply callback, this should be used instead of
	 * checking for "clicked" signal from the CfgWin's Apply
	 * GtkButton because that signal does not indicate when
	 * the widget values have already been (past tense) set to
	 * the CfgList
	 */
	CfgWinSetApplyCB(
	    cfg_win,
	    cfg_win_apply_cb, cfg_win
	);

	/* Create the pages */
	switch(cfg_win_style)
	{
	  case CFG_WIN_STYLE_NOTEBOOK:
	    create_cfg_win_notebook_pages(
		cfg_win,
		cfg_list
	    );
	    break;
	  case CFG_WIN_STYLE_TREE:
	    create_cfg_win_tree_pages(
		cfg_win,
		cfg_list
	    );
	    break;
	}

	/* This will iterate through the CfgWinLinks list and set
	 * all the widgets' values from their CfgItems' values
	 */
	CfgWinGetValues(
	    cfg_win,
	    FALSE				/* Do not show progress */
	);

	/* Reset the has changes flag on all the CfgWinLinks and
	 * the CfgWin
	 */
	CfgWinSetHasChanges(cfg_win, FALSE);

	/* Select the default page */
	CfgWinSetPage(
	    cfg_win,
	    NULL				/* Default page */
	);

	/* Map the CfgWin */
	gtk_widget_show(cfg_win);

	gtk_main();

	/* Unref and delete the CfgWin */
	CfgWinUnref(cfg_win);

	/* Delete the CfgList */
	CFGItemListDeleteList(cfg_list);

	ProgressDialogShutdown();
	CDialogShutdown();

	return(0);
}
