/*
		      System Information - Window
 */

#ifndef SI_WIN_H
#define SI_WIN_H

#include <gtk/gtk.h>


typedef struct _SIWin		SIWin;
#define SI_WIN(p)		((SIWin *)(p))
#define SI_WIN_KEY		"SIWin"


/*
 *	Flags:
 */
typedef enum {
	SI_WIN_MAPPED		= (1 << 0),
	SI_WIN_REALIZED		= (1 << 1),
	SI_WIN_SHOW_BORDER	= (1 << 2),
	SI_WIN_SHOW_TITLE	= (1 << 3),
        SI_WIN_DRAG_MOVE	= (1 << 4)		/* Window is being
                                                         * moved by drag */
} SIWinFlags;


/*
 *	Display Flags:
 */
typedef enum {
	SI_WIN_DISPLAY_CPU_LOAD	= (1 << 0),
	SI_WIN_DISPLAY_CPU_LOADAVG = (1 << 1),
	SI_WIN_DISPLAY_MEMORY	= (1 << 2),
	SI_WIN_DISPLAY_APM_POWER= (1 << 3),
	SI_WIN_DISPLAY_CPU_DETAILS= (1 << 4)
} SIWinDisplay;


/*
 *	Bar Styles:
 */
typedef enum {
	SI_WIN_BAR_STYLE_CONTINUOUS,
	SI_WIN_BAR_STYLE_DISCRETE,
	SI_WIN_BAR_STYLE_LED
} SIWinBarStyle;


/*
 *	SysInfo Window:
 */
struct _SIWin {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gint		busy_count,
			freeze_count;
	GdkColormap	*colormap;
	GdkGC		*gc;

	SIWinFlags	flags;
	GtkOrientation	orientation;
	SIWinDisplay	display;
	SIWinBarStyle	bar_style;
	gint		ndiscrete_bars,
			nled_bars;

	GdkCursor	*translate_cur;

        gint            last_button_x,
                        last_button_y;

	GdkPixmap	*bar_pixmap;		/* Back buffer for the bar
						 * GtkDrawingAreas */

	GdkColor	*bar_led_fg_color,	/* nled_bars * GdkColors */
			*bar_led_bg_color;	/* nled_bars * GdkColors */

	GtkWidget	*cpu_load_box,
			*cpu_load_icon_eb,
			*cpu_load_da;
	gfloat		cpu_load_last_value;

	GtkWidget	*cpu_loadavg_box,
			*cpu_loadavg_icon_eb,
			*cpu_loadavg_da;
	gfloat		cpu_loadavg_last_value;

	GtkWidget	*memory_box,
			*memory_icon_eb,
			*memory_da;
	gfloat		memory_last_value;
	gulong		memory_free,
			memory_total;

	GtkWidget	*apm_power_box,
			*apm_power_icon_eb,
			*apm_power_da;
	gfloat		apm_power_last_value;

	GtkWidget	*details_box,
			*details_text;

	GtkWidget	*pointer_in_widget;	/* Which widget the pointer
						 * is currently in (can be
						 * NULL for none) */

	GtkWidget	*menu,
			*display_memory_micheck,
			*display_apm_power_micheck,
			*display_cpu_details_micheck,
			*bar_style_continuous_micheck,
			*bar_style_discrete_micheck,
			*bar_style_led_micheck;

	gint		ncpus,			/* Total number of CPUs on
						 * the system */
			cpu_num;		/* CPU to monitor or -1 for
						 * total/combined CPUs */
};


extern SIWin *si_win_new(
	const gint processor_num,
	const GtkOrientation orientation,
	const gboolean show_border,
	const gboolean show_title,
	const SIWinDisplay display,
	const SIWinBarStyle bar_style,
	const gint bar_length
);
extern void si_win_set_display(
	SIWin *si,
	const SIWinDisplay display
);
extern void si_win_set_bar_style(
	SIWin *si,
	const SIWinBarStyle bar_style
);
extern void si_win_update(SIWin *si);
extern gboolean si_win_is_mapped(SIWin *si);
extern void si_win_map(SIWin *si);
extern void si_win_unmap(SIWin *si);
extern void si_win_delete(SIWin *si);


#endif	/* SI_WIN_H */
