#include <signal.h>
#include <gtk/gtk.h>

#include "si_cb.h"
#include "si_win.h"
#include "config.h"


void si_signal_cb(int s);

gint si_timeout_cb(gpointer data);


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	UNIX signal callback.
 */
void si_signal_cb(int s)
{
	switch(s)
	{
#ifdef SIGINT
	  case SIGINT:
		exit(0);
		break;
#endif
#ifdef SIGTERM
	  case SIGTERM:
		exit(0);
		break;
#endif
#ifdef SIGQUIT
	  case SIGQUIT:
		exit(0);
		break;
#endif
#ifdef SIGSEGV
	  case SIGSEGV:
		exit(1);
		break;
#endif
	}
}


/*
 *	Main timeout callback.
 */
gint si_timeout_cb(gpointer data)
{
	SIWin *si = SI_WIN(data);
	if(!si_win_is_mapped(si))
	{
		gtk_main_quit();
		return(FALSE);
	}

	si_win_update(si);

	return(TRUE);
}
