/*
           Endeavour Mark II - SysInfo - Compile Time Configuration
 */

#ifndef CONFIG_SYSINFO_H
#define CONFIG_SYSINFO_H

#include "../config.h"


/*
 *      Program name and version:
 */
#ifdef PROG_NAME
# undef PROG_NAME
#endif

#define PROG_NAME	"SysInfo"



/*
 *	Standard output help message:
 */
#ifdef PROG_HELP_MESG
# undef PROG_HELP_MESG
#endif

#define PROG_HELP_MESG  "\
Usage: sysinfo [cpu] [options] [GUI_options]\n\
\n\
    The [cpu] specifies which CPU to monitor, where [cpu] is the CPU\n\
    index (default value is 0). If [cpu] is -1 then the total/combined\n\
    CPU values will be reported.\n\
\n\
    The [options] can be any of the following:\n\
\n\
        --no-border             Do not display a border.\n\
        --no-borders            Same as --no-border.\n\
        -w                      Same as --no-border.\n\
\n\
        --no-title-bar          Do not display a title bar.\n\
        --no-title              Same as --no-title-bar.\n\
        -t                      Same as --no-title-bar.\n\
\n\
	-d <details...>         Details:\n\
					load\n\
					avg\n\
					mem\n\
					apm\n\
					details\n\
\n\
	-s <style>              Bar style:\n\
					continuous (default)\n\
					discrete\n\
					led\n\
\n\
	-o <orient>             Bar orientation:\n\
					horizontal (default)\n\
					vertical\n\
\n\
	-l <length>             Bar length in pixels (default is 100).\n\
\n\
	-i <interval>           Poll interval in milliseconds (default\n\
				is 250)\n\
\n\
	--help                  Prints this help screen and exits.\n\
	--version               Prints version information and exits.\n\
\n\
    The [GUI_options] can be any options standard to your GUI,\n\
    consult your GUI's manual for available options.\n\
\n"


/*
 *	Default Orientation:
 */
#define SYSINFO_DEF_ORIENTATION		GTK_ORIENTATION_HORIZONTAL

/*
 *	Default Bar Length (in pixels):
 */
#define SYSINFO_DEF_BAR_LENGTH		100

/*
 *	Default Poll Interval (in milliseconds):
 */
#define SYSINFO_DEF_POLL_INT		250


/*
 *	Legend:
 *
 *	SI_WIN			= SysInfo Window
 */


/*
 *	Window Manager Class Name:
 */
#define SYSINFO_WM_CLASS_NAME		PROG_NAME

/*
 *	Window Manager Window Names:
 */
#define SYSINFO_WM_WINDOW_NAME		"sysinfo"


/*
 *	Widget Names:
 */
#define SYSINFO_TOPLEVEL_WIDGET_NAME	"sysinfo"
#define SYSINFO_CPU_LOAD_BAR_WIDGET_NAME	\
					"cpu-load-bar"
#define SYSINFO_LOAD_AVERAGE_BAR_WIDGET_NAME	\
					"load-average-bar"
#define SYSINFO_MEMORY_BAR_WIDGET_NAME	"memory-bar"
#define SYSINFO_APM_POWER_BAR_WIDGET_NAME	\
					"apm-power-bar"


#endif	/* CONFIG_SYSINFO_H */
