#ifndef STATICTIP_H
#define STATICTIP_H

#include <gtk/gtk.h>


/*
 *	Widget Name:
 */
#define STATIC_TIP_WIDGET_NAME	"gtk-tooltips"


/*
 *	Aligns:
 */
typedef enum {
	STATIC_TIP_ALIGN_POINTER_MIN,		/* Left/top of pointer */
	STATIC_TIP_ALIGN_POINTER_CENTER,	/* Center of pointer */
	STATIC_TIP_ALIGN_POINTER_MAX,		/* Right/bottom of pointer */
	STATIC_TIP_ALIGN_WIDGET_MIN,		/* Left/top of GtkWidget */
	STATIC_TIP_ALIGN_WIDGET_CENTER,		/* Center of GtkWidget */
	STATIC_TIP_ALIGN_WIDGET_MAX,		/* Right/bottom of GtkWidget */
	STATIC_TIP_ALIGN_WIDGET_VALUE,		/* Relative to the GtkWidget's
						 * upper left corner */
	STATIC_TIP_ALIGN_ROOT_VALUE,		/* Relative to desktop's
						 * upper left corner */ 
} StaticTipAlign;


extern void StaticTipSet(
	GtkWidget *w,
	const gchar *text,
	const StaticTipAlign x_align, const StaticTipAlign y_align,
	const gint x, const gint y
);


#endif	/* STATICTIP_H */
