/*
			      Stack List

	Pair of lists with reorderable items
 */

#ifndef STACKLIST_H
#define STACKLIST_H

#include <gtk/gtk.h>


typedef struct _stack_list_item_struct	stack_list_item_struct;
#define STACK_LIST_ITEM(p)		((stack_list_item_struct *)(p))

typedef struct _stack_list_struct	stack_list_struct;
#define STACK_LIST(p)			((stack_list_struct *)(p))


/*
 *	Selection IDs:
 */
#define STACK_LIST_ITEM_SRC_TARGET_NAME	"StackList/Item/Source"
#define STACK_LIST_ITEM_SRC_INFO	0
#define STACK_LIST_ITEM_TAR_TARGET_NAME	"StackList/Item/Target"
#define STACK_LIST_ITEM_TAR_INFO	1


/*
 *	Flags:
 */
typedef enum {
	STACK_LIST_MAPPED			= (1 << 0),
	STACK_LIST_SHOW_DESCRIPTION_SOURCE	= (1 << 4),
	STACK_LIST_SHOW_DESCRIPTION_TARGET	= (1 << 5),
	STACK_LIST_MAINTAIN_SOURCE_ORDER	= (1 << 6)
} stack_list_flags;


/*
 *	Item:
 */
struct _stack_list_item_struct {

	gchar		*name;
	gchar		*description;
	GdkPixmap	*icon_pixmap;
	GdkBitmap	*icon_mask;

	gpointer	data;

	gint		id;		/* Arbitary number used to
					 * identify this item */ 

	gboolean	allow_multiple;	/* Multiple instances of this
					 * item on the target list
					 * allowed? */

	gboolean	stay_on_target;	/* This item may not be removed
					 * from the target list? */

};


/*
 *	Stack List:
 */
struct _stack_list_struct {

	GtkWidget	*toplevel;
	gint		freeze_count,
			busy_count;

	stack_list_flags	flags;

	GdkCursor	*translate_cur;

	GtkWidget 	*src_clist,
			*tar_clist,
			*left_arrow_btn,
			*right_arrow_btn,
			*up_arrow_btn,
			*down_arrow_btn;

	gint		src_last_selected,	/* Last selected item indices */
			tar_last_selected;

	GtkWidget	*description_toplevel,
			*description_label;

	GtkWidget	*src_menu,
			*src_add_mi,
			*src_remove_mi;

	GtkWidget	*tar_menu,
			*tar_add_mi,
			*tar_remove_mi,
			*tar_up_mi,
			*tar_down_mi;

	/* Complete list of Stack List Items, each data is a
	 * stack_list_item_struct *
	 *
	 * This items list is used to maintain the order of items
	 * on the src_list and to know exactly all the available
	 * items
	 */
	GList		*items_list;

	/* Last Stack List Item that was used for the description */
	stack_list_item_struct	*last_description_item;

	/* Last button pressed and pointer positions */
	gint		button,
			drag_last_x,
			drag_last_y;

	/* Changed Callback */
	void	(*changed_cb)(
		stack_list_struct *,		/* Stack List */
		gpointer			/* Data */
	);
	gpointer	changed_data;

	/* Added & Removed Callbacks */
	void	(*added_cb)(
		stack_list_struct *,		/* Stack List */
		stack_list_item_struct *,	/* Stack List Item */
		gpointer			/* Data */
	);
	gpointer	added_data;
	void	(*removed_cb)(
		stack_list_struct *,		/* Stack List */
		stack_list_item_struct *,	/* Stack List Item */
		gpointer			/* Data */
	);
	gpointer	removed_data;

};


/* Operations */
extern void StackListAdd(stack_list_struct *slist);
extern void StackListRemove(stack_list_struct *slist);
extern void StackListShiftUp(stack_list_struct *slist);
extern void StackListShiftDown(stack_list_struct *slist);

/* Stack List Item */
extern gint StackListAppend(
	stack_list_struct *slist,
	const gchar *name,
	const gchar *description,
	guint8 **icon_data,
	gpointer data,
	const gint id,
	const gboolean allow_multiple,
	const gboolean stay_on_target
);
extern void StackListClear(stack_list_struct *slist);

extern gint StackListItemAppendSrc(stack_list_struct *slist, const gint id);
extern gint StackListItemAppendTar(stack_list_struct *slist, const gint id);
extern void StackListItemSetAllFromCacheSrc(stack_list_struct *slist);

extern void StackListItemRemoveByIDSrc(
	stack_list_struct *slist, const gint id,
	const gboolean exclude_allowed_multiples
);
extern void StackListItemRemoveByIDTar(
	stack_list_struct *slist, const gint id,
	const gboolean exclude_allowed_multiples
);

extern void StackListItemClearSrc(stack_list_struct *slist);
extern void StackListItemClearTar(stack_list_struct *slist);

extern gint *StackListItemGetSrc(stack_list_struct *slist, gint *total);
extern gint *StackListItemGetTar(stack_list_struct *slist, gint *total);


/* Stack List */
extern stack_list_struct *StackListNew(
	GtkWidget *parent,
	const gchar *src_title, const gchar *tar_title
);
extern void StackListShowDescription(
	stack_list_struct *slist, 
	gboolean show_src_desc,
	gboolean show_tar_desc
);
extern void StackListSetMaintainSourceOrder(
	stack_list_struct *slist, gboolean maintain_source_order
);
extern void StackListSetChangedCB(
	stack_list_struct *slist, 
	void (*cb)(
		stack_list_struct *,		/* Stack List */
		gpointer			/* Data */
	),
	gpointer data   
);
extern void StackListSetAddedCB(
	stack_list_struct *slist,
	void (*cb)(
		stack_list_struct *,		/* Stack List */
		stack_list_item_struct *,	/* Stack List Item */
		gpointer			/* Data */
	),
	gpointer data
);
extern void StackListSetRemovedCB(
	stack_list_struct *slist,
	void (*cb)(
		stack_list_struct *,		/* Stack List */
		stack_list_item_struct *,	/* Stack List Item */
		gpointer			/* Data */
	),                                                
	gpointer data
);
extern void StackListUpdateMenus(stack_list_struct *slist);
extern gboolean StackListMapped(stack_list_struct *slist);
extern void StackListMap(stack_list_struct *slist);
extern void StackListUnmap(stack_list_struct *slist);
extern void StackListDelete(stack_list_struct *slist);


#endif	/* STACKLIST_H */
