#ifndef SPLASH_H
#define SPLASH_H

#include <gtk/gtk.h>
#include "guiutils.h"


/*
 *	Effects:
 */
typedef enum {
	SPLASH_EFFECTS_NONE,
	SPLASH_EFFECTS_FADE_WHITE,
	SPLASH_EFFECTS_FADE_BLACK,
	SPLASH_EFFECTS_FADE_BACKGROUND
} SplashEffects;


/*
 *	Default Map/Unmap Durations:
 */
#define SPLASH_DEF_MAP_DURATION_MS	750l
#define SPLASH_DEF_UNMAP_DURATION_MS	750l


extern GtkWidget *splash_new(void);
extern void SplashSetXPMFile(
	GtkWidget *w,
	const gchar *xpm_file
);
extern void splash_set_xpm_data(
	GtkWidget *w,
	const guint8 **xpm_data
);
extern void splash_set_message_color(
	GtkWidget *w,
	GdkColor *fg_color,
	GdkColor *bg_color
);
extern void splash_set_message_font(
	GtkWidget *w,
	GdkFont *font
);
extern void splash_set_message_justification(
	GtkWidget *w,
	const GtkJustification justify
);
extern void splash_set_message_position(
	GtkWidget *w,
	const GtkPositionType position
);
extern void splash_set_button_cb(
	GtkWidget *w,
	void (*cb)(
	    GtkWidget *,			/* Splash */
	    GdkEventButton *,			/* GdkEventButton */
	    gpointer				/* Data */
	),
	gpointer data
);
extern void splash_update_message(
	GtkWidget *w,
	const gfloat v,
	const gchar *msg
);
extern void splash_update(
	GtkWidget *w,
	const gboolean manage_events
);
extern void splash_map(
	GtkWidget *w,
	const SplashEffects effects,
	const gulong duration_ms,
	const GtkWindowPosition position
);
extern void splash_unmap(
	GtkWidget *w,
	const SplashEffects effects,
	const gulong duration_ms
);
extern GtkWidget *splash_ref(GtkWidget *w);
extern GtkWidget *splash_unref(GtkWidget *w);


#endif	/* SPLASH_H */
