/*
                       Endeavour Mark II - Run Dialog
 */

#ifndef RUN_DLG_H
#define RUN_DLG_H

#include <gtk/gtk.h>
#include "edv_types.h"


typedef struct _EDVRunDlg		EDVRunDlg;
#define EDV_RUN_DLG(p)			((EDVRunDlg *)(p))


/*
 *	Run Dialog:
 */
struct _EDVRunDlg {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		busy_count,
			freeze_count;
	EDVCore	*core;

	GtkWidget	*main_vbox,
			*run_combo,
			*browse_btn,
			*clear_btn,
			*working_dir_entry,
			*working_dir_browse_btn,
			*working_dir_clear_btn,
			*working_dir_get_from_cmd_btn,
			*run_in_terminal_check,
			*keep_dialog_check,
			*options_btn,
			*run_btn,
			*close_btn;

};


/* In rundlg.c */
extern void edv_run_dlg_set_command(
	EDVRunDlg *d,
	const char *command
);
extern void edv_run_dlg_set_working_directory(
	EDVRunDlg *d,
	const char *path
);
extern void edv_run_dlg_get_values(EDVRunDlg *d);

extern EDVRunDlg *edv_run_dlg_new(EDVCore *core);
extern void edv_run_dlg_set_busy(
	EDVRunDlg *d,
	const gboolean busy
);
extern gboolean edv_run_dlg_is_mapped(EDVRunDlg *d);
extern void edv_run_dlg_map(EDVRunDlg *d);
extern void edv_run_dlg_unmap(EDVRunDlg *d);
extern void edv_run_dlg_delete(EDVRunDlg *d);


#endif	/* RUN_DLG_H */
