#ifndef RGBA_TO_CIDX_H
#define RGBA_TO_CIDX_H

#include <sys/types.h>
#if defined(WIN32)
# include "../include/os.h"
#endif


typedef struct _ColormapColor		ColormapColor;
#define COLORMAP_COLOR(p)		((ColormapColor *)(p))


/*
 *	Colormap Color:
 */
struct _ColormapColor {
	u_int8_t        r, g, b;
};


extern int RGBAToCIdx(
        const u_int8_t *rgba,
        const int width, const int height,
        const int bpl,
        const int max_colors,
        u_int8_t **color_index_rtn,
        ColormapColor **colormap_rtn,
        int *colormap_ncolors_rtn,
        int (*progress_cb)(
                const int, const int,		/* Current & maximum values */
                void *				/* Progress data */
        ),
        void *progress_data
);


#endif	/* RGBA_TO_CIDX_H */
