/*
           Endeavour Mark II - Recycle Bin - Contents List
 */

#ifndef RECYCLE_BIN_LIST_H
#define RECYCLE_BIN_LIST_H

#include <gtk/gtk.h>
#include "recycle_bin.h"


/* Columns */
extern gint edv_recycle_bin_list_get_column_index_by_type(
        edv_recbin_struct *recbin,
        const EDVRecycleBinColumnType column_type
);
extern gint edv_recycle_bin_list_get_column_width_by_type(
        edv_recbin_struct *recbin,
        const EDVRecycleBinColumnType column_type
);
extern EDVRecycleBinColumnType edv_recycle_bin_list_get_column_type_by_index(
        edv_recbin_struct *recbin,
        const gint column_num
);
extern void edv_recycle_bin_list_set_column_width_by_type(
        edv_recbin_struct *recbin,
        const EDVRecycleBinColumnType column_type,
        const gint width
);
extern void edv_recycle_bin_list_resize_column_optimul(
	edv_recbin_struct *recbin,
	const gint column_num
);
extern void edv_recycle_bin_list_resize_columns_optimul(edv_recbin_struct *recbin);

/* Finding */
extern gint edv_recycle_bin_list_find_row_by_index(
	edv_recbin_struct *recbin,
	const guint index
);

/* Realize Listing */
extern void edv_recycle_bin_list_realize_listing(edv_recbin_struct *recbin);

/* Get Listing */
extern void edv_recycle_bin_list_get_listing(
	edv_recbin_struct *recbin,
	const gboolean show_progress
);
extern void edv_recycle_bin_list_clear(edv_recbin_struct *recbin);

/* Rename */
extern void edv_recycle_bin_list_rename_query(
        edv_recbin_struct *recbin,
	const gint row, const gint column
);

/* Callbacks */
extern void edv_recycle_bin_list_recycled_object_added_cb(
	edv_recbin_struct *recbin,
	const guint index
);
extern void edv_recycle_bin_list_recycled_object_modified_cb(
	edv_recbin_struct *recbin,
	const guint index
);
extern void edv_recycle_bin_list_recycled_object_removed_cb(
	edv_recbin_struct *recbin,
	const guint index
);


#endif	/* RECYCLE_BIN_LIST_H */
