/*
             Endeavour Mark II - Recycle Bin Desktop Icon
 */

#ifndef RECYCLE_BIN_DESKTOP_ICON_H
#define RECYCLE_BIN_DESKTOP_ICON_H

#include <gtk/gtk.h>
#include "edv_types.h"


typedef struct _EDVRecycleBinDesktopIcon	\
				EDVRecycleBinDesktopIcon;
#define EDV_RECYCLE_BIN_DESKTOP_ICON(p)	\
				((EDVRecycleBinDesktopIcon *)(p))


/*
 *	Recycle Bin Desktop Icon:
 */
struct _EDVRecycleBinDesktopIcon {

	GtkWidget	*desktop_icon;

	EDVCore		*core;

	/* Last known items in recycle bin, this is used as a quick
	 * access value to check if the recycle bin has contents or
	 * not
	 *
	 * Can be -1 to indicate undefined
	 */
	gint		last_nrecycle_bin_items;

};


extern EDVRecycleBinDesktopIcon *edv_recycle_bin_desktop_icon_new(EDVCore *core);
extern void edv_recycle_bin_desktop_icon_update_display(EDVRecycleBinDesktopIcon *rbdi);
extern void edv_recycle_bin_desktop_icon_map(EDVRecycleBinDesktopIcon *rbdi);
extern void edv_recycle_bin_desktop_icon_unmap(EDVRecycleBinDesktopIcon *rbdi);
extern void edv_recycle_bin_desktop_icon_delete(EDVRecycleBinDesktopIcon *rbdi);


#endif	/* RECYCLE_BIN_DESKTOP_ICON_H */
