#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "cfg.h"

#include "guiutils.h"
#include "desktop_icon.h"

#include "edv_types.h"
#include "edv_utils_gtk.h"
#include "recycle_bin.h"
#include "recycle_bin_dnd.h"
#include "recycle_bin_desktop_icon.h"
#include "edv_cb.h"
#include "edv_op.h"
#include "endeavour2.h"

#include "edv_cfg_list.h"
#include "config.h"

#include "images/icon_purge_all_20x20.xpm"


static void edv_recycle_bin_desktop_icon_map_cb(GtkWidget *icon, gpointer data);
static void edv_recycle_bin_dekstop_icon_moved_cb(
	GtkWidget *icon,
	const gint x, const gint y,
	gpointer data
);

EDVRecycleBinDesktopIcon *edv_recycle_bin_desktop_icon_new(EDVCore *core);
void edv_recycle_bin_desktop_icon_update_display(EDVRecycleBinDesktopIcon *rbdi);
void edv_recycle_bin_desktop_icon_map(EDVRecycleBinDesktopIcon *rbdi);
void edv_recycle_bin_desktop_icon_unmap(EDVRecycleBinDesktopIcon *rbdi);
void edv_recycle_bin_desktop_icon_delete(EDVRecycleBinDesktopIcon *rbdi);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? (gint)strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


#if defined(PROG_LANGUAGE_SPANISH)
# define EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL	"Cajn De Recirculacin"
#elif defined(PROG_LANGUAGE_FRENCH)
# define EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL	"Corbeille"
#elif defined(PROG_LANGUAGE_GERMAN)
# define EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL	"Verwerten Sie Behlter"
#elif defined(PROG_LANGUAGE_ITALIAN)
# define EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL	"Contenitore Per Raccolta"
#elif defined(PROG_LANGUAGE_DUTCH)
# define EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL	"Recycl Bak"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
# define EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL	"Caixa De Recycle"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
# define EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL	"Resirkulasjons Bin"
#else
# define EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL	"Recycle Bin"
#endif


/*
 *	Desktop icon map reference window callback.
 */
static void edv_recycle_bin_desktop_icon_map_cb(GtkWidget *icon, gpointer data)
{
	EDVCore *core;
	EDVRecycleBinDesktopIcon *rbdi = EDV_RECYCLE_BIN_DESKTOP_ICON(data);
	if((icon == NULL) || (rbdi == NULL))
		return;

	core = rbdi->core;

	edv_map_recycle_bin(
		core,
		core->geometry_flags,
		(core->geometry_flags != 0) ? &core->geometry : NULL
	);
}

/*
 *	Desktop icon moved callback.
 */
static void edv_recycle_bin_dekstop_icon_moved_cb(
	GtkWidget *icon,
	const gint x, const gint y,
	gpointer data
)
{
	CfgItem *cfg_list;
	EDVCore *core;
	EDVRecycleBinDesktopIcon *rbdi = EDV_RECYCLE_BIN_DESKTOP_ICON(data);
	if((icon == NULL) || (rbdi == NULL))
		return;

	core = rbdi->core;
	cfg_list = core->cfg_list;

	EDV_SET_I(
		EDV_CFG_PARM_RECBIN_DESKTOP_ICON_X,
		x
	);
	EDV_SET_I(
		EDV_CFG_PARM_RECBIN_DESKTOP_ICON_Y,
		y
	);
}


/*
 *	Creates a new recycle bin desktop icon.
 */
EDVRecycleBinDesktopIcon *edv_recycle_bin_desktop_icon_new(EDVCore *core)
{
	gint x = 0, y = 0;
	GtkWidget *w;
	const GtkTargetEntry dnd_tar_types[] = {
{GUI_TARGET_NAME_TEXT_PLAIN,	0,	EDV_DND_INFO_TEXT_PLAIN},
{GUI_TARGET_NAME_TEXT_URI_LIST,	0,	EDV_DND_INFO_TEXT_URI_LIST},
{GUI_TARGET_NAME_STRING,	0,	EDV_DND_INFO_STRING}
	};
	CfgList *cfg_list;
	EDVRecycleBinDesktopIcon *rbdi;

	if(core == NULL)
		return(NULL);

	cfg_list = core->cfg_list;

	x = EDV_GET_I(EDV_CFG_PARM_RECBIN_DESKTOP_ICON_X);
	y = EDV_GET_I(EDV_CFG_PARM_RECBIN_DESKTOP_ICON_Y);

	/* Create the Recycle Bin desktop icon */
	rbdi = EDV_RECYCLE_BIN_DESKTOP_ICON(
		g_malloc0(sizeof(EDVRecycleBinDesktopIcon))
	);
	if(rbdi == NULL)
		return(NULL);

	rbdi->core = core;
	rbdi->last_nrecycle_bin_items = -1;

	/* Desktop Icon */
	rbdi->desktop_icon = w = DesktopIconNew(
		DESKTOP_ICON_CAN_SELECT | DESKTOP_ICON_CAN_MOVE,
		x, y,
		NULL,
		edv_get_recycle_bin_icon_path(
			core,
			EDV_ICON_SIZE_48,
			0			/* Empty */
		),
		EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL
	);
	if(w == NULL)
	{
		g_free(rbdi);
		return(NULL);
	}
	DesktopIconSetMapRefCB(
		w,
		edv_recycle_bin_desktop_icon_map_cb,
		rbdi
	);
	DesktopIconSetMovedCB(
		w,
		edv_recycle_bin_dekstop_icon_moved_cb,
		rbdi
	);
	GUIDNDSetTar(
		DesktopIconGetIconWidget(w),
		dnd_tar_types,
		sizeof(dnd_tar_types) / sizeof(GtkTargetEntry),
		GDK_ACTION_MOVE,		/* Actions */
		GDK_ACTION_MOVE,		/* Default action if same */
		GDK_ACTION_MOVE,		/* Default action */
		edv_recycle_bin_desktop_icon_drag_data_received_cb,
		rbdi,
		FALSE				/* Do not highlight */
	);

	/* Create the menu */
	if(TRUE)
	{
		guint accel_key, accel_mods;
		gpointer data = core;
		const gchar *label;
		edv_pixmap_data *icon_data;
		GtkAccelGroup *accelgrp = NULL;
		GtkWidget *menu = GUIMenuCreate();
		void (*func_cb)(GtkWidget *, gpointer);

#define ADD_MENU_ITEM_LABEL	{		\
 w = GUIMenuItemCreate(				\
  menu,						\
  GUI_MENU_ITEM_TYPE_LABEL,			\
  accelgrp,					\
  icon_data,					\
  label,					\
  accel_key, accel_mods,			\
  func_cb, data					\
 );						\
}
#define ADD_MENU_SEPARATOR	{		\
 w = GUIMenuItemCreate(				\
  menu,						\
  GUI_MENU_ITEM_TYPE_SEPARATOR,			\
  NULL,						\
  NULL,						\
  NULL,						\
  0, 0,						\
  NULL, NULL					\
 );						\
}
		icon_data = NULL;
		label = "Restore";
		accel_key = 0;
		accel_mods = 0;
		func_cb = edv_map_recycle_bin_cb;
		ADD_MENU_ITEM_LABEL

		ADD_MENU_SEPARATOR

		icon_data = (edv_pixmap_data *)icon_purge_all_20x20_xpm;
		label = "Purge All";
		accel_key = 0;
		accel_mods = 0;
		func_cb = edv_purge_all_recycled_objects_cb;
		ADD_MENU_ITEM_LABEL

#undef ADD_MENU_ITEM_LABEL
#undef ADD_MENU_SEPARATOR

		DesktopIconSetMenu(rbdi->desktop_icon, menu);
	}

	return(rbdi);
}

/*
 *	Updates the icon on the recycle bin desktop icon to reflect the
 *	current unmber of contents in the recycle bin.
 */
void edv_recycle_bin_desktop_icon_update_display(EDVRecycleBinDesktopIcon *rbdi)
{
	gint cur_recbin_items;
	gchar		*icon_path,
			*label;
	GtkWidget *w;
	EDVCore *core;

	if(rbdi == NULL)
		return;

	core = rbdi->core;
	w = rbdi->desktop_icon;

	/* Get current number of recycled objects from core structure */
	cur_recbin_items = core->last_nrecycle_bin_items;

	/* Update recycle bin icon data, setting it to not NULL if it
	 * needs to be changed and update the recycle bin's
	 * last_nrecycle_bin_items to match the value on the core structure
	 */
	icon_path = NULL;
	label = NULL;
	if(rbdi->last_nrecycle_bin_items < 0)
	{
		/* Unknown if there were contents before, so definately
		 * set a new icon
		 */
		if(cur_recbin_items > 0)
		{
			icon_path = edv_get_recycle_bin_icon_path(
				core,
				EDV_ICON_SIZE_48,
				cur_recbin_items
			);
			label = g_strdup_printf(
#if defined(PROG_LANGUAGE_SPANISH)
EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL "\n%i Objeto%s"
#elif defined(PROG_LANGUAGE_FRENCH)
EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL "\n%i Objet%s"
#elif defined(PROG_LANGUAGE_GERMAN)
EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL "\n%i Objekt%s"
#elif defined(PROG_LANGUAGE_ITALIAN)
EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL "\n%i L'Oggetto%s"
#elif defined(PROG_LANGUAGE_DUTCH)
EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL "\n%i Voorwerp%s"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL "\n%i Objeto%s"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL "\n%i Objekt%s"
#else
EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL "\n%i Object%s"
#endif
				, cur_recbin_items,
				(cur_recbin_items == 1) ? "" : "s"
			);
		}
		else
		{
			icon_path = edv_get_recycle_bin_icon_path(
				core,
				EDV_ICON_SIZE_48,
				cur_recbin_items
			);
			label = g_strdup(EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL);
		}
	}
	else
	{
		/* Change in number of contents? */
		if(rbdi->last_nrecycle_bin_items != cur_recbin_items)
		{
			if(cur_recbin_items > 0)
			{
				icon_path = edv_get_recycle_bin_icon_path(
					core,
					EDV_ICON_SIZE_48,
					cur_recbin_items
				);
				label = g_strdup_printf(
#if defined(PROG_LANGUAGE_SPANISH)
EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL "\n%i Objeto%s"
#elif defined(PROG_LANGUAGE_FRENCH)
EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL "\n%i Objet%s"
#elif defined(PROG_LANGUAGE_GERMAN)
EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL "\n%i Objekt%s"
#elif defined(PROG_LANGUAGE_ITALIAN)
EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL "\n%i L'Oggetto%s"
#elif defined(PROG_LANGUAGE_DUTCH)
EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL "\n%i Voorwerp%s"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL "\n%i Objeto%s"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL "\n%i Objekt%s"
#else
EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL "\n%i Object%s"
#endif
					, cur_recbin_items,
					(cur_recbin_items == 1) ? "" : "s"
				);
			}
			else
			{
				icon_path = edv_get_recycle_bin_icon_path(
					core,
					EDV_ICON_SIZE_48,
					cur_recbin_items
				);
				label = g_strdup(EDV_RECYCLE_BIN_DESKTOP_ICON_LABEL);
			}
		}
	}
/*
printf("edv_recycle_bin_desktop_icon_update_display(): 0x%.8x %i\n", (guint)icon_data,
cur_recbin_items);
 */

	/* Update the desktop icon and label */
	DesktopIconSetFile(
		w,
		icon_path,
		label
	);

	/* Update number of recycled objects on the recycled desktop
	 * icon
	 */
	rbdi->last_nrecycle_bin_items = cur_recbin_items;

	g_free(icon_path);
	g_free(label);
}

/*
 *	Maps the recycle bin desktop icon.
 */
void edv_recycle_bin_desktop_icon_map(EDVRecycleBinDesktopIcon *rbdi)
{
	if(rbdi == NULL)
		return;

	DesktopIconMap(rbdi->desktop_icon);
}

/*
 *	Unmaps the recycle bin desktop icon.
 */
void edv_recycle_bin_desktop_icon_unmap(EDVRecycleBinDesktopIcon *rbdi)
{
	if(rbdi == NULL)
		return;

	DesktopIconUnmap(rbdi->desktop_icon);
}

/*
 *	Deallocates all resources of the given recycle bin desktop icon
 *	and deallocates the structure itself.
 */
void edv_recycle_bin_desktop_icon_delete(EDVRecycleBinDesktopIcon *rbdi)
{
	if(rbdi == NULL)
		return;

	edv_recycle_bin_desktop_icon_unmap(rbdi);

	rbdi->desktop_icon = DesktopIconUnref(rbdi->desktop_icon);

	g_free(rbdi);
}
