/*
              Endeavour Mark II - Recycle Bin - Callbacks
 */

#ifndef RECYCLE_BIN_CB_H
#define RECYCLE_BIN_CB_H

#include <gtk/gtk.h>
#include "edv_types.h"
#include "edv_mime_type.h"
#include "recycle_bin.h"


/* General */
extern void edv_recycle_bin_realize_cb(GtkWidget *widget, gpointer data);
extern gint edv_recycle_bin_delete_event_cb(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
extern gint edv_recycle_bin_key_event_cb(
	 GtkWidget *widget, GdkEventKey *key, gpointer data
);
extern gint edv_recycle_bin_enter_notify_event_cb(
	 GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint edv_recycle_bin_leave_notify_event_cb(
	 GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint edv_recycle_bin_button_event_cb(
	GtkWidget *widget, GdkEventButton *button, gpointer data
);

/* GtkHandleBox */
extern void edv_recycle_bin_handle_child_attached_cb(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);
extern void edv_recycle_bin_handle_child_detached_cb(
	GtkHandleBox *handle_box, GtkWidget *child, gpointer data
);

/* Contents GtkCList */
extern void edv_recycle_bin_resize_column_cb(
	GtkCList *clist, gint column, gint width, gpointer data
);
extern void edv_recycle_bin_click_column_cb(
	GtkCList *clist, gint column, gpointer data
);
extern void edv_recycle_bin_select_row_cb(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);
extern void edv_recycle_bin_unselect_row_cb(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);

/* GtkMenuItem Callbacks */
extern void edv_recycle_bin_menu_item_cb(GtkWidget *widget, gpointer data);
extern gint edv_recycle_bin_menu_item_enter_cb(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint edv_recycle_bin_menu_item_leavr_cb(
	GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);

/* EDVFindBar Callbacks */
extern void edv_recycle_bin_find_bar_start_cb(
	GtkWidget *bar,
	gpointer data
);
extern void edv_recycle_bin_find_bar_end_cb(
	GtkWidget *bar,
	const gint nmatches,
	gpointer data
);
extern void edv_recycle_bin_find_bar_match_cb(
	GtkWidget *bar,
	const gchar *path,
	GList *properties_list,
	const gint line_index,
	const gchar *excerpt,
	gpointer data
);

/* EDVStatusBar Callbacks */
extern void edv_recycle_bin_find_bar_status_message_cb(
	GtkWidget *widget,
	const gchar *message,
	gpointer data
);
extern void edv_recycle_bin_find_bar_status_progress_cb(
	GtkWidget *widget,
	const gfloat progress,
	gpointer data
);

/* Window Created/Deleted */
extern void edv_recycle_bin_window_created_cb(
	edv_recbin_struct *recbin,
	const EDVWindowType win_type,
	gpointer win
);
extern void edv_recycle_bin_window_deleted_cb(
	edv_recbin_struct *recbin,
	const EDVWindowType win_type,
	gpointer win
);

/* Reconfigured */
extern void edv_recycle_bin_reconfigured_cb(edv_recbin_struct *recbin);

/* Master Write Protect */
extern void edv_recycle_bin_master_write_protect_changed_cb(
	edv_recbin_struct *recbin,
	const gboolean state
);

/* Delete Method */
extern void edv_recycle_bin_delete_method_changed_cb(
	edv_recbin_struct *recbin,
	const EDVDeleteMethod delete_method
);

/* EDVRecycledObjects */
extern void edv_recycle_bin_recycled_object_added_cb(
	edv_recbin_struct *recbin,
	const guint index
);
extern void edv_recycle_bin_recycled_object_modified_cb(
	edv_recbin_struct *recbin,
	const guint index
);
extern void edv_recycle_bin_recycled_object_removed_cb(
	edv_recbin_struct *recbin,
	const guint index
);

/* EDVMIMETypes */
extern void edv_recycle_bin_mime_type_added_cb(
	edv_recbin_struct *recbin,
	const gint mt_num, EDVMIMEType *mt
);
extern void edv_recycle_bin_mime_type_modified_cb(
	edv_recbin_struct *recbin,
	const gint mt_num, EDVMIMEType *mt
);
extern void edv_recycle_bin_mime_type_removed_cb(
	edv_recbin_struct *recbin,
	const gint mt_num
);


#endif	/* RECYCLE_BIN_CB_H */
