/*
                     Endeavour Nark II - Recycle Bin

	These recycle_bin*.c modules are for the Recycle Bin Window,
	for Endeavour Mark II high-level recycle bin operations, see
	edv_recycle_bin_sync.c edv_recycle_obj.c, and
	edv_recycled_obj_op.c. All other recycle bin and recycled
	object modules are in the Endeavour Mark II API.

 */

#ifndef RECYCLE_BIN_H
#define RECYCLE_BIN_H

#include <gtk/gtk.h>
#include "cfg.h"
#include "edv_types.h"
#include "tool_bar.h"
#include "guiutils.h"


typedef struct _edv_recbin_struct	edv_recbin_struct;
#define EDV_RECBIN(p)			((edv_recbin_struct *)(p))

typedef struct _EDVRecycleBinOp		EDVRecycleBinOp;
#define EDV_RECYCLE_BIN_OP(p)		((EDVRecycleBinOp *)(p))


/*
 *	Flags:
 */
typedef enum {
	EDV_RECYCLE_BIN_MAPPED		= (1 << 0),
	EDV_RECYCLE_BIN_REALIZED	= (1 << 1),
	EDV_RECYCLE_BIN_PROCESSING	= (1 << 2),
	EDV_RECYCLE_BIN_TOOL_BAR_MAPPED	= (1 << 4),
	EDV_RECYCLE_BIN_FIND_BAR_MAPPED	= (1 << 5),
	EDV_RECYCLE_BIN_STATUS_BAR_MAPPED	\
					= (1 << 6)
} EDVRecycleBinFlags;


/*
 *	Recycle Bin Contents List Column Types:
 */
typedef enum {
	EDV_RECYCLE_BIN_COLUMN_TYPE_INDEX,
	EDV_RECYCLE_BIN_COLUMN_TYPE_NAME,
	EDV_RECYCLE_BIN_COLUMN_TYPE_SIZE,
	EDV_RECYCLE_BIN_COLUMN_TYPE_STORAGE_SIZE,
	EDV_RECYCLE_BIN_COLUMN_TYPE_TYPE,
	EDV_RECYCLE_BIN_COLUMN_TYPE_PERMISSIONS,
	EDV_RECYCLE_BIN_COLUMN_TYPE_OWNER,
	EDV_RECYCLE_BIN_COLUMN_TYPE_GROUP,
	EDV_RECYCLE_BIN_COLUMN_TYPE_DATE_ACCESS,
	EDV_RECYCLE_BIN_COLUMN_TYPE_DATE_MODIFIED,
	EDV_RECYCLE_BIN_COLUMN_TYPE_DATE_CHANGED,
	EDV_RECYCLE_BIN_COLUMN_TYPE_DATE_DELETED,
	EDV_RECYCLE_BIN_COLUMN_TYPE_LINKED_TO,
	EDV_RECYCLE_BIN_COLUMN_TYPE_ORIGINAL_LOCATION,
	EDV_RECYCLE_BIN_COLUMN_TYPE_CAPACITY_USED
} EDVRecycleBinColumnType;
/* Total number of column types */
#define EDV_RECYCLE_BIN_CONTENTS_CLIST_COLUMNS_MAX	\
					15


/*
 *	Recycle Bin Operations:
 */
typedef enum {

	EDV_RECYCLE_BIN_OP_NONE		= 0,
	EDV_RECYCLE_BIN_OP_SEPARATOR	= 100,

	EDV_RECYCLE_BIN_OP_CLOSE	= 200,
	EDV_RECYCLE_BIN_OP_EXIT		= 201,

	EDV_RECYCLE_BIN_OP_SYNC_DISKS	= 301,
	EDV_RECYCLE_BIN_OP_HISTORY	= 302,
	EDV_RECYCLE_BIN_OP_RUN		= 303,
	EDV_RECYCLE_BIN_OP_RUN_TERMINAL	= 304,
	EDV_RECYCLE_BIN_OP_WRITE_PROTECT	\
					= 305,
	EDV_RECYCLE_BIN_OP_DELETE_METHOD_RECYCLE	\
					= 308,
	EDV_RECYCLE_BIN_OP_DELETE_METHOD_PURGE	\
					= 309,

	EDV_RECYCLE_BIN_OP_SYNC_RECYCLE_BIN	\
					= 350,

	EDV_RECYCLE_BIN_OP_RECOVER	= 700,
	EDV_RECYCLE_BIN_OP_PURGE	= 701,
	EDV_RECYCLE_BIN_OP_PURGE_ALL	= 702,
	EDV_RECYCLE_BIN_OP_RENAME	= 703,
	EDV_RECYCLE_BIN_OP_CHMOD	= 704,
	EDV_RECYCLE_BIN_OP_CHOWN	= 705,
	EDV_RECYCLE_BIN_OP_CHTIME	= 706,
	EDV_RECYCLE_BIN_OP_PROPERTIES	= 707,

	EDV_RECYCLE_BIN_OP_SELECT_ALL	= 800,
	EDV_RECYCLE_BIN_OP_UNSELECT_ALL	= 801,
	EDV_RECYCLE_BIN_OP_INVERT_SELECTION	\
					= 802,
	EDV_RECYCLE_BIN_OP_FIND		= 850,

	EDV_RECYCLE_BIN_OP_REFRESH	= 1000,
	EDV_RECYCLE_BIN_OP_REFRESH_ALL	= 1001,

	EDV_RECYCLE_BIN_OP_SHOW_TOOL_BAR	\
					= 1300,
	EDV_RECYCLE_BIN_OP_SHOW_FIND_BAR	\
					= 1303,
	EDV_RECYCLE_BIN_OP_SHOW_STATUS_BAR	\
					= 1304,

	EDV_RECYCLE_BIN_OP_CONTENTS_LIST_FILTER	\
					= 1400,
	EDV_RECYCLE_BIN_OP_CONTENTS_LIST_AUTO_RESIZE_COLUMNS	\
					= 1410,

	EDV_RECYCLE_BIN_OP_MIME_TYPES	= 1700,

	EDV_RECYCLE_BIN_OP_NEW_BROWSER	= 1800,
	EDV_RECYCLE_BIN_OP_NEW_IMBR	= 1801,
	EDV_RECYCLE_BIN_OP_NEW_ARCHIVER	= 1802,

	EDV_RECYCLE_BIN_OP_OPTIONS	= 2000,
	EDV_RECYCLE_BIN_OP_CUSTOMIZE	= 2001,

	EDV_RECYCLE_BIN_OP_HELP_CONTENTS	\
					= 3000,
	EDV_RECYCLE_BIN_OP_HELP_FILE_BROWSER	\
					= 3010,
	EDV_RECYCLE_BIN_OP_HELP_IMAGE_BROWSER	\
					= 3011,
	EDV_RECYCLE_BIN_OP_HELP_ARCHIVER	\
					= 3012,
	EDV_RECYCLE_BIN_OP_HELP_RECYCLE_BIN	\
					= 3030,
	EDV_RECYCLE_BIN_OP_HELP_KEYS_LIST	\
					= 3050,
	EDV_RECYCLE_BIN_OP_HELP_COMMON_OPERATIONS	\
					= 3053,
	EDV_RECYCLE_BIN_OP_HELP_ABOUT	= 3100

} EDVRecycleBinOpID;


/*
 *	Recycle Bin Operation ID:
 */
struct _EDVRecycleBinOp {

	EDVRecycleBinOpID	id;
	EDVOpIDFlags	flags;
	ToolBarItemType	tb_item_type;
	edv_recbin_struct	*recbin;

	/* Operation callback */
	void		(*func_cb)(
		ToolBarItem *,			/* Tool Bar Item */
		gint,				/* ID */
		gpointer			/* OPID */
	);

	/* Enter and leave notify callbacks */
	void		(*enter_func_cb)(
		ToolBarItem *,			/* Tool Bar Item */
		gint,				/* ID */
		gpointer			/* OPID */
	);
	void		(*leave_func_cb)(
		ToolBarItem *,			/* Tool Bar Item */
		gint,				/* ID */
		gpointer			/* OPID */
	);

	gchar		*button_name;		/* Name on a button */
	gchar		*menu_name;		/* Name on a menu item */
	gchar		*tooltip;		/* Tool tip or description (one line) */

	guint		accel_key,		/* Accelerator key */
			accel_mods;		/* Accelerator key modifiers */

	guint8		**button_icon_data,	/* Shared */
			**menu_icon_data;	/* Shared */

};


/*
 *	Recycle Bin:
 */
struct _edv_recbin_struct {

	GtkWidget	*toplevel;
	EDVCore		*core;
	EDVRecycleBinFlags	flags;
	gint		freeze_count,
			busy_count,
			stop_count;

	GList		*op_ids_list;


	GtkWidget	*main_vbox,
			*menu_bar,

			*menu_bar_handle,
			*tool_bar_handle,
			*find_bar_handle,

			*contents_clist;	/* Contents GtkCList */

	/* GtkMenus and GtkMenuItems */
	GtkWidget	*recover_mi,
			*purge_mi,
			*purge_all_mi,
			*sync_recycle_bin_mi,
			*sync_disks_mi,
			*history_mi,
			*run_mi,
			*close_mi,

			*edit_recover_mi,
			*edit_purge_mi,
			*edit_purge_all_mi,
			*rename_mi,
			*chmod_mi,
			*chown_mi,
			*chtime_mi,
			*select_all_mi,
			*unselect_all_mi,
			*invert_selection_mi,
			*find_mi,
			*properties_mi,

			*refresh_mi,
			*refresh_all_mi,
			*show_tool_bar_micheck,
			*show_find_bar_micheck,
			*show_status_bar_micheck,
			*contents_list_filter_mi,
			*contents_list_auto_resize_columns_micheck,
			*mime_types_mi,

			*write_protect_mi,
			*delete_method_recycle_micheck,
			*delete_method_purge_micheck,
			*options_mi,
			*customize_mi,

			*window_new_browser_mi,
			*window_new_imbr_mi,
			*window_new_archiver_mi,

			*help_contents_mi,
			*help_recycle_bin_mi,
			*help_keys_list_mi,
			*help_common_operations_mi,
			*help_about_mi;

	/* Tool Bar */
	GtkWidget	*tool_bar;

	/* Find Bar */
	GtkWidget	*find_bar;

	/* Status Bar */
	GtkWidget	*status_bar;

	/* Contents GtkCList Right-Click GtkMenu */
	GtkWidget       *contents_clist_menu,
			*contents_clist_recover_mi,
			*contents_clist_purge_mi,
			*contents_clist_purge_all_mi,
			*contents_clist_rename_mi,
			*contents_clist_chmod_mi,
			*contents_clist_chown_mi,
			*contents_clist_chtime_mi,
			*contents_clist_properties_mi;

	gchar		*contents_list_filter;

	/* Last selected row on the clist (can be -1 for none)
	 *
	 * Note that this does not reflect other selected rows since
	 * multiple selections are allowed
	 */
	gint		contents_clist_selected_row;


	/* Last known items in recycle bin, this is used as a quick access
	 * value to check if the recycle bin has contents or not
	 *
	 * Can be -1 to indicate undefined
	 */
	gint		last_nrecycle_bin_items;

	/* Last known write protect state (can be -1 to indicate
	 * undefined)
	 */
	gint		last_write_protect_state;

};

#define EDV_RECYCLE_BIN_IS_PROCESSING(p)	\
					(((p) != NULL) ? \
 ((p)->flags & EDV_RECYCLE_BIN_PROCESSING) : FALSE)
#define EDV_RECYCLE_BIN_IS_FROZEN(p)	(((p) != NULL) ? \
 ((p)->freeze_count > 0) : FALSE)
#define EDV_RECYCLE_BIN_IS_BUSY(p)	(((p) != NULL) ? \
 ((p)->busy_count > 0) : FALSE)


/* Utilities */
extern EDVRecycleBinOp *edv_recycle_bin_op_match_by_id(
	edv_recbin_struct *recbin,
	const EDVRecycleBinOpID id
);

/* Title */
extern void edv_recycle_bin_set_title(edv_recbin_struct *recbin);

/* Get selected object & paths */
extern GList *edv_recycle_bin_get_selected_objects(
	edv_recbin_struct *recbin, 
	const gboolean copy
);

/* Regenerate Style, Menus, and Tool Bar */
extern void edv_recycle_bin_accelkeys_regenerate(edv_recbin_struct *recbin);
extern void edv_recycle_bin_tool_bar_regenerate(edv_recbin_struct *recbin);
extern void edv_recycle_bin_list_menu_regenerate(edv_recbin_struct *recbin);

/* Sync Configuration */
extern void edv_recycle_bin_sync_configuration(edv_recbin_struct *recbin);

/* Operation IDs List */
extern GList *edv_recycle_bin_ops_list_new(edv_recbin_struct *recbin);
extern void edv_recycle_bin_ops_list_delete(GList *op_ids_list);

/* Accel Keys */
extern CfgAccelkeyList *edv_recycle_bin_accelkeys_new(void);

/* Recycle Bin */
extern edv_recbin_struct *edv_recycle_bin_new(
	EDVCore *core,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry
);
extern void edv_recycle_bin_sync_data(edv_recbin_struct *recbin);
extern void edv_recycle_bin_update_display(edv_recbin_struct *recbin);
extern void edv_recycle_bin_set_busy(edv_recbin_struct *recbin, const gboolean busy);
extern gboolean edv_recycle_bin_is_mapped(edv_recbin_struct *recbin);
extern void edv_recycle_bin_map(edv_recbin_struct *recbin);
extern void edv_recycle_bin_unmap(edv_recbin_struct *recbin);
extern void edv_recycle_bin_delete(edv_recbin_struct *recbin);


#endif	/* RECYCLE_BIN_H */
