/*
	     Endeavour Mark II - Device Node Properties Page
 */

#ifndef PROP_PAGE_DEVICE_NODE_H
#define PROP_PAGE_DEVICE_NODE_H

#include <gtk/gtk.h>
#include "edv_types.h"
#include "libendeavour2-base/edv_vfs_obj.h"
#include "libendeavour2-base/edv_recycled_obj.h"
#include "prop_page.h"


extern gboolean edv_device_node_prop_page_query_create_cb(
	EDVPropPageContext *ctx,
	gint *version_major_rtn,
	gint *version_minor_rtn,
	gint *version_release_rtn,
	gchar **page_name_rtn,
	edv_pixmap_data **pixmap_data_20x20_rtn,
	const EDVObjectType type,
	const EDVLocationType location_type,
	GList *properties_list
);
extern gpointer edv_device_node_prop_page_create_cb(
	EDVPropPageContext *ctx,
	GtkWidget *parent
);
extern void edv_device_node_prop_page_update_cb(
	EDVPropPageContext *ctx,
	const EDVObjectType type,
	const EDVLocationType location_type,
	GList *properties_list,
	const int error_code,
	gpointer data
);
extern gboolean edv_device_node_prop_page_apply_vfs_cb(
	EDVPropPageContext *ctx,
	const EDVObjectType type,
	GList *properties_list,
	gpointer data
);
extern gboolean edv_device_node_prop_page_apply_recycle_bin_cb(
	EDVPropPageContext *ctx,
	const EDVObjectType type,
	GList *properties_list,
	gpointer data
);
extern void edv_device_node_prop_page_destroy_cb(
	EDVPropPageContext *ctx,
	gpointer data
);


#endif	/* PROP_PAGE_DEVICE_NODE_H */
