/*
		     Endeavour Mark II - Property Page

	Used to create individual pages on the Properties Dialog.

	See also; prop_dlg.h
 */

#ifndef PROP_PAGE_H
#define PROP_PAGE_H

#include <gtk/gtk.h>
#include "cfg.h"
#include "edv_types.h"
#include "libendeavour2-base/edv_property.h"


/*
 *	Page Context:
 */
typedef struct _EDVPropPageContext	EDVPropPageContext;
#define EDV_PROP_PAGE_CONTEXT(p)	((EDVPropPageContext *)(p))


/*
 *	Query Create Page Callback:
 *
 *	Called to query if the page supports the object and if the page
 *	should be created.
 *
 *	Return TRUE if you want to create the page, in which case the
 *	EDVPropPageCreateFunc will be called afterwards or
 *	FALSE if the page should not be created and in which case the
 *	EDVPropPageCreateFunc will not be called afterwards.
 */
typedef gboolean (*EDVPropPageQueryCreateFunc)(
	EDVPropPageContext *ctx,
	gint *version_major_rtn,
	gint *version_minor_rtn,
	gint *version_release_rtn,
	gchar **page_name_rtn,			/* Dynamically allocated copy */
	edv_pixmap_data **pixmap_data_20x20_rtn,
	const EDVObjectType type,
	const EDVLocationType location_type,
	GList *properties_list			/* GList of EDVProperty *
						 * properties */
);

/*
 *	Create Page Callback:
 *
 *	Called to create the page.
 *
 *	Return your pointer to your user data which will be passed to
 *	subsequent calls to the EDVPropDlgPage*Functions or NULL if
 *	there was an error or failure in which case no further calls
 *	will be made to the EDVPropDlgPage*Functions.
 */
typedef gpointer (*EDVPropPageCreateFunc)(
	EDVPropPageContext *ctx,
	GtkWidget *parent			/* GtkVBox which should
						 * be the parent for the
						 * page's GtkWidgets */
);

/*
 *	Update Page Callback:
 *
 *	Called whenever the page needs to update its displayed values,
 *	typically when the object, device, MIME Type, or configuration
 *	has been modified.
 */
typedef void (*EDVPropPageUpdateFunc)(
	EDVPropPageContext *ctx,
	const EDVObjectType type,
	const EDVLocationType location_type,
	GList *properties_list,			/* GList of EDVProperty *
						 * properties */
	const int error_code,			/* errno error code if
						 * properties_list is NULL */
	gpointer data				/* Data pointer returned from
						 * EDVPropPageCreateFunc */
);

/*
 *	Page Switch Callback:
 *
 *	Called whenever the page is switched to or from.
 */
typedef void (*EDVPropPagePageSwitchedFunc)(
	EDVPropPageContext *ctx,
	const gboolean to,			/* TRUE = to your page
						 * FALSE = away from your
						 * page */
	gpointer data				/* Data pointer returned from
						 * EDVPropPageCreateFunc */
);

/*
 *	Apply Callbacks:
 *
 *	Called whenever the OK or Apply button has been clicked and
 *	your page's current values need to be apply to the object,
 *
 *	Return TRUE if your page has actually modified the object in
 *	any way or FALSE if you have left it unmodified.
 */
typedef gboolean (*EDVPropPageApplyVFSFunc)(
	EDVPropPageContext *ctx,
	const EDVObjectType type,
	GList *properties_list,			/* GList of EDVProperty *
						 * properties */
	gpointer data				/* Data pointer returned from
						 * EDVPropPageCreateFunc */
);
typedef gboolean (*EDVPropPageApplyRecycleBinFunc)(
	EDVPropPageContext *ctx,
	const EDVObjectType type,
	GList *properties_list,			/* GList of EDVProperty *
						 * properties */
	gpointer data				/* Data pointer returned from
						 * EDVPropPageCreateFunc */
);

/*
 *	Destroy Callback:
 *
 *	Called when this page's GtkWidgets have already been destroyed.
 *
 *	Note that this function is called after the EDVPropDlg's
 *	GtkWidgets have been destroyed, which means that your page's
 *	GtkWidgets will have already been destroyed at the time this
 *	function is called so you should not attempt to destroy your
 *	GtkWidgets again.
 */
typedef void (*EDVPropPageDestroyFunc)(
	EDVPropPageContext *ctx,
	gpointer data				/* Data pointer returned from
						 * EDVPropPageCreateFunc */
);


extern GtkWidget *edv_prop_page_get_toplevel(EDVPropPageContext *ctx);
extern GtkAccelGroup *edv_prop_page_get_accelgrp(EDVPropPageContext *ctx);
extern gint edv_prop_page_get_freeze_count(EDVPropPageContext *ctx);
extern void edv_prop_page_get_freeze(EDVPropPageContext *ctx);
extern void edv_prop_page_get_thaw(EDVPropPageContext *ctx);

extern EDVCore *edv_prop_page_get_core(EDVPropPageContext *ctx);
extern CfgList *edv_prop_page_get_cfg_list(EDVPropPageContext *ctx);

extern EDVLocationType edv_prop_page_get_location_type(EDVPropPageContext *ctx);

extern GList *edv_prop_page_get_properties_list(EDVPropPageContext *ctx);

extern GList *edv_prop_page_get_meta_data_list(EDVPropPageContext *ctx);
extern void edv_prop_page_add_meta_data(
	EDVPropPageContext *ctx,
	const gchar *name,
	const gchar *value
);
extern void edv_prop_page_remove_meta_data(
	EDVPropPageContext *ctx,
	const gchar *name
);

extern const gchar *edv_prop_page_get_mime_type_type(EDVPropPageContext *ctx);

extern const gchar *edv_prop_page_get_archive_path(EDVPropPageContext *ctx);

extern gboolean edv_prop_page_get_has_changes(EDVPropPageContext *ctx);
extern void edv_prop_page_set_has_changes(
	EDVPropPageContext *ctx,
	const gboolean has_changes
);

extern void edv_prop_page_set_busy(
	EDVPropPageContext *ctx,
	const gboolean busy
);

extern GtkWidget *edv_prop_page_create_icon_selector(EDVPropPageContext *ctx);


#endif	/* PROP_PAGE_H */
