/*
		   Endeavour Mark II - Properties Dialog
 */

#ifndef PROP_DLG_H
#define PROP_DLG_H

#include <gtk/gtk.h>

#include "guiutils.h"

#include "edv_types.h"
#include "libendeavour2-base/edv_vfs_obj.h"
#include "edv_device.h"
#include "edv_mime_type.h"


typedef struct _EDVPropDlg		EDVPropDlg;
#define EDV_PROP_DLG(p)			((EDVPropDlg *)(p))


/* Callbacks */
extern void edv_prop_dlg_reconfigured_cb(EDVPropDlg *d);
extern void edv_prop_dlg_master_write_protect_changed_cb(
	EDVPropDlg *d,
	const gboolean state
);
extern void edv_prop_dlg_delete_method_changed_cb(
	EDVPropDlg *d,
	const EDVDeleteMethod delete_method
);

extern void edv_prop_dlg_mime_type_added_cb(
	EDVPropDlg *d,
	const gint mt_num, EDVMIMEType *m
);
extern void edv_prop_dlg_mime_type_modified_cb(
	EDVPropDlg *d,
	const gint mt_num, EDVMIMEType *m
);
extern void edv_prop_dlg_mime_type_removed_cb(
	EDVPropDlg *d,
	const gint mt_num
);

extern void edv_prop_dlg_device_added_cb(
	EDVPropDlg *d,
	const gint dev_num, EDVDevice *dev
);
extern void edv_prop_dlg_device_modified_cb(
	EDVPropDlg *d,
	const gint dev_num, EDVDevice *dev
);
extern void edv_prop_dlg_device_removed_cb(
	EDVPropDlg *d,
	const gint dev_num
);

extern void edv_prop_dlg_vfs_object_added_cb(
	EDVPropDlg *d,
	const gchar *path,
	EDVVFSObject *obj
);
extern void edv_prop_dlg_vfs_object_modified_cb(
	EDVPropDlg *d,
	const gchar *path,
	const gchar *new_path,
	EDVVFSObject *obj
);
extern void edv_prop_dlg_vfs_object_removed_cb(
	EDVPropDlg *d,
	const gchar *path
);

extern void edv_prop_dlg_device_mount_cb(
	EDVPropDlg *d,
	const gint dev_num, EDVDevice *dev,
	const gboolean mounted
);

extern void edv_prop_dlg_recycled_object_added_cb(
	EDVPropDlg *d,
	const gulong index
);
extern void edv_prop_dlg_recycled_object_modified_cb(
	EDVPropDlg *d,
	const gulong index
);
extern void edv_prop_dlg_recycled_object_removed_cb(
	EDVPropDlg *d,
	const gulong index
);

/* Utilities */
extern GList *edv_prop_dlg_update_properties_list(
	EDVCore *core,
	GList *properties_list,
	const EDVLocationType location_type,
	const gchar *path,
	const gulong index,
	const gchar *arch_path,
	GList **meta_data_list_rtn,
	gint *error_code_rtn
);
extern GtkWidget *edv_prop_dlg_create_icon_selector(EDVPropDlg *d);

/* Emit */
extern void edv_prop_dlg_emit_update_pages(EDVPropDlg *d);

/* Properties Dialog */
extern EDVPropDlg *edv_prop_dlg_new(
	EDVCore *core,
	const EDVLocationType location_type,
	const gchar *path,
	const gulong index,
	const gchar *arch_path,
	GList *meta_data_list,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry
);
extern GtkWidget *edv_prop_dlg_get_toplevel(EDVPropDlg *d);
extern GtkAccelGroup *edv_prop_dlg_get_accelgrp(EDVPropDlg *d);
extern gint edv_prop_dlg_get_freeze_count(EDVPropDlg *d);
extern void edv_prop_dlg_freeze(EDVPropDlg *d);
extern void edv_prop_dlg_thaw(EDVPropDlg *d);
extern EDVCore *edv_prop_dlg_get_core(EDVPropDlg *d);
extern CfgList *edv_prop_dlg_get_cfg_list(EDVPropDlg *d);
extern EDVLocationType edv_prop_dlg_get_location_type(EDVPropDlg *d);
extern GList *edv_prop_dlg_get_properties_list(EDVPropDlg *d);
extern GList *edv_prop_dlg_get_meta_data_list(EDVPropDlg *d);
extern void edv_prop_dlg_add_meta_data(
	EDVPropDlg *d,
	const gchar *name,
	const gchar *value
);
extern void edv_prop_dlg_remove_meta_data(
	EDVPropDlg *d,
	const gchar *name 
);
extern const gchar *edv_prop_dlg_get_mime_type_type(EDVPropDlg *d);
extern const gchar *edv_prop_dlg_get_archive_path(EDVPropDlg *d);
extern gboolean edv_prop_dlg_set_page(
	EDVPropDlg *d,
	const gchar *page_name
);
extern gboolean edv_prop_dlg_get_has_changes(EDVPropDlg *d);
extern void edv_prop_dlg_set_has_changes(
	EDVPropDlg *d,
	const gboolean has_changes
);
extern void edv_prop_dlg_update_display(EDVPropDlg *d);
extern void edv_prop_dlg_set_busy(EDVPropDlg *d, const gboolean busy);
extern gboolean edv_prop_dlg_is_mapped(EDVPropDlg *d);
extern void edv_prop_dlg_map(EDVPropDlg *d);
extern void edv_prop_dlg_unmap(EDVPropDlg *d);
extern void edv_prop_dlg_delete(EDVPropDlg *d);


#endif	/* PROP_DLG_H */
