/*
			     Progress Dialog
 */

#ifndef PROGRESSDIALOG_H
#define PROGRESSDIALOG_H

#include <gtk/gtk.h>


extern gint ProgressDialogInit(void);
extern void ProgressDialogSetStyle(GtkRcStyle *rc_style);
extern void ProgressDialogSetTransientFor(GtkWidget *w);
extern void ProgressDialogSetWMIconData(const guint8 **icon_data);
extern gboolean ProgressDialogIsQuery(void);	/* Checks if mapped */
extern void ProgressDialogBreakQuery(const gboolean allow_gtk_iteration);
extern gint ProgressDialogStopCount(void);
extern GtkWidget *ProgressDialogGetToplevel(void);
extern void ProgressDialogMap(
	const gchar *title,
	const gchar *label,
	const guint8 **icon_data,
	const gchar *stop_btn_label
);
extern void ProgressDialogMapFile(
	const gchar *title,
	const gchar *label,
	const gchar *icon_path,
	const gchar *stop_btn_label
);
extern void ProgressDialogMapAnimation(
	const gchar *title,
	const gchar *label,
	const gchar *stop_btn_label,
	GList *start_icon_datas_list,
	GList *icon_datas_list,
	GList *end_icon_datas_list,
	const gulong animation_interval_ms,
	const guint16 animation_increment	/* 1 to (guint16)-1 */
);
extern void ProgressDialogMapAnimationFile(
	const gchar *title,
	const gchar *label,
	const gchar *stop_btn_label,
	GList *start_icon_paths_list,
	GList *icon_paths_list,
	GList *end_icon_paths_list,
	const gulong animation_interval_ms,
	const guint16 animation_increment
);
extern void ProgressDialogUpdate(
	const gchar *title,
	const gchar *label,
	const guint8 **icon_data,
	const gchar *stop_btn_label,
	const gfloat position,			/* 0.0 to 1.0 */
	const guint nblocks,			/* 0 for continuous */
	const gboolean allow_gtk_iteration
);
extern void ProgressDialogUpdateUnknown(
	const gchar *title,
	const gchar *label,
	const guint8 **icon_data,
	const gchar *stop_btn_label,
	const gboolean allow_gtk_iteration
);
extern void ProgressDialogUnmap(void);
extern void ProgressDialogShutdown(void);


#endif	/* PROGRESSDIALOG_H */
