#ifndef PIE_CHART_H
#define PIE_CHART_H

#include <gtk/gtk.h>


/*
 *	Pie Chart Flags:
 */
typedef enum {
	PIE_CHART_REALIZED		= (1 << 0),
	PIE_CHART_DOUBLE_BUFFER		= (1 << 1),
	PIE_CHART_SHOW_LABELS		= (1 << 2),
	PIE_CHART_SHOW_SHADOW		= (1 << 3),
	PIE_CHART_SHOW_OUTLINE		= (1 << 4)
} pie_chart_flags;


extern gint PieChartValueAdd(
	GtkWidget *w,
	GtkAdjustment *adj,
	GdkColor *c,
	const gchar *type_label,
	const gchar *value_label
);
extern void PieChartValueSet(
	GtkWidget *w,
	const gint value_num,
	GtkAdjustment *adj,
	GdkColor *c,
	const gchar *type_label,
	const gchar *value_label
);
extern void PieChartValueRemove(
	GtkWidget *w,
	const gint value_num
);
extern void PieChartClear(GtkWidget *w);

/* Pie Chart */
extern GtkWidget *PieChartNew(
	const pie_chart_flags flags,
	const gint width, const gint height,
	GtkAdjustment *adj,
	GdkColor *c,
	const gchar *title,
	const gchar *footer,
	const gchar *base_type_label,
	const gchar *base_value_label
);
extern void PieChartRealize(GtkWidget *w);
extern void PieChartQueueDraw(GtkWidget *w);


#endif	/* PIE_CHART_H */
