#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <gtk/gtk.h>

#include "cfg.h"

#include "guiutils.h"
#include "pulist.h"
#include "stacklist.h"
#include "con_msg.h"
#include "fb.h"
#include "cfg_win.h"

#include "edv_types.h"
#include "libendeavour2-base/edv_utils.h"
#include "libendeavour2-base/edv_process.h"
#include "edv_date_format.h"
#include "edv_utils_gtk.h"
#include "edv_list_cb.h"
#include "vfs_browser.h"
#include "vfs_browser_cb.h"
#include "options_win.h"
#include "edv_cb.h"
#include "edv_op.h"
#include "endeavour2.h"

#include "edv_cfg_list.h"
#include "config.h"

#include "images/icon_options_48x48.xpm"

#include "images/icon_endeavour_file_browser_48x48.xpm"
#include "images/icon_endeavour_image_browser_48x48.xpm"
#include "images/icon_endeavour_archiver_48x48.xpm"

#include "images/icon_write_protect_off_20x20.xpm"
#include "images/icon_write_protect_on_20x20.xpm"
#include "images/icon_add_20x20.xpm"
#include "images/icon_folder_opened_20x20.xpm"
#include "images/icon_purge_all_20x20.xpm"
#include "images/icon_mimetypes_20x20.xpm"
#include "images/icon_device_misc_20x20.xpm"
#include "images/icon_run_20x20.xpm"
#include "images/icon_terminal2_20x20.xpm"
#include "images/icon_terminal_run2_20x20.xpm"
#include "images/icon_download_file_20x20.xpm"
#include "images/icon_mailbox_20x20.xpm"
#include "images/icon_open_20x20.xpm"
#include "images/icon_move_file_20x20.xpm"
#include "images/icon_copy_file_20x20.xpm"
#include "images/icon_link_20x20.xpm"
#include "images/icon_cancel_20x20.xpm"
#include "images/icon_archive_add_20x20.xpm"
#include "images/icon_archive_extract_20x20.xpm"
#include "images/icon_recover_20x20.xpm"
#include "images/icon_purge_20x20.xpm"
#include "images/icon_trace_20x20.xpm"
#include "images/icon_search_20x20.xpm"
#include "images/icon_clear_20x20.xpm"
#include "images/icon_revert_20x20.xpm"
#include "images/icon_devices_list_20x20.xpm"

#include "images/icon_memory_32x32.xpm"


typedef struct {

	GtkWidget	*format_entry,
					*result_entry,
					*tokens_clist,
					*tokens_insert_btn;
	gint		freeze_count;

} EDVOptionsDateFormat;
#define EDV_DATE_FORMAT_DATA(p)		((EDVOptionsDateFormat *)(p))
#define EDV_DATE_FORMAT_DATA_KEY	"EDV/Options/Date/Format"


/* Callbacks */
static void EDVOptionsConfirmationCheckChangedCB(
	CfgWinLink *cfg_link, gpointer data
);
static gint EDVOptionsDateTokensListEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
static void EDVOptionsDateTokensListDragDataGetCB(
	GtkWidget *widget, GdkDragContext *dc,           
	GtkSelectionData *selection_data, guint info, guint t,
	gpointer data                                         
);
static void EDVOptionsDateTokensListSelectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data                                           
);
static void EDVOptionsDateTokensListUnselectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data                                           
);
static void EDVOptionsDateInsertTokenCB(GtkWidget *widget, gpointer data);
static void EDVOptionsDateFormatDestroyCB(CfgWinLink *cfg_link, gpointer data);
static void EDVOptionsDateFormatChangedCB(CfgWinLink *cfg_link, gpointer data);

static void EDVOptionsRunCB(GtkWidget *widget, gpointer data);

static void EDVOptionsBrowseCB(gpointer button, gpointer data);
static void EDVOptionsBrowseProgramCB(gpointer button, gpointer data);

static void EDVOptionsViewHistoryCB(GtkWidget *widget, gpointer data);

#if 0
static void EDVOptionsToggledSensitiveCB(GtkWidget *widget, gpointer data);
static void EDVOptionsToggledInsensitiveCB(GtkWidget *widget, gpointer data);
#endif

static void EDVOptionsSoundOutputChangedCB(CfgWinLink *cfg_link, gpointer data);

static void EDVOptionsWinResetNoMoreMessagesCB(GtkWidget *widget, gpointer data);

/* Create Pages */
static void EDVCreateOptionsGeneralPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent,
	GtkRcStyle *caution_rcstyle
);
static void EDVCreateOptionsDisplayPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
);
static void EDVCreateOptionsKeyboardPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
);
static void EDVCreateOptionsPointerPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
);
static void EDVCreateOptionsProgramsPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
);
static void EDVCreateOptionsConfirmationPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent,
	GtkRcStyle *caution_rcstyle
);
static void EDVCreateOptionsDatePage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
);
static void EDVCreateOptionsMountPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
);
static void EDVCreateOptionsSoundsPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
);
static void EDVCreateOptionsHistoryPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
);
static void EDVCreateOptionsMiscPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
);

/* Select Tab */
gboolean EDVOptionsWindowSelectTab(
	GtkWidget *cfgwin,
	const gchar *tab_name
);

/* Options Window */
GtkWidget *EDVOptionsWindowNew(
	EDVCore *core,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry
);


#if defined(PROG_LANGUAGE_FRENCH)

#define DATE_TIME_SUBS_LIST	{ \
"%a",	"nom abrg du jour de la semaine", \
"%A",	"nom du jour de la semaine", \
"%b",	"nom du mois en abrg", \
"%B",	"nom du mois", \
"%c",	"Reprsentation prdfnie", \
"%C",	"Sicle (anne / 100) dcimal 2 chiffres", \
"%d",	"numro du jour du mois (entre 01 et 31)", \
"%D",	"Equivalent  %m/%d/%y", \
"%e",	"numro du jour du mois (entre 1 et 31 sans zro devant)", \
"%E",	"Modificateur : permet d'utiliser une autre forme pour le format (ci-dessous)", \
"%G",	"ISO 8601 numro dcimal pour l'anne avec le sicle", \
"%g",	"ISO 8601 anne (nombre de 2 chiffres entre 00 et 99)", \
"%h",	"Equivalent  %b", \
"%H",	"Heure en nombre dcimal pour la reprsentation 24-heure (entre 00 et 23)", \
"%I",	"Heure en nombre dcimal pour la reprsentation 12-heure (entre 01 et 12)", \
"%j",	"Jour de l'anne en nombre dcimal (entre 001 et 366)", \
"%k",	"Equivalent  %H mais sans le zro non significatif remplacer par un espace", \
"%l",	"Equivalent  %I mais sans le zro non significatif remplacer par un espace", \
"%m",	"Mois en nombre dcimal (entre 01 et 12)", \
"%M",	"Minute en nombre dcimal (entre 00 et 59)", \
"%O",	"Modificateur : permet d'utiliser une autre forme pour le format (ci-dessous)", \
"%p",	"soit \"AM\" (matin) ou \"PM\" (aprs-midi) suivant l'heure", \
"%P",	"Equivalent  %p mais en minuscule", \
"%r",	"Heure en notation a.m. ou p.m.", \
"%R",	"Heure en notation 24-heure (quivalent  %H:%M)", \
"%s",	"nombre de secondes coules depuis le 1970-01-01 00:00:00 UTC (dit Epoch day)", \
"%S",	"Second en nombre dcimal (entre 00 et 59)", \
"%T",	"Heure en notation 24-heure (equivalent  %H:%M:%S)", \
"%u",	"Jour de la semaine en nombre dcimal (entre 1 et 7 avec lundi = 1)", \
"%U",	"Numero de la semaine en nombre dcimal (entre 00 et 53)\
 dmarrant par le premier dimanche comme 1 jour de la premire semaine (01)", \
"%V",	"ISO 8601:1988 numro de semaine en nombre dcimal (entre 01 et 53)", \
"%w",	"Jour de la semaine en nombre dcimal (entre 0 et 6 avec dimanche = 0 )", \
"%W",	"Numro de la Semaine en nombre dcimal (entre 01 et 53)\
 dmarrant par le premier Lundi comme 1 jour de la premire semaine (01)", \
"%x",	"Date prdfinie de la date locale sans l'heure", \
"%X",	"Heure prdfinie de la date locale sans le jour", \
"%y",	"Anne en nombre dcimal sans le sicle (entre 00 et 99)", \
"%Y",	"Anne en nombre dcimal comprenant le sicle", \
"%z",	"Fuseau Horaire reprsent en dcalage par rapport au temps GMT", \
"%Z",	"Fuseau Horaire reprsent par son nom ou abrviation", \
"%+",	"Date et heure  au format de la commande date(1)", \
"%%",	"Caractre % ", \
NULL, NULL \
}

#else
#define DATE_TIME_SUBS_LIST	{ \
"%a",	"Abbreviated weekday name", \
"%A",	"Full weekday name", \
"%b",	"Abbreviated month name", \
"%B",	"Full month name", \
"%c",	"Preferred date & time representation", \
"%C",	"Century number (year / 100) as a 2-digit integer", \
"%d",	"Day of the month as a decimal number (from 01 to 31)", \
"%D",	"Equivalent to %m/%d/%y", \
"%e",	"Day of the month as a decimal number (no leading zero)", \
"%E",	"Modifier: use alternative format, see below", \
"%G",	"ISO 8601 year with century as a decimal number", \
"%g",	"ISO 8601 year with century as a 2-digit year (from 00 to 99)", \
"%h",	"Equivalent to %b", \
"%H",	"Hour as a decimal number using 24-hour time (from 00 to 23)", \
"%I",	"Hour as a decimal number using 12-hour time (from 01 to 12)", \
"%j",	"Day of the year as a decimal number (range 001 to 366)", \
"%k",	"Equivalent to %H but with single digits preceded by a space", \
"%l",	"Equivalent to %I but with single digits preceded by a space", \
"%m",	"Month as a decimal number (from 01 to 12)", \
"%M",	"Minute as a decimal number (from 00 to 59)", \
"%O",	"Modifier: use alternative format, see below", \
"%p",	"Either \"AM\" or \"PM\" according to the time value", \
"%P",	"Equivalent to %p but in lowercase", \
"%r",	"Time in a.m. or p.m. notation", \
"%R",	"Time in 24-hour notation (equivalent to %H:%M)", \
"%s",	"Number of seconds since the Epoch (1970-01-01 00:00:00 UTC)", \
"%S",	"Second as a decimal number (from 00 to 61)", \
"%T",	"Time in 24-hour notation (equivalent to %H:%M:%S)", \
"%u",	"Day of the week as a decimal number (from 1 to 7 with monday\
 being 1)", \
"%U",	"Week number of the current year as a decimal number (from 00\
 to 53) starting with the first Sunday as the first day of week 01", \
"%V",	"ISO 8601:1988 week number of the current year as a\
 decimal number (from 01 to 53)", \
"%w",	"Day of the week as a decimal number (from 0 to 6 with sunday\
 being 0)", \
"%W",	"Week number of the current year as a decimal number (from 00\
 to 53) starting with the first Monday as the first day of week 01", \
"%x",	"Preferred date representation for the current locale without\
 the time", \
"%X",	"Preferred time representation for the current locale without\
 the date", \
"%y",	"Year as a decimal number without a century (from 00 to 99)", \
"%Y",	"Year as a decimal number including the century", \
"%z",	"Time zone as hour offset from GMT", \
"%Z",	"Time zone, name, or abbreviation", \
"%+",	"Date & time in date(1) format", \
"%%",	"Literal % character", \
NULL, NULL \
}
#endif


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? (gint)strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Confirmation GtkCheckButton "changed" signal callback.
 */
static void EDVOptionsConfirmationCheckChangedCB(
	CfgWinLink *cfg_link, gpointer data
)
{
	GtkToggleButton *tb = (GtkToggleButton *)CfgWinLinkGetWidget(cfg_link);
	GtkWidget *w = (GtkWidget *)data;
	if((tb == NULL) || (w == NULL))
		return;

	gtk_widget_set_sensitive(w, tb->active);
}

/*
 *	Date Tokens GtkCList event signal callback.
 */
static gint EDVOptionsDateTokensListEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	gint status = FALSE;
	GtkCList *clist = (GtkCList *)widget;
	EDVOptionsDateFormat *d = EDV_DATE_FORMAT_DATA(data);
	if((clist == NULL) || (event == NULL) || (d == NULL))
		return(status);

	if(d->freeze_count > 0)
		return(status);

	switch((gint)event->type)
	{
	  case GDK_MAP:
		if(clist->columns >= 2)
		{
			gint i, row;
			gchar *strv[2];
			const gchar *line[] = DATE_TIME_SUBS_LIST;
			gtk_clist_freeze(clist);
			for(i = 0; line[i] != NULL; i += 2)
			{
				strv[0] = (gchar *)line[i];
				strv[1] = (gchar *)line[i + 1];
				row = gtk_clist_append(clist, strv);
				if(row < 0)
					break;

				gtk_clist_set_row_data_full(
					clist, row,
					STRDUP(strv[0]), (GtkDestroyNotify)g_free
				);
			}
			gtk_clist_columns_autosize(clist);
			gtk_clist_thaw(clist);
		}
		status = TRUE;
		break;

	  case GDK_UNMAP:
		gtk_clist_freeze(clist);
		gtk_clist_clear(clist);
		gtk_clist_columns_autosize(clist);
		gtk_clist_thaw(clist);
		status = TRUE;
		break;
	}

	return(status);
}

/*
 *	Date Tokens GtkCList "drag_data_get" signal callback.
 */
static void EDVOptionsDateTokensListDragDataGetCB(
	GtkWidget *widget, GdkDragContext *dc,           
	GtkSelectionData *selection_data, guint info, guint t,
	gpointer data                                         
)
{
	gint row;
	gchar *s;
	GList *glist;
	GtkCList *clist;
	EDVOptionsDateFormat *d = EDV_DATE_FORMAT_DATA(data);
	if((widget == NULL) || (dc == NULL) || (d == NULL))
		return;

	if(d->freeze_count > 0)
		return;

	clist = GTK_CLIST(d->tokens_clist);
	glist = clist->selection_end;
	row = (glist != NULL) ? (gint)glist->data : -1;

	s = STRDUP((const gchar *)gtk_clist_get_row_data(clist, row));
	if(s == NULL)
		s = STRDUP(" ");

	gtk_selection_data_set(
		selection_data,
		GDK_SELECTION_TYPE_STRING,
		8,				/* Bits Per Character */
		s,				/* Data */
		STRLEN(s)			/* Length */
	);

	g_free(s);
}

/*
 *	Date Format Tokens GtkCList "select_row" signal callback.
 */
static void EDVOptionsDateTokensListSelectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data                                           
)
{
	EDVOptionsDateFormat *d = EDV_DATE_FORMAT_DATA(data);
	if((clist == NULL) || (event == NULL) || (d == NULL))
		return;

	if(d->freeze_count > 0)
		return;

	/* Scroll to the selected row if it is not visible */
	if(gtk_clist_row_is_visible(clist, row) !=
	   GTK_VISIBILITY_FULL
	)
		gtk_clist_moveto(
			clist,
			row, -1,			/* Row, column */
			0.5f, 0.0f			/* Row, column */
		);

	/* Set the DND drag icon */
	GUIDNDSetDragIconFromCListSelection(clist);

	/* Double click inserts the selected token to the format
	 * entry
	 */
	if(event->type == GDK_2BUTTON_PRESS)
	{
		/* Get the selected token */
		const gchar *token = (gchar *)gtk_clist_get_row_data(clist, row);
		if(token != NULL)
		{
			/* Insert the selected token into the format entry */
			GtkEditable *editable = GTK_EDITABLE(d->format_entry);
			gint position = gtk_editable_get_position(editable);
			gtk_editable_insert_text(
				editable,
				token,
				STRLEN(token),
				&position
			);
		}
	}

	gtk_widget_set_sensitive(d->tokens_insert_btn, TRUE);
}

/*
 *	Date Format Tokens GtkCList "unselect_row" signal callback.
 */
static void EDVOptionsDateTokensListUnselectRowCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data                                           
)
{
	EDVOptionsDateFormat *d = EDV_DATE_FORMAT_DATA(data);
	if((clist == NULL) || (event == NULL) || (d == NULL))
		return;

	if(d->freeze_count > 0)
		return;

	gtk_widget_set_sensitive(d->tokens_insert_btn, FALSE);
}

/*
 *	Date Insert Token callback.
 */
static void EDVOptionsDateInsertTokenCB(GtkWidget *widget, gpointer data)
{
	gint row;
	const gchar *token;
	GList *glist;
	GtkCList *clist;
	EDVOptionsDateFormat *d = EDV_DATE_FORMAT_DATA(data);
	if(d == NULL)
		return;

	if(d->freeze_count > 0)
		return;

	clist = GTK_CLIST(d->tokens_clist);
	glist = clist->selection_end;
	row = (glist != NULL) ? (gint)glist->data : -1;
	token = (gchar *)gtk_clist_get_row_data(clist, row);
	if(token != NULL)
	{
		/* Insert the selected token into the format entry */
		GtkEditable *editable = GTK_EDITABLE(d->format_entry);
		gint position = gtk_editable_get_position(editable);
		gtk_editable_insert_text(
			editable,
			token,
			STRLEN(token),
			&position
		);
	}
}

/*
 *	Date Format Sample Data "destroy" signal callback.
 */
static void EDVOptionsDateFormatDestroyCB(CfgWinLink *cfg_link, gpointer data)
{
	EDVOptionsDateFormat *d = EDV_DATE_FORMAT_DATA(data);
	if(d == NULL)
		return;

	g_free(d);
}

/*
 *	Date Format Sample update callback.
 */
static void EDVOptionsDateFormatChangedCB(CfgWinLink *cfg_link, gpointer data)
{
	gchar *s;
	EDVOptionsDateFormat *d = EDV_DATE_FORMAT_DATA(data);
	if(d == NULL)
		return;

	if(d->freeze_count > 0)
		return;

	d->freeze_count++;

	s = edv_date_string_format(
		edv_time(),
		gtk_entry_get_text(GTK_ENTRY(d->format_entry)),
		EDV_DATE_RELATIVITY_ABSOLUTE
	);
	gtk_entry_set_text(
		GTK_ENTRY(d->result_entry),
		(s != NULL) ? s : ""
	);
	g_free(s);

	d->freeze_count--;
}


/*
 *	Run callback.
 *
 *      The specified data must be a CfgWinLink *.
 */
static void EDVOptionsRunCB(GtkWidget *widget, gpointer data)
{
	gint pid;
	const gchar *cmd, *shell_cmd, *shell_args;
	gchar *shell_prog;
	GtkWidget *w, *toplevel;
	GtkEntry *entry;
	CfgItem *cfg_list;
	GtkWidget *cfgwin;
	EDVCore *core;
	CfgWinLink *cfg_link = CFG_WIN_LINK(data);
	if(cfg_link == NULL)
		return;

	w = (GtkWidget *)CfgWinLinkGetWidget(cfg_link);
	cfgwin = CfgWinLinkGetCfgWin(cfg_link);
	if((w == NULL) || (cfgwin == NULL))
		return;

	toplevel = gtk_widget_get_toplevel(w);
	core = EDV_CORE(gtk_object_get_data(
		GTK_OBJECT(cfgwin),
		EDV_CORE_KEY
	));
	cfg_list = core->cfg_list;

	/* The referenced widget must be a GtkEntry */
	if(!GTK_IS_ENTRY(w))
		return;

	entry = GTK_ENTRY(w);

	/* Get the current command */
	cmd = gtk_entry_get_text(entry);
	if(STRISEMPTY(cmd))
		return;

	/* Get the shell program and shell arguments */
	shell_cmd = EDV_GET_S(EDV_CFG_PARM_PROG_SHELL);
	shell_args = edv_strarg(
		shell_cmd,
		&shell_prog,
		TRUE,				/* Parse escapes */
		TRUE				/* Parse quotes */
	);

	/* Execute the command */
	pid = edv_system_shell(
		cmd,
		shell_prog,
		shell_args
	);
	if(pid < 0)
	{
		const gint error_code = (gint)errno;
		gchar *msg = g_strdup_printf(
"Unable to execute the command:\n\
\n\
    %s\n\
\n\
%s.",
			cmd,
			g_strerror(error_code)
		);
		edv_play_sound_error(core);
		edv_message_error(
			"Run Failed",
			msg,  
"Please check to make sure that the path to the program\n\
is correct and that the program is set executable.",
			toplevel
		);
		g_free(msg);
	}

	g_free(shell_prog);
}


/*
 *	General browse callback.
 *
 *	The specified data must be a GtkEntry and the path to browse
 *	will be obtained from and set to its value.
 */
static void EDVOptionsBrowseCB(gpointer button, gpointer data)
{
	gboolean response;
	gint		npaths = 0,
					nftypes = 0;
	gchar		*cur_path = NULL,
					**paths_list = NULL;
	const gchar *cur_cmd;
	GtkWidget *toplevel;
	fb_type_struct	**ftypes_list = NULL,
					*ftype_rtn = NULL;
	GtkEntry *entry = (GtkEntry *)data;
	if((entry == NULL) || FileBrowserIsQuery())
		return;

	toplevel = gtk_widget_get_toplevel(GTK_WIDGET(entry));

	/* Get the current command */
	cur_cmd = gtk_entry_get_text(entry);
	if(cur_cmd != NULL)
	{
		/* Does it start with an absolute path? */
		if(*cur_cmd == G_DIR_SEPARATOR)
		{
			/* Get the first argument, which should specify the
			 * program
			 */
			gchar *s;
			(void)edv_strarg(
				cur_cmd,
				&s,
				FALSE,                      /* Do not parse escapes */
				TRUE                        /* Parse quotes */
			);
			if(s != NULL)
			{
				/* Get the parent directory of the first argument */
				cur_path = g_dirname(s);
				g_free(s);
			}
		}
	}

	/* Create the file types list */
	FileBrowserTypeListNew(
		&ftypes_list, &nftypes,
		"*.*", "All Files"
	);

	/* Query the user for a path */
	FileBrowserSetTransientFor(toplevel);
	response = FileBrowserGetResponse(
#if defined(PROG_LANGUAGE_SPANISH)
"El Objeto Selecto",
"Selecto",
"Cancele",
#elif defined(PROG_LANGUAGE_FRENCH)
"Objet Privilgi",
"Privilgi",
"Annuler",
#elif defined(PROG_LANGUAGE_GERMAN)
"Erlesenes Objekt",
"Erlesen",
"Heben",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Scegliere L'Oggetto",
"Scegliere",
"Annullare",
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitgezocht Voorwerp",
"Uitgezocht",
"Annuleer",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Selecione Objeto",
"Selecione",
"Cancelamento",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utvalgt Objekt",
"Utvalgt",
"Kanseller",
#else
"Select Object",
"Select",
"Cancel",
#endif
		cur_path,
		ftypes_list, nftypes,
		&paths_list, &npaths,
		&ftype_rtn
	);
	g_free(cur_path);
	FileBrowserSetTransientFor(NULL);

	/* Got user response? */
	if(response && (npaths > 0))
	{
		gchar *path = STRDUP(paths_list[npaths - 1]);
		if(path != NULL)
		{
			gtk_entry_set_text(entry, path);
			g_free(path);
		}
	}

	/* Delete the file types list */
	FileBrowserDeleteTypeList(ftypes_list, nftypes);
}

/*
 *	Browse Program callback.
 *
 *	The specified data must be a GtkEntry and the path to browse
 *	will be obtained from and set to its value.
 */
static void EDVOptionsBrowseProgramCB(gpointer button, gpointer data)
{
	gboolean response;
	gint		npaths = 0,
					nftypes = 0;
	gchar		*cur_path = NULL,
					**paths_list = NULL;
	const gchar *cur_cmd;
	GtkWidget *toplevel;
	fb_type_struct	**ftypes_list = NULL,
					*ftype_rtn = NULL;
	GtkEntry *entry = (GtkEntry *)data;
	if((entry == NULL) || FileBrowserIsQuery())
		return;

	toplevel = gtk_widget_get_toplevel(GTK_WIDGET(entry));

	/* Get the current command */
	cur_cmd = gtk_entry_get_text(entry);
	if(cur_cmd != NULL)
	{
		/* Does it start with an absolute path? */
		if(*cur_cmd == G_DIR_SEPARATOR)
		{
			/* Get the first argument, which should specify the
			 * program
			 */
			gchar *s;
			(void)edv_strarg(
				cur_cmd,
				&s,
				FALSE,                      /* Do not parse escapes */
				TRUE                        /* Parse quotes */
			);
			if(s != NULL)
			{
				/* Get the parent directory of the first argument */
				cur_path = g_dirname(s);
				g_free(s);
			}
		}
	}

	/* Create the file types list */
	FileBrowserTypeListNew(
		&ftypes_list, &nftypes,
		"*.*", "All programs"
	);

	/* Query the user for a program */
	FileBrowserSetTransientFor(toplevel);
	response = FileBrowserGetResponse(
#if defined(PROG_LANGUAGE_SPANISH)
"El Programa Selecto",
"Selecto",
"Cancele",
#elif defined(PROG_LANGUAGE_FRENCH)
"Programme Privilgi",
"Privilgi",
"Annuler",
#elif defined(PROG_LANGUAGE_GERMAN)
"Erlesenes Programm",
"Erlesen",
"Heben",
#elif defined(PROG_LANGUAGE_ITALIAN)
"Scegliere Il Programma",
"Scegliere",
"Annullare",
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitgezocht Programma",
"Uitgezocht",
"Annuleer",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Selecione Programa",
"Selecione",
"Cancelamento",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utvalgt Program",
"Utvalgt",
"Kanseller",
#else
"Select Program",
"Select",
"Cancel",
#endif
		cur_path,
		ftypes_list, nftypes,
		&paths_list, &npaths,
		&ftype_rtn
	);
	g_free(cur_path);
	FileBrowserSetTransientFor(NULL);

	/* Got user response? */
	if(response && (npaths > 0))
	{
		gchar *path = STRDUP(paths_list[npaths - 1]);
		if(path != NULL)
		{
			gtk_entry_set_text(entry, path);
			g_free(path);
		}
	}

	/* Delete the file types list */
	FileBrowserDeleteTypeList(ftypes_list, nftypes);
}


/*
 *	View history callback.
 */
static void EDVOptionsViewHistoryCB(GtkWidget *widget, gpointer data)
{
	GtkWidget *toplevel = gtk_widget_get_toplevel(widget);
	EDVCore *core = EDV_CORE(data);
	if(data == NULL)
		return;

	edv_map_history(
		core,
		-1,
		core->geometry_flags,
		(core->geometry_flags != 0) ? &core->geometry : NULL,
		toplevel
	);
}


#if 0
/*
 *	GtkToggleButton "toggled" signal callback.
 *
 *	Sets the GtkWidget specified by data to be sensitive if
 *	toggled.
 */
static void EDVOptionsToggledSensitiveCB(GtkWidget *widget, gpointer data)
{
	GtkWidget *ref_w = (GtkWidget *)data;
	if((widget == NULL) || (ref_w == NULL))
		return;

	gtk_widget_set_sensitive(
		ref_w,
		GTK_TOGGLE_BUTTON_GET_ACTIVE(widget)
	);
}

/*
 *	GtkToggleButton "toggled" signal callback.
 *
 *	Sets the GtkWidget specified by data to be insensitive if
 *      toggled.
 */
static void EDVOptionsToggledInsensitiveCB(GtkWidget *widget, gpointer data)
{
	GtkWidget *ref_w = (GtkWidget *)data;
	if((widget == NULL) || (ref_w == NULL))
		return;

	gtk_widget_set_sensitive(
		ref_w,
		!GTK_TOGGLE_BUTTON_GET_ACTIVE(widget)
	);
}
#endif


/*
 *	Sound output "changed" signal callback.
 */
static void EDVOptionsSoundOutputChangedCB(
	CfgWinLink *cfg_link, gpointer data
)
{
	gboolean sensitive;
	EDVSoundOutput sound_output;
	GtkWidget *w = (GtkWidget *)data;
	if((cfg_link == NULL) || (w == NULL))
		return;

	sound_output = (EDVSoundOutput)PUListBoxGetSelected(
		(GtkWidget *)CfgWinLinkGetWidget(cfg_link)
	);
	if(sound_output == EDV_SOUND_OUTPUT_COMMAND)
		sensitive = TRUE;
	else
		sensitive = FALSE;

	gtk_widget_set_sensitive(w, sensitive);
}


/*
 *	Reset "No More Messages" callback.
 */
static void EDVOptionsWinResetNoMoreMessagesCB(GtkWidget *widget, gpointer data)
{
	EDVCore *core = EDV_CORE(data);
	if(core == NULL)
		return;

	ConMsgReset(
		PROG_NAME_FULL,
		NULL,
		0,
		0,
		TRUE,				/* Show stdout messages */
		TRUE				/* Show stderr messages */
	);
}


/*
 *      Creates the General Page on options window.
 */
static void EDVCreateOptionsGeneralPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent,
	GtkRcStyle *caution_rcstyle
)
{
	const gint	border_major = 5,
					border_minor = 2;
	const gchar *c_decl;
	edv_pixmap_data *icon_data;
	gpointer	entry_rtn,
					browse_rtn;
	GSList *gslist;
	GtkAdjustment *adj;
	GtkWidget	*w,
					*parent2, *parent3, *parent4, *parent5;
	CfgWinLink *cfg_link;

	/* Create a GtkScrolledWindow to allow scrolling through
	 * the many widgets on this page
	 */
	parent2 = edv_new_scrolled_window(
		GTK_POLICY_AUTOMATIC,
		GTK_POLICY_AUTOMATIC,
		NULL, &w
	);
	gtk_box_pack_start(GTK_BOX(parent), parent2, TRUE, TRUE, 0);
	gtk_widget_show(parent2);

	gtk_box_set_spacing(GTK_BOX(w), border_major);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	parent2 = w;


	/* Startup With GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Arranque Con"
#elif defined(PROG_LANGUAGE_FRENCH)
"Mettre En Route Avec"
#elif defined(PROG_LANGUAGE_GERMAN)
"Start Mit"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Avvio Con"
#elif defined(PROG_LANGUAGE_DUTCH)
"Start Met"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Startup Com"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Oppstarting With"
#else
"Startup With"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;


	w = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	/* File Browser GtkToggleButton */
	w = GUIToggleButtonPixmapLabelV(
		(guint8 **)icon_endeavour_file_browser_48x48_xpm,
		"File\nBrowser",
		NULL
	);
	gtk_widget_set_usize(w, 80, 80);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_TOGGLE_BUTTON,
		w,
		EDV_CFG_PARM_STARTUP_BROWSER
	);

	/* Image Browser GtkToggleButton */
	w = (GtkWidget *)GUIToggleButtonPixmapLabelV(
		(guint8 **)icon_endeavour_image_browser_48x48_xpm,
		"Image\nBrowser",
		NULL
	);
	gtk_widget_set_usize(w, 80, 80);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_TOGGLE_BUTTON,
		w,
		EDV_CFG_PARM_STARTUP_IMBR
	);

	/* Archiver GtkToggleButton */
	w = (GtkWidget *)GUIToggleButtonPixmapLabelV(
		(guint8 **)icon_endeavour_archiver_48x48_xpm,
		"Archiver",
		NULL
	);
	gtk_widget_set_usize(w, 80, 80);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_TOGGLE_BUTTON,
		w,
		EDV_CFG_PARM_STARTUP_ARCHIVER
	);

	/* Recycle Bin GtkToggleButton */
	w = (GtkWidget *)GUIToggleButtonPixmapLabelV(
		edv_get_recycle_bin_icon_data(
			EDV_ICON_SIZE_48,
			0,
			NULL
		),
		"Recycle\nBin",
		NULL
	);
	gtk_widget_set_usize(w, 80, 80);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_TOGGLE_BUTTON,
		w,
		EDV_CFG_PARM_STARTUP_RECBIN
	);



	/* Maximum GtkFrame */
	w = gtk_frame_new("Maximum");
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* GtkHBox for the GtkSpinButtons */
	w = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	/* File Browsers GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent5 = w;

	/* File Browsers GtkLabel */
	w = gtk_label_new("File Browsers:");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* File Browsers GtkSpinButton */
	adj = (GtkAdjustment *)gtk_adjustment_new(
		0.0f, -1.0f, (gfloat)((guint32)-1),
		1.0f, 10.0f, 10.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 70, -1);
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
"Set the maximum number of File Browsers allowed at one time\
 (enter -1 for no maximum"
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_SPIN_BUTTON,
		w,
		EDV_CFG_PARM_MAX_BROWSERS
	);

	/* Image Browsers GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent5 = w;

	/* Image Browsers GtkLabel */
	w = gtk_label_new("Image Browsers:");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Image Browsers GtkSpinButton */
	adj = (GtkAdjustment *)gtk_adjustment_new(
		0.0f, -1.0f, (gfloat)((guint32)-1),
		1.0f, 10.0f, 10.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 70, -1);
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
"Set the maximum number of Image Browsers allowed at one time\
 (enter -1 for no maximum"
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_SPIN_BUTTON,
		w,
		EDV_CFG_PARM_MAX_IMBRS
	);

	/* Archivers GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent5 = w;

	/* Archivers GtkLabel */
	w = gtk_label_new("Archivers:");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Archivers GtkSpinButton */
	adj = (GtkAdjustment *)gtk_adjustment_new(
		0.0f, -1.0f, (gfloat)((guint32)-1),
		1.0f, 10.0f, 10.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 70, -1);
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
"Set the maximum number of Archivers allowed at one time\
 (enter -1 for no maximum"
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_SPIN_BUTTON,
		w,
		EDV_CFG_PARM_MAX_ARCHIVERS
	);


	/* Startup Location GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Ubicacin De Startup"
#elif defined(PROG_LANGUAGE_FRENCH)
"Emplacement De Dmarrage"
#elif defined(PROG_LANGUAGE_GERMAN)
"Start Ort"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Posizione Di Avvio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Start Plaats"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Localidade De Startup"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Oppstarting Location"
#else
"Startup Location"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Startup Directory */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	w = GUIPromptBarWithBrowse(
		(guint8 **)icon_folder_opened_20x20_xpm,
		NULL,
		NULL, &entry_rtn, &browse_rtn,
		NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la ubicacin de arranque"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer l'emplacement de dmarrage"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie den start ort ein"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare la posizione di avvio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga de start plaats binnen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre a localidade de startup"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i opp startings plasseringen"
#else
"Enter the startup location"
#endif
	);
	edv_entry_set_dnd(core, w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_EDITABLE,
		w,
		EDV_CFG_PARM_DIR_START_UP
	);
	w = (GtkWidget *)browse_rtn;
#if defined(PROG_LANGUAGE_FRENCH)
	GUISetWidgetTip(w, "Parcourir");
#else
	GUISetWidgetTip(w, "Browse");
#endif
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsBrowseCB), entry_rtn
	);

	/* Record Startup Directory */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Automticamente Registro Dura La Ubicacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Automatiquement Le Disque Dure L'Emplacement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Zeichnen Sie Automatisch Letzten Ort Auf"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Automaticamente Il Disco Dura La Posizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Automatisch Verslag Leest Plaats"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Automaticamente Registro ltima Localidade"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Automatisk Record Last Location"
#else
"Automatically Record Last Location"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto actualizar automticamente el arranca la ubicacin\
 para la prxima sesin basada en la ubicacin que era ltima accesado.\
 Cundo esto se verifica, usted no necesita modificar el arranca el\
 valor de la ubicacin abajo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci automatiquement pour mettre  jour le met\
 en route l'emplacement pour la sance prochaine base sur\
 l'emplacement qui tait dernier accessed. Quand ceci est vrifi,\
 vous n'avez pas besoin de modifier le met en route la valeur\
 d'emplacement au dessous"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen Sie dies automatisch, das zu aktualisieren, ort startet fr\
 die nchste sitzung, die auf dem ort basiert worden ist, der letzt\
 war, auf whrend dieser Sitzung hat zugegriffen. Sie mssen das ort\
 unten nicht modifizieren startet, wenn dies geprft ist."
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controlla questo automaticamente di aggiornare l'avvia posizione per\
 il prossimo sessione basato sulla posizione che era ultimo accesso\
 a durante questa sessione. Lei non ha bisogno di modificare l'avvia\
 la posizione al di sotto se questo  controllato."
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit automatisch om het te actualiseren opstart plaats voor\
 de volgende zitting, die op de plaats die gebaseerd is, was voriges\
 had toegang tot gedurende deze zitting. U moet het plaats onder niet\
 wijzigen opstart indien dit gecontroleerd is."
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto automaticamente atualizar o comea para localidade de\
 cima para a prxima sesso baseado na localidade que era ltimo\
 acedido durante esta sesso. Voc nao necessita modificar o comea\
 para localidade de cima embaixo se isto est verificado."
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette automatisk oppdatere starten opp plassering for den neste\
 sesjonen basert p plasseringen var som siste kommet til i lpet av\
 denne sesjonen. De modifiserer ikke starten opp plassering under om\
 dette sjekker."
#else
"Check this to automatically update the startup location for\
 the next session based on the location that was last accessed\
 during this session.\
 You do not need to modify the startup location if this is checked."
#endif
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_TOGGLE_BUTTON,
		w,
		EDV_CFG_PARM_RECORD_START_UP_DIR
	);


	/* Master Write Protect GtkFrame */
	w = gtk_frame_new("Master Write Protect");
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* GtkHBox for the label */
	w = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	/* GtkLabel */
	w = gtk_label_new(
"The master write protect allows you to block all operations by this program that would alter\n\
(such as move, copy, delete, etc) an object or data on a disk"
	);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* GtkHBox for the radio buttons */
	w = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	gslist = NULL;

	/* On GtkRadioButton */
	w = gtk_radio_button_new(gslist);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));
	GUISetWidgetTip(
		w,
"Check this to turn the master write protect on"
	);
	gtk_widget_show(w);
	parent5 = w;
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_RADIO_BUTTON,
		w,
		EDV_CFG_PARM_WRITE_PROTECT
	);
	CfgWinLinkSetData(
		cfg_link,
		(gpointer)TRUE
	);
	/* GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent5), w);
	gtk_widget_show(w);
	parent5 = w;
	/* Icon */
	w = edv_new_pixmap_widget(
		core,
		(edv_pixmap_data *)icon_write_protect_on_20x20_xpm,
		"icon_write_protect_on_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* GtkLabel */
	w = gtk_label_new("On");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Off GtkRadioButton */
	w = gtk_radio_button_new(gslist);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
/*	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w)); */
	GUISetWidgetTip(
		w,
"Check this to turn the master write protect off"
	);
	gtk_widget_show(w);
	parent5 = w;
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_RADIO_BUTTON,
		w,
		EDV_CFG_PARM_WRITE_PROTECT
	);
	CfgWinLinkSetData(
		cfg_link,
		(gpointer)FALSE
	);
	/* GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent5), w);
	gtk_widget_show(w);
	parent5 = w;
	/* Icon */
	w = edv_new_pixmap_widget(
		core,
		(edv_pixmap_data *)icon_write_protect_off_20x20_xpm,
		"icon_write_protect_off_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* GtkLabel */
	w = gtk_label_new("Off");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);


	/* Delete Objects By GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Borre Objetos Por"
#elif defined(PROG_LANGUAGE_FRENCH)
"Effacer Des Pbjets Pa"
#elif defined(PROG_LANGUAGE_GERMAN)
"Lschen Sie Objekte Durch"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Cancellare Gli Oggetti Da"
#elif defined(PROG_LANGUAGE_DUTCH)
"Schrap Voorwerpen Door"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Anule Objetos Por"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Stryk Objects By"
#else
"Delete Objects By"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* GtkHBox for the radio buttons */
	w = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	gslist = NULL;

	/* Moving Them To The Recycle Bin GtkRadioButton */
	w = gtk_radio_button_new(gslist);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto para mover los objetos al Cajn de Reciclaje cuando\
 los borre"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci pour se transfrer les objets au Recycle l'Huche en\
 effaant les"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen die dies, die objekte zum zu bewegen, Berwertet Nehlter\
 beim lschen sie wieder"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo per muovere gli oggetti al Contenitore per la\
 raccolta differenziata quando cancellare loro"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit om de voorwerpen aan het te bewegen Bak Recyclt\
 wanneer schrappen hen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto mover os objetos  Caixa de Recycle quando anular os"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette flytte objektene til Recycle Bin ved stryke av dem"
#else
"Check this to move the objects to the Recycle Bin when deleting\
 them (default)"
#endif
	);
	gtk_widget_show(w);
	parent5 = w;
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_RADIO_BUTTON,
		w,
		EDV_CFG_PARM_DELETE_METHOD
	);
	CfgWinLinkSetData(
		cfg_link,
		(gpointer)EDV_DELETE_METHOD_RECYCLE
	);
	/* GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent5), w);
	gtk_widget_show(w);
	parent5 = w;
	/* Icon */
	icon_data = edv_get_recycle_bin_icon_data(
		EDV_ICON_SIZE_20,
		1,
		&c_decl
	);
	w = edv_new_pixmap_widget(
		core,
		icon_data,
		c_decl
	);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* GtkLabel */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Mover Al Cajn De Reciclaje"
#elif defined(PROG_LANGUAGE_FRENCH)
"Se Transfrer Les Au Recycler l'Huche"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bewegen, Das Sie Zum Behlter Wiederverwerten"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Trasloco Loro Al Contenitore Per La Raccolta Differenziata"
#elif defined(PROG_LANGUAGE_DUTCH)
"Bewegen, Dat Hen Aan het Bak Recyclen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Mover Os  Caixa De Recycle"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Flyttende Them To The Recycle Bin"
#else
"Moving Them To The Recycle Bin"
#endif
	);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Purge On Delete GtkRadioButton */
	w = gtk_radio_button_new(gslist);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
/*	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w)); */
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto purgar permanentemente los objetos cuando borrarlos.\
 Los objetos borrados no se pueden recuperar utilizando este mtodo!"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci d'une faon permanente pour purger les objets en\
 effaant les. Les objets effacs ne peuvent pas tre retrouvs\
 l'utilisation de cette mthode!"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen Sie dies permanent, die Objekte beim Lschen sie zu reinigen.\
 Die gelschten Objekte knnen Gebrauch dieser Methode nicht \
 wiedererlangt werden!"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo permanentemente per prosciogliere gli oggetti\
 quando cancellare loro. Gli oggetti cancellati non possono essere\
 ricuperati per usare questo metodo!"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit permanent om de voorwerpen wanneer schrappen hen te\
 reinigen. De geschrappenene voorwerpen zullen gebruik van deze\
 methode niet misschien teruggekregen worden!"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto a permanentemente purge os objetos quando anular os.\
 Os objetos anulados nao podem ser recuperados usar este mtodo!"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette permanent rense objektene ved stryke av dem.\
 De strkne objektene utvunnet ikke bruk av denne metoden!"
#else
"Check this to permanently purge the objects when deleting them\
 (THE DELETED OBJECTS MAY NOT BE RECOVERED)"
#endif
	);
	gtk_widget_show(w);
	parent5 = w;
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_RADIO_BUTTON,
		w,
		EDV_CFG_PARM_DELETE_METHOD
	);
	CfgWinLinkSetData(
		cfg_link,
		(gpointer)EDV_DELETE_METHOD_PURGE
	);
	/* GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent5), w);
	gtk_widget_show(w);
	parent5 = w;
	/* Icon */
	w = edv_new_pixmap_widget(
		core,
		(edv_pixmap_data *)icon_purge_20x20_xpm,
		"icon_purge_20x20_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* GtkLabel */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Permanentemente Purging Ellos"
#elif defined(PROG_LANGUAGE_FRENCH)
"D'une Faon permanente Purger Les"
#elif defined(PROG_LANGUAGE_GERMAN)
"Permanent Reinigung Sie"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Permanentemente Prosciogliere Loro"
#elif defined(PROG_LANGUAGE_DUTCH)
"Permanent Reinigen Hen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Permanentemente Purging Os"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Permanent Purging Them"
#else
"Permanently Purging Them"
#endif
	);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(parent5), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	w = (GtkWidget *)CfgWinLinkGetWidget(cfg_link);
	gtk_widget_modify_style_recursive(w, caution_rcstyle);


	/* Recycle Bin GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Recicle Cajn"
#elif defined(PROG_LANGUAGE_FRENCH)
"Recycler L'Huche"
#elif defined(PROG_LANGUAGE_GERMAN)
"Werfen Sie Dose Weg"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Bidone"
#elif defined(PROG_LANGUAGE_DUTCH)
"Recycl Bak"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Recicle Caixa"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Forkast Boks"
#else
"Recycle Bin"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Recycle Bin Index File */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	w = GUIPromptBarWithBrowse(
		edv_get_recycle_bin_icon_data(
			EDV_ICON_SIZE_20,
			1,
			NULL
		),
		NULL,
		NULL, &entry_rtn, &browse_rtn,
		NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la ubicacin de los objetos reciclados indexa el archivo.\
 La gua reciclada de objetos ser la ubicacin (gua de padre)\
 de este archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer l'emplacement du fichier d'index d'objets recycl.\
 L'annuaire recycl d'objets sera l'emplacement (l'annuaire de\
 parent) de ce fichier"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie den ort index der wiederverwerteten objekte ablegt ein.\
 das wiederverwertete objekte Verzeichnis wird der ort (elternteil\
 verzeichnis) von dieser akte sein"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare la posizione del file di indice di oggetti riciclato.\
 L'elenco di oggetti riciclato sar la posizione (l'elenco di\
 genitore) di questo file"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga de plaats van de gerecyclde voorwerpen index dossier binnen.\
 De gerecyclde voorwerpen gids zal de plaats (ouder gids) van deze\
 dossier zijn"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre a localidade do arquivo reciclado de ndice de objetos. O\
 guia reciclado de objetos ser a localidade (guia de pai) deste\
 arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i plasseringen av det resirkuleredde objektindeksarkiv.\
 Den resirkuleredde objektkatalog er plasseringen (moreller\
 farkatalog) av dette arkivet"
#else
"Enter the location of the Recycle Bin Index file. The\
 Recycle Bin directory will be the parent directory\
 of this file"
#endif
	);
	edv_entry_set_dnd(core, w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_EDITABLE,
		w,
		EDV_CFG_PARM_FILE_RECYCLE_BIN_INDEX
	);
	w = (GtkWidget *)browse_rtn;
#if defined(PROG_LANGUAGE_FRENCH)
	GUISetWidgetTip(w, "Parcourir");
#else
	GUISetWidgetTip(w, "Browse");
#endif
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsBrowseCB), entry_rtn
	);

	/* Recycle Bin Size Warn */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* GtkLabel */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Advierta Cundo Tamao De Suma Excede"
#elif defined(PROG_LANGUAGE_FRENCH)
"Avertir Quand La Taille Totale Dpasse"
#elif defined(PROG_LANGUAGE_GERMAN)
"Warnen Sie, Wenn Gesamte Gre berschreitet"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Avvertire Quando Sommare La Misura Eccede"
#elif defined(PROG_LANGUAGE_DUTCH)
"Waarschuuw Wanneer Totaal Maat Overschrijdt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Advirta Quando Tamanho Total Excede"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Advar When Total Size Exceeds"
#else
"Warn When Total Size Exceeds"
#endif
		":"
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* Recbin Size Warn GtkSpinButton */
	adj = (GtkAdjustment *)gtk_adjustment_new(
		0.0f, 0.0f, (gfloat)((guint32)-1),
		10.0f, 100.0f, 100.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 110, -1);
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Cundo el tamao total de todos objetos de recycled excede este\
 valor, una advertencia ser impresa al usuario en arranca. Usted puede\
 especificar tambin un valor de 0 en incapacitar este cheque"
#elif defined(PROG_LANGUAGE_FRENCH)
"Quand la taille totale de tous objets recycls dpasse cette valeur,\
 un avertissement sera imprim  l'utilisateur  met en route. Vous\
 pouvez spcifier aussi une valeur de 0 rendre infirme ce chque"
#elif defined(PROG_LANGUAGE_GERMAN)
"N startet die gesamte gre uberschreiten diese viele nytes aller\
 wiederverwerteten objekte, eine earnung zum berbraucher an wird\
 gedruckt werden. Sie knnen auch einen eert von 0 angeben, unwirksam\
 dieses kennzeichen zu machen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"N la misura totale di tutti gli oggetti riciclati eccede questi\
 numerosi byte, un avvertimento sar stampato all'operatore a avvia.\
 Lei pu specificare anche un valore di 0 di essere incapace questa\
 caratteristica"
#elif defined(PROG_LANGUAGE_DUTCH)
"N opstart de totale maat van alle gerecyclde voorwerpen\
 overschrijdenen deze vele-byte, een waarschuwing te de gebruiker\
 aan zal afgedrukt worden. U kan ook een waarde van 0 specificeren\
 onbruikbaar deze kenmerk te maken"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O n o tamanho total de todo recycled ope-se excede tantos bytes, um\
 aviso ser imprimido ao operador em comear para cima. Voc tambm\
 pode especificar um valor de 0 incapacitar esta caracterstica"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"N den totale strrelsen av alle resirkuleredde objektoverskrider dene\
 mange bytene, en varsling trykt til brukeren p start opp. De\
 spesifiserer ogs en verdi av 0 udyktiggjre dette kjennetegnet"
#else
"Set the size (in bytes) that specifies when a warning will be\
 displayed (on startup) when the total size of all the recycled\
 objects has reached or exceeded this size (enter 0 to disable\
 this feature)"
#endif
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_SPIN_BUTTON,
		w,
		EDV_CFG_PARM_RECBIN_SIZE_WARN
	);

	/* Units GtkLabel */
	w = gtk_label_new("bytes");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);


	/* Purge Recycle Bin Button */
	w = gtk_vbox_new(TRUE, 0);
	gtk_box_pack_end(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent5 = w;
	w = GUIButtonPixmapLabelH(
		(guint8 **)icon_purge_all_20x20_xpm,
#if defined(PROG_LANGUAGE_SPANISH)
"Purga"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Purge"
#elif defined(PROG_LANGUAGE_GERMAN)
"Reinigen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Purga"
#elif defined(PROG_LANGUAGE_DUTCH)
"Zuivering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Limpeza"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Rens"
#else
"Purge Recycle Bin"
#endif
		, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent5), w, TRUE, FALSE, 0);
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(edv_purge_all_recycled_objects_cb), core
	);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Purgue todo se opone en el cajn del recirculacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Purger tous objets dans le recycle l'huche"
#elif defined(PROG_LANGUAGE_GERMAN)
"Reinigen sie alle objekte im wiederverwerten behlter"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Prosciogliere tutto l'obbietta nel contenitore per la raccolta\
 differenziata"
#elif defined(PROG_LANGUAGE_DUTCH)
"Reiniig alle voorwerpen in het recyclen bak"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Purgue todo ope-se no recicla caixa"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Rens alle objekt i den resirkulasjons beholderen"
#else
"Click to purge all the recycled objects in the recycle bin"
#endif
	);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_BUTTON,
		w,
		NULL				/* No parameter */
	);
	CfgWinLinkSetIgnoreChanges(cfg_link, TRUE);
	gtk_widget_show(w);


	/* MIME Types frame */
	w = gtk_frame_new("MIME Types");
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Global MIME Types File Prompt */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	w = GUIPromptBarWithBrowse(
		(guint8 **)icon_mimetypes_20x20_xpm,
		"Global:",
		NULL, &entry_rtn, &browse_rtn,
		NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
"Enter the location of the global MIME Types file"
	);
	edv_entry_set_dnd(core, w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_EDITABLE,
		w,
		EDV_CFG_PARM_FILE_MIME_TYPES_GLOBAL
	);
	w = (GtkWidget *)browse_rtn;
#if defined(PROG_LANGUAGE_FRENCH)
	GUISetWidgetTip(w, "Parcourir");
#else
	GUISetWidgetTip(w, "Browse");
#endif
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsBrowseCB), entry_rtn
	);

	/* Local MIME Types File Prompt */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	w = GUIPromptBarWithBrowse(
		(guint8 **)icon_mimetypes_20x20_xpm,
		"Local:",
		NULL, &entry_rtn, &browse_rtn,
		NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
"Enter the location of the local MIME Types file"
	);
	edv_entry_set_dnd(core, w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_EDITABLE,
		w,
		EDV_CFG_PARM_FILE_MIME_TYPES
	);
	w = (GtkWidget *)browse_rtn;
#if defined(PROG_LANGUAGE_FRENCH)
	GUISetWidgetTip(w, "Parcourir");
#else
	GUISetWidgetTip(w, "Browse");
#endif
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsBrowseCB), entry_rtn
	);


	/* Devices frame */
	w = gtk_frame_new("Devices");
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Devices File Prompt */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	w = GUIPromptBarWithBrowse(
		(guint8 **)icon_device_misc_20x20_xpm,
		NULL,
		NULL, &entry_rtn, &browse_rtn,
		NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
"Enter the location of the Devices Reference file"
	);
	edv_entry_set_dnd(core, w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_EDITABLE,
		w,
		EDV_CFG_PARM_FILE_DEVICES
	);
	w = (GtkWidget *)browse_rtn;
#if defined(PROG_LANGUAGE_FRENCH)
	GUISetWidgetTip(w, "Parcourir");
#else
	GUISetWidgetTip(w, "Browse");
#endif
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsBrowseCB), entry_rtn
	);
}

/*
 *      Creates the Display Page on options window.
 */
static void EDVCreateOptionsDisplayPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
					border_minor = 2;
	gint i;
	GtkAdjustment *adj;
	GtkWidget	*w,
					*parent2, *parent3, *parent4,
					*pulist;
	CfgWinLink *cfg_link;

	/* Image Quality GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Imagine La Calidad"
#elif defined(PROG_LANGUAGE_FRENCH)
"Qualit D'Image"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bildnis Qualitt"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Qualit Di Immagine"
#elif defined(PROG_LANGUAGE_DUTCH)
"Beeld Kwaliteit"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Qualidade De Imagem"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Avbilde Quality"
#else
"Image Quality"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Left column GtkVBox */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Image Quality GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	/* Image Quality Popup List Box */
	w = PUListBoxNew(
		160, -1
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	pulist = PUListBoxGetPUList(w);
	if(core->run_flags & EDV_RUN_SAFE_MODE)
		PUListSetShadowStyle(pulist, PULIST_SHADOW_NONE);
#define APPEND_ITEM(_s_,_v_)		{	\
 i = PUListAddItem(pulist, (_s_));	\
 PUListSetItemData(			\
  pulist,				\
  i,					\
  (gpointer)(_v_)			\
 );					\
}
#if defined(PROG_LANGUAGE_SPANISH)
	APPEND_ITEM("Pobre/Rapidamente",	0);
	APPEND_ITEM("El Medio/Optimul",		1);
	APPEND_ITEM("Mejor/Ms Lento",		2);
#elif defined(PROG_LANGUAGE_FRENCH)
	APPEND_ITEM("Pauvre/Jene",		0);
	APPEND_ITEM("Milieu/Optimul",		1);
	APPEND_ITEM("Mieux/Plus Lent",		2);
#elif defined(PROG_LANGUAGE_GERMAN)
	APPEND_ITEM("Arm/Schnellsten",		0);
	APPEND_ITEM("Medium/Ideal",		1);
	APPEND_ITEM("Besten/Langsamsten",	2);
#elif defined(PROG_LANGUAGE_ITALIAN)
	APPEND_ITEM("Povero/Digiuno",		0);
	APPEND_ITEM("Mezzo/Ottima",		1);
	APPEND_ITEM("Meglio/Pi Lento",		2);
#elif defined(PROG_LANGUAGE_DUTCH)
	APPEND_ITEM("Arm/Snel",			0);
	APPEND_ITEM("Middel/Optimaal",		1);
	APPEND_ITEM("Best/Langzaam",		2);
#elif defined(PROG_LANGUAGE_PORTUGUESE)
	APPEND_ITEM("Pobre/Rpido",		0);
	APPEND_ITEM("Mdio/Optimal",		1);
	APPEND_ITEM("Melhor/Lento",		2);
#elif defined(PROG_LANGUAGE_NORWEGIAN)
	APPEND_ITEM("Fattig/Fortest",		0);
	APPEND_ITEM("Middel/Optimal",		1);
	APPEND_ITEM("Best/Langsom",		2);
#else
	APPEND_ITEM("Poor/Fastest",		0);
	APPEND_ITEM("Medium/Optimal",		1);
	APPEND_ITEM("Best/Slowest",		2);
#endif
#undef APPEND_ITEM
	PUListBoxSetLinesVisible(w, MIN((i + 1), 10));
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_POPUP_LIST_BOX,
		w,
		EDV_CFG_PARM_IMAGE_QUALITY
	);


	/* Lists GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Las Listas"
#elif defined(PROG_LANGUAGE_FRENCH)
"Listes"
#elif defined(PROG_LANGUAGE_GERMAN)
"Listen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Gli Elenchi"
#elif defined(PROG_LANGUAGE_DUTCH)
"Lijsten"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Listas"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Lister"
#else
"Lists"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Show Update Progress & Messages GtkCheckButton */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Anime Actualice"
#elif defined(PROG_LANGUAGE_FRENCH)
"Animer Des Mises A Jour"
#elif defined(PROG_LANGUAGE_GERMAN)
"Lebende Aktualisierungen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Animare Gli Aggiornamenti"
#elif defined(PROG_LANGUAGE_DUTCH)
"Levende Herziening"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Anime Atualiza"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Opplivende Updates"
#else
"Show Update Progress & Messages"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto animar artculos de lista durante actualiza (donde\
 disponible)"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci pour animer les articles de liste pendant les mises \
 jour (o disponible)"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen Sie dies, Liste Punkte whrend Aktualisierungen (wo verfgbar)\
 zu beleben"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo per animare gli articoli di elenco durante gli\
 aggiornamenti (dove disponibile)"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit om lijst onderdelen gedurende herziening (waar\
 verkrijgbaar) te bezielen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto animar itens de lista durante atualizar (onde\
 disponvel)"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette live opp listeting i lpet av oppdateringer (hvor\
 tilgjengelig)"
#else
"Check this to display the progress and messages on the\
 status bars during list updates"
#endif
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_TOGGLE_BUTTON,
		w,
		EDV_CFG_PARM_LISTS_SHOW_PROGRESS
	);

	/* Double Buffer GtkCheckButton */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"La Memoria Intermedia Doble"
#elif defined(PROG_LANGUAGE_FRENCH)
"Tampon Double"
#elif defined(PROG_LANGUAGE_GERMAN)
"Doppelpuffer"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Tampone Doppio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Dubbele Buffer"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Memria Dupla Intermediria"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dobbel Buffer"
#else
"Double Buffer"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto usar las memorias intermedias dobles para listas,\
 esto producir ms liso actualiza pero va ms despacio el desempeo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci pour utiliser des tampons doubles pour les listes,\
 ceci produira des mises  jour plus lisses mais ralentit l'excution"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen sie dies, doppelpuffer fr listen, dies wird herstellen\
 glattere aktualisierungen zu benutzen, aber verlangsamen sie leistung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo per usare i tamponi doppi per gli elenchi, questo\
 produrr degli aggiornamenti pi lisci ma rallenta l'esecuzione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit om dubbele buffers voor lijsten, dit zal produceren\
 gladdere herziening te gebruiken, maar prestatie vertraagt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto usar memrias duplas intermediria para listas, isto\
 produzir mais liso atualiza mas vai mais devagar desempenho"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette bruke dobble buffere for lister, dette produserer glatt\
 oppdateringer men saktner prestasjon"
#else
"Check this to use double buffers for lists, this will produce\
 smoother updates but slow down performance"
#endif
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_TOGGLE_BUTTON,
		w,
		EDV_CFG_PARM_LISTS_DOUBLE_BUFFER
	);

	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Optimize Tree Expand GtkCheckButton */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Optimice La Posicin De Ensanchar De Arbol"
#elif defined(PROG_LANGUAGE_FRENCH)
"Optimiser L'Arbre Augmente La Position"
#elif defined(PROG_LANGUAGE_GERMAN)
"Optimieren Sie Baum Ausbreitet Position"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Ottimizzare L'Albero Allarga La Posizione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Optimaliseer Boom Uitbreidt Positie"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A rvore De Optimize Expande Posio"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Optimer Tre Utvider Posisjon"
#else
"Optimize Tree Expand Position"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto desplazar automticamente las listas de rbol a las\
 la mayora de las posiciones de la optimul cuando ensanchar ramifica"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci automatiquement pour dfiler les listes d'arbre au plus\
 de optimul la position en augmentant diverge"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen sie dies automatisch, baum listen zur meisten optimul position\
 zu rollen, beim ausbreiten abzweigt"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo automaticamente per scorrere gli elenchi di albero\
 al la maggior parte della posizione di optimul quando allargare dirama"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit automatisch om boom lijsten aan de meeste optimul\
 positie te rollen wanneer uitbreiden aftakt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto a automaticamente listas de rvore de scroll a mais\
 posio de optimul quando expandir ramos"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette automatisk rulle trelister til den meste optimul\
 posisjon ved deler seg utvide"
#else
"Check this to automatically scroll tree lists to the most\
 optimul position when expanding branches"
#endif
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_TOGGLE_BUTTON,
		w,
		EDV_CFG_PARM_TREE_EXPAND_OPTIMIZE_POS
	);

	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Lists Load Images Priority GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	w = gtk_label_new("Load Images Priority:");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Lists Load Images Priority Popup List Box */
	w = PUListBoxNew(
		100, -1
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	pulist = PUListBoxGetPUList(w);
	if(core->run_flags & EDV_RUN_SAFE_MODE)
		PUListSetShadowStyle(pulist, PULIST_SHADOW_NONE);
#define APPEND_ITEM(_s_,_v_)	{	\
 i = PUListAddItem(pulist, (_s_));	\
 PUListSetItemData(			\
  pulist,				\
  i,					\
  (gpointer)(_v_)			\
 );					\
}
	APPEND_ITEM("Highest",	EDV_LISTS_LOAD_IMAGES_PRIORITY_HIGHEST);
	APPEND_ITEM("High",	EDV_LISTS_LOAD_IMAGES_PRIORITY_HIGH);
	APPEND_ITEM("Normal",	EDV_LISTS_LOAD_IMAGES_PRIORITY_NORMAL);
	APPEND_ITEM("Low",	EDV_LISTS_LOAD_IMAGES_PRIORITY_LOW);
	APPEND_ITEM("Lowest",	EDV_LISTS_LOAD_IMAGES_PRIORITY_LOWEST);
#undef APPEND_ITEM
	PUListBoxSetLinesVisible(w, MIN((i + 1), 10));
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_POPUP_LIST_BOX,
		w,
		EDV_CFG_PARM_LISTS_LOAD_IMAGES_PRIORITY
	);


	/* Size GtkFrame */
	w = gtk_frame_new("Size");
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Left column GtkVBox */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Format GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	w = gtk_label_new("Format:");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Format Popup List Box */
	w = PUListBoxNew(
		280, -1
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	pulist = PUListBoxGetPUList(w);
	if(core->run_flags & EDV_RUN_SAFE_MODE)
		PUListSetShadowStyle(pulist, PULIST_SHADOW_NONE);
#define APPEND_ITEM(_s_,_v_)	{	\
 i = PUListAddItem(pulist, (_s_));	\
 PUListSetItemData(			\
  pulist,				\
  i,					\
  (gpointer)(_v_)			\
 );					\
}
	APPEND_ITEM(
		"Raw (eg 123456789)",
		EDV_SIZE_FORMAT_RAW
	);
	APPEND_ITEM(
		"Deliminated (eg 123,456,789)",
		EDV_SIZE_FORMAT_DELIMINATED
	);
	APPEND_ITEM(
		"Blocks (eg 5.2K 123K 6,232,876K)",
		EDV_SIZE_FORMAT_BLOCKS
	);
	APPEND_ITEM(
		"Human Readable (eg 5.2K 123M 2.8G)",
		EDV_SIZE_FORMAT_HUMAN_READABLE
	);
#undef APPEND_ITEM
	PUListBoxSetLinesVisible(w, MIN((i + 1), 10));
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_POPUP_LIST_BOX,
		w,
		EDV_CFG_PARM_SIZE_FORMAT
	);


	/* Right column GtkVBox */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;


	/* Block Size GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	w = gtk_label_new("Block Size:");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Block Size GtkSpinButton */
	adj = (GtkAdjustment *)gtk_adjustment_new(
		0.0f, 0.0f, (gfloat)((guint32)-1),
		1.0f, 10.0f, 10.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 80, -1);
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
"Set the block size (in bytes) for size conversions,\
 the default value is 1000 (some users prefer 1024)"
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_SPIN_BUTTON,
		w,
		EDV_CFG_PARM_BLOCK_SIZE
	);

	/* Units GtkLabel */
	w = gtk_label_new("bytes");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
}

/*
 *	Creates the Keyboard page.
 */
static void EDVCreateOptionsKeyboardPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
					border_minor = 2;
	GtkWidget	*w,
					*parent2, *parent3;
	CfgWinLink *cfg_link;

	/* Lists GtkFrame */
	w = gtk_frame_new("Lists");
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Scroll To Key Name */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	w = gtk_check_button_new_with_label("Enable Scroll To Object Name");
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	GUISetWidgetTip(
		w,
"Check this to scroll to the first object (or last object if the ALT\
 modifier was held) in the list who's first letter in its name matches\
 the key that was pressed. If you are experiencing accelerator key\
 conflicts then you may need to uncheck this feature."
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_TOGGLE_BUTTON,
		w,
		EDV_CFG_PARM_LISTS_KEYBOARD_SCROLL_TO_KEY_NAME
	);

}

/*
 *	Creates the Pointer page.
 */
static void EDVCreateOptionsPointerPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
					border_minor = 2;
	gint i;
	GtkWidget	*w,
					*parent2, *parent3,
					*pulist;
	CfgWinLink *cfg_link;

	/* Lists Quality GtkFrame */
	w = gtk_frame_new("Lists");
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Lists Pointer Operation Button2 */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_label_new("Middle Button:");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	w = PUListBoxNew(
		160, -1
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	pulist = PUListBoxGetPUList(w);
	if(core->run_flags & EDV_RUN_SAFE_MODE)
		PUListSetShadowStyle(pulist, PULIST_SHADOW_NONE);
#define APPEND_ITEM(_s_,_v_)            {       \
 i = PUListAddItem(pulist, (_s_));      \
 PUListSetItemData(                     \
  pulist,                               \
  i,                                    \
  (gpointer)(_v_)                       \
 );                                     \
}
	APPEND_ITEM("Does Nothing",  EDV_LISTS_POINTER_OP_BUTTON2_NONE);
	APPEND_ITEM("Scrolls 2 Dimensional",  EDV_LISTS_POINTER_OP_BUTTON2_SCROLL_XY);
	APPEND_ITEM("Renames",  EDV_LISTS_POINTER_OP_BUTTON2_RENAME);
	APPEND_ITEM("Pastes Object(s)",  EDV_LISTS_POINTER_OP_BUTTON2_PASTE);
#undef APPEND_ITEM
	PUListBoxSetLinesVisible(w, MIN((i + 1), 10));
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_POPUP_LIST_BOX,
		w,
		EDV_CFG_PARM_LISTS_POINTER_OP_BUTTON2
	);


	/* Right Click Select Item & Map Menu */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	/* GtkCheckButton */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Escoja Antes De Trazar Mens De Chasquido De Derecho"
#elif defined(PROG_LANGUAGE_FRENCH)
"Choisir Avant Les Menus De Dclic De Droite De Mapping"
#elif defined(PROG_LANGUAGE_GERMAN)
"Whlen Sie Vor Aufzeichnen Von Recht Klicken Mens Aus"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Scegliere Prima Mapping Fa Clic Col Pulsante Destro Dei Menu"
#elif defined(PROG_LANGUAGE_DUTCH)
"Selecteer Voor Brengen In Kaart Recht Klik Menu's"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Selecione Antes De Mapping Cardpios Direitos De Estalido"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utvalgt Before Mapping Right Click Menus"
#else
"Select Before Mapping Right Click Menus"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"El cheque este si usted quiere que el artculo bajo la flecha para sea\
 escogido cuando usted traza el men correcto del chasquido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Le chque ceci si vous voulez que l'article sous le pointeur soit\
 choisi quand vous la carte le bon menu de dclic"
#elif defined(PROG_LANGUAGE_GERMAN)
"Kontrolle dieses, wenn Sie den Punkt unter dem Zeiger wollen,\
 ausgewhlt zu werden, wenn Sie das richtige Klicken Men\
 aufzeichnen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'assegno questo se lei vuole che l'articolo sotto l'indicatore di\
 essere scelto quando lei la mappa il fa clic col pulsante destro il\
 menu"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controle deze indien u het onderdeel onder de wijzer wil\
 geselecteerd te worden wanneer u in kaart het juist klik menu\
 brengt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verificar este se quer o item sob o pointer ser selecionado\
 quando voc mapa o cardpio direito de estalido"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Kontroll dette om De vil ha tingen under viseren valgt ut nr De\
 kartlegger den riktige klikkmeny"
#else
"Check this if you want the item under the pointer to be selected\
 when you map the right click menu"
#endif
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_TOGGLE_BUTTON,
		w,
		EDV_CFG_PARM_RIGHT_CLICK_MENU_SELECTS
	);
}

/*
 *      Creates the Programs Page on options window.
 */
static void EDVCreateOptionsProgramsPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
					border_minor = 2;
	edv_pixmap_data *icon;
	const gchar	*label,
					*tip;
	gpointer	label_rtn,
					entry_rtn,
					browse_rtn;
	GtkWidget	*w,
					*parent2, *parent3;
	CfgWinLink *cfg_link;

	/* Create a scrolled window to allow scrolling through the many
	 * widgets on this page
	 */
	parent2 = edv_new_scrolled_window(
		GTK_POLICY_AUTOMATIC,
		GTK_POLICY_AUTOMATIC,
		NULL, &w
	);
	gtk_box_pack_start(GTK_BOX(parent), parent2, TRUE, TRUE, 0);
	gtk_widget_show(parent2);

	gtk_box_set_spacing(GTK_BOX(w), border_major);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	parent2 = w;

#if defined(PROG_LANGUAGE_FRENCH)
#define NEW_PROMPT(_parent_,_parm_) {		\
 GtkWidget *w, *box;				\
											\
 box = w = gtk_hbox_new(FALSE, border_minor);	\
 gtk_box_pack_start(				\
  GTK_BOX(_parent_), w, FALSE, FALSE, 0		\
 );						\
 gtk_widget_show(w);				\
											\
 /* Create the Prompt */			\
 w = GUIPromptBarWithBrowse(			\
  icon, label,					\
  &label_rtn, &entry_rtn, &browse_rtn,		\
  NULL, NULL					\
 );						\
 gtk_box_pack_start(				\
  GTK_BOX(box), w, TRUE, TRUE, 0		\
 );						\
 gtk_widget_show(w);				\
											\
 /* Set up the Browse GtkButton */		\
 w = (GtkWidget *)browse_rtn;			\
 if(w != NULL) {				\
  GUISetWidgetTip(w, "Parcourir");		\
  gtk_signal_connect(				\
   GTK_OBJECT(w), "clicked",			\
   GTK_SIGNAL_FUNC(EDVOptionsBrowseProgramCB),	\
   entry_rtn					\
  );						\
 }						\
											\
 cfg_link = NULL:				\
											\
 /* Set up the GtkEntry */			\
 w = (GtkWidget *)entry_rtn;			\
 if(w != NULL) {				\
  if(tip != NULL)				\
   GUISetWidgetTip(w, tip);			\
  edv_entry_set_dnd(core, w);			\
  GUIEditableEndowPopupMenu(w, 0);		\
  cfg_link = CfgWinAddLink(			\
   cfgwin,					\
   parent,					\
   CFG_WIN_LINK_WIDGET_EDITABLE,		\
   w,						\
   (_parm_)					\
  );						\
 }						\
											\
 /* Create the Run GtkButton */			\
 if(cfg_link != NULL) {				\
  w = GUIButtonPixmap(				\
   (guint8 **)icon_run_20x20_xpm		\
  );						\
  gtk_box_pack_start(				\
   GTK_BOX(box), w, FALSE, FALSE, 0		\
  );						\
  gtk_signal_connect(				\
   GTK_OBJECT(w), "clicked",			\
   GTK_SIGNAL_FUNC(EDVOptionsRunCB), cfg_link	\
  );						\
  GUISetWidgetTip(w, "Test");			\
  gtk_widget_show(w);				\
 }						\
}

#else

#define NEW_PROMPT(_parent_,_parm_) {		\
 GtkWidget *w, *box;				\
											\
 box = w = gtk_hbox_new(FALSE, border_minor);	\
 gtk_box_pack_start(				\
  GTK_BOX(_parent_), w, FALSE, FALSE, 0		\
 );						\
 gtk_widget_show(w);				\
											\
 /* Create the Prompt */			\
 w = GUIPromptBarWithBrowse(			\
  icon, label,					\
  &label_rtn, &entry_rtn, &browse_rtn,		\
  NULL, NULL					\
 );						\
 gtk_box_pack_start(				\
  GTK_BOX(box), w, TRUE, TRUE, 0		\
 );						\
 gtk_widget_show(w);				\
											\
 /* Set up the Browse GtkButton */		\
 w = (GtkWidget *)browse_rtn;			\
 if(w != NULL) {				\
  GUISetWidgetTip(w, "Browse");			\
  gtk_signal_connect(				\
   GTK_OBJECT(w), "clicked",			\
   GTK_SIGNAL_FUNC(EDVOptionsBrowseProgramCB),	\
   entry_rtn					\
  );						\
 }						\
											\
 cfg_link = NULL;				\
											\
 /* Set up the GtkEntry */			\
 w = (GtkWidget *)entry_rtn;			\
 if(w != NULL) {				\
  if(tip != NULL)				\
   GUISetWidgetTip(w, tip);			\
  edv_entry_set_dnd(core, w);			\
  GUIEditableEndowPopupMenu(w, 0);		\
  cfg_link = CfgWinAddLink(			\
   cfgwin,					\
   parent,					\
   CFG_WIN_LINK_WIDGET_EDITABLE,		\
   w,						\
   (_parm_)					\
  );						\
 }						\
											\
 /* Create the Run Button */			\
 if(cfg_link != NULL) {				\
  w = GUIButtonPixmap(				\
   (guint8 **)icon_run_20x20_xpm		\
  );						\
  gtk_box_pack_start(				\
   GTK_BOX(box), w, FALSE, FALSE, 0		\
  );						\
  gtk_signal_connect(				\
   GTK_OBJECT(w), "clicked",			\
   GTK_SIGNAL_FUNC(EDVOptionsRunCB), cfg_link	\
  );						\
  GUISetWidgetTip(w, "Test");			\
  gtk_widget_show(w);				\
 }						\
}

#endif

	/* Shells GtkFrame */
	w = gtk_frame_new("Shells");
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	icon = NULL;
	label = "Default Shell:";
	tip = "Enter the command to run the default shell and\
 any shell-specific arguments or leave this blank to use the\
 default shell specified by the environment variable " ENV_VAR_NAME_SHELL ".\
 The default shell is used when a MIME Type's command does not\
 specify a shell or when executing objects that are not associated\
 with a MIME Type.";
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_SHELL);


	/* Viewers GtkFrame */
	w = gtk_frame_new("Viewers");
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	icon = NULL;
	label = "Default Viewer:";
	tip = "Enter the command to run the default viewer program.\
 This program will be used to open objects that are not associated\
 with a MIME Type.\
 A %path, %paths, or equivalent substitution is required in this command.";
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_DEF_VIEWER);


	/* Terminal Programs GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Las Terminales"
#elif defined(PROG_LANGUAGE_FRENCH)
"Terminaux"
#elif defined(PROG_LANGUAGE_GERMAN)
"Terminale"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Estremit"
#elif defined(PROG_LANGUAGE_DUTCH)
"Eindpunten"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Terminais"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Terminaler"
#else
"Terminals"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	icon = (edv_pixmap_data *)icon_terminal2_20x20_xpm;
	label =
#if defined(PROG_LANGUAGE_SPANISH)
"La Terminal"
#elif defined(PROG_LANGUAGE_FRENCH)
"Terminal"
#elif defined(PROG_LANGUAGE_GERMAN)
"Terminal"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Estremit"
#elif defined(PROG_LANGUAGE_DUTCH)
"Eindpunt"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Terminal"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Terminal"
#else
"Terminal"
#endif
	":";
	tip = "Enter the command to run the terminal program.";
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_TERMINAL);

	icon = (edv_pixmap_data *)icon_terminal_run2_20x20_xpm;
	label =
#if defined(PROG_LANGUAGE_SPANISH)
"Terminal & Corra Program"
#elif defined(PROG_LANGUAGE_FRENCH)
"Terminal & Courir Program"
#elif defined(PROG_LANGUAGE_GERMAN)
"Terminal & Lauf Programmiert"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Estremit & Ha Corso Il Programma"
#elif defined(PROG_LANGUAGE_DUTCH)
"Eindpunt & Tocht Programma"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Terminal & Programa De Corrida"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Terminal & Run Program"
#else
"Terminal & Run Program"
#endif
	":";
	tip = "Enter the command to run a program within a\
 terminal program. This is used to run programs and\
 display their output to a terminal.";
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_TERMINAL_RUN);


	/* Archiver programs frame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Archive"
#elif defined(PROG_LANGUAGE_GERMAN)
"Archiv"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Archivio"
#elif defined(PROG_LANGUAGE_DUTCH)
"Archief"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Arkiv"
#else
"Archivers"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	icon = NULL;
	label = "ARJ:";
	tip = NULL;
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_ARJ);

	icon = NULL;
	label = "LHA:";
	tip = NULL;
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_LHA);

	icon = NULL;
	label = "RAR:";
	tip = NULL;
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_RAR);

	icon = NULL;
	label = "RPM:";
	tip = NULL;
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_RPM);

	icon = NULL;
	label = "TAR:";
	tip = NULL;
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_TAR);

	icon = NULL;
	label = "Zip:";
	tip = NULL;
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_ZIP);

	icon = NULL;
	label = "UnZip:";
	tip = NULL;
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_UNZIP);

	icon = NULL;
	label = "Compress:";
	tip = NULL;
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_COMPRESS);

	icon = NULL;
	label = "UnCompress:";
	tip = NULL;
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_UNCOMPRESS);

	icon = NULL;
	label = "GZip:";
	tip = NULL;
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_GZIP);

	icon = NULL;
	label = "GUnZip:";
	tip = NULL;
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_GUNZIP);

	icon = NULL;
	label = "BZip2:";
	tip = NULL;
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_BZIP2);

	icon = NULL;
	label = "BUnZip2:";
	tip = NULL;
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_BUNZIP2);

	/* Network programs GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Red"
#elif defined(PROG_LANGUAGE_FRENCH)
"Rseau"
#elif defined(PROG_LANGUAGE_GERMAN)
"Netz"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Rete"
#elif defined(PROG_LANGUAGE_DUTCH)
"Net"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Rede"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Nettverk"
#else
"Network"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	icon = (edv_pixmap_data *)icon_download_file_20x20_xpm;
	label =
#if defined(PROG_LANGUAGE_SPANISH)
"La Descarga"
#elif defined(PROG_LANGUAGE_FRENCH)
"Chargement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Laden Sie"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Scaricare"
#elif defined(PROG_LANGUAGE_DUTCH)
"Download"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Download"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Download"
#else
"Download"
#endif
	":";
	tip = "Enter the path to the download front end program";
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_NET_DOWNLOAD);

	icon = (edv_pixmap_data *)icon_mailbox_20x20_xpm;
	label =
#if defined(PROG_LANGUAGE_SPANISH)
"Enve A Cliente"
#elif defined(PROG_LANGUAGE_FRENCH)
"Client De Courrier"
#elif defined(PROG_LANGUAGE_GERMAN)
"Postkunde"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Il Cliente Di Posta"
#elif defined(PROG_LANGUAGE_DUTCH)
"Postklant"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Remeta Cliente"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Post Client"
#else
"E-Mail Client"
#endif
	":";
	tip = "Enter the path to the e-mail client program";
	NEW_PROMPT(parent3, EDV_CFG_PARM_PROG_MAIL_CLIENT);


#undef NEW_PROMPT
}

/*
 *	Creates the Confirmation Page.
 */
static void EDVCreateOptionsConfirmationPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent,
	GtkRcStyle *caution_rcstyle
)
{
	const gint	border_major = 5,
					border_minor = 2;
	const gchar	*s,
					*or_more_objects_str;
	GtkWidget	*w,
					*w_check,
					*w_label,
					*parent2, *parent3, *parent4;
	CfgWinLink *cfg_link;

	/* Create a scrolled window to allow scrolling through the many
	 * widgets on this page
	 */
	parent2 = edv_new_scrolled_window(
		GTK_POLICY_AUTOMATIC,
		GTK_POLICY_AUTOMATIC,
		NULL, &w
	);
	gtk_box_pack_start(GTK_BOX(parent), parent2, TRUE, TRUE, 0);
	gtk_widget_show(parent2);

	gtk_box_set_spacing(GTK_BOX(w), border_major);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	parent2 = w;


#define CREATE_CHECK(_icon_d_,_icon_n_,_label_,_cfg_parm_,_cfg_parm_nobjs_) { \
 GtkWidget	*sparent = parent4,		\
			*sparent2;			\
											\
 w = gtk_hbox_new(FALSE, border_minor);		\
 gtk_box_pack_start(				\
  GTK_BOX(sparent), w, FALSE, FALSE, 0		\
 );						\
 gtk_widget_show(w);				\
 sparent = w;					\
											\
 /* GtkCheckButton */				\
 w_check = w = gtk_check_button_new();		\
 gtk_box_pack_start(				\
  GTK_BOX(sparent), w, FALSE, FALSE, 0		\
 );						\
 gtk_widget_show(w);				\
 sparent2 = w;					\
 cfg_link = CfgWinAddLink(			\
  cfgwin,					\
  parent,					\
  CFG_WIN_LINK_WIDGET_TOGGLE_BUTTON,		\
  w,						\
  (_cfg_parm_)					\
 );						\
											\
 w = gtk_hbox_new(FALSE, border_minor);		\
 gtk_container_add(GTK_CONTAINER(sparent2), w);	\
 gtk_widget_show(w);				\
 sparent2 = w;					\
											\
 /* Icon GtkPixmap */				\
 if((_icon_d_) != NULL) {			\
  w = edv_new_pixmap_widget(			\
   core, (edv_pixmap_data *)(_icon_d_), (_icon_n_)	\
  );						\
  gtk_box_pack_start(				\
   GTK_BOX(sparent2), w, FALSE, FALSE, 0	\
  );						\
  gtk_widget_show(w);				\
 }						\
 /* GtkLabel */					\
 w_label = w = gtk_label_new(_label_);		\
 gtk_label_set_justify(				\
  GTK_LABEL(w),					\
  GTK_JUSTIFY_LEFT				\
 );						\
 gtk_box_pack_start(				\
  GTK_BOX(sparent2), w, FALSE, FALSE, 0		\
 );						\
 gtk_widget_show(w);				\
											\
 /* If a number of objects parameter name was	\
  * specified then create a GtkSpinButton for	\
  * it						\
  */						\
 if((_cfg_parm_nobjs_) != NULL) {		\
  CfgWinLink *nobjs_cfg_link;			\
  GtkAdjustment *adj = (GtkAdjustment *)gtk_adjustment_new(	\
   1.0f, 1.0f, (gfloat)((guint32)-1),		\
   1.0f, 5.0f, 0.0f				\
  );						\
  /* GtkSpinButton */				\
  w = gtk_spin_button_new(adj, 1.0, 0);		\
  gtk_box_pack_start(				\
   GTK_BOX(sparent), w, FALSE, FALSE, 0		\
  );						\
  CfgWinLinkSignalConnectAfter(			\
   cfg_link,					\
   "changed",					\
   EDVOptionsConfirmationCheckChangedCB, w	\
  );						\
  gtk_widget_set_usize(w, 60, -1);		\
  GUIEditableEndowPopupMenu(w, 0);		\
  gtk_widget_show(w);				\
  nobjs_cfg_link = CfgWinAddLink(		\
   cfgwin,					\
   parent,					\
   CFG_WIN_LINK_WIDGET_SPIN_BUTTON,		\
   w,						\
   (_cfg_parm_nobjs_)				\
  );						\
											\
  /* GtkLabel */				\
  w = gtk_label_new(or_more_objects_str);	\
  gtk_label_set_justify(			\
   GTK_LABEL(w),				\
   GTK_JUSTIFY_LEFT				\
  );						\
  gtk_box_pack_start(				\
   GTK_BOX(sparent), w, FALSE, FALSE, 0		\
  );						\
  gtk_widget_show(w);				\
											\
 }						\
}

	/* Confirm When GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Confirme Cundo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Confirmer Quand"
#elif defined(PROG_LANGUAGE_GERMAN)
"Besttigen Sie Wenn"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Confermare Quando"
#elif defined(PROG_LANGUAGE_DUTCH)
"Bevestiig Wanneer"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Confirme Quando"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bekreft Nr"
#else
"Confirm When"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent3 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent3 = w;

	/* Set the units string */
	or_more_objects_str =
#if defined(PROG_LANGUAGE_SPANISH)
"or more objects"
#elif defined(PROG_LANGUAGE_FRENCH)
"or more objects"
#elif defined(PROG_LANGUAGE_GERMAN)
"or more objects"
#elif defined(PROG_LANGUAGE_ITALIAN)
"or more objects"
#elif defined(PROG_LANGUAGE_DUTCH)
"or more objects"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"or more objects"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"or more objects"
#elif defined(PROG_LANGUAGE_POLISH)
"or more objects"
#else
"or more objects"
#endif
	;

	/* Open GtkVBox */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	/* Opening An Object */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Abrir"
#elif defined(PROG_LANGUAGE_FRENCH)
"Ouvert"
#elif defined(PROG_LANGUAGE_GERMAN)
"Opening"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Opening"
#elif defined(PROG_LANGUAGE_DUTCH)
"Opening"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Opening"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Opening"
#elif defined(PROG_LANGUAGE_POLISH)
"Otwrz"
#else
"Opening"
#endif
	;
	CREATE_CHECK(
		icon_open_20x20_xpm,
		"icon_open_20x20_xpm",
		s,
		EDV_CFG_PARM_CONFIRM_OPEN,
		EDV_CFG_PARM_CONFIRM_OPEN_NOBJECTS
	);

	w = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);


	/* Move, Copy, Link, and Delete GtkVBox */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	/* Moving An Object */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Mover"
#elif defined(PROG_LANGUAGE_FRENCH)
"Dmnagement"
#elif defined(PROG_LANGUAGE_GERMAN)
"Bewegen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Trasloco"
#elif defined(PROG_LANGUAGE_DUTCH)
"Bewegen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Mover"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Flytting"
#else
"Moving"
#endif
	;
	CREATE_CHECK(
		icon_move_file_20x20_xpm,
		"icon_move_file_20x20_xpm",
		s,
		EDV_CFG_PARM_CONFIRM_MOVE,
		EDV_CFG_PARM_CONFIRM_MOVE_NOBJECTS
	);

	/* Copying An Object */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Copiar"
#elif defined(PROG_LANGUAGE_FRENCH)
"Copier"
#elif defined(PROG_LANGUAGE_GERMAN)
"Kopieren"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Copiare"
#elif defined(PROG_LANGUAGE_DUTCH)
"Kopiren"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Copiar"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Kopiering"
#else
"Copying"
#endif
	;
	CREATE_CHECK(
		icon_copy_file_20x20_xpm,
		"icon_copy_file_20x20_xpm",
		s,
		EDV_CFG_PARM_CONFIRM_COPY,
		EDV_CFG_PARM_CONFIRM_COPY_NOBJECTS
	);

	/* Linking An Object */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Ligar"
#elif defined(PROG_LANGUAGE_FRENCH)
"Relier"
#elif defined(PROG_LANGUAGE_GERMAN)
"Verknpfen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Concatenare"
#elif defined(PROG_LANGUAGE_DUTCH)
"Verbinden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Ligao"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Forbinding"
#else
"Linking"
#endif
	;
	CREATE_CHECK(
		icon_link_20x20_xpm,
		"icon_link_20x20_xpm",
		s,
		EDV_CFG_PARM_CONFIRM_LINK,
		EDV_CFG_PARM_CONFIRM_LINK_NOBJECTS
	);

	/* Deleting An Object */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Borrar"
#elif defined(PROG_LANGUAGE_FRENCH)
"Effacer"
#elif defined(PROG_LANGUAGE_GERMAN)
"Lschen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Cancellare"
#elif defined(PROG_LANGUAGE_DUTCH)
"Schrappen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Anular"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Stryking"
#else
"Deleting"
#endif
	;
	CREATE_CHECK(
		icon_cancel_20x20_xpm,
		"icon_cancel_20x20_xpm",
		s,
		EDV_CFG_PARM_CONFIRM_DELETE,
		EDV_CFG_PARM_CONFIRM_DELETE_NOBJECTS
	);
	/* Set the GtkLabel red for cautionary purposes */
	gtk_widget_modify_style_recursive(w_check, caution_rcstyle);

	w = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);


	/* Recycled Object Operations GtkVBox */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	/* Set the units string */
	or_more_objects_str =
#if defined(PROG_LANGUAGE_SPANISH)
"or more objects from the Recycle Bin"
#elif defined(PROG_LANGUAGE_FRENCH)
"or more objects from the Recycle Bin"
#elif defined(PROG_LANGUAGE_GERMAN)
"or more objects from the Recycle Bin"
#elif defined(PROG_LANGUAGE_ITALIAN)
"or more objects from the Recycle Bin"
#elif defined(PROG_LANGUAGE_DUTCH)
"or more objects from the Recycle Bin"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"or more objects from the Recycle Bin"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"or more objects from the Recycle Bin"
#elif defined(PROG_LANGUAGE_POLISH)
"or more objects from the Recycle Bin"
#else
"or more objects from the Recycle Bin"
#endif
	;

	/* Recovering An Object From The Recycle Bin */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Recuperar"
#elif defined(PROG_LANGUAGE_FRENCH)
"Retrouver"
#elif defined(PROG_LANGUAGE_GERMAN)
"Wiedererlangen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Ricuperare"
#elif defined(PROG_LANGUAGE_DUTCH)
"Terugkrijgen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Recuperar"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utvinning"
#else
"Recovering"
#endif
	;
	CREATE_CHECK(
		icon_recover_20x20_xpm,
		"icon_recover_20x20_xpm",
		s,
		EDV_CFG_PARM_CONFIRM_RECOVER,
		EDV_CFG_PARM_CONFIRM_RECOVER_NOBJECTS
	);

	/* Purging An Object From The Recycle Bin */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Purgando"
#elif defined(PROG_LANGUAGE_FRENCH)
"Purger"
#elif defined(PROG_LANGUAGE_GERMAN)
"Reinigung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Proscioglimento"
#elif defined(PROG_LANGUAGE_DUTCH)
"Reinigen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Purgue"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Rensing"
#else
"Purging"
#endif
	;
	CREATE_CHECK(
		icon_purge_20x20_xpm,
		"icon_purge_20x20_xpm",
		s,
		EDV_CFG_PARM_CONFIRM_PURGE,
		EDV_CFG_PARM_CONFIRM_PURGE_NOBJECTS
	);
	/* Set the GtkLabel red for cautionary purposes */
	gtk_widget_modify_style_recursive(w_check, caution_rcstyle);


	w = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);


	/* Archive Operations GtkVBox */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	/* Set the units string to reflect "to an archive" */
	or_more_objects_str =
#if defined(PROG_LANGUAGE_SPANISH)
"or more objects to an archive"
#elif defined(PROG_LANGUAGE_FRENCH)
"or more objects to an archive"
#elif defined(PROG_LANGUAGE_GERMAN)
"or more objects to an archive"
#elif defined(PROG_LANGUAGE_ITALIAN)
"or more objects to an archive"
#elif defined(PROG_LANGUAGE_DUTCH)
"or more objects to an archive"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"or more objects to an archive"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"or more objects to an archive"
#elif defined(PROG_LANGUAGE_POLISH)
"or more objects to an archive"
#else
"or more objects to an archive"
#endif
	;

	/* Adding An Object To An Archive */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Agregar"
#elif defined(PROG_LANGUAGE_FRENCH)
"Ajouter"
#elif defined(PROG_LANGUAGE_GERMAN)
"Hinzufgen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Aggiunta"
#elif defined(PROG_LANGUAGE_DUTCH)
"Toevoegen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Adicionar"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Tilfying"
#else
"Adding"
#endif
	;
	CREATE_CHECK(
		icon_archive_add_20x20_xpm,
		"icon_archive_add_20x20_xpm",
		s,
		EDV_CFG_PARM_CONFIRM_ARCHIVE_ADD,
		EDV_CFG_PARM_CONFIRM_ARCHIVE_ADD_NOBJECTS
	);

	/* Set the units string to reflect "from an archive" */
	or_more_objects_str =
#if defined(PROG_LANGUAGE_SPANISH)
"or more objects from an archive"
#elif defined(PROG_LANGUAGE_FRENCH)
"or more objects from an archive"
#elif defined(PROG_LANGUAGE_GERMAN)
"or more objects from an archive"
#elif defined(PROG_LANGUAGE_ITALIAN)
"or more objects from an archive"
#elif defined(PROG_LANGUAGE_DUTCH)
"or more objects from an archive"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"or more objects from an archive"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"or more objects from an archive"
#elif defined(PROG_LANGUAGE_POLISH)
"or more objects from an archive"
#else
"or more objects from an archive"
#endif
	;

	/* Extracting An Object From An Archive */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Extraer"
#elif defined(PROG_LANGUAGE_FRENCH)
"Extraire"
#elif defined(PROG_LANGUAGE_GERMAN)
"Extrahieren"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Estrarre"
#elif defined(PROG_LANGUAGE_DUTCH)
"Onttrekken"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Extrair"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Trekking"
#else
"Extracting"
#endif
	;
	CREATE_CHECK(
		icon_archive_extract_20x20_xpm,
		"icon_archive_extract_20x20_xpm",
		s,
		EDV_CFG_PARM_CONFIRM_ARCHIVE_EXTRACT,
		EDV_CFG_PARM_CONFIRM_ARCHIVE_EXTRACT_NOBJECTS
	);

	/* Deleting An Object In An Archive */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Borrar"
#elif defined(PROG_LANGUAGE_FRENCH)
"Effacer"
#elif defined(PROG_LANGUAGE_GERMAN)
"Lschen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Cancellare"
#elif defined(PROG_LANGUAGE_DUTCH)
"Schrappen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Anular"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Stryking"
#else
"Deleting"
#endif
	;
	CREATE_CHECK(
		icon_cancel_20x20_xpm,
		"icon_cancel_20x20_xpm",
		s,
		EDV_CFG_PARM_CONFIRM_ARCHIVE_DELETE,
		EDV_CFG_PARM_CONFIRM_ARCHIVE_DELETE_NOBJECTS
	);
	/* Set the GtkLabel red for cautionary purposes */
	gtk_widget_modify_style_recursive(w_check, caution_rcstyle);


	w = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);


	/* Other Operations GtkVBox */
	w = gtk_vbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	/* Downloading An Object */
	s =
#if defined(PROG_LANGUAGE_SPANISH)
"Descargar Un Objeto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Tlcharger Un Objet"
#elif defined(PROG_LANGUAGE_GERMAN)
"Laden Eines Objekts"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Scaricare Un Oggetto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Downloaden Van Een Voorwerp"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Download Um Objeto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Downloading Et Objekt"
#else
"Downloading An Object"
#endif
	;
	CREATE_CHECK(
		icon_download_file_20x20_xpm,
		"icon_download_file_20x20_xpm",
		s,
		EDV_CFG_PARM_CONFIRM_DOWNLOAD,
		NULL
	);

#undef CREATE_CHECK
}

/*
 *      Creates the Date & Time Page.
 */
static void EDVCreateOptionsDatePage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
					border_minor = 2;
	gchar *heading[2];
	GSList *gslist;
	gpointer label_rtn, entry_rtn;
	GtkWidget	*w,
					*parent2, *parent3;
	GtkCList *clist;
	EDVOptionsDateFormat *d;
	CfgWinLink *cfg_link;


	/* Relativity GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Tiempo Relativo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Temps Relatif"
#elif defined(PROG_LANGUAGE_GERMAN)
"Abhngigkeit"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Relativit"
#elif defined(PROG_LANGUAGE_DUTCH)
"Relativiteit"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Relativity"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Relativity"
#else
"Relativity"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_minor);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	gslist = NULL;

	/* Absolute GtkRadioButton */
	w = gtk_radio_button_new_with_label(
		gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"Absoluto"
#elif defined(PROG_LANGUAGE_FRENCH)
"Absolu"
#elif defined(PROG_LANGUAGE_GERMAN)
"Absolut"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Assoluto"
#elif defined(PROG_LANGUAGE_DUTCH)
"Absoluut"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Absoluto"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Absolutt"
#else
"Absolute"
#endif
	);
	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto demostrar la fecha & el pariente de cuerdas de tiempo\
 al tiempo del principio of definido para el locale actual"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci pour montrer la date & les ficelles de temps relatives\
 au temps de of premier dfini pour le locale actuel"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen sie dies, datum & zeit schnre verwandten zum beginnen der\
 zeit darzustellen, fr den jetzigen schauplatz hat definiert"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controlla questo mostrare data & tempo relativo all'inizio di tempo\
 definito per l'attuale locale"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit om datum & tijd koorden verwandte aan het beginnen\
 van tijd te tonen voor de huidig locale definieerde"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto exibir data & parente de barbantes de tempo ao comeo\
 de tempo definido para o locale atual"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette vise dato & tidssnorslektning til begynningen av\
 tid-definert for den nvrendee locale"
#else
"Check this to display the date & time strings relative to the\
 start of the Common Era defined by your current locale (default)"
#endif
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_RADIO_BUTTON,
		w,
		EDV_CFG_PARM_DATE_RELATIVITY
	);
	CfgWinLinkSetData(
		cfg_link,
		(gpointer)EDV_DATE_RELATIVITY_ABSOLUTE
	);

	/* Current GtkRadioButton */
	w = gtk_radio_button_new_with_label(
		gslist,
#if defined(PROG_LANGUAGE_SPANISH)
"La Corriente"
#elif defined(PROG_LANGUAGE_FRENCH)
"Courant"
#elif defined(PROG_LANGUAGE_GERMAN)
"Strmung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Corrente"
#elif defined(PROG_LANGUAGE_DUTCH)
"Stroom"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Corrente"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Strm"
#else
"Current"
#endif
	);
/*	gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w)); */
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto demostrar la fecha & el pariente de cuerdas de tiempo\
 al tiempo actual"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci pour montrer la date & les ficelles de temps relatives\
 au temps actuel"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen sie dies, datum & zeit schnre verwandten zum jetzigen mal\
 darzustellen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo per mostrare la data & le cordicelle di tempo\
 relative al tempo attuale"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit om datum & tijd koorden verwandte aan de huidig tijd\
 te tonen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto exibir data & parente de barbantes de tempo ao tempo\
 atual"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette vise dato & tidssnorslektning til den nvrendee tiden"
#else
"Check this to display the date & time strings relative to the\
 current time (example, \"2 days ago\")."
#endif
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_RADIO_BUTTON,
		w,
		EDV_CFG_PARM_DATE_RELATIVITY
	);
	CfgWinLinkSetData(
		cfg_link,
		(gpointer)EDV_DATE_RELATIVITY_CURRENT
	);


	/* Date Format GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Formato De La Fecha"
#elif defined(PROG_LANGUAGE_FRENCH)
"Dater Le Format"
#elif defined(PROG_LANGUAGE_GERMAN)
"Datieren Sie Format"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Datare Il Formato"
#elif defined(PROG_LANGUAGE_DUTCH)
"Dateer Formaat"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Date Formato"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dater Format"
#else
"Date Format"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	/* Date Format GtkVBox */
	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Create Date Format Sample Data */
	d = EDV_DATE_FORMAT_DATA(
		g_malloc0(sizeof(EDVOptionsDateFormat))
	);
	d->freeze_count = 0;

	d->freeze_count++;

	/* Format GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Format GtkEntry */
	w = GUIPromptBar(
		NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Formatear Cuerda"
#elif defined(PROG_LANGUAGE_FRENCH)
"Ficelle De format"
#elif defined(PROG_LANGUAGE_GERMAN)
"Formatieren Sie Schnur"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Cordicella Di formato"
#elif defined(PROG_LANGUAGE_DUTCH)
"Formatteer Koord"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Barbante De Formato"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Formater String"
#else
"Format String"
#endif
		":", &label_rtn, &entry_rtn
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);

	w = (GtkWidget *)entry_rtn;
	d->format_entry = w;
	edv_entry_set_dnd(core, w);
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la cuerda de formato por toda fecha demostrada & los valores\
 de tiempo (vea la lista abajo para sustituciones disponibles)"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer la ficelle de format pour toute date montre & les valeurs\
 de temps (la liste d'vch au dessous pour les remplacements disponibles)"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen die format schnur fr alles dargestellte datum & zeit werte\
 (siehe liste unten fr verfgbaren austausch)"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare la cordicella di formato per tutta la data mostrata & i\
 valori di tempo (vedere l'elenco al di sotto per le sostituzioni disponibili)"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga het formaat koord voor alle getoonde datum & tijd waarde binnen\
 (zie lijst beneden voor verkrijgbare tokens)"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre a barbante de formato para toda data exibida & valores de\
 tempo (veja lista embaixo para substituies disponveis)"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i formatsnoret for all vist dato & tidsverdier (se liste under\
 for tilgjengelige substitusjoner)"
#else
"Enter the format string for displaying all date & time values\
 (see the list below for available tokens)"
#endif
	);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_EDITABLE,
		w,
		EDV_CFG_PARM_DATE_FORMAT
	);
	CfgWinLinkSignalConnectAfter(
		cfg_link,
		"changed",
		EDVOptionsDateFormatChangedCB, d
	);
	CfgWinLinkSignalConnectAfter(
		cfg_link,
		"destroy",
		EDVOptionsDateFormatDestroyCB, d
	);

	/* Result GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Result Entry */
	w = GUIPromptBar(
		NULL,
		"Result:", &label_rtn, &entry_rtn
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	d->result_entry = w;
	gtk_entry_set_editable(GTK_ENTRY(w), FALSE);
	GUIEditableEndowPopupMenu(w, GUI_EDITABLE_POPUP_MENU_READ_ONLY);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_EDITABLE,
		w,
		NULL				/* No parameter */
	);
	CfgWinLinkSetIgnoreChanges(cfg_link, TRUE);


	/* GtkScrolledWindow */
	w = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(
		GTK_SCROLLED_WINDOW(w),
		GTK_POLICY_AUTOMATIC,
		GTK_POLICY_AUTOMATIC
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Tokens GtkCList */
	heading[0] = "Token";
	heading[1] = "Description";
	d->tokens_clist = w = gtk_clist_new_with_titles(
		sizeof(heading) / sizeof(gchar *),
		heading
	);
	clist = GTK_CLIST(w);
	gtk_widget_add_events(
		w,
		GDK_STRUCTURE_MASK | GDK_EXPOSURE_MASK |
		GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK |
		GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK |
		GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK |
		GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK
	);
	gtk_signal_connect_after(
		GTK_OBJECT(w), "map_event",
		GTK_SIGNAL_FUNC(EDVOptionsDateTokensListEventCB), d
	);
	gtk_signal_connect_after(
		GTK_OBJECT(w), "unmap_event",
		GTK_SIGNAL_FUNC(EDVOptionsDateTokensListEventCB), d
	);
	gtk_signal_connect(
		GTK_OBJECT(w), "key_press_event",
		GTK_SIGNAL_FUNC(edv_clist_key_event_cb), core
	);
	gtk_signal_connect(
		GTK_OBJECT(w), "key_release_event",
		GTK_SIGNAL_FUNC(edv_clist_key_event_cb), core
	);
	gtk_signal_connect(
		GTK_OBJECT(w), "button_press_event",
		GTK_SIGNAL_FUNC(edv_clist_button_event_cb), core
	);
	gtk_signal_connect(
		GTK_OBJECT(w), "button_release_event",
		GTK_SIGNAL_FUNC(edv_clist_button_event_cb), core
	);
	gtk_signal_connect(
		GTK_OBJECT(w), "motion_notify_event",
		GTK_SIGNAL_FUNC(edv_clist_motion_event_cb), core
	);
	gtk_signal_connect(
		GTK_OBJECT(w), "select_row",
		GTK_SIGNAL_FUNC(EDVOptionsDateTokensListSelectRowCB), d
	);
	gtk_signal_connect(
		GTK_OBJECT(w), "unselect_row",
		GTK_SIGNAL_FUNC(EDVOptionsDateTokensListUnselectRowCB), d
	);
	gtk_container_add(GTK_CONTAINER(parent3), w);
	gtk_clist_column_titles_passive(clist);
	gtk_clist_set_shadow_type(clist, GTK_SHADOW_IN);
	gtk_clist_set_column_auto_resize(clist, 0, TRUE);
	gtk_clist_set_column_resizeable(clist, 0, TRUE);
	gtk_clist_set_column_justification(   
		clist, 0, GTK_JUSTIFY_LEFT
	);
	gtk_clist_set_column_auto_resize(clist, 1, TRUE);
	gtk_clist_set_column_resizeable(clist, 1, TRUE);
	gtk_clist_set_column_justification(
		clist, 1, GTK_JUSTIFY_LEFT
	);
	gtk_clist_set_selection_mode(clist, GTK_SELECTION_SINGLE);
	gtk_clist_set_row_height(clist, EDV_LIST_ROW_SPACING);
	if(w != NULL)
	{
		const GtkTargetEntry dnd_src_types[] = {
{GUI_TARGET_NAME_TEXT_PLAIN,	0,	EDV_DND_INFO_TEXT_PLAIN},
{GUI_TARGET_NAME_TEXT_URI_LIST,	0,	EDV_DND_INFO_TEXT_URI_LIST},
{GUI_TARGET_NAME_STRING,	0,	EDV_DND_INFO_STRING}
		};
		GUIDNDSetSrc(
			w,
			dnd_src_types,
			sizeof(dnd_src_types) / sizeof(GtkTargetEntry),
			GDK_ACTION_COPY,		/* Actions */
			GDK_BUTTON1_MASK,		/* Buttons */
			NULL,
			EDVOptionsDateTokensListDragDataGetCB,
			NULL,
			NULL,
			d
		);
	}
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_CLIST,
		w,
		NULL				/* No parameter */
	);
	CfgWinLinkSetIgnoreChanges(cfg_link, TRUE);

	/* Buttons GtkHBox */
	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Insert GtkButton */
	d->tokens_insert_btn = w = GUIButtonPixmapLabelH(
		(guint8 **)icon_add_20x20_xpm, "Insert", NULL
	);
	gtk_widget_set_usize(
		w,
		GUI_BUTTON_HLABEL_WIDTH, GUI_BUTTON_HLABEL_HEIGHT
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsDateInsertTokenCB), d
	);
	GUISetWidgetTip(
		w,
"Click this to insert the selected token into the Date Format String"
	);
	gtk_widget_set_sensitive(w, FALSE);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_BUTTON,
		w,
		NULL				/* No parameter */
	);
	CfgWinLinkSetIgnoreChanges(cfg_link, TRUE);


	d->freeze_count--;
}

/*
 *	Creates the Mount Page.
 */
static void EDVCreateOptionsMountPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
					border_minor = 2;
	GtkAdjustment *adj;
	GtkWidget	*w,
					*parent2, *parent3, *parent4;
	CfgWinLink *cfg_link;

	/* Mount GtkFrame */
	w = gtk_frame_new("Mount");
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;


	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Check Mount States Interval */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	w = gtk_label_new("Check Mount States Interval:");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Check Mount States Interval  GtkSpinButton */
	adj = (GtkAdjustment *)gtk_adjustment_new(
		0.0f, 0.0f, (gfloat)((guint32)-1),
		1.0f, 10.0f, 10.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 80, -1);
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
"Set the interval to check the mount states of all the removable\
 devices or set this to 0 for no check"
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_SPIN_BUTTON,
		w,
		EDV_CFG_PARM_CHECK_MOUNT_STATES_INT
	);

	/* Units GtkLabel */
	w = gtk_label_new("seconds");
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);


	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Query Unmount Before Exit GtkCheckButton */
	w = gtk_check_button_new_with_label(
"Query Unmount Before Exit"
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	GUISetWidgetTip(
		w,
"Check this to ask about unmounting removable devices before exiting"
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_TOGGLE_BUTTON,
		w,
		EDV_CFG_PARM_QUERY_UNMOUNT_BEFORE_EXIT
	);


	/* Devices GtkButton */
	w = GUIButtonPixmapLabelH(
		(guint8 **)icon_devices_list_20x20_xpm,
		"Devices...",
		NULL
	);
	gtk_widget_set_usize(
		w,
		GUI_BUTTON_HLABEL_WIDTH, GUI_BUTTON_HLABEL_HEIGHT
	);
	gtk_box_pack_end(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(edv_devices_cb), core
	);
	GUISetWidgetTip(
		w,
"Click this to configure the devices"
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_BUTTON,
		w,
		NULL				/* No parameter */
	);
	CfgWinLinkSetIgnoreChanges(cfg_link, TRUE);


}

/*
 *	Creates the Sound Page.
 */
static void EDVCreateOptionsSoundsPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
					border_minor = 2;
	gint i;
	gpointer label_rtn, entry_rtn, browse_rtn;
	GtkWidget	*w,
					*parent2, *parent3,
					*pulist;
	CfgWinLink	*cfg_link,
							*sound_output_cfg_link;

	/* Output GtkFrame */
	w = gtk_frame_new("Output");
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Sound Output */
	w = PUListBoxNew(
		200, -1
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	pulist = PUListBoxGetPUList(w);
	if(core->run_flags & EDV_RUN_SAFE_MODE)
		PUListSetShadowStyle(pulist, PULIST_SHADOW_NONE);
#define APPEND_ITEM(_s_,_v_)	{	\
 i = PUListAddItem(pulist, (_s_));	\
 PUListSetItemData(			\
  pulist,				\
  i,					\
  (gpointer)(_v_)			\
 );					\
}
	APPEND_ITEM("None",		EDV_SOUND_OUTPUT_NONE);
	APPEND_ITEM("Command",		EDV_SOUND_OUTPUT_COMMAND);
	APPEND_ITEM("GDK",		EDV_SOUND_OUTPUT_GDK);
#undef APPEND_ITEM
	PUListBoxSetLinesVisible(w, MIN((i + 1), 10));
	gtk_widget_show(w);
	sound_output_cfg_link = cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_POPUP_LIST_BOX,
		w,
		EDV_CFG_PARM_SOUND_OUTPUT
	);


	/* Commands GtkFrame */
	w = gtk_frame_new("Commands");
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	/* Set the Commands GtkFrame as the widget to set
	 * sensitive/insensitive when the Sound Output Popup List
	 * Box changes value
	 */
	CfgWinLinkSignalConnectAfter(
		sound_output_cfg_link,
		"changed",
		EDVOptionsSoundOutputChangedCB, w
	);

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Play Beep Sound Command */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	w = GUIPromptBarWithBrowse(
		NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Orden Sonido Juego \"Beep\""
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Ordre Son \"Beep\" Pice"
#elif defined(PROG_LANGUAGE_GERMAN)
"Spielen \"Beep\" Gesunden Befehl"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Comando Suono \"Beep\" Gioco"
#elif defined(PROG_LANGUAGE_DUTCH)
"Speel \"Beep\" Geluid Bevel"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Comando Som \"Beep\" Jogo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Lek \"Beep\" Sunn Kommando"
#else 
"Play \"Beep\" Sound Command"
#endif
		":", &label_rtn, &entry_rtn, &browse_rtn,
		 NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la orden que jugar un sonido para todos acontecimientos\
 de \"Beep\" o saldr este blanco para no jugar un sonido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer l'ordre qui jouera un son pour tous vnements de \"Beep\" ou\
 part ce vide pour ne pas jouer un son"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie den befehl, der einen klang fr alle \"Beep\" ereignisse\
 spielen wird, ein oder verlassen sie diese leerstelle, keinen\
 klang zu spielen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare il comando che giocher un suono per tutto gli\
 avvenimenti di \"Beep\" o lasciare lo spazio vuoto di questo per non\
 di giocare un suono"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga het bevel dat een geluid voor alle \"Beep\" gebeurtenissen\
 spelen zal binnen of verlaat deze leegte om geen geluid te\
 spelen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre o comando que jogar um som para todos acontecimentos\
 de \"Beep\" ou saia desta lacuna no jogar um som"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i kommandoen som leker en lyd for all \"Beep\" begivenheter\
 eller forlate dette tomromet ikke leke en lyd"
#else
"Enter the command that will play a sound for all \"Beep\" events\
 or leave this blank to not play a sound"
#endif
	);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_EDITABLE,
		w,
		EDV_CFG_PARM_SOUND_PLAY_BEEP
	);
	w = (GtkWidget *)browse_rtn;
#if defined(PROG_LANGUAGE_FRENCH)
	GUISetWidgetTip(w, "Parcourir");
#else
	GUISetWidgetTip(w, "Browse");
#endif
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsBrowseProgramCB), entry_rtn
	);
	w = GUIButtonPixmap(
		(guint8 **)icon_run_20x20_xpm
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsRunCB), cfg_link
	);
	GUISetWidgetTip(w, "Test"); 
	gtk_widget_show(w);


	/* Play Info Sound Command */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	w = GUIPromptBarWithBrowse(
		NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Orden Sonido Juego \"Info\""
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Ordre Son \"Info\" Pice"
#elif defined(PROG_LANGUAGE_GERMAN)
"Spielen \"Info\" Gesunden Befehl"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Comando Suono \"Info\" Gioco"
#elif defined(PROG_LANGUAGE_DUTCH)
"Speel \"Info\" Geluid Bevel"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Comando Som \"Info\" Jogo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Lek \"Info\" Sunn Kommando"
#else
"Play \"Info\" Sound Command"
#endif
		":", &label_rtn, &entry_rtn, &browse_rtn,
		 NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la orden que jugar un sonido para todos acontecimientos\
 de \"Info\" o saldr este blanco para no jugar un sonido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer l'ordre qui jouera un son pour tous vnements de \"Info\" ou\
 part ce vide pour ne pas jouer un son"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie den befehl, der einen klang fr alle \"Info\" ereignisse\
 spielen wird, ein oder verlassen sie diese leerstelle, keinen\
 klang zu spielen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare il comando che giocher un suono per tutto gli\
 avvenimenti di \"Info\" o lasciare lo spazio vuoto di questo per non\
 di giocare un suono"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga het bevel dat een geluid voor alle \"Info\" gebeurtenissen\
 spelen zal binnen of verlaat deze leegte om geen geluid te\
 spelen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre o comando que jogar um som para todos acontecimentos\
 de \"Info\" ou saia desta lacuna no jogar um som"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i kommandoen som leker en lyd for all \"Info\" begivenheter\
 eller forlate dette tomromet ikke leke en lyd"
#else
"Enter the command that will play a sound for all \"Info\" events\
 or leave this blank to not play a sound"
#endif
	);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_EDITABLE,
		w,
		EDV_CFG_PARM_SOUND_PLAY_INFO
	);
	w = (GtkWidget *)browse_rtn;
#if defined(PROG_LANGUAGE_FRENCH)
	GUISetWidgetTip(w, "Parcourir");
#else
	GUISetWidgetTip(w, "Browse");
#endif
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsBrowseProgramCB), entry_rtn
	);
	w = GUIButtonPixmap(
		(guint8 **)icon_run_20x20_xpm
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsRunCB), cfg_link
	);
	GUISetWidgetTip(w, "Test");
	gtk_widget_show(w);

	/* Play Question Sound */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	w = GUIPromptBarWithBrowse(
		NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Orden Sonido Juego \"Question\""
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Ordre Son \"Question\" Pice"
#elif defined(PROG_LANGUAGE_GERMAN)
"Spielen \"Question\" Gesunden Befehl"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Comando Suono \"Question\" Gioco"
#elif defined(PROG_LANGUAGE_DUTCH)
"Speel \"Question\" Geluid Bevel"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Comando Som \"Question\" Jogo"         
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Lek \"Question\" Sunn Kommando"
#else
"Play \"Question\" Sound Command"
#endif
		":", &label_rtn, &entry_rtn, &browse_rtn,
		 NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w, 
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la orden que jugar un sonido para todos acontecimientos\
 de \"Question\" o saldr este blanco para no jugar un sonido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer l'ordre qui jouera un son pour tous vnements de \"Question\" ou\
 part ce vide pour ne pas jouer un son"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie den befehl, der einen klang fr alle \"Question\" ereignisse\
 spielen wird, ein oder verlassen sie diese leerstelle, keinen\
 klang zu spielen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare il comando che giocher un suono per tutto gli\
 avvenimenti di \"Question\" o lasciare lo spazio vuoto di questo per non\
 di giocare un suono"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga het bevel dat een geluid voor alle \"Question\" gebeurtenissen\
 spelen zal binnen of verlaat deze leegte om geen geluid te\
 spelen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre o comando que jogar um som para todos acontecimentos\
 de \"Question\" ou saia desta lacuna no jogar um som"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i kommandoen som leker en lyd for all \"Question\" begivenheter\
 eller forlate dette tomromet ikke leke en lyd"
#else 
"Enter the command that will play a sound for all \"Question\" events\
 or leave this blank to not play a sound"
#endif
	);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_EDITABLE,
		w,
		EDV_CFG_PARM_SOUND_PLAY_QUESTION
	);
	w = (GtkWidget *)browse_rtn;
#if defined(PROG_LANGUAGE_FRENCH)
	GUISetWidgetTip(w, "Parcourir");
#else
	GUISetWidgetTip(w, "Browse");
#endif
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsBrowseProgramCB), entry_rtn
	);
	w = GUIButtonPixmap(
		(guint8 **)icon_run_20x20_xpm
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsRunCB), cfg_link
	);
	GUISetWidgetTip(w, "Test");
	gtk_widget_show(w);

	/* Play Warning Sound */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w); 
	parent3 = w;
	w = GUIPromptBarWithBrowse(
		NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Orden Sonido Juego \"Warning\""
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Ordre Son \"Warning\" Pice"
#elif defined(PROG_LANGUAGE_GERMAN)
"Spielen \"Warning\" Gesunden Befehl"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Comando Suono \"Warning\" Gioco"
#elif defined(PROG_LANGUAGE_DUTCH)
"Speel \"Warning\" Geluid Bevel"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Comando Som \"Warning\" Jogo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Lek \"Warning\" Sunn Kommando"
#else
"Play \"Warning\" Sound Command"
#endif  
		":", &label_rtn, &entry_rtn, &browse_rtn,
		 NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la orden que jugar un sonido para todos acontecimientos\
 de \"Warning\" o saldr este blanco para no jugar un sonido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer l'ordre qui jouera un son pour tous vnements de \"Warning\" ou\
 part ce vide pour ne pas jouer un son"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie den befehl, der einen klang fr alle \"Warning\" ereignisse\
 spielen wird, ein oder verlassen sie diese leerstelle, keinen\
 klang zu spielen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare il comando che giocher un suono per tutto gli\
 avvenimenti di \"Warning\" o lasciare lo spazio vuoto di questo per non\
 di giocare un suono"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga het bevel dat een geluid voor alle \"Warning\" gebeurtenissen\
 spelen zal binnen of verlaat deze leegte om geen geluid te\
 spelen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre o comando que jogar um som para todos acontecimentos\
 de \"Warning\" ou saia desta lacuna no jogar um som"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i kommandoen som leker en lyd for all \"Warning\" begivenheter\
 eller forlate dette tomromet ikke leke en lyd"
#else
"Enter the command that will play a sound for all \"Warning\" events\
 or leave this blank to not play a sound"
#endif
	);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_EDITABLE,
		w,
		EDV_CFG_PARM_SOUND_PLAY_WARNING
	);
	w = (GtkWidget *)browse_rtn;
#if defined(PROG_LANGUAGE_FRENCH)
	GUISetWidgetTip(w, "Parcourir");
#else
	GUISetWidgetTip(w, "Browse");
#endif
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsBrowseProgramCB), entry_rtn
	);
	w = GUIButtonPixmap(
		(guint8 **)icon_run_20x20_xpm
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsRunCB), cfg_link
	);
	GUISetWidgetTip(w, "Test");
	gtk_widget_show(w);

	/* Play Error Sound */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	w = GUIPromptBarWithBrowse(
		NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Orden Sonido Juego \"Error\""
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Ordre Son \"Error\" Pice"
#elif defined(PROG_LANGUAGE_GERMAN)
"Spielen \"Error\" Gesunden Befehl"      
#elif defined(PROG_LANGUAGE_ITALIAN)
"Comando Suono \"Error\" Gioco"
#elif defined(PROG_LANGUAGE_DUTCH)
"Speel \"Error\" Geluid Bevel"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Comando Som \"Error\" Jogo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Lek \"Error\" Sunn Kommando"
#else
"Play \"Error\" Sound Command"
#endif
		":", &label_rtn, &entry_rtn, &browse_rtn,
		 NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la orden que jugar un sonido para todos acontecimientos\
 de \"Error\" o saldr este blanco para no jugar un sonido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer l'ordre qui jouera un son pour tous vnements de \"Error\" ou\
 part ce vide pour ne pas jouer un son"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie den befehl, der einen klang fr alle \"Error\" ereignisse\
 spielen wird, ein oder verlassen sie diese leerstelle, keinen\
 klang zu spielen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare il comando che giocher un suono per tutto gli\
 avvenimenti di \"Error\" o lasciare lo spazio vuoto di questo per non\
 di giocare un suono"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga het bevel dat een geluid voor alle \"Error\" gebeurtenissen\
 spelen zal binnen of verlaat deze leegte om geen geluid te\
 spelen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre o comando que jogar um som para todos acontecimentos\
 de \"Error\" ou saia desta lacuna no jogar um som"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i kommandoen som leker en lyd for all \"Error\" begivenheter\
 eller forlate dette tomromet ikke leke en lyd"
#else
"Enter the command that will play a sound for all \"Error\" events\
 or leave this blank to not play a sound"
#endif
	);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_EDITABLE,
		w,
		EDV_CFG_PARM_SOUND_PLAY_ERROR
	);
	w = (GtkWidget *)browse_rtn;
#if defined(PROG_LANGUAGE_FRENCH)
	GUISetWidgetTip(w, "Parcourir");
#else
	GUISetWidgetTip(w, "Browse");
#endif
	gtk_signal_connect( 
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsBrowseProgramCB), entry_rtn
	);
	w = GUIButtonPixmap(
		(guint8 **)icon_run_20x20_xpm
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsRunCB), cfg_link
	);
	GUISetWidgetTip(w, "Test");
	gtk_widget_show(w);

	/* Play Operation Completed Sound Command */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	w = GUIPromptBarWithBrowse(
		NULL,
#if defined(PROG_LANGUAGE_SPANISH)
"Orden Sonido Juego \"Operation Completed\""
#elif defined(PROG_LANGUAGE_FRENCH)
"L'Ordre Son \"Operation Completed\" Pice"
#elif defined(PROG_LANGUAGE_GERMAN)
"Spielen \"Operation Completed\" Gesunden Befehl"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Comando Suono \"Operation Completed\" Gioco"
#elif defined(PROG_LANGUAGE_DUTCH)
"Speel \"Operation Completed\" Geluid Bevel"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Comando Som \"Operation Completed\" Jogo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Lek \"Operation Completed\" Sunn Kommando"
#else 
"Play \"Operation Completed\" Sound Command"
#endif
		":", &label_rtn, &entry_rtn, &browse_rtn,
		 NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre la orden que jugar un sonido para todos acontecimientos\
 de \"Operation Completed\" o saldr este blanco para no jugar un sonido"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer l'ordre qui jouera un son pour tous vnements de \"Operation Completed\" ou\
 part ce vide pour ne pas jouer un son"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie den befehl, der einen klang fr alle \"Operation Completed\" ereignisse\
 spielen wird, ein oder verlassen sie diese leerstelle, keinen\
 klang zu spielen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare il comando che giocher un suono per tutto gli\
 avvenimenti di \"Operation Completed\" o lasciare lo spazio vuoto di questo per non\
 di giocare un suono"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga het bevel dat een geluid voor alle \"Operation Completed\" gebeurtenissen\
 spelen zal binnen of verlaat deze leegte om geen geluid te\
 spelen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre o comando que jogar um som para todos acontecimentos\
 de \"Operation Completed\" ou saia desta lacuna no jogar um som"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i kommandoen som leker en lyd for all \"Operation Completed\" begivenheter\
 eller forlate dette tomromet ikke leke en lyd"
#else
"Enter the command that will play a sound for all \"Operation Completed\" events\
 or leave this blank to not play a sound"
#endif
	);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_EDITABLE,
		w,
		EDV_CFG_PARM_SOUND_PLAY_COMPLETED
	);
	w = (GtkWidget *)browse_rtn;
#if defined(PROG_LANGUAGE_FRENCH)
	GUISetWidgetTip(w, "Parcourir");
#else
	GUISetWidgetTip(w, "Browse");
#endif
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsBrowseProgramCB), entry_rtn
	);
	w = GUIButtonPixmap(
		(guint8 **)icon_run_20x20_xpm
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsRunCB), cfg_link
	);
	GUISetWidgetTip(w, "Test");
	gtk_widget_show(w);
}

/*
 *	Creates the History Page.
 */
static void EDVCreateOptionsHistoryPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
					border_minor = 2;
	gpointer entry_rtn, browse_rtn;
	GtkAdjustment *adj;
	GtkWidget *w, *parent2, *parent3, *parent4;
	CfgWinLink *cfg_link;


	/* All GtkFrame */
	w = gtk_frame_new("All");
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Clear All History Button */
	w = GUIButtonPixmapLabelH(
		(guint8 **)icon_clear_20x20_xpm,
#if defined(PROG_LANGUAGE_SPANISH)
"Claro"
#elif defined(PROG_LANGUAGE_FRENCH)
"Clair"
#elif defined(PROG_LANGUAGE_GERMAN)
"Klar"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Chiaro"
#elif defined(PROG_LANGUAGE_DUTCH)
"Helder"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Claro"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Klar"
#else
"Clear All History"
#endif
		, NULL
	);
	gtk_widget_set_usize(
		w,
		-1, GUI_BUTTON_HLABEL_HEIGHT
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(edv_clear_all_history_cb), core
	);
	GUISetWidgetTip(
		w,
"Click to clear all of " PROG_NAME "'s history from memory and\
 delete all of " PROG_NAME "'s history files"
	);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_BUTTON,
		w,
		NULL				/* No parameter */
	);
	CfgWinLinkSetIgnoreChanges(cfg_link, TRUE);
	gtk_widget_show(w);


	/* Events GtkFrame */
	w = gtk_frame_new("Events");
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Events History File GtkHBox */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Events History File Prompt */
	w = GUIPromptBarWithBrowse(
		(guint8 **)icon_trace_20x20_xpm,
		NULL,
		NULL,
		&entry_rtn,
		&browse_rtn,
		NULL, NULL
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	w = (GtkWidget *)entry_rtn;
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"Entre el archivo del tronco de la historia"
#elif defined(PROG_LANGUAGE_FRENCH)
"Entrer le fichier de journal de bord d'histoire"
#elif defined(PROG_LANGUAGE_GERMAN)
"Tragen sie die geschichte klotz akte ein"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Entrare il file di ceppo di storia"
#elif defined(PROG_LANGUAGE_DUTCH)
"Ga het geschiedenis boomstronk dossier binnen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Entre o arquivo de tora de histria"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"G inn i historieloggarkivet"
#else
"Enter the path to the Events History File"
#endif
	);
	edv_entry_set_dnd(core, w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_EDITABLE,
		w,
		EDV_CFG_PARM_FILE_HISTORY
	);
	w = (GtkWidget *)browse_rtn;
#if defined(PROG_LANGUAGE_FRENCH)
	GUISetWidgetTip(w, "Parcourir");
#else
	GUISetWidgetTip(w, "Browse");
#endif
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsBrowseCB), entry_rtn
	);


	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* History Events Max */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* Label */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Los Acontecimientos Mximos"
#elif defined(PROG_LANGUAGE_FRENCH)
"Evnements Maximums"
#elif defined(PROG_LANGUAGE_GERMAN)
"Maximale Ereignisse"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Gli Avvenimenti Massimi"
#elif defined(PROG_LANGUAGE_DUTCH)
"Maximale Gebeurtenissen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Acontecimentos Mximos"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Maksimum Begivenheter"
#else
"Maximum Events"
#endif
		":"
	);
	gtk_label_set_justify(GTK_LABEL(w), GTK_JUSTIFY_RIGHT);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	/* GtkSpinButton */
	adj = (GtkAdjustment *)gtk_adjustment_new(
		0.0f, 0.0f, 1000000.0f,
		10.0f, 100.0f, 100.0f
	);
	w = gtk_spin_button_new(adj, 1.0, 0);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_widget_set_usize(w, 80, -1);
	GUIEditableEndowPopupMenu(w, 0);
	GUISetWidgetTip(
		w,
"Set the maximum number of events to log, or set this\
 to 0 for no maximum"
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_SPIN_BUTTON,
		w,
		EDV_CFG_PARM_HISTORY_EVENTS_MAX
	);


	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent3), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent4 = w;

	/* Clear Events History Button */
	w = GUIButtonPixmapLabelH(
		(guint8 **)icon_clear_20x20_xpm,
#if defined(PROG_LANGUAGE_SPANISH)
"Claro"
#elif defined(PROG_LANGUAGE_FRENCH)
"Clair"
#elif defined(PROG_LANGUAGE_GERMAN)
"Klar"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Chiaro"
#elif defined(PROG_LANGUAGE_DUTCH)
"Helder"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Claro"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Klar"
#else
"Clear"
#endif
		, NULL
	);
	gtk_widget_set_usize(
		w,
		GUI_BUTTON_HLABEL_WIDTH, GUI_BUTTON_HLABEL_HEIGHT
	);
	gtk_box_pack_end(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(edv_clear_events_history_cb), core
	);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"El clic para borrar los acontecimientos de la historia apuntan el archivo"
#elif defined(PROG_LANGUAGE_FRENCH)
"Le dclic pour effacer les vnements d'histoire notent le fichier"
#elif defined(PROG_LANGUAGE_GERMAN)
"Klicken, den geschichte ereignisse klotz zu lschen, legt ab"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo scatto di cancellare gli avvenimenti di storia abbattono il file"
#elif defined(PROG_LANGUAGE_DUTCH)
"Klik het geschiedenis gebeurtenissen boomstronk dossier te schrappen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O estalido anular os acontecimentos de histria registrar arquivo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Klikk stryke historie begiven hets loggar kivet"
#else
"Click to delete the Events History File"
#endif
	);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_BUTTON,
		w,
		NULL				/* No parameter */
	);
	CfgWinLinkSetIgnoreChanges(cfg_link, TRUE);
	gtk_widget_show(w);

	/* View History Events Button */
	w = GUIButtonPixmapLabelH(
		(guint8 **)icon_search_20x20_xpm,
		"View",
		NULL
	);
	gtk_widget_set_usize(
		w,
		GUI_BUTTON_HLABEL_WIDTH, GUI_BUTTON_HLABEL_HEIGHT
	);
	gtk_box_pack_end(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsViewHistoryCB), core
	);
	GUISetWidgetTip(
		w,
"Click to view the Events History"
	);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_BUTTON,
		w,
		NULL				/* No parameter */
	);
	CfgWinLinkSetIgnoreChanges(cfg_link, TRUE);
	gtk_widget_show(w);


	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;


	/* Location Bars GtkFrame */
	w = gtk_frame_new("Location Bars");
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Clear Location Bars History Button */
	w = GUIButtonPixmapLabelH(
		(guint8 **)icon_clear_20x20_xpm,
		"Clear",
		NULL
	);
	gtk_widget_set_usize(
		w,
		GUI_BUTTON_HLABEL_WIDTH, GUI_BUTTON_HLABEL_HEIGHT
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(edv_clear_location_bars_history_cb), core
	);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"El clic para borrar los Archivos del Tronco de la Historia de Ubicaciones"
#elif defined(PROG_LANGUAGE_FRENCH)
"Le dclic pour effacer les Fichiers de Journal de bord d'Histoire d'Emplacements"
#elif defined(PROG_LANGUAGE_GERMAN)
"Klicken, die Orte Geschichte Klotz Akten zu lschen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo scatto di cancellare i File di Ceppo di Storia di Posizioni"
#elif defined(PROG_LANGUAGE_DUTCH)
"Klik de Plaatzen Geschiedenis Boomstronk te schrappen Archiveert"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O estalido anular os Arquivos de Tora de Histria de Localidades"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Klikk stryke plasserings historie logg Arkivene"
#else
"Click to delete the Locations Bars History Files"
#endif
	);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_BUTTON,
		w,
		NULL				/* No parameter */
	);
	CfgWinLinkSetIgnoreChanges(cfg_link, TRUE);
	gtk_widget_show(w);


	/* Run GtkFrame */
	w = gtk_frame_new("Run");
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Clear Run History Button */
	w = GUIButtonPixmapLabelH(
		(guint8 **)icon_clear_20x20_xpm,
#if defined(PROG_LANGUAGE_SPANISH)
"Claro"
#elif defined(PROG_LANGUAGE_FRENCH)
"Clair"
#elif defined(PROG_LANGUAGE_GERMAN)
"Klar"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Chiaro"
#elif defined(PROG_LANGUAGE_DUTCH)
"Helder"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Claro"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Klar"
#else
"Clear"
#endif
		, NULL
	);
	gtk_widget_set_usize(
		w,
		GUI_BUTTON_HLABEL_WIDTH, GUI_BUTTON_HLABEL_HEIGHT
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(edv_clear_run_history_cb), core
	);
	GUISetWidgetTip(
		w,
#if defined(PROG_LANGUAGE_SPANISH)
"El clic para borrar el Corre la Historia el Archivo del Tronco"
#elif defined(PROG_LANGUAGE_FRENCH)
"Le dclic pour effacer le Fichier de Journal de bord d'Histoire de Course"
#elif defined(PROG_LANGUAGE_GERMAN)
"Klicken, die Lauf Geschichte Klotz Akte zu lschen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Lo scatto di cancellare il Ha Corso il File di Ceppo di Storia"
#elif defined(PROG_LANGUAGE_DUTCH)
"Klik het Tocht Geschiedenis Boomstronk Dossier te schrappen"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O estalido anular o Arquivo de Tora de Histria de Corrida"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Klikk stryke lphistorie logg Arkivet"
#else
"Click to delete the Run History File"
#endif
	);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_BUTTON,
		w,
		NULL				/* No parameter */
	);
	CfgWinLinkSetIgnoreChanges(cfg_link, TRUE);
	gtk_widget_show(w);
}

/*
 *	Creates the Misc Page.
 */
static void EDVCreateOptionsMiscPage(
	EDVCore *core,
	GtkWidget *cfgwin,
	GtkWidget *parent
)
{
	const gint	border_major = 5,
					border_minor = 2;
	GtkWidget	*w,
					*parent2, *parent3, *parent4;
	CfgWinLink *cfg_link;

	/* Memory GtkFrame */
	w = gtk_frame_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Memoria"
#elif defined(PROG_LANGUAGE_FRENCH)
"Mmoire"
#elif defined(PROG_LANGUAGE_GERMAN)
"Erinnerung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Memoria"
#elif defined(PROG_LANGUAGE_DUTCH)
"Herinnering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Memria"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Hukommelse"
#else
"Memory"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;
	w = edv_new_pixmap_widget(
		core,
		(edv_pixmap_data *)icon_memory_32x32_xpm,
		"icon_memory_32x32_xpm"
	);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	w = gtk_vbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Conserve Memory */
	w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;
	/* GtkCheckButton */
	w = gtk_check_button_new_with_label(
#if defined(PROG_LANGUAGE_SPANISH)
"Conserve La Memoria"
#elif defined(PROG_LANGUAGE_FRENCH)
"Prserver La Mmoire"
#elif defined(PROG_LANGUAGE_GERMAN)
"Konservieren Sie Erinnerung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Conservare La Memoria"
#elif defined(PROG_LANGUAGE_DUTCH)
"Bewaar Herinnering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Conserve Memria"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Konserver Hukommelse"
#else
"Conserve Memory"
#endif
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	GUISetWidgetTip(w,
#if defined(PROG_LANGUAGE_SPANISH)
"Verifique esto aminorar el uso de la memoria (esto puede ir ms\
 despacio el desempeo e incapacitar guardar de recursos)"
#elif defined(PROG_LANGUAGE_FRENCH)
"Vrifier ceci pour minimiser l'usage de mmoire (ceci peut ralentir\
 l'excution et rend infirme cache de ressources)"
#elif defined(PROG_LANGUAGE_GERMAN)
"Prfen sie dies, speichergebrauch (dies kann verlangsamen leistung\
 und machen zu minimieren, unwirksam aufnehmend in den cachespeicher\
 von ressourcen)"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Controllare questo per minimizzare l'uso di memoria (questo pu\
 rallentare l'esecuzione e  incapace il caching di risorse)"
#elif defined(PROG_LANGUAGE_DUTCH)
"Controleer dit om herinnering gebruik (deze Mei vertraagt\
 prestatie te minimaliseren en maak onbruikbaar caching van\
 hulpbronnen)"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Verifique isto reduzir uso de memria (isto vai mais devagar\
 desempenho e incapacita esconde de recursos)"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Sjekk dette minimalisere hukommelsesbruk (dette kan saktner\
 prestasjon og udyktiggjr caching av ressurser)"
#else
"Check this to minimize memory use (this may slow down performance\
 and disable caching of resources)"
#endif
	);
	gtk_widget_show(w);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_TOGGLE_BUTTON,
		w,
		EDV_CFG_PARM_CONSERVE_MEMORY
	);


	/* Messages GtkFrame */
	w = gtk_frame_new("Messages");
	gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_add(GTK_CONTAINER(parent2), w);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_widget_show(w);
	parent2 = w;

	w = gtk_hbox_new(FALSE, border_major);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

	/* Reset "No More Messages" Button */
	w = gtk_vbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent4 = w;

	w = GUIButtonPixmapLabelH(
		(guint8 **)icon_revert_20x20_xpm,
		"Reset All \"No More Messages\"",
		NULL
	);
	gtk_widget_set_usize(
		w,
		-1, GUI_BUTTON_HLABEL_HEIGHT
	);
	gtk_box_pack_start(GTK_BOX(parent4), w, TRUE, FALSE, 0);
	if(core->run_flags & EDV_RUN_SAFE_MODE)
		gtk_widget_set_sensitive(w, FALSE);
	gtk_signal_connect(
		GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(EDVOptionsWinResetNoMoreMessagesCB), core
	);
	GUISetWidgetTip(
		w,
"Click this to (re)enable the displaying of all console messages (stdout and\
 stderr messages) in dialogs again."
	);
	cfg_link = CfgWinAddLink(
		cfgwin,
		parent,
		CFG_WIN_LINK_WIDGET_BUTTON,
		w,
		NULL				/* No parameter */
	);
	CfgWinLinkSetIgnoreChanges(cfg_link, TRUE);
	gtk_widget_show(w);

}


/*
 *	Switches to the notebook page by tab name.
 *
 *	Returns TRUE if a valid page was switched to or FALSE on error.
 */
gboolean EDVOptionsWindowSelectTab(
	GtkWidget *cfgwin,
	const gchar *tab_name
)
{
	gboolean status;

	if(cfgwin == NULL)
		return(FALSE);

	if(STRISEMPTY(tab_name))
	{
		CfgWinSetPage(
			cfgwin,
			NULL				/* Default page */
		);
		status = TRUE;
	}
	else
	{
		GtkWidget *page = CfgWinGetPageByLabel(
			cfgwin,
			NULL,				/* Toplevel page */
			tab_name,			/* Label */
			FALSE				/* Do not recurse */
		);
		if(page != NULL)
		{
			CfgWinSetPage(
				cfgwin,
				page
			);
			status = TRUE;
		}
		else
		{
			status = FALSE;
		}
	}

	return(status);
}

/*
 *	Creates a new Options Window.
 */
GtkWidget *EDVOptionsWindowNew(
	EDVCore *core,
	const GdkGeometryFlags geometry_flags,
	const GdkRectangle *geometry
)
{
	const gint border_major = 5;
	GtkRcStyle	*rcstyle,
					*caution_rcstyle;
	GtkWidget	*w,
					*parent,
					*cfgwin,
					*page;

	if(core == NULL)
		return(NULL);

	/* Create a new CfgWin as the Options Window */
	cfgwin = CfgWinNew(
		CFG_WIN_STYLE_NOTEBOOK,
		PROG_NAME ": "
#if defined(PROG_LANGUAGE_SPANISH)
"Las Opciones"
#elif defined(PROG_LANGUAGE_FRENCH)
"Options"
#elif defined(PROG_LANGUAGE_GERMAN)
"Optionen"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Le Opzioni"
#elif defined(PROG_LANGUAGE_DUTCH)
"Opties"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"As Opes"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Alternativer"
#else
"Options"
#endif
		,
		(guint8 **)icon_options_48x48_xpm,
		CFG_WIN_BUTTON_OK | CFG_WIN_BUTTON_APPLY |
			CFG_WIN_BUTTON_CANCEL | CFG_WIN_BUTTON_CLOSE,
		640, 480,
		core->cfg_list,
		core->cfg_path,
		geometry_flags,
		geometry
	);
	if(cfgwin == NULL)
		return(NULL);

	gtk_object_set_data(
		GTK_OBJECT(cfgwin),
		EDV_CORE_KEY,
		core
	);

	CfgWinSetApplyCB(
		cfgwin,
		edv_cfg_win_apply_cb, core
	);

	/* Create the caution GtkRcStyle */
	rcstyle = gtk_rc_style_new();
	if(rcstyle != NULL)
	{
		GdkColor	c_red = EDV_GDKCOLOR_RED,
					c_white = EDV_GDKCOLOR_WHITE;
		GtkStateType state = GTK_STATE_NORMAL;
		rcstyle->color_flags[state] = GTK_RC_FG | GTK_RC_TEXT;
		memcpy(
			&rcstyle->fg[state],
			&c_red,
			sizeof(GdkColor)
		);
		memcpy(
			&rcstyle->text[state],
			&c_red,
			sizeof(GdkColor)
		);
		state = GTK_STATE_ACTIVE;
		rcstyle->color_flags[state] = GTK_RC_FG | GTK_RC_TEXT;
		memcpy(
			&rcstyle->fg[state],
			&c_red,
			sizeof(GdkColor)
		);
		memcpy(
			&rcstyle->text[state],
			&c_red,
			sizeof(GdkColor)
		);
		state = GTK_STATE_PRELIGHT;
		rcstyle->color_flags[state] = GTK_RC_FG | GTK_RC_BG | GTK_RC_TEXT;
		memcpy(
			&rcstyle->fg[state],
			&c_white,
			sizeof(GdkColor)
		);
		memcpy(
			&rcstyle->bg[state],
			&c_red,
			sizeof(GdkColor)
		);
		memcpy(
			&rcstyle->text[state],
			&c_white,
			sizeof(GdkColor)
		);
		state = GTK_STATE_SELECTED;
		rcstyle->color_flags[state] = 0;
		state = GTK_STATE_INSENSITIVE;
		rcstyle->color_flags[state] = GTK_RC_FG | GTK_RC_TEXT;
		memcpy(
			&rcstyle->fg[state],
			&c_red,
			sizeof(GdkColor)
		);
		memcpy(
			&rcstyle->text[state],
			&c_red,
			sizeof(GdkColor)
		);
	}
	caution_rcstyle = rcstyle;

	/* Begin creating the General Page */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"General"
#elif defined(PROG_LANGUAGE_FRENCH)
"Gnral"
#elif defined(PROG_LANGUAGE_GERMAN)
"General"
#elif defined(PROG_LANGUAGE_ITALIAN)
"Generale"
#elif defined(PROG_LANGUAGE_DUTCH)
"Generaal"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O General"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"General"
#else
"General"
#endif
	);
	parent = page = CfgWinAddPageNotebook(
		cfgwin,
		NULL,				/* Parent to toplevel */
		-1,					/* Append */
		"General",
		w,
		FALSE				/* Not a parent */
	);
	if(parent != NULL)
	{
		gtk_container_border_width(GTK_CONTAINER(parent), border_major);
		gtk_box_set_spacing(GTK_BOX(parent), border_major);
		EDVCreateOptionsGeneralPage(
			core,
			cfgwin,
			parent,
			caution_rcstyle
		);
	}

	/* Begin creating the Display Page */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"El Despliegue"
#elif defined(PROG_LANGUAGE_FRENCH)
"Exposition"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausstellung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Mostra"
#elif defined(PROG_LANGUAGE_DUTCH)
"Tentoonstelling"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Exposio"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Utstilling"
#else
"Display"
#endif
	);
	parent = page = CfgWinAddPageNotebook(
		cfgwin,
		NULL,				/* Parent to toplevel */
		-1,					/* Append */
		"Display",
		w,
		FALSE				/* Not a parent */
	);
	if(parent != NULL)
	{
		gtk_container_border_width(GTK_CONTAINER(parent), border_major);
		gtk_box_set_spacing(GTK_BOX(parent), border_major);
		EDVCreateOptionsDisplayPage(
			core,
			cfgwin,
			parent
		);
	}

	/* Begin creating the Keyboard Page */
	w = gtk_label_new("Keyboard");
	parent = page = CfgWinAddPageNotebook(
		cfgwin,
		NULL,				/* Parent to toplevel */
		-1,					/* Append */
		"Keyboard",
		w,
		FALSE				/* Not a parent */
	);
	if(parent != NULL)
	{
		gtk_container_border_width(GTK_CONTAINER(parent), border_major);
		gtk_box_set_spacing(GTK_BOX(parent), border_major);
		EDVCreateOptionsKeyboardPage(
			core,
			cfgwin,
			parent
		);
	}

	/* Begin creating the Pointer Page */
	w = gtk_label_new("Pointer");
	parent = page = CfgWinAddPageNotebook(
		cfgwin,
		NULL,				/* Parent to toplevel */
		-1,					/* Append */
		"Pointer",
		w,
		FALSE				/* Not a parent */
	);
	if(parent != NULL)
	{
		gtk_container_border_width(GTK_CONTAINER(parent), border_major);
		gtk_box_set_spacing(GTK_BOX(parent), border_major);
		EDVCreateOptionsPointerPage(
			core,
			cfgwin,
			parent
		);
	}

	/* Begin creating the Programs Page */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Los Programas"
#elif defined(PROG_LANGUAGE_FRENCH)
"Programmes"
#elif defined(PROG_LANGUAGE_GERMAN)
"Programme"
#elif defined(PROG_LANGUAGE_ITALIAN)
"I Programmi"
#elif defined(PROG_LANGUAGE_DUTCH)
"Programma's"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Os Programas"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Programer"
#else
"Programs"
#endif
	);
	parent = page = CfgWinAddPageNotebook(
		cfgwin,
		NULL,				/* Parent to toplevel */
		-1,					/* Append */
		"Programs",
		w,
		FALSE				/* Not a parent */
	);
	if(parent != NULL)
	{
		gtk_container_border_width(GTK_CONTAINER(parent), border_major);
		gtk_box_set_spacing(GTK_BOX(parent), border_major);
		EDVCreateOptionsProgramsPage(
			core,
			cfgwin,
			parent
		);
	}

	/* Begin creating the Confirmation Page */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Confirmacin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Confirmation"
#elif defined(PROG_LANGUAGE_GERMAN)
"Besttigung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Conferma"
#elif defined(PROG_LANGUAGE_DUTCH)
"Bevestiging"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Confirmao"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Bekreftelse"
#else
"Confirmation"
#endif
	);
	parent = page = CfgWinAddPageNotebook(
		cfgwin,
		NULL,				/* Parent to toplevel */
		-1,					/* Append */
		"Confirmation",
		w,
		FALSE				/* Not a parent */
	);
	if(parent != NULL)
	{
		gtk_container_border_width(GTK_CONTAINER(parent), border_major);
		gtk_box_set_spacing(GTK_BOX(parent), border_major);
		EDVCreateOptionsConfirmationPage(
			core,
			cfgwin,
			parent,
			caution_rcstyle
		);
	}

	/* Begin creating the Date & Time Page */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"La Fecha & Tiempo"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Date & Le Temps"
#elif defined(PROG_LANGUAGE_GERMAN)
"Datum & Zeit"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Data & Il Tempo"
#elif defined(PROG_LANGUAGE_DUTCH)
"Datum & Tijd"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Data & Tempo"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Dato & Time"
#else
"Date & Time"
#endif
	);
	parent = page = CfgWinAddPageNotebook(
		cfgwin,
		NULL,				/* Parent to toplevel */
		-1,					/* Append */
		"Date & Time",
		w,
		FALSE				/* Not a parent */
	);
	if(parent != NULL)
	{
		gtk_container_border_width(GTK_CONTAINER(parent), border_major);
		gtk_box_set_spacing(GTK_BOX(parent), border_major);
		EDVCreateOptionsDatePage(
			core,
			cfgwin,
			parent
		);
	}

	/* Begin creating the Mount Page */
	w = gtk_label_new("Mount");
	parent = page = CfgWinAddPageNotebook(
		cfgwin,
		NULL,				/* Parent to toplevel */
		-1,					/* Append */
		"Mount",
		w,
		FALSE				/* Not a parent */
	);
	if(parent != NULL)
	{
		gtk_container_border_width(GTK_CONTAINER(parent), border_major);
		gtk_box_set_spacing(GTK_BOX(parent), border_major);
		EDVCreateOptionsMountPage(
			core,
			cfgwin,
			parent
		);
	}

	/* Begin creating the History Page */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
		"Historia"
#elif defined(PROG_LANGUAGE_FRENCH)
		"L'Histoire"
#elif defined(PROG_LANGUAGE_POLISH)
		"Historia"
#else
		"History"
#endif
);
	parent = page = CfgWinAddPageNotebook(
		cfgwin,
		NULL,				/* Parent to toplevel */
		-1,					/* Append */
		"History",
		w,
		FALSE				/* Not a parent */
	);
	if(parent != NULL)
	{
		gtk_container_border_width(GTK_CONTAINER(parent), border_major);
		gtk_box_set_spacing(GTK_BOX(parent), border_major);
		EDVCreateOptionsHistoryPage(
			core,
			cfgwin,
			parent
		);
	}

	/* Begin creating the Sound Page */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Los Sonidos"
#elif defined(PROG_LANGUAGE_FRENCH)
"Sons"
#elif defined(PROG_LANGUAGE_GERMAN)
"Klnge"
#elif defined(PROG_LANGUAGE_ITALIAN)  
"I Suoni"
#elif defined(PROG_LANGUAGE_DUTCH)
"Geluiden"
#elif defined(PROG_LANGUAGE_PORTUGUESE)  
"Os Sons"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Lyder"
#else
"Sound"
#endif
	);
	parent = page = CfgWinAddPageNotebook(
		cfgwin,
		NULL,				/* Parent to toplevel */
		-1,					/* Append */
		"Sound",
		w,
		FALSE				/* Not a parent */
	);
	if(parent != NULL)
	{
		gtk_container_border_width(GTK_CONTAINER(parent), border_major);
		gtk_box_set_spacing(GTK_BOX(parent), border_major);
		EDVCreateOptionsSoundsPage(
			core,
			cfgwin,
			parent
		);
	}

	/* Begin creating the Misc Page */
	w = gtk_label_new(
#if defined(PROG_LANGUAGE_SPANISH)
"Otro"
#elif defined(PROG_LANGUAGE_FRENCH)
"Autre"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ander"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Altro"
#elif defined(PROG_LANGUAGE_DUTCH)
"Anders"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"Outro"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Andre"
#else
"Misc"
#endif
	);
	parent = page = CfgWinAddPageNotebook(
		cfgwin,
		NULL,				/* Parent to toplevel */
		-1,					/* Append */
		"Misc",
		w,
		FALSE				/* Not a parent */
	);
	if(parent != NULL)
	{
		gtk_container_border_width(GTK_CONTAINER(parent), border_major);
		gtk_box_set_spacing(GTK_BOX(parent), border_major);
		EDVCreateOptionsMiscPage(
			core,
			cfgwin,
			parent
		);
	}


	GTK_RC_STYLE_UNREF(caution_rcstyle);

	return(cfgwin);
}
