/*
                           MIME Types List Window
 */

#ifndef MIME_TYPES_LIST_WIN_H
#define MIME_TYPES_LIST_WIN_H

#include <gtk/gtk.h>

#include "pulist.h"
#include "edv_types.h"
#include "edv_pixmap.h"
#include "edv_mime_type.h"
#include "mime_type_edit_dlg.h"


typedef struct _edv_mime_types_list_win_struct	edv_mime_types_list_win_struct;
#define EDV_MIME_TYPES_LIST_WIN(p)		((edv_mime_types_list_win_struct *)(p))


/*
 *	MIME Type List Window:
 */
struct _edv_mime_types_list_win_struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gint		busy_count,
			freeze_count;
	EDVCore	*core;

	GtkWidget	*main_vbox,
			*find_entry,
			*mimetypes_clist,
			*add_btn,
			*edit_btn,
			*remove_btn,
			*up_btn,
			*down_btn,
			*save_btn,
			*import_btn,
			*export_btn,
			*display_parent,	/* GtkVBox */
			*display_client,
			*display_icon,
			*display_edit_btn,
			*close_btn;

	/* Right click menu */
	GtkWidget	*menu,
			*add_mi,
			*edit_mi,
			*remove_mi,
			*up_mi,
			*down_mi,
			*save_mi,
			*import_mi,
			*export_mi;

	edv_mime_type_edit_dlg_struct	*edit_dlg;

	/* MIME Type class icons */
	EDVPixmap	*system_object_icon,
			*file_format_icon,
			*program_icon,
			*unique_object_icon;
};


/* Callbacks */
extern void EDVMimeTypesListWinReconfiguredNotifyCB(
	edv_mime_types_list_win_struct *lw
);
extern void EDVMimeTypesListWinMimeTypeAddedCB(
	edv_mime_types_list_win_struct *lw,
	const gint mt_num, EDVMIMEType *m
);
extern void EDVMimeTypesListWinMimeTypeModifiedCB(
	edv_mime_types_list_win_struct *lw,
	const gint mt_num, EDVMIMEType *m
);
extern void EDVMimeTypesListWinMimeTypeRemovedCB(
	edv_mime_types_list_win_struct *lw,
	const gint mt_num
);

/* Select */
extern void EDVMimeTypesListWinSelect(
	edv_mime_types_list_win_struct *lw,
	const gint i
);
extern gint EDVMimeTypesListWinSelectByType(
	edv_mime_types_list_win_struct *lw,
	const gchar *type
);

/* Get List */
extern void EDVMimeTypesListWinGetList(
	edv_mime_types_list_win_struct *lw,
	const gboolean verbose
);

/* Operations */
extern void EDVMimeTypesListWinFind(edv_mime_types_list_win_struct *lw);
extern void EDVMimeTypesListWinAdd(edv_mime_types_list_win_struct *lw);
extern void EDVMimeTypesListWinEditMimeType(
	edv_mime_types_list_win_struct *lw,
	const gint mt_num
);
extern void EDVMimeTypesListWinEdit(edv_mime_types_list_win_struct *lw);
extern void EDVMimeTypesListWinRemove(
	edv_mime_types_list_win_struct *lw,
	const gboolean confirm
);
extern void EDVMimeTypesListWinShiftUp(edv_mime_types_list_win_struct *lw);
extern void EDVMimeTypesListWinShiftDown(edv_mime_types_list_win_struct *lw);
extern void EDVMimeTypesListWinSave(edv_mime_types_list_win_struct *lw);
extern void EDVMimeTypesListWinImport(edv_mime_types_list_win_struct *lw);
extern void EDVMimeTypesListWinExport(edv_mime_types_list_win_struct *lw); 
extern void EDVMimeTypesListWinClose(edv_mime_types_list_win_struct *lw); 

/* MIME Types List Window */
extern edv_mime_types_list_win_struct *EDVMimeTypesListWinNew(EDVCore *core);
extern void EDVMimeTypesListWinUpdateWidgets(edv_mime_types_list_win_struct *lw);
extern void EDVMimeTypesListWinSetBusy(
	edv_mime_types_list_win_struct *lw,
	const gboolean busy
);
extern gboolean EDVMimeTypesListWinIsMapped(edv_mime_types_list_win_struct *lw);
extern void EDVMimeTypesListWinMap(edv_mime_types_list_win_struct *lw);
extern void EDVMimeTypesListWinUnmap(edv_mime_types_list_win_struct *lw);
extern void EDVMimeTypesListWinDelete(edv_mime_types_list_win_struct *lw);


#endif	/* MIME_TYPES_LIST_WIN_H */
