/*
                            MIME Type Edit Dialog
 */

#ifndef MIME_TYPE_EDIT_DLG_H
#define MIME_TYPE_EDIT_DLG_H

#include <gtk/gtk.h>

#include "edv_types.h"
#include "edv_pixmap.h"
#include "edv_mime_type.h"


typedef struct _edv_mime_type_edit_dlg_struct	edv_mime_type_edit_dlg_struct;
#define EDV_MIME_TYPE_EDIT_DLG(p)		((edv_mime_type_edit_dlg_struct *)(p))


/*
 *      MIME Type Edit Dialog:
 */
struct _edv_mime_type_edit_dlg_struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gint		busy_count,
			freeze_count;
	gboolean	has_changes;
	EDVCore	*core;

	GtkWidget       *main_vbox,
			*class_pulistbox,
			*type_entry,
			*value_label,
			*value_entry,
			*description_entry,
			*handler_pulistbox,
			*commands_clist_box,
			*commands_clist,
			*command_add_btn,
			*command_edit_btn,
			*command_remove_btn,
			*command_shift_up_btn,
			*command_shift_down_btn,
			*commands_menu,
			*commands_menu_add_mi,
			*commands_menu_edit_mi,
			*commands_menu_remove_mi,
			*commands_menu_shift_up_mi,
			*commands_menu_shift_down_mi,
			*icon_small_ip,
			*icon_medium_ip,
			*icon_large_ip,
			*ok_btn,
			*apply_btn,
			*cancel_btn,
			*close_btn;


	gint		mt_num;			/* Reference to the MIME
						 * Type being edited */
	gchar		*browse_path_rtn;

	EDVPixmap	*mime_type_icon,
			*run_in_terminal_icon;

	/* Icon Selector Dialog */
	GtkWidget	*icon_sel_dlg;
};


/* Callbacks */
extern void EDVMimeTypeEditDlgMimeTypeRemovedCB(
	edv_mime_type_edit_dlg_struct *d,
	const gint mt_num
);

/* Get/set values */
extern void EDVMimeTypeEditDlgGetValues(
	edv_mime_type_edit_dlg_struct *d,
	const gint mt_num
);
extern void EDVMimeTypeEditDlgSetValues(
        edv_mime_type_edit_dlg_struct *d,
        const gint mt_num,
        const gboolean verbose
);

/* MIME Type Edit Dialog */
extern edv_mime_type_edit_dlg_struct *EDVMimeTypeEditDlgNew(EDVCore *core);
extern void EDVMimeTypeEditDlgResetHasChanges(
	edv_mime_type_edit_dlg_struct *d,
	const gboolean has_changes
);
extern void EDVMimeTypeEditDlgUpdateMenus(edv_mime_type_edit_dlg_struct *d);
extern gboolean EDVMimeTypeEditDlgIsMapped(edv_mime_type_edit_dlg_struct *d);
extern void EDVMimeTypeEditDlgMap(edv_mime_type_edit_dlg_struct *d);
extern void EDVMimeTypeEditDlgUnmap(edv_mime_type_edit_dlg_struct *d);
extern void EDVMimeTypeEditDlgDelete(edv_mime_type_edit_dlg_struct *d);


#endif	/* MIME_TYPE_EDIT_DLG_H */
