/*
                                 Menu Button

	A GtkButton that maps a GtkMenu.
 */

#ifndef MENU_BUTTON_H
#define MENU_BUTTON_H

#include <gtk/gtk.h>


/*
 *	Menu map trigger type codes:
 */
typedef enum {
	MENU_BUTTON_MAP_TYPE_PRESSED,		/* Map on press */
	MENU_BUTTON_MAP_TYPE_PRESSED_DRAG	/* Map on press and short drag */
} MenuButtonMapTrigger;


extern GtkWidget *menu_hbutton_new(
	const gchar *label,
	guchar **icon_data,
	GtkWidget **menu_rtn
);
extern GtkWidget *menu_vbutton_new(
	const gchar *label,
	guchar **icon_data,
	GtkWidget **menu_rtn
);
extern GtkWidget *menu_button_pixmap_new(
	guchar **icon_data,
	GtkWidget **menu_rtn
);
extern GtkWidget *menu_button_new_from_button(
	GtkWidget *w,
	GtkWidget **menu_rtn
);

extern GtkWidget *menu_button_get_menu(GtkWidget *w);
extern void menu_button_set_menu(
	GtkWidget *w,
	GtkMenu *menu
);

extern void menu_button_set_map_trigger(
	GtkWidget *w,
	const MenuButtonMapTrigger map_trigger
);


#endif	/* MENU_BUTTON_H */
