#include <glib.h>

#include "edv_archive_list.h"
#include "edv_main.h"
#include "config.h"


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? (gint)strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


int main(int argc, char *argv[])
{
	gint status;
	gint (*main_function_ptr)(const gint, const gchar **) = edv_main;

	/* Handle general command line arguments
	 *
	 * This only handles the arguments for --help, --version, and
	 * other general arguments, more specific arguments are handled
	 * in edv_core_new_init()
	 */
	if(argc > 1)
	{
		gint i;
		const gchar *arg;

		for(i = 1; i < argc; i++)
		{
			arg = argv[i];
			if(STRISEMPTY(arg))
				continue;

			/* Help */
			if(!g_strcasecmp(arg, "--help") ||
			   !g_strcasecmp(arg, "-help") ||
			   !g_strcasecmp(arg, "--h") ||
			   !g_strcasecmp(arg, "-h") ||
			   !g_strcasecmp(arg, "-?")
			)
			{
				g_print(
					"%s",
					PROG_HELP_MESG
				);
				return(0);
			}
			/* Version */
			else if(!g_strcasecmp(arg, "--version") ||
				!g_strcasecmp(arg, "-version")
			)
			{
				g_print(
					"%s %s %s\n%s",
					PROG_NAME_FULL,
#if defined(PROG_LANGUAGE_SPANISH)
"La Versin"
#elif defined(PROG_LANGUAGE_FRENCH)
"Version"
#elif defined(PROG_LANGUAGE_GERMAN)
"Ausfhrung"
#elif defined(PROG_LANGUAGE_ITALIAN)
"La Versione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitvoering"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"A Verso"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"Versjon"
#else
"Version"
#endif
					,
					PROG_VERSION,
					PROG_COPYRIGHT
				);
				return(0);
			}
			/* List Archive */
			else if(!g_strcasecmp(arg, "--list-archive"))
			{
				main_function_ptr = edv_archive_list;
			}
		}
	}

	/* Run the selected main function (default is edv_main()) */
	status = main_function_ptr((const gint)argc, (const gchar **)argv);

	/* Return value must be positive */
	if(status < 0)
		status *= -1;

	return(status);
}


#if 0
/*
 *	"Focus on the family", that means actually caring and expending
 *	your time and energy on your family members at a higher
 *	priority level and amount than at political rallies against
 *	homosexual families.
 *
 *	What does that have to do with this code? Because this is me,
 *	Tara, the head programer of this project writing this and I
 *	can write anything that I want here... this is my project
 *	afterall.
 *
 *	I wrote that because it has been a very difficult life for me
 *	and I'm not sure exactly why I decided to put this in here
 *	tonight... My (genetic) father was an avid supporter of "Family
 *	values", however he abandoned my mom and I for most of my life
 *	and when he was around he subjected us to his "war" on
 *	homosexual families and other individuals and groups he labeled
 *	as part of the "liberal army". Many individuals who claim to
 *	"protect family values" are often abusing their own family
 *	members behind close doors.
 *
 *	I spent hundreds of hours writing this program for you, I only
 *	wanted to share a part of my life, not my political views, in
 *	this. This program is here, for you, because of me, and there
 *	are things that I went through to make this a reality. I only
 *	want to share a part of the human side of this author. She is
 *	not just another name, @ sign, site address, she wrote this for
 *	you and she also had her own human experience. She asks nothing
 *	in return.
 *
 *	Tara - 2007 Mar 4
 */
#endif

