/*
                 Endeavour Mark II API - Master Header File

	All applications using the Endeavour Mark II API should
	#include this header file. Do not specifically #include any
	header file listed here.

	To learn how to use this API, see the demos in:

	$ENDEAVOUR2_SOURCE/endeavour2/lib/demos/
 */

#ifndef LIBENDEAVOUR2_H
#define LIBENDEAVOUR2_H

#include <glib.h>

#include "edv_types.h"				/* Types and enumerations */
#include "edv_cfg_list.h"			/* Endeavour Mark II
						 * configuration list */
#include "edv_context.h"			/* Endeavour Mark II API Context */
#include "edv_convert_obj.h"			/* Convert EDV*Objects and
						 * EDVProperty lists */
#include "edv_date_format.h"			/* Date & time string formatting */
#include "edv_date_parse.h"			/* Date & time string parsing */
#include "edv_device.h"				/* EDVDevice */
#include "edv_device_get.h"			/* Device fetching & matching */
#include "edv_device_mount.h"			/* Device Mounting, Unmounting,
						 * and Ejecting */
#include "edv_device_stat.h"			/* Get device statistics */
#include "edv_directory.h"			/* Low-level directory creating,
						 * removing, and listing */
#include "edv_fs_type.h"			/* Filesystem types */
#include "edv_get.h"				/* Configuration value fetching */
#include "edv_help.h"				/* Help displaying and help
						 * browser */
#include "edv_history.h"			/* History event logging */
#include "edv_id.h"				/* EDVUID and EDVGID */
#include "edv_id_get.h"				/* User and group ID fetching &
						 * matching */
#include "edv_link.h"				/* Low-level link creating,
						 * checking, and get target */
#include "edv_message.h"			/* Message displaying in a
						 * dialog */
#include "edv_mime_type.h"			/* EDVMIMEType */
#include "edv_mime_type_get.h"			/* MIME Types fetching & matching */
#include "edv_mime_type_install.h"		/* MIME Types installing */
#include "edv_notify.h"				/* Event emission */
#include "edv_obj_info_match.h"			/* Get object icon and type
						 * string from object information */
#include "edv_open.h"				/* Object opening */
#include "edv_path.h"				/* Low-level path, name and
						 * extension */
#include "edv_process.h"			/* Low-level process testing,
						 * status, forking, and execute */
#include "edv_property.h"			/* EDVProperty and property
						 * lists */
#include "edv_property_fio.h"			/* Property file IO */
#include "edv_property_directory.h"		/* Directory properties */
#include "edv_recycle.h"			/* High-level recycle, recover,
						 * and purge */
#include "edv_recycle_bin_index.h"		/* Low-level recycle bin index
						 * IO and low-level recycle,
						 * recover, and purge */
#include "edv_recycled_obj.h"			/* EDVRecycledObject */
#include "edv_recycled_obj_stat.h"		/* Get recycled object statistics */
#include "edv_sound.h"				/* Play sounds */
#include "edv_stream.h"				/* Stream IO */
#include "edv_utils.h"				/* Utilities and system wrapper */
#include "edv_vfs_obj.h"			/* EDVVFSObject */
#include "edv_vfs_obj_stat.h"			/* Get VFS object statistics */
#include "edv_window.h"				/* Window creation & mapping */


#endif	/* LIBENDEAVOUR2_H */
