/*
	    Endeavour Mark II API - Window Creation & Mapping

	If Endeavour is already running then an interps command will
	be sent to it instructing it to create/map the window,
	otherwise Endeavour will be runned and instructed to
	create/map the window.

	All functions will block until the window has been created or
	mapped.
 */

#ifndef EDV_WINDOW_H
#define EDV_WINDOW_H

#include <glib.h>
#include "edv_context.h"


/*
 *	Maps the About Dialog.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	If page_name is not NULL then it specifies the name of the
 *	page to switch to.
 */
extern void edv_window_about_dialog_map(
	EDVContext *ctx,
	const gchar *page_name
);


/*
 *	Creates a new VFS Browser.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	If path is not NULL then it specifies the initial location..
 *
 *	If tree_origin is not NULL then it specifies the initial
 *	directory tree origin path.
 */
extern void edv_window_vfs_browser_new(
	EDVContext *ctx,
	const gchar *path,
	const gchar *tree_origin
);

/*
 *	Creates a new Image Browser.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	If path is not NULL then it specifies the initial location..
 */
extern void edv_window_image_browser_new(
	EDVContext *ctx,
	const gchar *path
);

/*
 *	Creates a new Archiver.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	If path is not NULL then it specifies the initial location..
 *
 *	If password is not NULL then it specifies the password.
 */
extern void edv_window_archiver_new(
	EDVContext *ctx,
	const gchar *path,
	const gchar *password
);

/*
 *	Maps the Recycle Bin.
 *
 *	The ctx specifies the Endeavour 2 context.
 */
extern void edv_window_recycle_bin_map(EDVContext *ctx);


/*
 *	Maps the MIME Types Window.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	If type is not NULL then it specifies the initial MIME Type
 *	to display.
 */
extern void edv_window_mime_types_list_map(
	EDVContext *ctx,
	const gchar *type
);

/*
 *	Maps the Devices List Window.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	If path is not NULL then it specifies the path to an object
 *	on the initial Device to display, including the device's
 *	mount path or device path itself.
 */
extern void edv_window_devices_list_map(
        EDVContext *ctx,
        const gchar *path
);

/*
 *	Maps the History List Window.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	If event_index is not negative then it specifies the initial
 *	event to display.
 */
extern void edv_window_history_list_map(
	EDVContext *ctx,
	const gint event_index
);


/*
 *	Maps the Options Window.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	If page_name is not NULL then it specifies the name of the
 *	page to switch to.
 */
extern void edv_window_options_map(
	EDVContext *ctx,
	const gchar *page_name
);


/*
 *	Maps the Customize Window.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	If page_name is not NULL then it specifies the name of the
 *	page to switch to.
 */
extern void edv_window_customize_map(
	EDVContext *ctx,
	const gchar *page_name
);


/*
 *	Creates a new Properties Dialog.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	The path specifies the initial object to display.
 *
 *	If page_name is not NULL then it specifies the name of the
 *	page to switch to.
 */
extern void edv_window_properties_dialog_new(
	EDVContext *ctx,
	const gchar *path,
	const gchar *page_name
);


/*
 *	Maps the Find Window.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	If location is not NULL then location specifies the initial
 *	location.
 *
 *	If value is not NULL then it specifies the initial search
 *	value.
 */
extern void edv_window_find_map(
	EDVContext *ctx,
	const gchar *location,
	const gchar *value
);


/*
 *	Maps the Run Dialog.
 *
 *	The ctx specifies the Endeavour 2 context.
 *
 *	If command is not NULL then it specifies the initial command.
 *
 *	If working_directory_path is not NULL then it specifies the
 *	iniital working directory path.
 */
extern void edv_window_run_dialog_map(
        EDVContext *ctx,
        const gchar *command,
        const gchar *working_directory_path
);


#endif	/* EDV_WINDOW_H */
