/*
	      Endeavour Mark II API - VFS Object Statistics

	Gets the VFS object's statistics and returns the values as a
	EDVVFSObject.
 */

#ifndef EDV_VFS_OBJ_STAT_H
#define EDV_VFS_OBJ_STAT_H

#include <glib.h>
#include "edv_vfs_obj.h"


/*
 *	Gets the VFS object's destination statistics.
 *
 *	The path specifies the full path to the object.
 *
 *	Returns a new dynamically allocated EDVVFSObject with all of its
 *	statistics filled or NULL on error.
 */
extern EDVVFSObject *edv_vfs_object_stat(const gchar *path);

/*
 *	Gets the VFS object's local statistics.
 *
 *	The path specifies the full path to the object.
 *
 *	Returns a new dynamically allocated EDVVFSObject with all of its
 *	statistics filled or NULL on error.
 */
extern EDVVFSObject *edv_vfs_object_lstat(const gchar *path);

/*
 *	Gets the VFS object's statistics from the descriptor.
 *
 *	The fd specifies the descriptor. Since the descriptor does not
 *	contain the path, the VFS object's name and full_path will not
 *	be set.
 *
 *	Returns a new dynamically allocated EDVVFSObject with all of its
 *	statistics filled or NULL on error.
 */
extern EDVVFSObject *edv_vfs_object_fstat(const gint fd);


#endif	/* EDV_VFS_OBJ_STAT_H */
