/*
              Endeavour Mark II - Data Types & Enumerations

	These declarations do not depend on Endeavour 2 or GTK+.

 */

#ifndef EDV_TYPES_H
#define EDV_TYPES_H


/*
 *	Size Format:
 */
typedef enum {
	EDV_SIZE_FORMAT_RAW,			/* 123456679 */
	EDV_SIZE_FORMAT_DELIMINATED,		/* 123,456,679 */
	EDV_SIZE_FORMAT_BLOCKS,			/* 1.2K, 923K, 1232K */
	EDV_SIZE_FORMAT_HUMAN_READABLE		/* 1.2K, 234M, 2G */
} EDVSizeFormat;


/*
 *	Object Types:
 */
typedef enum {
	EDV_OBJECT_TYPE_UNKNOWN			= 0,
	EDV_OBJECT_TYPE_FILE			= 1,
	EDV_OBJECT_TYPE_DIRECTORY		= 2,
	EDV_OBJECT_TYPE_LINK			= 3,
	EDV_OBJECT_TYPE_DEVICE_BLOCK		= 4,
	EDV_OBJECT_TYPE_DEVICE_CHARACTER	= 5,
	EDV_OBJECT_TYPE_FIFO			= 6,
	EDV_OBJECT_TYPE_SOCKET			= 7,
	EDV_OBJECT_TYPE_ERROR			= 128
} EDVObjectType;


/*
 *	Location Types:
 */
typedef enum {
	EDV_LOCATION_TYPE_VFS,			/* On the Virtual File System */
	EDV_LOCATION_TYPE_RECYCLE_BIN,		/* In the Recycle Bin */
	EDV_LOCATION_TYPE_ARCHIVE		/* In an archive */
} EDVLocationType;


/*
 *	Permission Flags:
 */
typedef enum {
	/* Owner (User) */
	EDV_PERMISSION_UX		= (1 << 0),	/* Execute */
	EDV_PERMISSION_UR		= (1 << 1),	/* Read */
	EDV_PERMISSION_UW		= (1 << 2),	/* Write */

	/* Group */
	EDV_PERMISSION_GX		= (1 << 3),	/* Execute */
	EDV_PERMISSION_GR		= (1 << 4),	/* Read */
	EDV_PERMISSION_GW		= (1 << 5),	/* Write */

	/* Other (Anyone) */
	EDV_PERMISSION_OX		= (1 << 6),	/* Execute */
	EDV_PERMISSION_OR		= (1 << 7),	/* Read */
	EDV_PERMISSION_OW		= (1 << 8),	/* Write */

	/* SetUID, SetGID, Sticky */
	EDV_PERMISSION_SETUID		= (1 << 9),
	EDV_PERMISSION_SETGID		= (1 << 10),
	EDV_PERMISSION_STICKY		= (1 << 11)
} EDVPermissionFlags;


/*
 *	Link Hint Flags:
 */
typedef enum {
	EDV_LINK_HINT_TARGET_EXISTS	= (1 << 0),	/* Not dangling */
	EDV_LINK_HINT_TARGET_DIRECTORY	= (1 << 1),	/* Ultimately links to
							 * a directory */
	EDV_LINK_HINT_TARGET_GRAND_PARENT
					= (1 << 2)	/* Target is a parent
							 * or grand parent, also
							 * infinate recursion */
} EDVLinkHintFlags;


/*
 *	Operation ID Flags:
 */
typedef enum {
	EDV_OPID_ALLOW_MULTIPLE		= (1 << 0),	/* Allow more than one
							 * instance per list */
	EDV_OPID_NO_OP			= (1 << 1),	/* Does not perform an
							 * operation (labels and
							 * separators) */
	EDV_OPID_EX_MENU		= (1 << 2),	/* Exclude from menus */
	EDV_OPID_EX_TOOL_BAR		= (1 << 3)	/* Exclude from tool bars */
} EDVOpIDFlags;


/*
 *	Delete Methods:
 */
typedef enum {
	EDV_DELETE_METHOD_RECYCLE	= 0,
	EDV_DELETE_METHOD_PURGE		= 1
} EDVDeleteMethod;


/*
 *	MIME Type Classes:
 */
typedef enum {
	EDV_MIME_TYPE_CLASS_SYSTEM	= 0,	/* System object type */
	EDV_MIME_TYPE_CLASS_FORMAT	= 1,	/* File format */
	EDV_MIME_TYPE_CLASS_PROGRAM	= 2,	/* Program object */
	EDV_MIME_TYPE_CLASS_UNIQUE	= 3	/* Unique object */
} EDVMIMETypeClass;


/*
 *	MIME Type Handlers:
 */
typedef enum {
	EDV_MIME_TYPE_HANDLER_COMMAND		= 0,	/* Use Command */
	EDV_MIME_TYPE_HANDLER_EDV_ARCHIVER	= 1,	/* Use Archiver */
	EDV_MIME_TYPE_HANDLER_EDV_IMAGE_BROWSER	= 2,	/* Use Image Browser */
	EDV_MIME_TYPE_HANDLER_EDV_RECYCLE_BIN	= 3	/* Use Recycle Bin */
} EDVMIMETypeHandler;


/*
 *	History Types:
 */
typedef enum {
	EDV_HISTORY_UNKNOWN			= 0,
	EDV_HISTORY_SYNC_DISKS			= 1,
	EDV_HISTORY_SYNC_RECBIN			= 2,

	EDV_HISTORY_VFS_OBJECT_CREATE		= 10,
	EDV_HISTORY_VFS_OBJECT_COPY		= 11,
	EDV_HISTORY_VFS_OBJECT_MOVE		= 12,	/* Or rename */
	EDV_HISTORY_VFS_OBJECT_LINK		= 13,
	EDV_HISTORY_VFS_OBJECT_CHMOD		= 15,	/* Originally misordered */
	EDV_HISTORY_VFS_OBJECT_CHOWN		= 14,	/* Originally misordered */
	EDV_HISTORY_VFS_OBJECT_CHTIME		= 16,
	EDV_HISTORY_VFS_OBJECT_DOWNLOAD		= 17,
	EDV_HISTORY_VFS_OBJECT_DELETE		= 18,

	EDV_HISTORY_RECYCLED_OBJECT_RECOVER	= 20,
	EDV_HISTORY_RECYCLED_OBJECT_PURGE	= 21,
	EDV_HISTORY_RECYCLED_OBJECT_PURGE_ALL	= 22,
	EDV_HISTORY_RECYCLED_OBJECT_LINK	= 23,
	EDV_HISTORY_RECYCLED_OBJECT_RENAME	= 24,	/* Not move */
	EDV_HISTORY_RECYCLED_OBJECT_CHMOD	= 25,
	EDV_HISTORY_RECYCLED_OBJECT_CHOWN	= 26,
	EDV_HISTORY_RECYCLED_OBJECT_CHTIME	= 27,

	EDV_HISTORY_ARCHIVE_OBJECT_ADD		= 30,
	EDV_HISTORY_ARCHIVE_OBJECT_EXTRACT	= 31,
	EDV_HISTORY_ARCHIVE_OBJECT_DELETE	= 32,
	EDV_HISTORY_ARCHIVE_FIX			= 38
} EDVHistoryType;

/*
 *	Version 2.8.3 and older EDVHistoryType compatability:
 */
#define EDV_HISTORY_DISK_OBJECT_CREATE	EDV_HISTORY_VFS_OBJECT_CREATE
#define EDV_HISTORY_DISK_OBJECT_COPY	EDV_HISTORY_VFS_OBJECT_COPY
#define EDV_HISTORY_DISK_OBJECT_MOVE	EDV_HISTORY_VFS_OBJECT_MOVE
#define EDV_HISTORY_DISK_OBJECT_LINK	EDV_HISTORY_VFS_OBJECT_LINK
#define EDV_HISTORY_DISK_OBJECT_CHOWN	EDV_HISTORY_VFS_OBJECT_CHOWN
#define EDV_HISTORY_DISK_OBJECT_CHMOD	EDV_HISTORY_VFS_OBJECT_CHMOD
#define EDV_HISTORY_DISK_OBJECT_CHTIME	EDV_HISTORY_VFS_OBJECT_CHTIME
#define EDV_HISTORY_DISK_OBJECT_DOWNLOAD	EDV_HISTORY_VFS_OBJECT_DOWNLOAD
#define EDV_HISTORY_DISK_OBJECT_DELETE	EDV_HISTORY_VFS_OBJECT_DELETE


/*
 *	Pixmap Data Type:
 *
 *	Refers to the XPM data type.
 */
typedef guint8*				edv_pixmap_data;


/*
 *	Icon Sizes:
 *
 *	The code corresponds with the size in pixels, all icons are
 *	square so width = height.
 */
typedef enum {
	EDV_ICON_SIZE_16		= 16,	/* Mini */
	EDV_ICON_SIZE_20		= 20,	/* Small */
	EDV_ICON_SIZE_32		= 32,	/* Medium */
	EDV_ICON_SIZE_48		= 48	/* Large */
} EDVIconSize;

/*
 *	Lists Load Images Priorties:
 */
typedef enum {
	EDV_LISTS_LOAD_IMAGES_PRIORITY_HIGHEST,
	EDV_LISTS_LOAD_IMAGES_PRIORITY_HIGH,
	EDV_LISTS_LOAD_IMAGES_PRIORITY_NORMAL,
	EDV_LISTS_LOAD_IMAGES_PRIORITY_LOW,
	EDV_LISTS_LOAD_IMAGES_PRIORITY_LOWEST
} EDVListsLoadImagesPriority;

/*
 *	Lists Pointer Operations:
 */
typedef enum {
	EDV_LISTS_POINTER_OP_BUTTON2_NONE,
	EDV_LISTS_POINTER_OP_BUTTON2_SCROLL_XY,	/* 2D press and drag scroll */
	EDV_LISTS_POINTER_OP_BUTTON2_RENAME,
	EDV_LISTS_POINTER_OP_BUTTON2_PASTE	/* Paste object */
} EDVListsPointerOpButton2;

/*
 *	Sound Output:
 */
typedef enum {
	EDV_SOUND_OUTPUT_NONE,
	EDV_SOUND_OUTPUT_COMMAND,		/* Execute shell commands
						 * specified by
						 * EDV_CFG_PARM_SOUND_PLAY_* */
	EDV_SOUND_OUTPUT_GDK
} EDVSoundOutput;

/*
 *	Window Types:
 */
typedef enum {
	EDV_WINDOW_NONE				= 0,
	EDV_WINDOW_ABOUT_DIALOG			= 500,
	EDV_WINDOW_VFS_BROWSER			= 1000,	/* File Browser */
	EDV_WINDOW_IMAGE_BROWSER		= 1100,
	EDV_WINDOW_ARCHIVER			= 2000,
	EDV_WINDOW_RECYCLE_BIN			= 5000,
	EDV_WINDOW_MIME_TYPES_LIST		= 6000,
	EDV_WINDOW_DEVICES_LIST			= 7000,
	EDV_WINDOW_HISTORY_LIST			= 8000,
	EDV_WINDOW_OPTIONS			= 9000,
	EDV_WINDOW_CUSTOMIZE			= 9100,
	EDV_WINDOW_PROPERTIES_DIALOG		= 10000,
	EDV_WINDOW_FIND				= 11000,
	EDV_WINDOW_OBJECT_OPERATIONS_DIALOG	= 11100,
	EDV_WINDOW_RUN_DIALOG			= 11200,
	EDV_WINDOW_HELP				= 50000	/* Help Browser */
} EDVWindowType;


/*
 *	Core Pending Operation Flags:
 */
typedef enum {
	EDV_CORE_PENDING_CLOSE_ALL_WINDOWS	= (1 << 0),
	EDV_CORE_PENDING_RESET			= (1 << 1)
} EDVCorePendingFlags;


/*
 *	Endeavour 2 Program Core:
 *
 *	Used only by the Endeavour 2 program's source, other sources
 *	should not use this.
 */
typedef struct _EDVCore         EDVCore;


#endif	/* EDV_TYPES_H */
