#include <glib.h>
#include "edv_utils.h"
#include "edv_process.h"
#include "edv_context.h"
#include "edv_get.h"
#include "edv_sound.h"

#include "edv_cfg_list.h"


void edv_beep(EDVContext *ctx);
void edv_play_sound_beep(EDVContext *ctx);      
void edv_play_sound_info(EDVContext *ctx);
void edv_play_sound_question(EDVContext *ctx);
void edv_play_sound_warning(EDVContext *ctx);
void edv_play_sound_error(EDVContext *ctx);  
void edv_play_sound_completed(EDVContext *ctx);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Plays the "Beep" sound.
 */
void edv_beep(EDVContext *ctx)
{
	edv_play_sound_beep(ctx);
}
void edv_play_sound_beep(EDVContext *ctx)
{
	EDVSoundOutput sound_output;

	if(ctx == NULL)
	    return;

	sound_output = (EDVSoundOutput)edv_get_i(
	    ctx,
	    EDV_CFG_PARM_SOUND_OUTPUT
	);
	if(sound_output == EDV_SOUND_OUTPUT_GDK)
	{

	}
	else if(sound_output == EDV_SOUND_OUTPUT_COMMAND)
	{
	    const gchar *cmd = edv_get_s(ctx, EDV_CFG_PARM_SOUND_PLAY_BEEP);
	    if(!STRISEMPTY(cmd))
	    {
		gchar *shell_prog;
		const gchar     *shell_cmd = edv_get_s(ctx, EDV_CFG_PARM_PROG_SHELL),
				*shell_args = edv_strarg(
		    shell_cmd,
		    &shell_prog,
		    TRUE,			/* Parse escapes */
		    TRUE			/* Parse quotes */
		);
		edv_system_shell(
		    cmd,
		    shell_prog,
		    shell_args
		);
		g_free(shell_prog);
	    }
	}
}

/*
 *      Plays the "Info" sound.
 */
void edv_play_sound_info(EDVContext *ctx)
{
	EDVSoundOutput sound_output;

	if(ctx == NULL)
	    return;

	sound_output = (EDVSoundOutput)edv_get_i(
	    ctx,
	    EDV_CFG_PARM_SOUND_OUTPUT
	);
	if(sound_output == EDV_SOUND_OUTPUT_GDK)
	{

	}
	else if(sound_output == EDV_SOUND_OUTPUT_COMMAND)
	{   
	    const gchar *cmd = edv_get_s(ctx, EDV_CFG_PARM_SOUND_PLAY_INFO);
	    if(!STRISEMPTY(cmd))
	    {
		gchar *shell_prog;
		const gchar     *shell_cmd = edv_get_s(ctx, EDV_CFG_PARM_PROG_SHELL),
				*shell_args = edv_strarg(
		    shell_cmd,
		    &shell_prog,
		    TRUE,			/* Parse escapes */
		    TRUE			/* Parse quotes */
		);
		edv_system_shell(
		    cmd,
		    shell_prog,
		    shell_args
		);
		g_free(shell_prog);
	    }
	}
}

/*
 *	Plays the "Question" sound.
 */
void edv_play_sound_question(EDVContext *ctx)
{
	EDVSoundOutput sound_output;

	if(ctx == NULL)
	    return;

	sound_output = (EDVSoundOutput)edv_get_i(
	    ctx,
	    EDV_CFG_PARM_SOUND_OUTPUT
	);
	if(sound_output == EDV_SOUND_OUTPUT_GDK)
	{

	}
	else if(sound_output == EDV_SOUND_OUTPUT_COMMAND)
	{   
	    const gchar *cmd = edv_get_s(ctx, EDV_CFG_PARM_SOUND_PLAY_QUESTION);
	    if(!STRISEMPTY(cmd))
	    {
		gchar *shell_prog;
		const gchar     *shell_cmd = edv_get_s(ctx, EDV_CFG_PARM_PROG_SHELL),
				*shell_args = edv_strarg(
		    shell_cmd,
		    &shell_prog,
		    TRUE,			/* Parse escapes */
		    TRUE			/* Parse quotes */
		);
		edv_system_shell(
		    cmd,
		    shell_prog,
		    shell_args
		);
		g_free(shell_prog);
	    }
	}
}

/*
 *	Plays the "Warning" sound.
 */
void edv_play_sound_warning(EDVContext *ctx)
{
	EDVSoundOutput sound_output;

	if(ctx == NULL)
	    return;

	sound_output = (EDVSoundOutput)edv_get_i(
	    ctx,
	    EDV_CFG_PARM_SOUND_OUTPUT
	);
	if(sound_output == EDV_SOUND_OUTPUT_GDK)
	{

	}
	else if(sound_output == EDV_SOUND_OUTPUT_COMMAND)
	{
	    const gchar *cmd = edv_get_s(ctx, EDV_CFG_PARM_SOUND_PLAY_WARNING);
	    if(!STRISEMPTY(cmd))
	    {
		gchar *shell_prog;
		const gchar     *shell_cmd = edv_get_s(ctx, EDV_CFG_PARM_PROG_SHELL),
				*shell_args = edv_strarg(
		    shell_cmd,
		    &shell_prog,
		    TRUE,			/* Parse escapes */
		    TRUE			/* Parse quotes */
		);
		edv_system_shell(
		    cmd,
		    shell_prog,
		    shell_args
		);
		g_free(shell_prog);
	    }
	}
}

/*
 *	Plays the "Error" sound.
 */
void edv_play_sound_error(EDVContext *ctx)
{
	EDVSoundOutput sound_output;

	if(ctx == NULL)
	    return;

	sound_output = (EDVSoundOutput)edv_get_i(
	    ctx,
	    EDV_CFG_PARM_SOUND_OUTPUT
	);
	if(sound_output == EDV_SOUND_OUTPUT_GDK)
	{

	}
	else if(sound_output == EDV_SOUND_OUTPUT_COMMAND)
	{   
	    const gchar *cmd = edv_get_s(ctx, EDV_CFG_PARM_SOUND_PLAY_ERROR);
	    if(!STRISEMPTY(cmd))
	    {
		gchar *shell_prog;
		const gchar     *shell_cmd = edv_get_s(ctx, EDV_CFG_PARM_PROG_SHELL),
				*shell_args = edv_strarg(
		    shell_cmd,
		    &shell_prog,
		    TRUE,			/* Parse escapes */
		    TRUE			/* Parse quotes */
		);
		edv_system_shell(
		    cmd,
		    shell_prog,
		    shell_args
		);
		g_free(shell_prog);
	    }
	}
}

/*
 *	Plays the "Completed" sound.
 */
void edv_play_sound_completed(EDVContext *ctx)
{
	EDVSoundOutput sound_output;

	if(ctx == NULL)
	    return;

	sound_output = (EDVSoundOutput)edv_get_i(
	    ctx,
	    EDV_CFG_PARM_SOUND_OUTPUT
	);
	if(sound_output == EDV_SOUND_OUTPUT_GDK)
	{

	}
	else if(sound_output == EDV_SOUND_OUTPUT_COMMAND)
	{   
	    const gchar *cmd = edv_get_s(ctx, EDV_CFG_PARM_SOUND_PLAY_COMPLETED);
	    if(!STRISEMPTY(cmd))
	    {
		gchar *shell_prog;
		const gchar     *shell_cmd = edv_get_s(ctx, EDV_CFG_PARM_PROG_SHELL),
				*shell_args = edv_strarg(
		    shell_cmd,
		    &shell_prog,
		    TRUE,			/* Parse escapes */
		    TRUE			/* Parse quotes */
		);
		edv_system_shell(
		    cmd,
		    shell_prog,
		    shell_args
		);
		g_free(shell_prog);
	    }
	}
}
